/*
 * FileOperation01TempTest class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.util.file;

import ts.tester.function.FunctionTester;
import ts.tester.function.ObjectInspector;
import ts.tester.function.print.*;
import java.io.*;
import java.util.*;
import java.security.*;

/**
 * {@link ts.util.file.FileOperation FileOperation}NX̋@\NXB
 *
 * @author  V. 
 * @version $Revision: 1.1.1.1 $, $Date: 2010-10-16 00:03:46 $
 */
public class FileOperation01TempTest extends FunctionTester
{
  public static void main(String[] args)
  {
    try {
      PrinterGroup group = new PrinterGroup();
      group.addPrinter(new ConsolePrinter());
      setPrinter(group);

      run(FileOperation01TempTest.class, (args.length == 0) ? null : args[0]);
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

  final File WORKDIR = new File("test/data/ts/util/file/FileOperation");

  protected void preInvocation(String method)
  {
    WORKDIR.mkdirs();
  }

  protected void postInvocation(String method)
  {
    try {
      FileOperation.deleteRecursive(WORKDIR);
    } catch (Exception e) {}
  }

  /* -- test case -- */

  public void createTempFile()
  {
    MSG("j[NȖÕt@C̐B");

    try {
      File f = FileOperation.createTempFile("xxx", ".yyy", WORKDIR);

      TRUE(f.getName().startsWith("xxx"));
      TRUE(f.getName().endsWith(".yyy"));
      TRUE(f.exists());
      FALSE(f.isDirectory());
      OK("temporary file name = " + f.getPath());

      File f1 = FileOperation.createTempFile("xxx", ".yyy", WORKDIR);
      File f2 = FileOperation.createTempFile("xxx", ".yyy", WORKDIR);

      TRUE(f1.getName().startsWith("xxx"));
      TRUE(f1.getName().endsWith(".yyy"));
      TRUE(f1.exists());
      FALSE(f1.getName().equals(f.getName()));
      OK("temporary file name = " + f1.getPath());

      TRUE(f2.getName().startsWith("xxx"));
      TRUE(f2.getName().endsWith(".yyy"));
      TRUE(f2.exists());
      FALSE(f2.getName().equals(f.getName()));
      FALSE(f2.getName().equals(f1.getName()));
      OK("temporary file name = " + f2.getPath());
    } catch (Exception e) {
      NG(e);
    }
  }

  public void createTempFile_0()
  {
    MSG("ړꂪk̏ꍇB");

    try {
      FileOperation.createTempFile(null, ".txt", WORKDIR);
      NG();
    } catch (NullPointerException e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void createTempFile_1()
  {
    MSG("ړꂪ3̏ꍇB");

    try {
      FileOperation.createTempFile("ab", ".txt", WORKDIR);
      NG();
    } catch (IllegalArgumentException e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void createTempFile_2()
  {
    MSG("ڔꂪk̏ꍇB");

    try {
      File f = FileOperation.createTempFile("abc", null, WORKDIR);
      TRUE(f.getName().startsWith("abc"));
      TRUE(f.getName().endsWith(".tmp"));
      TRUE(f.exists());
      FALSE(f.isDirectory());
    } catch (Exception e) {
      NG(e);
    }
  }

  public void createTempFile_3()
  {
    MSG("fBNgk̏ꍇB");

    try {
      File f = FileOperation.createTempFile("abc", ".ttt", null);
      EQUAL(f.getParent() + File.separator,
        System.getProperty("java.io.tmpdir"));
      OK(f.getPath());
      TRUE(f.getName().startsWith("abc"));
      TRUE(f.getName().endsWith(".ttt"));
      TRUE(f.exists());
    } catch (Exception e) {
      NG(e);
    }
  }

  public void createTempDirectory()
  {
    MSG("j[NȖÕt@C̐B");

    try {
      File f = FileOperation.createTempDirectory("xxx", "yyy", WORKDIR);

      TRUE(f.getName().startsWith("xxx"));
      TRUE(f.getName().endsWith("yyy"));
      TRUE(f.exists());
      TRUE(f.isDirectory());
      OK("temporary directory name = " + f.getPath());

      File f1 = FileOperation.createTempDirectory("xxx", "yyy", WORKDIR);
      File f2 = FileOperation.createTempDirectory("xxx", "yyy", WORKDIR);

      TRUE(f1.getName().startsWith("xxx"));
      TRUE(f1.getName().endsWith("yyy"));
      TRUE(f1.exists());
      TRUE(f1.isDirectory());
      OK("temporary directory name = " + f1.getPath());

      TRUE(f2.getName().startsWith("xxx"));
      TRUE(f2.getName().endsWith("yyy"));
      TRUE(f2.exists());
      TRUE(f2.isDirectory());
      OK("temporary directory name = " + f2.getPath());
    } catch (Exception e) {
      NG(e);
    }
  }

  public void createTempDirectory_0()
  {
    MSG("ړꂪk̏ꍇB");

    try {
      FileOperation.createTempDirectory(null, "txt", WORKDIR);
      NG();
    } catch (NullPointerException e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void createTempDirectory_1()
  {
    MSG("ړꂪ3̏ꍇB");

    try {
      FileOperation.createTempDirectory("ab", "xxx", WORKDIR);
      NG();
    } catch (IllegalArgumentException e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void createTempDirectory_2()
  {
    MSG("ڔꂪk̏ꍇB");

    try {
      File f = FileOperation.createTempDirectory("abc", null, WORKDIR);
      TRUE(f.getName().startsWith("abc"));
      TRUE(f.exists());
      TRUE(f.isDirectory());
    } catch (Exception e) {
      NG(e);
    }
  }

  public void createTempDirectory_3()
  {
    MSG("fBNgk̏ꍇB");

    try {
      File f = FileOperation.createTempFile("abc", "ttt", null);
      EQUAL(f.getParent() + File.separator,
        System.getProperty("java.io.tmpdir"));
      OK(f.getPath());
      TRUE(f.getName().startsWith("abc"));
      TRUE(f.getName().endsWith("ttt"));
      TRUE(f.exists());
    } catch (Exception e) {
      NG(e);
    }
  }
}
