/*
 * Decompiled with CFR 0.152.
 */
package ts.query;

import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import ts.query.Query;
import ts.query.QueryConnection;
import ts.query.QueryContext;
import ts.query.QueryParam;
import ts.query.QueryResult;
import ts.query.QueryResultList;
import ts.util.ReasonedException;
import ts.util.ReasonedRuntimeException;
import ts.util.resource.Resource;
import ts.util.table.ArrayListTable;
import ts.util.table.Header;
import ts.util.table.Table;

public abstract class AbstractQuery
implements Query {
    private final QueryConnection connection;
    private final Resource resource;

    public AbstractQuery(QueryConnection queryConnection, Resource resource) {
        assert (queryConnection != null && resource != null) : queryConnection == null ? "@param:conn is null." : (resource == null ? "@param:res is null." : "");
        this.connection = queryConnection;
        this.resource = resource;
    }

    protected QueryConnection getConnection() {
        return this.connection;
    }

    protected Resource getResource() {
        return this.resource;
    }

    @Override
    public void execute(String[] stringArray, Map<String, Object> map, QueryResultList queryResultList) throws ReasonedException {
        for (String string : stringArray) {
            this.execute(string, map, queryResultList);
        }
    }

    @Override
    public void execute(List<String> list, Map<String, Object> map, QueryResultList queryResultList) throws ReasonedException {
        for (String string : list) {
            this.execute(string, map, queryResultList);
        }
    }

    @Override
    public void execute(Map<String, Object> map, QueryResultList queryResultList) throws ReasonedException {
        for (String string : this.listAllQueryIds()) {
            this.execute(string, map, queryResultList);
        }
    }

    public abstract List<String> listAllQueryIds();

    @Override
    public void execute(String string, Map<String, Object> map, QueryResultList queryResultList) throws ReasonedException {
        assert (string != null && map != null && queryResultList != null) : string == null ? "@param:queryId is null." : (map == null ? "@param:inputMap is null." : (queryResultList == null ? "@param:resultLst is null." : ""));
        long l = System.currentTimeMillis();
        Resource resource = this.getResource();
        QueryConnection queryConnection = this.getConnection();
        QueryContext queryContext = this.createContext(queryConnection.getId(), string);
        QueryResult queryResult = new QueryResult(queryContext);
        try {
            this.checkTimeout(queryContext);
            List<QueryParam> list = this.prepareQuery(queryContext, map, queryResultList);
            this.checkTimeout(queryContext);
            if (queryContext.hasResultTable()) {
                Table<String, Object> table = this.createResultTable(queryContext);
                int n = this.executeQuery(queryContext, list, table);
                queryResult.setResultTable(table);
                queryResult.setResultCount(n);
                queryResult.setSuccess(true);
            } else {
                int n = this.executeQuery(queryContext, list);
                queryResult.setResultCount(n);
                queryResult.setSuccess(true);
            }
        }
        catch (ReasonedException reasonedException) {
            queryResult.setSuccess(false);
            queryResult.setException(reasonedException);
            throw reasonedException;
        }
        catch (ReasonedRuntimeException reasonedRuntimeException) {
            queryResult.setSuccess(false);
            ReasonedException reasonedException = new ReasonedException(reasonedRuntimeException.getReason(), (Throwable)reasonedRuntimeException);
            reasonedException.setStackTrace(reasonedRuntimeException.getStackTrace());
            queryResult.setException(reasonedException);
            throw reasonedException;
        }
        catch (Exception exception) {
            queryResult.setSuccess(false);
            ReasonedException reasonedException = new ReasonedException((Enum)Query.Error.FailToExecute, (Throwable)exception);
            reasonedException.setStackTrace(exception.getStackTrace());
            queryResult.setException(reasonedException);
            throw reasonedException;
        }
        finally {
            long l2 = System.currentTimeMillis();
            queryResult.setSpentTimeMillis(l2 - l);
            queryResultList.addResult(queryResult);
        }
    }

    protected void checkTimeout(QueryContext queryContext) throws ReasonedException {
        long l = this.getConnection().getLimitTimeMillis();
        if (l >= 0L && l <= System.currentTimeMillis()) {
            throw new ReasonedException((Enum)Query.Error.Timeout, queryContext.getQueryId());
        }
    }

    protected QueryContext createContext(String string, String string2) {
        return new QueryContext(string, string2);
    }

    protected Table<String, Object> createResultTable(QueryContext queryContext) {
        assert (queryContext != null) : "@param:ctx is null.";
        int n = queryContext.countOutputNames();
        ArrayListTable.Header header = new ArrayListTable.Header(n);
        Enumeration<String> enumeration = queryContext.enumOutputNames();
        while (enumeration.hasMoreElements()) {
            header.addColumn((Object)enumeration.nextElement());
        }
        return new ArrayListTable((Header)header);
    }

    protected abstract List<QueryParam> prepareQuery(QueryContext var1, Map<String, Object> var2, QueryResultList var3) throws ReasonedException;

    protected abstract int executeQuery(QueryContext var1, List<QueryParam> var2, Table<String, Object> var3) throws ReasonedException;

    protected abstract int executeQuery(QueryContext var1, List<QueryParam> var2) throws ReasonedException;
}

