/*
 * Decompiled with CFR 0.152.
 */
package ts.query;

import java.util.LinkedHashMap;
import java.util.Map;
import ts.query.QueryConfig;
import ts.query.QueryConnection;
import ts.query.QueryConnectionFactory;
import ts.query.QueryTransaction;
import ts.util.ReasonedException;
import ts.util.ReasonedRuntimeException;

public class DefaultQueryTransaction
implements QueryTransaction {
    private QueryTransaction.State state;
    private long beginTimeMillis = -1L;
    private long limitTimeMillis = -1L;
    private long timeoutMillis = -1L;
    private Map<String, QueryConnection> connectionMap;
    private final Map<String, QueryConnectionFactory> connectionFactoryMap = new LinkedHashMap<String, QueryConnectionFactory>();

    protected DefaultQueryTransaction() {
        this.state = QueryTransaction.State.CREATED;
        this.connectionMap = new LinkedHashMap<String, QueryConnection>();
    }

    @Override
    public void begin() {
        this.begin(this.timeoutMillis);
    }

    @Override
    public void begin(long l) {
        this.changeState(new QueryTransaction.State[]{QueryTransaction.State.CREATED}, QueryTransaction.State.BEGINING);
        this.beginTimeMillis = System.currentTimeMillis();
        this.limitTimeMillis = l >= 0L ? this.beginTimeMillis + l : -1L;
        this.state = QueryTransaction.State.BEGINED;
    }

    @Override
    public void commit() {
        this.changeState(new QueryTransaction.State[]{QueryTransaction.State.BEGINED}, QueryTransaction.State.COMMITTING);
        for (QueryConnection queryConnection : this.connectionMap.values()) {
            queryConnection.commit();
        }
        this.state = QueryTransaction.State.COMMITTED;
    }

    @Override
    public void rollback() {
        this.changeState(new QueryTransaction.State[]{QueryTransaction.State.BEGINING, QueryTransaction.State.BEGINED, QueryTransaction.State.COMMITTING}, QueryTransaction.State.ROLLBACKING);
        for (QueryConnection queryConnection : this.connectionMap.values()) {
            queryConnection.rollback();
        }
        this.state = QueryTransaction.State.ROLLBACKED;
    }

    @Override
    public void end() {
        QueryTransaction.State state = this.state;
        this.state = QueryTransaction.State.ENDING;
        Map<String, QueryConnection> map = this.connectionMap;
        this.connectionMap = new LinkedHashMap<String, QueryConnection>();
        if (state == QueryTransaction.State.BEGINED) {
            for (QueryConnection queryConnection : map.values()) {
                queryConnection.rollback();
            }
        }
        for (QueryConnection queryConnection : map.values()) {
            queryConnection.close();
        }
        map.clear();
        this.state = QueryTransaction.State.ENDED;
    }

    protected long getTimeoutMillis() {
        return this.timeoutMillis;
    }

    public void setTimeoutMillis(long l) {
        this.checkState(new QueryTransaction.State[]{QueryTransaction.State.CREATED});
        this.timeoutMillis = l;
    }

    @Override
    public long getBeginTimeMillis() {
        return this.beginTimeMillis;
    }

    @Override
    public long getLimitTimeMillis() {
        return this.limitTimeMillis;
    }

    @Override
    public QueryTransaction.State getState() {
        return this.state;
    }

    protected final void changeState(QueryTransaction.State[] stateArray, QueryTransaction.State state) {
        this.checkState(stateArray);
        this.state = state;
    }

    protected final void checkState(QueryTransaction.State[] stateArray) {
        for (QueryTransaction.State state : stateArray) {
            if (state != this.state) continue;
            return;
        }
        throw new ReasonedRuntimeException((Enum)QueryTransaction.Error.IllegalState, this.state.name());
    }

    @Override
    public QueryConnection getConnection(String string) throws ReasonedException {
        this.checkState(new QueryTransaction.State[]{QueryTransaction.State.BEGINED});
        QueryConnection queryConnection = this.connectionMap.get(string);
        if (queryConnection == null) {
            QueryConnectionFactory queryConnectionFactory = this.connectionFactoryMap.get(string);
            if (queryConnectionFactory == null) {
                throw new ReasonedException((Enum)QueryTransaction.Error.ConnectionNotFound, string);
            }
            queryConnection = queryConnectionFactory.create(string, QueryConfig.getInstance());
            queryConnection.setLimitTimeMillis(this.limitTimeMillis);
            queryConnection.open();
            this.connectionMap.put(string, queryConnection);
        }
        return queryConnection;
    }

    @Override
    public void addConnectionFactory(String string, QueryConnectionFactory queryConnectionFactory) {
        assert (string != null && queryConnectionFactory != null) : string == null ? "@param:connId is null." : "@param:factory is null.";
        this.checkState(new QueryTransaction.State[]{QueryTransaction.State.CREATED});
        this.connectionFactoryMap.put(string, queryConnectionFactory);
    }
}

