/*
 * Decompiled with CFR 0.152.
 */
package ts.query;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import ts.query.QueryOutput;
import ts.util.AbstractTypedGetter;

public class QueryContext
extends AbstractTypedGetter<Enum, Object> {
    static final long serialVersionUID = 9063342353250916896L;
    private final String queryId;
    private final String connectionId;
    private final Map<Enum, Object> innerMap = new HashMap<Enum, Object>();
    private final Set<String> inputNameSet = new TreeSet<String>();
    private final Set<QueryOutput> outputSet = new LinkedHashSet<QueryOutput>();

    public QueryContext(String string, String string2) {
        assert (string != null && string2 != null) : string == null ? "@param:connId is null." : (string2 == null ? "@param:queryId is null." : "");
        this.connectionId = string;
        this.queryId = string2;
    }

    public String getQueryId() {
        return this.queryId;
    }

    public String getConnectionId() {
        return this.connectionId;
    }

    public Object get(Enum enum_) {
        assert (enum_ != null) : "@param:key is null.";
        return this.innerMap.get(enum_);
    }

    public void set(Enum enum_, Serializable serializable) {
        assert (enum_ != null) : "@param:key is null.";
        if (serializable == null) {
            this.innerMap.remove(enum_);
        } else {
            this.innerMap.put(enum_, serializable);
        }
    }

    public boolean hasResultTable() {
        return this.countOutputNames() > 0;
    }

    public Enumeration<String> enumInputNames() {
        return Collections.enumeration(this.inputNameSet);
    }

    public int countInputNames() {
        return this.inputNameSet.size();
    }

    public Enumeration<String> enumOutputNames() {
        final Iterator<QueryOutput> iterator = this.outputSet.iterator();
        return new Enumeration<String>(){

            @Override
            public boolean hasMoreElements() {
                return iterator.hasNext();
            }

            @Override
            public String nextElement() {
                return ((QueryOutput)((Object)iterator.next())).getName();
            }
        };
    }

    public int countOutputNames() {
        return this.outputSet.size();
    }

    public void addInputName(String string) {
        assert (string != null) : "@param:name is null.";
        this.inputNameSet.add(string);
    }

    public void addInputNames(Collection<String> collection) {
        assert (collection != null) : "@param:names is null.";
        for (String string : collection) {
            assert (string != null) : "@param:names has null elements.";
            this.inputNameSet.add(string);
        }
    }

    public void addInputNames(String[] stringArray) {
        assert (stringArray != null) : "@param:names is null.";
        for (String string : stringArray) {
            assert (string != null) : "@param:names has null elements.";
            this.inputNameSet.add(string);
        }
    }

    public void addOutput(QueryOutput queryOutput) {
        assert (queryOutput != null) : "@param:output is null.";
        this.outputSet.add(queryOutput);
    }

    public void addOutputs(Collection<QueryOutput> collection) {
        assert (collection != null) : "@param:outputs is null.";
        for (QueryOutput queryOutput : collection) {
            assert (queryOutput != null) : "@param:outputs has null elements.";
            this.outputSet.add(queryOutput);
        }
    }

    public void addOutputs(QueryOutput[] queryOutputArray) {
        assert (queryOutputArray != null) : "@param:outputs is null.";
        for (QueryOutput queryOutput : queryOutputArray) {
            assert (queryOutput != null) : "@param:outputs has null elements.";
            this.outputSet.add(queryOutput);
        }
    }
}

