/*
 * Decompiled with CFR 0.152.
 */
package ts.query;

import java.util.HashMap;
import java.util.Map;
import ts.query.DefaultQueryTransaction;
import ts.query.QueryConnection;
import ts.query.QueryConnectionFactory;
import ts.query.QueryTransaction;
import ts.util.ReasonedException;
import ts.util.ReasonedRuntimeException;

public class QueryTransactionManager {
    private static ThreadLocal<QueryTransaction> threadLocal = new ThreadLocal();
    private static Map<String, QueryTransaction> threadMap = new HashMap<String, QueryTransaction>();

    private QueryTransactionManager() {
    }

    public static QueryTransaction getThreadLocalTransaction() throws ReasonedRuntimeException {
        return new ThreadLocalTransaction();
    }

    public static QueryTransaction getThreadSafeTransaction(String string) throws ReasonedRuntimeException {
        return new ThreadSafeTransaction(string);
    }

    public static QueryTransaction createThreadLocalTransaction() throws ReasonedRuntimeException {
        return QueryTransactionManager.createThreadLocalTransaction(DefaultQueryTransaction.class);
    }

    public static QueryTransaction createThreadSafeTransaction(String string) throws ReasonedRuntimeException {
        return QueryTransactionManager.createThreadSafeTransaction(string, DefaultQueryTransaction.class);
    }

    public static QueryTransaction createThreadLocalTransaction(Class<? extends QueryTransaction> clazz) throws ReasonedRuntimeException {
        QueryTransaction queryTransaction = threadLocal.get();
        if (queryTransaction != null && queryTransaction.getState() != QueryTransaction.State.ENDED) {
            throw new ReasonedRuntimeException((Enum)Error.ThreadLocalAlreadyExists);
        }
        try {
            threadLocal.set(clazz.newInstance());
        }
        catch (Exception exception) {
            throw new ReasonedRuntimeException((Enum)Error.ThreadLocalFailToCreate, (Throwable)exception);
        }
        return new ThreadLocalTransaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static QueryTransaction createThreadSafeTransaction(String string, Class<? extends QueryTransaction> clazz) throws ReasonedRuntimeException {
        Map<String, QueryTransaction> map = threadMap;
        synchronized (map) {
            QueryTransaction queryTransaction = threadMap.get(string);
            if (queryTransaction != null && queryTransaction.getState() != QueryTransaction.State.ENDED) {
                throw new ReasonedRuntimeException((Enum)Error.ThreadSafeAlreadyExists, string);
            }
            try {
                queryTransaction = clazz.newInstance();
            }
            catch (Exception exception) {
                throw new ReasonedRuntimeException((Enum)Error.ThreadSafeFailToCreate, string, (Throwable)exception);
            }
            threadMap.put(string, queryTransaction);
            return new ThreadSafeTransaction(string);
        }
    }

    private static final class ThreadSafeTransaction
    implements QueryTransaction {
        private final String key;

        private ThreadSafeTransaction(String string) {
            this.key = string;
            this.getInnerTransaction();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private QueryTransaction getInnerTransaction() {
            Map map = threadMap;
            synchronized (map) {
                QueryTransaction queryTransaction = (QueryTransaction)threadMap.get(this.key);
                if (queryTransaction == null) {
                    throw new ReasonedRuntimeException((Enum)Error.ThreadSafeNotExist, this.key);
                }
                return queryTransaction;
            }
        }

        @Override
        public synchronized void begin() {
            this.getInnerTransaction().begin();
        }

        @Override
        public synchronized void begin(long l) {
            this.getInnerTransaction().begin(l);
        }

        @Override
        public synchronized void commit() {
            this.getInnerTransaction().commit();
        }

        @Override
        public synchronized void rollback() {
            this.getInnerTransaction().rollback();
        }

        @Override
        public synchronized void end() {
            QueryTransaction queryTransaction = this.getInnerTransaction();
            threadMap.remove(this.key);
            queryTransaction.end();
        }

        @Override
        public synchronized long getBeginTimeMillis() {
            return this.getInnerTransaction().getBeginTimeMillis();
        }

        @Override
        public synchronized long getLimitTimeMillis() {
            return this.getInnerTransaction().getLimitTimeMillis();
        }

        @Override
        public synchronized QueryConnection getConnection(String string) throws ReasonedException {
            return this.getInnerTransaction().getConnection(string);
        }

        @Override
        public synchronized void addConnectionFactory(String string, QueryConnectionFactory queryConnectionFactory) {
            this.getInnerTransaction().addConnectionFactory(string, queryConnectionFactory);
        }

        @Override
        public QueryTransaction.State getState() {
            try {
                return this.getInnerTransaction().getState();
            }
            catch (ReasonedRuntimeException reasonedRuntimeException) {
                if (reasonedRuntimeException.getReason().equals((Object)Error.ThreadSafeNotExist)) {
                    return QueryTransaction.State.ENDED;
                }
                throw reasonedRuntimeException;
            }
        }
    }

    private static final class ThreadLocalTransaction
    implements QueryTransaction {
        private ThreadLocalTransaction() {
            this.getInnerTransaction();
        }

        private QueryTransaction getInnerTransaction() {
            QueryTransaction queryTransaction = (QueryTransaction)threadLocal.get();
            if (queryTransaction == null) {
                throw new ReasonedRuntimeException((Enum)Error.ThreadLocalNotExist);
            }
            return queryTransaction;
        }

        @Override
        public void begin() {
            this.getInnerTransaction().begin();
        }

        @Override
        public void begin(long l) {
            this.getInnerTransaction().begin(l);
        }

        @Override
        public void commit() {
            this.getInnerTransaction().commit();
        }

        @Override
        public void rollback() {
            this.getInnerTransaction().rollback();
        }

        @Override
        public void end() {
            QueryTransaction queryTransaction = this.getInnerTransaction();
            threadLocal.remove();
            queryTransaction.end();
        }

        @Override
        public long getBeginTimeMillis() {
            return this.getInnerTransaction().getBeginTimeMillis();
        }

        @Override
        public long getLimitTimeMillis() {
            return this.getInnerTransaction().getLimitTimeMillis();
        }

        @Override
        public QueryConnection getConnection(String string) throws ReasonedException {
            return this.getInnerTransaction().getConnection(string);
        }

        @Override
        public void addConnectionFactory(String string, QueryConnectionFactory queryConnectionFactory) {
            this.getInnerTransaction().addConnectionFactory(string, queryConnectionFactory);
        }

        @Override
        public QueryTransaction.State getState() {
            QueryTransaction queryTransaction = (QueryTransaction)threadLocal.get();
            if (queryTransaction == null) {
                return QueryTransaction.State.ENDED;
            }
            return queryTransaction.getState();
        }
    }

    public static enum Error {
        ThreadLocalFailToCreate,
        ThreadLocalNotExist,
        ThreadLocalAlreadyExists,
        ThreadSafeFailToCreate,
        ThreadSafeNotExist,
        ThreadSafeAlreadyExists;

    }
}

