package ts.query;

import ts.tester.UnitTest;
import ts.util.*;
import ts.util.resource.*;
import java.util.*;

public class QueryContextTest extends UnitTest
{
  public static void main(String[] args)
  {
    run(QueryContextTest.class, args);
  }

  enum Attribute {
    AAA,
    BBB,
    CCC,
  }

  public void constructor_connId_queryId()
  {
    MSG("コネクションIDとクエリIDを引数にもつコンストラクタ。");

    QueryContext ctx = new QueryContext("c0", "q0");
    EQUAL(ctx.getConnectionId(), "c0");
    EQUAL(ctx.getQueryId(), "q0");
    NULL(ctx.get(Attribute.AAA));
    NULL(ctx.get(Attribute.BBB));
    NULL(ctx.get(Attribute.CCC));
    FALSE(ctx.hasResultTable());
    FALSE(ctx.enumInputNames().hasMoreElements());
    EQUAL(ctx.countInputNames(), 0);
    FALSE(ctx.enumOutputNames().hasMoreElements());
    EQUAL(ctx.countOutputNames(), 0);
  }

  public void constructor_connId_queryId_Null()
  {
    MSG("引数がヌルの場合。");

    try {
      new QueryContext(null, "q0");
      NG();
    } catch (AssertionError e) {
      OK(e);
    }

    try {
      new QueryContext("c0", null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    }
  }

  public void set_key_value()
  {
    MSG("任意のコンテキスト情報を設定するメソッドの確認。");

    QueryContext ctx = new QueryContext("c0", "q0");
    EQUAL(ctx.getConnectionId(), "c0");
    EQUAL(ctx.getQueryId(), "q0");
    NULL(ctx.get(Attribute.AAA));
    NULL(ctx.get(Attribute.BBB));
    NULL(ctx.get(Attribute.CCC));
    FALSE(ctx.hasResultTable());
    FALSE(ctx.enumInputNames().hasMoreElements());
    EQUAL(ctx.countInputNames(), 0);
    FALSE(ctx.enumOutputNames().hasMoreElements());
    EQUAL(ctx.countOutputNames(), 0);

    ctx.set(Attribute.BBB, "あいうえお");
    EQUAL(ctx.getConnectionId(), "c0");
    EQUAL(ctx.getQueryId(), "q0");
    NULL(ctx.get(Attribute.AAA));
    EQUAL(ctx.get(Attribute.BBB), "あいうえお");
    NULL(ctx.get(Attribute.CCC));
    FALSE(ctx.hasResultTable());
    FALSE(ctx.enumInputNames().hasMoreElements());
    EQUAL(ctx.countInputNames(), 0);
    FALSE(ctx.enumOutputNames().hasMoreElements());
    EQUAL(ctx.countOutputNames(), 0);

    ctx.set(Attribute.CCC, 12345);
    EQUAL(ctx.getConnectionId(), "c0");
    EQUAL(ctx.getQueryId(), "q0");
    NULL(ctx.get(Attribute.AAA));
    EQUAL(ctx.get(Attribute.BBB), "あいうえお");
    EQUAL(ctx.get(Attribute.CCC), 12345);
    FALSE(ctx.hasResultTable());
    FALSE(ctx.enumInputNames().hasMoreElements());
    EQUAL(ctx.countInputNames(), 0);
    FALSE(ctx.enumOutputNames().hasMoreElements());
    EQUAL(ctx.countOutputNames(), 0);

    ctx.set(Attribute.BBB, null);
    EQUAL(ctx.getConnectionId(), "c0");
    EQUAL(ctx.getQueryId(), "q0");
    NULL(ctx.get(Attribute.AAA));
    NULL(ctx.get(Attribute.BBB));
    EQUAL(ctx.get(Attribute.CCC), 12345);
    FALSE(ctx.hasResultTable());
    FALSE(ctx.enumInputNames().hasMoreElements());
    EQUAL(ctx.countInputNames(), 0);
    FALSE(ctx.enumOutputNames().hasMoreElements());
    EQUAL(ctx.countOutputNames(), 0);
  }

  public void get_key_value_Null()
  {
    MSG("引数がヌルの場合。");

    QueryContext ctx = new QueryContext("c0", "q0");
    NULL(ctx.get(Attribute.AAA));

    try {
      ctx.set(null, "x");
      NG();
    } catch (AssertionError e) {
      OK(e);
    }
    NULL(ctx.get(Attribute.AAA));

    ctx.set(Attribute.AAA, null);
    NULL(ctx.get(Attribute.AAA));

    ctx.set(Attribute.AAA, "X");
    EQUAL(ctx.get(Attribute.AAA), "X");

    ctx.set(Attribute.AAA, null);
    NULL(ctx.get(Attribute.AAA));
  }

  public void addInputName_name()
  {
    MSG("入力パラメータ名の追加。");

    Enumeration<String> enm;

    QueryContext ctx = new QueryContext("c0", "q0");
    EQUAL(ctx.getConnectionId(), "c0");
    EQUAL(ctx.getQueryId(), "q0");
    NULL(ctx.get(Attribute.AAA));
    NULL(ctx.get(Attribute.BBB));
    NULL(ctx.get(Attribute.CCC));
    FALSE(ctx.hasResultTable());
    FALSE(ctx.enumInputNames().hasMoreElements());
    EQUAL(ctx.countInputNames(), 0);
    FALSE(ctx.enumOutputNames().hasMoreElements());
    EQUAL(ctx.countOutputNames(), 0);

    ctx.addInputName("ccc");
    EQUAL(ctx.getConnectionId(), "c0");
    EQUAL(ctx.getQueryId(), "q0");
    NULL(ctx.get(Attribute.AAA));
    NULL(ctx.get(Attribute.BBB));
    NULL(ctx.get(Attribute.CCC));
    FALSE(ctx.hasResultTable());
    FALSE(ctx.enumOutputNames().hasMoreElements());
    EQUAL(ctx.countOutputNames(), 0);
    EQUAL(ctx.countInputNames(), 1);
    enm = ctx.enumInputNames();
    TRUE(enm.hasMoreElements());
    EQUAL(enm.nextElement(), "ccc");
    FALSE(enm.hasMoreElements());

    ctx.addInputName("bbb");
    EQUAL(ctx.getConnectionId(), "c0");
    EQUAL(ctx.getQueryId(), "q0");
    NULL(ctx.get(Attribute.AAA));
    NULL(ctx.get(Attribute.BBB));
    NULL(ctx.get(Attribute.CCC));
    FALSE(ctx.hasResultTable());
    FALSE(ctx.enumOutputNames().hasMoreElements());
    EQUAL(ctx.countOutputNames(), 0);
    EQUAL(ctx.countInputNames(), 2);
    enm = ctx.enumInputNames();
    TRUE(enm.hasMoreElements());
    EQUAL(enm.nextElement(), "bbb");
    TRUE(enm.hasMoreElements());
    EQUAL(enm.nextElement(), "ccc");
    FALSE(enm.hasMoreElements());

    ctx.addInputName("eee");
    EQUAL(ctx.getConnectionId(), "c0");
    EQUAL(ctx.getQueryId(), "q0");
    NULL(ctx.get(Attribute.AAA));
    NULL(ctx.get(Attribute.BBB));
    NULL(ctx.get(Attribute.CCC));
    FALSE(ctx.hasResultTable());
    FALSE(ctx.enumOutputNames().hasMoreElements());
    EQUAL(ctx.countOutputNames(), 0);
    EQUAL(ctx.countInputNames(), 3);
    enm = ctx.enumInputNames();
    TRUE(enm.hasMoreElements());
    EQUAL(enm.nextElement(), "bbb");
    TRUE(enm.hasMoreElements());
    EQUAL(enm.nextElement(), "ccc");
    TRUE(enm.hasMoreElements());
    EQUAL(enm.nextElement(), "eee");
    FALSE(enm.hasMoreElements());

    ctx.addInputName("bbb");
    EQUAL(ctx.getConnectionId(), "c0");
    EQUAL(ctx.getQueryId(), "q0");
    NULL(ctx.get(Attribute.AAA));
    NULL(ctx.get(Attribute.BBB));
    NULL(ctx.get(Attribute.CCC));
    FALSE(ctx.hasResultTable());
    FALSE(ctx.enumOutputNames().hasMoreElements());
    EQUAL(ctx.countOutputNames(), 0);
    EQUAL(ctx.countInputNames(), 3);
    enm = ctx.enumInputNames();
    TRUE(enm.hasMoreElements());
    EQUAL(enm.nextElement(), "bbb");
    TRUE(enm.hasMoreElements());
    EQUAL(enm.nextElement(), "ccc");
    TRUE(enm.hasMoreElements());
    EQUAL(enm.nextElement(), "eee");
    FALSE(enm.hasMoreElements());

    ctx.addInputName("ccc");
    EQUAL(ctx.getConnectionId(), "c0");
    EQUAL(ctx.getQueryId(), "q0");
    NULL(ctx.get(Attribute.AAA));
    NULL(ctx.get(Attribute.BBB));
    NULL(ctx.get(Attribute.CCC));
    FALSE(ctx.hasResultTable());
    FALSE(ctx.enumOutputNames().hasMoreElements());
    EQUAL(ctx.countOutputNames(), 0);
    EQUAL(ctx.countInputNames(), 3);
    enm = ctx.enumInputNames();
    TRUE(enm.hasMoreElements());
    EQUAL(enm.nextElement(), "bbb");
    TRUE(enm.hasMoreElements());
    EQUAL(enm.nextElement(), "ccc");
    TRUE(enm.hasMoreElements());
    EQUAL(enm.nextElement(), "eee");
    FALSE(enm.hasMoreElements());
  }

  public void addInputName_name_Null()
  {
    MSG("引数がヌルの場合。");

    QueryContext ctx = new QueryContext("c0", "q0");

    try {
      ctx.addInputName(null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    }
  }

  public void addInputNames_coll()
  {
    MSG("入力パラメータ名のコレクションの追加。");

    Enumeration<String> enm;
    List<String> lst;

    QueryContext ctx = new QueryContext("c0", "q0");
    EQUAL(ctx.getConnectionId(), "c0");
    EQUAL(ctx.getQueryId(), "q0");
    NULL(ctx.get(Attribute.AAA));
    NULL(ctx.get(Attribute.BBB));
    NULL(ctx.get(Attribute.CCC));
    FALSE(ctx.hasResultTable());
    FALSE(ctx.enumInputNames().hasMoreElements());
    EQUAL(ctx.countInputNames(), 0);
    FALSE(ctx.enumOutputNames().hasMoreElements());
    EQUAL(ctx.countOutputNames(), 0);

    lst = new ArrayList<String>(0);
    ctx.addInputNames(lst);
    EQUAL(ctx.getConnectionId(), "c0");
    EQUAL(ctx.getQueryId(), "q0");
    NULL(ctx.get(Attribute.AAA));
    NULL(ctx.get(Attribute.BBB));
    NULL(ctx.get(Attribute.CCC));
    FALSE(ctx.hasResultTable());
    FALSE(ctx.enumInputNames().hasMoreElements());
    EQUAL(ctx.countInputNames(), 0);
    FALSE(ctx.enumOutputNames().hasMoreElements());
    EQUAL(ctx.countOutputNames(), 0);

    lst = new ArrayList<String>(4);
    lst.add("eee");
    lst.add("bbb");
    lst.add("ccc");
    lst.add("ddd");
    lst.add("bbb");
    lst.add("ccc");
    ctx.addInputNames(lst);
    EQUAL(ctx.getConnectionId(), "c0");
    EQUAL(ctx.getQueryId(), "q0");
    NULL(ctx.get(Attribute.AAA));
    NULL(ctx.get(Attribute.BBB));
    NULL(ctx.get(Attribute.CCC));
    FALSE(ctx.hasResultTable());
    FALSE(ctx.enumOutputNames().hasMoreElements());
    EQUAL(ctx.countOutputNames(), 0);
    EQUAL(ctx.countInputNames(), 4);
    enm = ctx.enumInputNames();
    TRUE(enm.hasMoreElements());
    EQUAL(enm.nextElement(), "bbb");
    TRUE(enm.hasMoreElements());
    EQUAL(enm.nextElement(), "ccc");
    TRUE(enm.hasMoreElements());
    EQUAL(enm.nextElement(), "ddd");
    TRUE(enm.hasMoreElements());
    EQUAL(enm.nextElement(), "eee");
    FALSE(enm.hasMoreElements());

    lst = new ArrayList<String>(0);
    ctx.addInputNames(lst);
    EQUAL(ctx.getConnectionId(), "c0");
    EQUAL(ctx.getQueryId(), "q0");
    NULL(ctx.get(Attribute.AAA));
    NULL(ctx.get(Attribute.BBB));
    NULL(ctx.get(Attribute.CCC));
    FALSE(ctx.hasResultTable());
    FALSE(ctx.enumOutputNames().hasMoreElements());
    EQUAL(ctx.countOutputNames(), 0);
    EQUAL(ctx.countInputNames(), 4);
    enm = ctx.enumInputNames();
    TRUE(enm.hasMoreElements());
    EQUAL(enm.nextElement(), "bbb");
    TRUE(enm.hasMoreElements());
    EQUAL(enm.nextElement(), "ccc");
    TRUE(enm.hasMoreElements());
    EQUAL(enm.nextElement(), "ddd");
    TRUE(enm.hasMoreElements());
    EQUAL(enm.nextElement(), "eee");
    FALSE(enm.hasMoreElements());
  }

  public void addInputNames_coll_Null()
  {
    MSG("引数がヌルの場合。");

    QueryContext ctx = new QueryContext("c0", "q0");

    try {
      ctx.addInputNames((Collection<String>) null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    }
  }

  public void addInputNames_array()
  {
    MSG("入力パラメータ名の配列の追加。");

    Enumeration<String> enm;

    QueryContext ctx = new QueryContext("c0", "q0");
    EQUAL(ctx.getConnectionId(), "c0");
    EQUAL(ctx.getQueryId(), "q0");
    NULL(ctx.get(Attribute.AAA));
    NULL(ctx.get(Attribute.BBB));
    NULL(ctx.get(Attribute.CCC));
    FALSE(ctx.hasResultTable());
    FALSE(ctx.enumInputNames().hasMoreElements());
    EQUAL(ctx.countInputNames(), 0);
    FALSE(ctx.enumOutputNames().hasMoreElements());
    EQUAL(ctx.countOutputNames(), 0);

    ctx.addInputNames(new String[0]);
    EQUAL(ctx.getConnectionId(), "c0");
    EQUAL(ctx.getQueryId(), "q0");
    NULL(ctx.get(Attribute.AAA));
    NULL(ctx.get(Attribute.BBB));
    NULL(ctx.get(Attribute.CCC));
    FALSE(ctx.hasResultTable());
    FALSE(ctx.enumInputNames().hasMoreElements());
    EQUAL(ctx.countInputNames(), 0);
    FALSE(ctx.enumOutputNames().hasMoreElements());
    EQUAL(ctx.countOutputNames(), 0);

    ctx.addInputNames(new String[]{"eee","bbb","ccc","ddd","bbb","ccc"});
    EQUAL(ctx.getConnectionId(), "c0");
    EQUAL(ctx.getQueryId(), "q0");
    NULL(ctx.get(Attribute.AAA));
    NULL(ctx.get(Attribute.BBB));
    NULL(ctx.get(Attribute.CCC));
    FALSE(ctx.hasResultTable());
    FALSE(ctx.enumOutputNames().hasMoreElements());
    EQUAL(ctx.countOutputNames(), 0);
    EQUAL(ctx.countInputNames(), 4);
    enm = ctx.enumInputNames();
    TRUE(enm.hasMoreElements());
    EQUAL(enm.nextElement(), "bbb");
    TRUE(enm.hasMoreElements());
    EQUAL(enm.nextElement(), "ccc");
    TRUE(enm.hasMoreElements());
    EQUAL(enm.nextElement(), "ddd");
    TRUE(enm.hasMoreElements());
    EQUAL(enm.nextElement(), "eee");
    FALSE(enm.hasMoreElements());

    ctx.addInputNames(new String[0]);
    EQUAL(ctx.getConnectionId(), "c0");
    EQUAL(ctx.getQueryId(), "q0");
    NULL(ctx.get(Attribute.AAA));
    NULL(ctx.get(Attribute.BBB));
    NULL(ctx.get(Attribute.CCC));
    FALSE(ctx.hasResultTable());
    FALSE(ctx.enumOutputNames().hasMoreElements());
    EQUAL(ctx.countOutputNames(), 0);
    EQUAL(ctx.countInputNames(), 4);
    enm = ctx.enumInputNames();
    TRUE(enm.hasMoreElements());
    EQUAL(enm.nextElement(), "bbb");
    TRUE(enm.hasMoreElements());
    EQUAL(enm.nextElement(), "ccc");
    TRUE(enm.hasMoreElements());
    EQUAL(enm.nextElement(), "ddd");
    TRUE(enm.hasMoreElements());
    EQUAL(enm.nextElement(), "eee");
    FALSE(enm.hasMoreElements());
  }

  public void addInputNames_array_Null()
  {
    MSG("引数がヌルの場合。");

    QueryContext ctx = new QueryContext("c0", "q0");

    try {
      ctx.addInputNames((String[]) null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    }
  }

  public void addOutput_output()
  {
    MSG("出力項目の追加。");

    Enumeration<String> enm;

    QueryContext ctx = new QueryContext("c0", "q0");
    EQUAL(ctx.getConnectionId(), "c0");
    EQUAL(ctx.getQueryId(), "q0");
    NULL(ctx.get(Attribute.AAA));
    NULL(ctx.get(Attribute.BBB));
    NULL(ctx.get(Attribute.CCC));
    FALSE(ctx.hasResultTable());
    FALSE(ctx.enumInputNames().hasMoreElements());
    EQUAL(ctx.countInputNames(), 0);
    FALSE(ctx.enumOutputNames().hasMoreElements());
    EQUAL(ctx.countOutputNames(), 0);

    ctx.addOutput(new QueryOutput("ccc"));
    EQUAL(ctx.getConnectionId(), "c0");
    EQUAL(ctx.getQueryId(), "q0");
    NULL(ctx.get(Attribute.AAA));
    NULL(ctx.get(Attribute.BBB));
    NULL(ctx.get(Attribute.CCC));
    TRUE(ctx.hasResultTable());
    FALSE(ctx.enumInputNames().hasMoreElements());
    EQUAL(ctx.countInputNames(), 0);
    EQUAL(ctx.countOutputNames(), 1);
    enm = ctx.enumOutputNames();
    TRUE(enm.hasMoreElements());
    EQUAL(enm.nextElement(), "ccc");
    FALSE(enm.hasMoreElements());

    ctx.addOutput(new QueryOutput("bbb"));
    EQUAL(ctx.getConnectionId(), "c0");
    EQUAL(ctx.getQueryId(), "q0");
    NULL(ctx.get(Attribute.AAA));
    NULL(ctx.get(Attribute.BBB));
    NULL(ctx.get(Attribute.CCC));
    TRUE(ctx.hasResultTable());
    FALSE(ctx.enumInputNames().hasMoreElements());
    EQUAL(ctx.countInputNames(), 0);
    EQUAL(ctx.countOutputNames(), 2);
    enm = ctx.enumOutputNames();
    TRUE(enm.hasMoreElements());
    EQUAL(enm.nextElement(), "ccc");
    TRUE(enm.hasMoreElements());
    EQUAL(enm.nextElement(), "bbb");
    FALSE(enm.hasMoreElements());

    ctx.addOutput(new QueryOutput("eee"));
    EQUAL(ctx.getConnectionId(), "c0");
    EQUAL(ctx.getQueryId(), "q0");
    NULL(ctx.get(Attribute.AAA));
    NULL(ctx.get(Attribute.BBB));
    NULL(ctx.get(Attribute.CCC));
    TRUE(ctx.hasResultTable());
    FALSE(ctx.enumInputNames().hasMoreElements());
    EQUAL(ctx.countInputNames(), 0);
    EQUAL(ctx.countOutputNames(), 3);
    enm = ctx.enumOutputNames();
    TRUE(enm.hasMoreElements());
    EQUAL(enm.nextElement(), "ccc");
    TRUE(enm.hasMoreElements());
    EQUAL(enm.nextElement(), "bbb");
    TRUE(enm.hasMoreElements());
    EQUAL(enm.nextElement(), "eee");
    FALSE(enm.hasMoreElements());

    ctx.addOutput(new QueryOutput("bbb"));
    EQUAL(ctx.getConnectionId(), "c0");
    EQUAL(ctx.getQueryId(), "q0");
    NULL(ctx.get(Attribute.AAA));
    NULL(ctx.get(Attribute.BBB));
    NULL(ctx.get(Attribute.CCC));
    TRUE(ctx.hasResultTable());
    FALSE(ctx.enumInputNames().hasMoreElements());
    EQUAL(ctx.countInputNames(), 0);
    EQUAL(ctx.countOutputNames(), 3);
    enm = ctx.enumOutputNames();
    TRUE(enm.hasMoreElements());
    EQUAL(enm.nextElement(), "ccc");
    TRUE(enm.hasMoreElements());
    EQUAL(enm.nextElement(), "bbb");
    TRUE(enm.hasMoreElements());
    EQUAL(enm.nextElement(), "eee");
    FALSE(enm.hasMoreElements());

    ctx.addOutput(new QueryOutput("ccc"));
    EQUAL(ctx.getConnectionId(), "c0");
    EQUAL(ctx.getQueryId(), "q0");
    NULL(ctx.get(Attribute.AAA));
    NULL(ctx.get(Attribute.BBB));
    NULL(ctx.get(Attribute.CCC));
    TRUE(ctx.hasResultTable());
    FALSE(ctx.enumInputNames().hasMoreElements());
    EQUAL(ctx.countInputNames(), 0);
    EQUAL(ctx.countOutputNames(), 3);
    enm = ctx.enumOutputNames();
    TRUE(enm.hasMoreElements());
    EQUAL(enm.nextElement(), "ccc");
    TRUE(enm.hasMoreElements());
    EQUAL(enm.nextElement(), "bbb");
    TRUE(enm.hasMoreElements());
    EQUAL(enm.nextElement(), "eee");
    FALSE(enm.hasMoreElements());
  }

  public void addOutputName_name_Null()
  {
    MSG("引数がヌルの場合。");

    QueryContext ctx = new QueryContext("c0", "q0");

    try {
      ctx.addOutput(null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    }
  }

  public void addOutputNames_coll()
  {
    MSG("出力パラメータ名のコレクションの追加。");

    Enumeration<String> enm;
    List<QueryOutput> lst;

    QueryContext ctx = new QueryContext("c0", "q0");
    EQUAL(ctx.getConnectionId(), "c0");
    EQUAL(ctx.getQueryId(), "q0");
    NULL(ctx.get(Attribute.AAA));
    NULL(ctx.get(Attribute.BBB));
    NULL(ctx.get(Attribute.CCC));
    FALSE(ctx.hasResultTable());
    FALSE(ctx.enumInputNames().hasMoreElements());
    EQUAL(ctx.countInputNames(), 0);
    FALSE(ctx.enumOutputNames().hasMoreElements());
    EQUAL(ctx.countOutputNames(), 0);

    lst = new ArrayList<QueryOutput>(0);
    ctx.addOutputs(lst);
    EQUAL(ctx.getConnectionId(), "c0");
    EQUAL(ctx.getQueryId(), "q0");
    NULL(ctx.get(Attribute.AAA));
    NULL(ctx.get(Attribute.BBB));
    NULL(ctx.get(Attribute.CCC));
    FALSE(ctx.hasResultTable());
    FALSE(ctx.enumInputNames().hasMoreElements());
    EQUAL(ctx.countInputNames(), 0);
    FALSE(ctx.enumOutputNames().hasMoreElements());
    EQUAL(ctx.countOutputNames(), 0);

    lst = new ArrayList<QueryOutput>();
    lst.add(new QueryOutput("eee"));
    lst.add(new QueryOutput("bbb"));
    lst.add(new QueryOutput("ccc"));
    lst.add(new QueryOutput("ddd"));
    lst.add(new QueryOutput("bbb"));
    lst.add(new QueryOutput("ccc"));
    ctx.addOutputs(lst);
    EQUAL(ctx.getConnectionId(), "c0");
    EQUAL(ctx.getQueryId(), "q0");
    NULL(ctx.get(Attribute.AAA));
    NULL(ctx.get(Attribute.BBB));
    NULL(ctx.get(Attribute.CCC));
    TRUE(ctx.hasResultTable());
    FALSE(ctx.enumInputNames().hasMoreElements());
    EQUAL(ctx.countInputNames(), 0);
    EQUAL(ctx.countOutputNames(), 4);
    enm = ctx.enumOutputNames();
    TRUE(enm.hasMoreElements());
    EQUAL(enm.nextElement(), "eee");
    TRUE(enm.hasMoreElements());
    EQUAL(enm.nextElement(), "bbb");
    TRUE(enm.hasMoreElements());
    EQUAL(enm.nextElement(), "ccc");
    TRUE(enm.hasMoreElements());
    EQUAL(enm.nextElement(), "ddd");
    FALSE(enm.hasMoreElements());

    lst = new ArrayList<QueryOutput>(0);
    ctx.addOutputs(lst);
    EQUAL(ctx.getConnectionId(), "c0");
    EQUAL(ctx.getQueryId(), "q0");
    NULL(ctx.get(Attribute.AAA));
    NULL(ctx.get(Attribute.BBB));
    NULL(ctx.get(Attribute.CCC));
    TRUE(ctx.hasResultTable());
    FALSE(ctx.enumInputNames().hasMoreElements());
    EQUAL(ctx.countInputNames(), 0);
    EQUAL(ctx.countOutputNames(), 4);
    enm = ctx.enumOutputNames();
    TRUE(enm.hasMoreElements());
    EQUAL(enm.nextElement(), "eee");
    TRUE(enm.hasMoreElements());
    EQUAL(enm.nextElement(), "bbb");
    TRUE(enm.hasMoreElements());
    EQUAL(enm.nextElement(), "ccc");
    TRUE(enm.hasMoreElements());
    EQUAL(enm.nextElement(), "ddd");
    FALSE(enm.hasMoreElements());
  }

  public void addOutputs_coll_Null()
  {
    MSG("引数がヌルの場合。");

    QueryContext ctx = new QueryContext("c0", "q0");

    try {
      ctx.addOutputs((Collection<QueryOutput>) null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    }
  }

  public void addOutputs_array()
  {
    MSG("出力パラメータ名の配列の追加。");

    Enumeration<String> enm;

    QueryContext ctx = new QueryContext("c0", "q0");
    EQUAL(ctx.getConnectionId(), "c0");
    EQUAL(ctx.getQueryId(), "q0");
    NULL(ctx.get(Attribute.AAA));
    NULL(ctx.get(Attribute.BBB));
    NULL(ctx.get(Attribute.CCC));
    FALSE(ctx.hasResultTable());
    FALSE(ctx.enumInputNames().hasMoreElements());
    EQUAL(ctx.countInputNames(), 0);
    FALSE(ctx.enumOutputNames().hasMoreElements());
    EQUAL(ctx.countOutputNames(), 0);

    ctx.addOutputs(new QueryOutput[0]);
    EQUAL(ctx.getConnectionId(), "c0");
    EQUAL(ctx.getQueryId(), "q0");
    NULL(ctx.get(Attribute.AAA));
    NULL(ctx.get(Attribute.BBB));
    NULL(ctx.get(Attribute.CCC));
    FALSE(ctx.hasResultTable());
    FALSE(ctx.enumInputNames().hasMoreElements());
    EQUAL(ctx.countInputNames(), 0);
    FALSE(ctx.enumOutputNames().hasMoreElements());
    EQUAL(ctx.countOutputNames(), 0);

    QueryOutput[] arr = new QueryOutput[6];
    arr[0] = new QueryOutput("eee");
    arr[1] = new QueryOutput("bbb");
    arr[2] = new QueryOutput("ccc");
    arr[3] = new QueryOutput("ddd");
    arr[4] = new QueryOutput("bbb");
    arr[5] = new QueryOutput("ccc");
    ctx.addOutputs(arr);
    EQUAL(ctx.getConnectionId(), "c0");
    EQUAL(ctx.getQueryId(), "q0");
    NULL(ctx.get(Attribute.AAA));
    NULL(ctx.get(Attribute.BBB));
    NULL(ctx.get(Attribute.CCC));
    TRUE(ctx.hasResultTable());
    FALSE(ctx.enumInputNames().hasMoreElements());
    EQUAL(ctx.countInputNames(), 0);
    EQUAL(ctx.countOutputNames(), 4);
    enm = ctx.enumOutputNames();
    TRUE(enm.hasMoreElements());
    EQUAL(enm.nextElement(), "eee");
    TRUE(enm.hasMoreElements());
    EQUAL(enm.nextElement(), "bbb");
    TRUE(enm.hasMoreElements());
    EQUAL(enm.nextElement(), "ccc");
    TRUE(enm.hasMoreElements());
    EQUAL(enm.nextElement(), "ddd");
    FALSE(enm.hasMoreElements());

    ctx.addOutputs(new QueryOutput[0]);
    EQUAL(ctx.getConnectionId(), "c0");
    EQUAL(ctx.getQueryId(), "q0");
    NULL(ctx.get(Attribute.AAA));
    NULL(ctx.get(Attribute.BBB));
    NULL(ctx.get(Attribute.CCC));
    TRUE(ctx.hasResultTable());
    FALSE(ctx.enumInputNames().hasMoreElements());
    EQUAL(ctx.countInputNames(), 0);
    EQUAL(ctx.countOutputNames(), 4);
    enm = ctx.enumOutputNames();
    TRUE(enm.hasMoreElements());
    EQUAL(enm.nextElement(), "eee");
    TRUE(enm.hasMoreElements());
    EQUAL(enm.nextElement(), "bbb");
    TRUE(enm.hasMoreElements());
    EQUAL(enm.nextElement(), "ccc");
    TRUE(enm.hasMoreElements());
    EQUAL(enm.nextElement(), "ddd");
    FALSE(enm.hasMoreElements());
  }

  public void addOutputNames_array_Null()
  {
    MSG("引数がヌルの場合。");

    QueryContext ctx = new QueryContext("c0", "q0");

    try {
      ctx.addOutputs((QueryOutput[]) null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    }
  }
}
