package ts.query;

import ts.tester.UnitTest;
import ts.util.*;
import java.util.*;

public class QueryParamTest extends UnitTest
{
  public static void main(String[] args)
  {
    run(QueryParamTest.class, args);
  }

  public void constructor_name()
  {
    MSG("名前を引数にとるコンストラクタ。");

    QueryParam param = new QueryParam("abc");
    EQUAL(param.getName(), "abc");
    EQUAL(param.getIO(), QueryParam.IO.IN);
    NULL(param.get("AAA"));
    NULL(param.get("BBB"));
    NULL(param.get("CCC"));
    NULL(param.getValue());
    EQUAL(param.getValueCount(), 1);
  }

  public void constructor_name_Null()
  {
    MSG("引数がヌルの場合。");

    try {
      new QueryParam(null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    }
  }

  public void constructor_name_io()
  {
    MSG("名前と入出力区分を引数にとるコンストラクタ。");

    QueryParam param = new QueryParam("xyz", QueryParam.IO.OUT);
    EQUAL(param.getName(), "xyz");
    EQUAL(param.getIO(), QueryParam.IO.OUT);
    NULL(param.get("AAA"));
    NULL(param.get("BBB"));
    NULL(param.get("CCC"));
    NULL(param.getValue());
    EQUAL(param.getValueCount(), 1);
  }

  public void constructor_name_io_Null()
  {
    MSG("引数がヌルの場合。");

    try {
      new QueryParam(null, QueryParam.IO.OUT);
      NG();
    } catch (AssertionError e) {
      OK(e);
    }

    try {
      new QueryParam("lmn", null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    }
  }

  public void put_key_attrValue()
  {
    MSG("属性値を設定するメソッドの確認。");

    QueryParam param = new QueryParam("xyz", QueryParam.IO.INOUT);
    EQUAL(param.getName(), "xyz");
    EQUAL(param.getIO(), QueryParam.IO.INOUT);
    NULL(param.get("AAA"));
    NULL(param.get("BBB"));
    NULL(param.get("CCC"));
    NULL(param.getValue());
    EQUAL(param.getValueCount(), 1);

    param.put("AAA", 123);
    EQUAL(param.getName(), "xyz");
    EQUAL(param.getIO(), QueryParam.IO.INOUT);
    EQUAL(param.get("AAA"), 123);
    NULL(param.get("BBB"));
    NULL(param.get("CCC"));
    NULL(param.getValue());
    EQUAL(param.getValueCount(), 1);

    param.put("CCC", "あいうえお");
    EQUAL(param.getName(), "xyz");
    EQUAL(param.getIO(), QueryParam.IO.INOUT);
    EQUAL(param.get("AAA"), 123);
    NULL(param.get("BBB"));
    EQUAL(param.get("CCC"), "あいうえお");
    NULL(param.getValue());
    EQUAL(param.getValueCount(), 1);

    param.put("AAA", null);
    EQUAL(param.getName(), "xyz");
    EQUAL(param.getIO(), QueryParam.IO.INOUT);
    NULL(param.get("AAA"));
    NULL(param.get("BBB"));
    EQUAL(param.get("CCC"), "あいうえお");
    NULL(param.getValue());
    EQUAL(param.getValueCount(), 1);

    param.put(null, 999);
    EQUAL(param.getName(), "xyz");
    EQUAL(param.getIO(), QueryParam.IO.INOUT);
    NULL(param.get("AAA"));
    NULL(param.get("BBB"));
    EQUAL(param.get("CCC"), "あいうえお");
    EQUAL(param.get(null), 999);
    NULL(param.getValue());
    EQUAL(param.getValueCount(), 1);
  }

  public void setValueIterator_itr()
  {
    MSG("パラメータの値のイテレータを設定するメソッドの確認。");

    QueryParam param = new QueryParam("xyz", QueryParam.IO.INOUT);
    EQUAL(param.getName(), "xyz");
    EQUAL(param.getIO(), QueryParam.IO.INOUT);
    NULL(param.get("AAA"));
    NULL(param.get("BBB"));
    NULL(param.get("CCC"));
    NULL(param.getValue());
    EQUAL(param.getValueCount(), 1);

    QueryParamValueIterator itr0 = new QueryParamValueIterator("かきくけこ");
    param.setValueIterator(itr0);
    EQUAL(param.getName(), "xyz");
    EQUAL(param.getIO(), QueryParam.IO.INOUT);
    NULL(param.get("AAA"));
    NULL(param.get("BBB"));
    NULL(param.get("CCC"));
    EQUAL(param.getValueCount(), 1);
    EQUAL(param.getValue(), "かきくけこ");
    EQUAL(param.getValue(), "かきくけこ");
    EQUAL(param.getValue(), "かきくけこ");

    QueryParamValueIterator itr1 = new QueryParamValueIterator(Arrays.asList(
      new String[]{ "x1", "x2", "x3" }));
    param.setValueIterator(itr1);
    EQUAL(param.getName(), "xyz");
    EQUAL(param.getIO(), QueryParam.IO.INOUT);
    NULL(param.get("AAA"));
    NULL(param.get("BBB"));
    NULL(param.get("CCC"));
    EQUAL(param.getValueCount(), 3);
    EQUAL(param.getValue(), "x1");
    EQUAL(param.getValue(), "x2");
    EQUAL(param.getValue(), "x3");
    EQUAL(param.getValue(), "x3");
    EQUAL(param.getValue(), "x3");

    param.setValueIterator(null);
    EQUAL(param.getName(), "xyz");
    EQUAL(param.getIO(), QueryParam.IO.INOUT);
    NULL(param.get("AAA"));
    NULL(param.get("BBB"));
    NULL(param.get("CCC"));
    EQUAL(param.getValueCount(), 1);
    NULL(param.getValue());
    NULL(param.getValue());
    NULL(param.getValue());
  }
}
