package ts.tester;

import ts.tester.function.coverage.FunctionTester;
import ts.tester.function.print.*;

public class UnitTest extends FunctionTester
{
  public static void run(Class<? extends UnitTest> testClass, String[] args)
  {
    try {
      PrinterGroup group = new PrinterGroup();
      group.addPrinter(new HtmlPrinter(System.getProperty("user.name")));
      group.addPrinter(new ConsolePrinter());
      setPrinter(group);
      run(testClass, (args == null || args.length == 0) ? null : args[0]);
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }
}
