/*
 * Decompiled with CFR 0.152.
 */
package ts.query;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import ts.util.AbstractTypedGetter;
import ts.util.ReasonedRuntimeException;
import ts.util.resource.PropertyResource;
import ts.util.resource.Resource;

public final class QueryConfig
extends AbstractTypedGetter<String, String> {
    private static final long serialVersionUID = 7870866298172485389L;
    private static final QueryConfig INSTANCE = new QueryConfig();
    private final Resource resource = QueryConfig.loadResource();

    public static QueryConfig getInstance() {
        return INSTANCE;
    }

    private QueryConfig() throws ReasonedRuntimeException {
    }

    static final Resource loadResource() throws ReasonedRuntimeException {
        String string = QueryConfig.class.getName().replace('.', '/') + ".properties";
        try {
            return new PropertyResource(string){
                private static final long serialVersionUID = 7870866298172485390L;

                protected InputStream getInputStream(String string) throws IOException {
                    InputStream inputStream = ClassLoader.getSystemResourceAsStream(string);
                    if (inputStream == null && !ClassLoader.getSystemResources(string).hasMoreElements()) {
                        throw new FileNotFoundException(string);
                    }
                    return inputStream;
                }
            };
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ReasonedRuntimeException((Enum)Error.FileNotFound, string);
        }
        catch (IOException iOException) {
            throw new ReasonedRuntimeException((Enum)Error.FailToLoad, string);
        }
    }

    public String get(String string) {
        if (string == null) {
            throw new IllegalArgumentException("@param:key is null.");
        }
        return this.resource.getFirstValue(string);
    }

    public List<String> getList(String string) {
        if (string == null) {
            throw new IllegalArgumentException("@param:key is null.");
        }
        return this.resource.getValues(string);
    }

    public static enum Error {
        FileNotFound,
        FailToLoad;

    }
}

