/*
 * Decompiled with CFR 0.152.
 */
package ts.query;

import java.io.Serializable;
import ts.query.Query;
import ts.query.QueryContent;
import ts.util.ReasonedException;
import ts.util.ReasonedRuntimeException;
import ts.util.table.Table;

public class QueryResult
implements Serializable {
    private static final long serialVersionUID = 8309940887092598304L;
    private final String queryId;
    private final String connId;
    private boolean isSuccess;
    private int resultCount = 0;
    private long spentTimeMillis = 0L;
    private ReasonedException exception = null;
    private Table<String, Object> resultTable = null;
    private QueryContent content = null;

    public QueryResult(String string, String string2) {
        assert (string != null && string2 != null) : string == null ? "@param:connId is null." : (string2 == null ? "@param:connId is null." : "");
        this.queryId = string2;
        this.connId = string;
    }

    public String getQueryId() {
        return this.queryId;
    }

    public String getConnectionId() {
        return this.connId;
    }

    public void setContent(QueryContent queryContent) {
        assert (queryContent != null) : "@param:cont is null.";
        this.content = queryContent;
    }

    public QueryContent getContent() {
        return this.content;
    }

    protected void setSuccess(boolean bl) {
        this.isSuccess = bl;
    }

    public boolean isSuccess() {
        return this.isSuccess;
    }

    protected void setResultCount(int n) {
        assert (n >= 0) : "@param:resultCount is negative.";
        this.resultCount = n;
    }

    public int getResultCount() {
        return this.resultCount;
    }

    protected void setSpentTimeMillis(long l) {
        assert (l >= 0L) : "@param:spentTime is negative.";
        this.spentTimeMillis = l;
    }

    public long getSpentTimeMillis() {
        return this.spentTimeMillis;
    }

    protected void setException(Exception exception) {
        if (exception == null) {
            this.exception = null;
        } else if (exception instanceof ReasonedException) {
            this.exception = (ReasonedException)ReasonedException.class.cast(exception);
        } else if (exception instanceof ReasonedRuntimeException) {
            ReasonedRuntimeException reasonedRuntimeException = (ReasonedRuntimeException)ReasonedRuntimeException.class.cast(exception);
            this.exception = new ReasonedException(reasonedRuntimeException.getReason(), (Throwable)reasonedRuntimeException);
            this.exception.setStackTrace(exception.getStackTrace());
        } else {
            this.exception = new ReasonedException((Enum)Query.Error.FailToExecute, (Throwable)exception);
            this.exception.setStackTrace(exception.getStackTrace());
        }
    }

    public ReasonedException getReasonedException() {
        return this.exception;
    }

    protected void setResultTable(Table<String, Object> table) {
        this.resultTable = table;
    }

    public Table<String, Object> getResultTable() {
        return this.resultTable;
    }
}

