/*
 * QueryConnectionFactory class.
 *
 * Copyright (C) 2011 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.query;

import ts.util.ReasonedException;

/**
 * クエリの接続先を示すコネクション・オブジェクトを作成するファクトリ・クラスの
 * インターフェイス。
 * <br>
 * 初期設定オブジェクトを引数にとり、{@link QueryConnection}オブジェクトを作成
 * する{@link #create(String, QueryTransaction)}メソッドを宣言している。
 *
 * @author 佐藤隆之
 * @version $Id: QueryConnectionFactory.java,v 1.6 2011-09-18 16:15:16 tayu Exp $
 */
public interface QueryConnectionFactory
{
  /** このクラスで発生しうるエラーの列挙型。 */
  enum Error {
    /** コネクション・オブジェクトの作成に失敗したことを示す列挙値。 */
    FailToCreate,
  }

  /**
   * 指定されたコネクションIDに対応づけられた{@link QueryConnection}オブジェクト
   * を作成する。
   *
   * @param  connId 接続先を識別するためのコネクションID。
   * @param  transaction  作成される{@link QueryConnection}オブジェクトが属する
   *           トランザクション・オブジェクト。
   * @return 引数のコネクションIDに対応づけられた{@link
   *           QueryConnection}オブジェクト。
   * @throws ReasonedException {@link QueryConnection}オブジェクトの作成に失敗
   *           した場合。
   */
  QueryConnection create(String connId, QueryTransaction transaction)
    throws ReasonedException;
}
