package ts.query;

import ts.tester.UnitTest;
import ts.util.*;
import java.util.*;

public class QueryOutputTest extends UnitTest
{
  public static void main(String[] args)
  {
    run(QueryOutputTest.class, args);
  }

  public void constructor_name()
  {
    MSG("名前を引数にとるコンストラクタ。");

    QueryOutput output = new QueryOutput("abc");
    EQUAL(output.getName(), "abc");
    NULL(output.get("AAA"));
    NULL(output.get("BBB"));
    NULL(output.get("CCC"));
  }

  public void constructor_name_Null()
  {
    MSG("引数がヌルの場合。");

    try {
      new QueryOutput(null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    }
  }

  public void put_key_attrValue()
  {
    MSG("属性値を設定するメソッドの確認。");

    QueryOutput output = new QueryOutput("xyz");
    EQUAL(output.getName(), "xyz");
    NULL(output.get("AAA"));
    NULL(output.get("BBB"));
    NULL(output.get("CCC"));

    output.put("AAA", 123);
    EQUAL(output.getName(), "xyz");
    EQUAL(output.get("AAA"), 123);
    NULL(output.get("BBB"));
    NULL(output.get("CCC"));

    output.put("CCC", "あいうえお");
    EQUAL(output.getName(), "xyz");
    EQUAL(output.get("AAA"), 123);
    NULL(output.get("BBB"));
    EQUAL(output.get("CCC"), "あいうえお");

    output.put("AAA", null);
    EQUAL(output.getName(), "xyz");
    NULL(output.get("AAA"));
    NULL(output.get("BBB"));
    EQUAL(output.get("CCC"), "あいうえお");

    output.put(null, 999);
    EQUAL(output.getName(), "xyz");
    NULL(output.get("AAA"));
    NULL(output.get("BBB"));
    EQUAL(output.get("CCC"), "あいうえお");
    EQUAL(output.get(null), 999);
  }

  public void equals()
  {
    MSG("オブジェクトが等しいかどうかを判定するメソッドの確認。");

    QueryOutput output0 = new QueryOutput("xyz");
    QueryOutput output1 = new QueryOutput("xyz");
    QueryOutput output2 = new QueryOutput("abc");
    QueryOutput output3 = new QueryOutput("xyz0");
    QueryOutput output4 = new QueryOutput("XYZ");
    QueryOutput output5 = new QueryOutput("xyz") {
      private static final long serialVersionUID = -1L;
    };

    TRUE(output0.equals(output0));
    TRUE(output0.equals(output1));
    TRUE(output1.equals(output0));
    FALSE(output0.equals(output2));
    FALSE(output2.equals(output0));
    FALSE(output0.equals(output3));
    FALSE(output3.equals(output0));
    FALSE(output0.equals(output4));
    FALSE(output4.equals(output0));
    TRUE(output0.equals(output5));
    TRUE(output5.equals(output0));
  }

  public void equals_obj_Null()
  {
    MSG("引数がヌルの場合。");

    QueryOutput output0 = new QueryOutput("xyz");
    FALSE(output0.equals(null));
  }

  public void equals_obj_OtherClass()
  {
    MSG("引数が他のクラスのインスタンスの場合。");

    QueryOutput output0 = new QueryOutput("xyz");
    QueryParam param0 = new QueryParam("xyz");
    String str0 = "xyz";

    FALSE(output0.equals(param0));
    FALSE(output0.equals(str0));
  }

  public void _hashCode()
  {
    MSG("ハッシュ・コードを求めるメソッドの確認。");

    Map<QueryOutput,QueryOutput> map = new HashMap<QueryOutput,QueryOutput>();

    QueryOutput output0 = new QueryOutput("xyz");
    QueryOutput output1 = new QueryOutput("xyz");
    QueryOutput output2 = new QueryOutput("abc");
    QueryOutput output3 = new QueryOutput("xyz0");
    QueryOutput output4 = new QueryOutput("XYZ");
    QueryOutput output5 = new QueryOutput("xyz") {
      private static final long serialVersionUID = -1L;
    };

    map.put(output0, output0);
    EQUAL(map.size(), 1);
    EQUAL(map.get(output0), output0);
    EQUAL(map.get(output1), output0);
    NULL(map.get(output2));
    NULL(map.get(output3));
    NULL(map.get(output4));
    EQUAL(map.get(output5), output0);

    map.put(output1, output1);
    EQUAL(map.size(), 1);
    EQUAL(map.get(output0), output1);
    EQUAL(map.get(output1), output1);
    NULL(map.get(output2));
    NULL(map.get(output3));
    NULL(map.get(output4));
    EQUAL(map.get(output5), output1);

    map.put(output2, output2);
    EQUAL(map.size(), 2);
    EQUAL(map.get(output0), output1);
    EQUAL(map.get(output1), output1);
    EQUAL(map.get(output2), output2);
    NULL(map.get(output3));
    NULL(map.get(output4));
    EQUAL(map.get(output5), output1);

    map.put(output3, output3);
    EQUAL(map.size(), 3);
    EQUAL(map.get(output0), output1);
    EQUAL(map.get(output1), output1);
    EQUAL(map.get(output2), output2);
    EQUAL(map.get(output3), output3);
    NULL(map.get(output4));
    EQUAL(map.get(output5), output1);

    map.put(output4, output4);
    EQUAL(map.size(), 4);
    EQUAL(map.get(output0), output1);
    EQUAL(map.get(output1), output1);
    EQUAL(map.get(output2), output2);
    EQUAL(map.get(output3), output3);
    EQUAL(map.get(output4), output4);
    EQUAL(map.get(output5), output1);

    map.put(output5, output5);
    EQUAL(map.size(), 4);
    EQUAL(map.get(output0), output5);
    EQUAL(map.get(output1), output5);
    EQUAL(map.get(output2), output2);
    EQUAL(map.get(output3), output3);
    EQUAL(map.get(output4), output4);
    EQUAL(map.get(output5), output5);
  }
}
