package ts.query;

import ts.tester.UnitTest;
import ts.util.*;
import java.util.*;

public class QueryResultListTest extends UnitTest
{
  public static void main(String[] args)
  {
    run(QueryResultListTest.class, args);
  }

  public void constructor()
  {
    MSG("デフォルト・コンストラクタの確認。");

    QueryResultList rsltLst = new QueryResultList();
    TRUE(rsltLst.isSuccess());
    EQUAL(rsltLst.getSpentTimeMillis(), 0L);
    EQUAL(rsltLst.countResults(), 0);
    EQUAL(rsltLst.getAllResults().size(), 0);
    NULL(rsltLst.getFirstResult());
    NULL(rsltLst.getLastResult());
    EQUAL(rsltLst.getResultsByConnectionId("c0").size(), 0);
    NULL(rsltLst.getFirstResultByConnectionId("c0"));
    NULL(rsltLst.getLastResultByConnectionId("c0"));
    EQUAL(rsltLst.getResultsByQueryId("q0").size(), 0);
    NULL(rsltLst.getFirstResultByQueryId("q0"));
    NULL(rsltLst.getLastResultByQueryId("q0"));

    try {
      rsltLst.getAllResults().add(new QueryResult("c0", "q0"));
      NG();
    } catch (UnsupportedOperationException e) {
      OK(e);
    }
    try {
      rsltLst.getResultsByConnectionId("c0").add(new QueryResult("c0", "q0"));
      NG();
    } catch (UnsupportedOperationException e) {
      OK(e);
    }
    try {
      rsltLst.getResultsByQueryId("q0").add(new QueryResult("c0", "q0"));
      NG();
    } catch (UnsupportedOperationException e) {
      OK(e);
    }
  }

  public void setSuccess_bool()
  {
    MSG("結果の成否を設定するメソッドの確認。");

    QueryResultList rsltLst = new QueryResultList();
    TRUE(rsltLst.isSuccess());
    EQUAL(rsltLst.getSpentTimeMillis(), 0L);
    EQUAL(rsltLst.countResults(), 0);
    EQUAL(rsltLst.getAllResults().size(), 0);
    NULL(rsltLst.getFirstResult());
    NULL(rsltLst.getLastResult());
    EQUAL(rsltLst.getResultsByConnectionId("c0").size(), 0);
    NULL(rsltLst.getFirstResultByConnectionId("c0"));
    NULL(rsltLst.getLastResultByConnectionId("c0"));
    EQUAL(rsltLst.getResultsByQueryId("q0").size(), 0);
    NULL(rsltLst.getFirstResultByQueryId("q0"));
    NULL(rsltLst.getLastResultByQueryId("q0"));

    QueryResult rslt0 = new QueryResult("c0", "q0");
    rslt0.setSuccess(true);
    rsltLst.addResult(rslt0);
    TRUE(rsltLst.isSuccess());
    EQUAL(rsltLst.getSpentTimeMillis(), 0L);
    EQUAL(rsltLst.countResults(), 1);
    EQUAL(rsltLst.getAllResults().size(), 1);
    EQUAL(rsltLst.getAllResults().get(0), rslt0);
    EQUAL(rsltLst.getFirstResult(), rslt0);
    EQUAL(rsltLst.getLastResult(), rslt0);
    EQUAL(rsltLst.getResultsByConnectionId("c0").size(), 1);
    EQUAL(rsltLst.getResultsByConnectionId("c1").size(), 0);
    EQUAL(rsltLst.getResultsByConnectionId("c2").size(), 0);
    EQUAL(rsltLst.getFirstResultByConnectionId("c0"), rslt0);
    NULL(rsltLst.getFirstResultByConnectionId("c1"));
    NULL(rsltLst.getFirstResultByConnectionId("c2"));
    EQUAL(rsltLst.getLastResultByConnectionId("c0"), rslt0);
    NULL(rsltLst.getLastResultByConnectionId("c1"));
    NULL(rsltLst.getLastResultByConnectionId("c2"));
    EQUAL(rsltLst.getResultsByQueryId("q0").size(), 1);
    EQUAL(rsltLst.getResultsByQueryId("q1").size(), 0);
    EQUAL(rsltLst.getResultsByQueryId("q2").size(), 0);
    EQUAL(rsltLst.getFirstResultByQueryId("q0"), rslt0);
    NULL(rsltLst.getFirstResultByQueryId("q1"));
    NULL(rsltLst.getFirstResultByQueryId("q2"));
    EQUAL(rsltLst.getLastResultByQueryId("q0"), rslt0);
    NULL(rsltLst.getLastResultByQueryId("q1"));
    NULL(rsltLst.getLastResultByQueryId("q2"));

    QueryResult rslt1 = new QueryResult("c1", "q1");
    rslt1.setSuccess(false);
    rsltLst.addResult(rslt1);
    FALSE(rsltLst.isSuccess());
    EQUAL(rsltLst.getSpentTimeMillis(), 0L);
    EQUAL(rsltLst.countResults(), 2);
    EQUAL(rsltLst.getAllResults().size(), 2);
    EQUAL(rsltLst.getAllResults().get(0), rslt0);
    EQUAL(rsltLst.getAllResults().get(1), rslt1);
    EQUAL(rsltLst.getFirstResult(), rslt0);
    EQUAL(rsltLst.getLastResult(), rslt1);
    EQUAL(rsltLst.getResultsByConnectionId("c0").size(), 1);
    EQUAL(rsltLst.getResultsByConnectionId("c1").size(), 1);
    EQUAL(rsltLst.getResultsByConnectionId("c2").size(), 0);
    EQUAL(rsltLst.getFirstResultByConnectionId("c0"), rslt0);
    EQUAL(rsltLst.getFirstResultByConnectionId("c1"), rslt1);
    NULL(rsltLst.getFirstResultByConnectionId("c2"));
    EQUAL(rsltLst.getLastResultByConnectionId("c0"), rslt0);
    EQUAL(rsltLst.getLastResultByConnectionId("c1"), rslt1);
    NULL(rsltLst.getLastResultByConnectionId("c2"));
    EQUAL(rsltLst.getResultsByQueryId("q0").size(), 1);
    EQUAL(rsltLst.getResultsByQueryId("q1").size(), 1);
    EQUAL(rsltLst.getResultsByQueryId("q2").size(), 0);
    EQUAL(rsltLst.getFirstResultByQueryId("q0"), rslt0);
    EQUAL(rsltLst.getFirstResultByQueryId("q1"), rslt1);
    NULL(rsltLst.getFirstResultByQueryId("q2"));
    EQUAL(rsltLst.getLastResultByQueryId("q0"), rslt0);
    EQUAL(rsltLst.getLastResultByQueryId("q1"), rslt1);
    NULL(rsltLst.getLastResultByQueryId("q2"));

    QueryResult rslt2 = new QueryResult("c2", "q2");
    rslt2.setSuccess(true);
    rsltLst.addResult(rslt2);
    FALSE(rsltLst.isSuccess());
    EQUAL(rsltLst.getSpentTimeMillis(), 0L);
    EQUAL(rsltLst.countResults(), 3);
    EQUAL(rsltLst.getAllResults().size(), 3);
    EQUAL(rsltLst.getAllResults().get(0), rslt0);
    EQUAL(rsltLst.getAllResults().get(1), rslt1);
    EQUAL(rsltLst.getAllResults().get(2), rslt2);
    EQUAL(rsltLst.getFirstResult(), rslt0);
    EQUAL(rsltLst.getLastResult(), rslt2);
    EQUAL(rsltLst.getResultsByConnectionId("c0").size(), 1);
    EQUAL(rsltLst.getResultsByConnectionId("c1").size(), 1);
    EQUAL(rsltLst.getResultsByConnectionId("c2").size(), 1);
    EQUAL(rsltLst.getFirstResultByConnectionId("c0"), rslt0);
    EQUAL(rsltLst.getFirstResultByConnectionId("c1"), rslt1);
    EQUAL(rsltLst.getFirstResultByConnectionId("c2"), rslt2);
    EQUAL(rsltLst.getLastResultByConnectionId("c0"), rslt0);
    EQUAL(rsltLst.getLastResultByConnectionId("c1"), rslt1);
    EQUAL(rsltLst.getLastResultByConnectionId("c2"), rslt2);
    EQUAL(rsltLst.getResultsByQueryId("q0").size(), 1);
    EQUAL(rsltLst.getResultsByQueryId("q1").size(), 1);
    EQUAL(rsltLst.getResultsByQueryId("q2").size(), 1);
    EQUAL(rsltLst.getFirstResultByQueryId("q0"), rslt0);
    EQUAL(rsltLst.getFirstResultByQueryId("q1"), rslt1);
    EQUAL(rsltLst.getFirstResultByQueryId("q2"), rslt2);
    EQUAL(rsltLst.getLastResultByQueryId("q0"), rslt0);
    EQUAL(rsltLst.getLastResultByQueryId("q1"), rslt1);
    EQUAL(rsltLst.getLastResultByQueryId("q2"), rslt2);
  }
  
  public void setAndResetSpentTimeMillis_long()
  {
    MSG("処理時間を設定・リセットするメソッドの確認。");

    QueryResultList rsltLst = new QueryResultList();
    TRUE(rsltLst.isSuccess());
    EQUAL(rsltLst.getSpentTimeMillis(), 0L);
    EQUAL(rsltLst.countResults(), 0);
    EQUAL(rsltLst.getAllResults().size(), 0);
    NULL(rsltLst.getFirstResult());
    NULL(rsltLst.getLastResult());
    EQUAL(rsltLst.getResultsByConnectionId("c0").size(), 0);
    EQUAL(rsltLst.getResultsByConnectionId("c1").size(), 0);
    EQUAL(rsltLst.getResultsByConnectionId("c2").size(), 0);
    NULL(rsltLst.getFirstResultByConnectionId("c0"));
    NULL(rsltLst.getFirstResultByConnectionId("c1"));
    NULL(rsltLst.getFirstResultByConnectionId("c2"));
    NULL(rsltLst.getLastResultByConnectionId("c0"));
    NULL(rsltLst.getLastResultByConnectionId("c1"));
    NULL(rsltLst.getLastResultByConnectionId("c2"));
    EQUAL(rsltLst.getResultsByQueryId("q0").size(), 0);
    EQUAL(rsltLst.getResultsByQueryId("q1").size(), 0);
    EQUAL(rsltLst.getResultsByQueryId("q2").size(), 0);
    NULL(rsltLst.getFirstResultByQueryId("q0"));
    NULL(rsltLst.getFirstResultByQueryId("q1"));
    NULL(rsltLst.getFirstResultByQueryId("q2"));
    NULL(rsltLst.getLastResultByQueryId("q0"));
    NULL(rsltLst.getLastResultByQueryId("q1"));
    NULL(rsltLst.getLastResultByQueryId("q2"));

    rsltLst.setSpentTimeMillis(100L);
    TRUE(rsltLst.isSuccess());
    EQUAL(rsltLst.getSpentTimeMillis(), 100L);
    EQUAL(rsltLst.countResults(), 0);
    EQUAL(rsltLst.getAllResults().size(), 0);
    NULL(rsltLst.getFirstResult());
    NULL(rsltLst.getLastResult());
    EQUAL(rsltLst.getResultsByConnectionId("c0").size(), 0);
    EQUAL(rsltLst.getResultsByConnectionId("c1").size(), 0);
    EQUAL(rsltLst.getResultsByConnectionId("c2").size(), 0);
    NULL(rsltLst.getFirstResultByConnectionId("c0"));
    NULL(rsltLst.getFirstResultByConnectionId("c1"));
    NULL(rsltLst.getFirstResultByConnectionId("c2"));
    NULL(rsltLst.getLastResultByConnectionId("c0"));
    NULL(rsltLst.getLastResultByConnectionId("c1"));
    NULL(rsltLst.getLastResultByConnectionId("c2"));
    EQUAL(rsltLst.getResultsByQueryId("q0").size(), 0);
    EQUAL(rsltLst.getResultsByQueryId("q1").size(), 0);
    EQUAL(rsltLst.getResultsByQueryId("q2").size(), 0);
    NULL(rsltLst.getFirstResultByQueryId("q0"));
    NULL(rsltLst.getFirstResultByQueryId("q1"));
    NULL(rsltLst.getFirstResultByQueryId("q2"));
    NULL(rsltLst.getLastResultByQueryId("q0"));
    NULL(rsltLst.getLastResultByQueryId("q1"));
    NULL(rsltLst.getLastResultByQueryId("q2"));

    rsltLst.resetSpentTimeMillis();
    TRUE(rsltLst.isSuccess());
    EQUAL(rsltLst.getSpentTimeMillis(), 0L);
    EQUAL(rsltLst.countResults(), 0);
    EQUAL(rsltLst.getAllResults().size(), 0);
    NULL(rsltLst.getFirstResult());
    NULL(rsltLst.getLastResult());
    EQUAL(rsltLst.getResultsByConnectionId("c0").size(), 0);
    EQUAL(rsltLst.getResultsByConnectionId("c1").size(), 0);
    EQUAL(rsltLst.getResultsByConnectionId("c2").size(), 0);
    NULL(rsltLst.getFirstResultByConnectionId("c0"));
    NULL(rsltLst.getFirstResultByConnectionId("c1"));
    NULL(rsltLst.getFirstResultByConnectionId("c2"));
    NULL(rsltLst.getLastResultByConnectionId("c0"));
    NULL(rsltLst.getLastResultByConnectionId("c1"));
    NULL(rsltLst.getLastResultByConnectionId("c2"));
    EQUAL(rsltLst.getResultsByQueryId("q0").size(), 0);
    EQUAL(rsltLst.getResultsByQueryId("q1").size(), 0);
    EQUAL(rsltLst.getResultsByQueryId("q2").size(), 0);
    NULL(rsltLst.getFirstResultByQueryId("q0"));
    NULL(rsltLst.getFirstResultByQueryId("q1"));
    NULL(rsltLst.getFirstResultByQueryId("q2"));
    NULL(rsltLst.getLastResultByQueryId("q0"));
    NULL(rsltLst.getLastResultByQueryId("q1"));
    NULL(rsltLst.getLastResultByQueryId("q2"));

    rsltLst.setSpentTimeMillis(100L);
    TRUE(rsltLst.isSuccess());
    EQUAL(rsltLst.getSpentTimeMillis(), 100L);
    EQUAL(rsltLst.countResults(), 0);
    EQUAL(rsltLst.getAllResults().size(), 0);
    NULL(rsltLst.getFirstResult());
    NULL(rsltLst.getLastResult());
    EQUAL(rsltLst.getResultsByConnectionId("c0").size(), 0);
    EQUAL(rsltLst.getResultsByConnectionId("c1").size(), 0);
    EQUAL(rsltLst.getResultsByConnectionId("c2").size(), 0);
    NULL(rsltLst.getFirstResultByConnectionId("c0"));
    NULL(rsltLst.getFirstResultByConnectionId("c1"));
    NULL(rsltLst.getFirstResultByConnectionId("c2"));
    NULL(rsltLst.getLastResultByConnectionId("c0"));
    NULL(rsltLst.getLastResultByConnectionId("c1"));
    NULL(rsltLst.getLastResultByConnectionId("c2"));
    EQUAL(rsltLst.getResultsByQueryId("q0").size(), 0);
    EQUAL(rsltLst.getResultsByQueryId("q1").size(), 0);
    EQUAL(rsltLst.getResultsByQueryId("q2").size(), 0);
    NULL(rsltLst.getFirstResultByQueryId("q0"));
    NULL(rsltLst.getFirstResultByQueryId("q1"));
    NULL(rsltLst.getFirstResultByQueryId("q2"));
    NULL(rsltLst.getLastResultByQueryId("q0"));
    NULL(rsltLst.getLastResultByQueryId("q1"));
    NULL(rsltLst.getLastResultByQueryId("q2"));

    QueryResult rslt0 = new QueryResult("c0", "q0");
    rslt0.setSpentTimeMillis(111L);
    rsltLst.addResult(rslt0);
    FALSE(rsltLst.isSuccess());
    EQUAL(rsltLst.getSpentTimeMillis(), 100L);
    EQUAL(rsltLst.countResults(), 1);
    EQUAL(rsltLst.getAllResults().size(), 1);
    EQUAL(rsltLst.getAllResults().get(0), rslt0);
    EQUAL(rsltLst.getFirstResult(), rslt0);
    EQUAL(rsltLst.getLastResult(), rslt0);
    EQUAL(rsltLst.getResultsByConnectionId("c0").size(), 1);
    EQUAL(rsltLst.getResultsByConnectionId("c1").size(), 0);
    EQUAL(rsltLst.getResultsByConnectionId("c2").size(), 0);
    EQUAL(rsltLst.getFirstResultByConnectionId("c0"), rslt0);
    NULL(rsltLst.getFirstResultByConnectionId("c1"));
    NULL(rsltLst.getFirstResultByConnectionId("c2"));
    EQUAL(rsltLst.getLastResultByConnectionId("c0"), rslt0);
    NULL(rsltLst.getLastResultByConnectionId("c1"));
    NULL(rsltLst.getLastResultByConnectionId("c2"));
    EQUAL(rsltLst.getResultsByQueryId("q0").size(), 1);
    EQUAL(rsltLst.getResultsByQueryId("q1").size(), 0);
    EQUAL(rsltLst.getResultsByQueryId("q2").size(), 0);
    EQUAL(rsltLst.getFirstResultByQueryId("q0"), rslt0);
    NULL(rsltLst.getFirstResultByQueryId("q1"));
    NULL(rsltLst.getFirstResultByQueryId("q2"));
    EQUAL(rsltLst.getLastResultByQueryId("q0"), rslt0);
    NULL(rsltLst.getLastResultByQueryId("q1"));
    NULL(rsltLst.getLastResultByQueryId("q2"));

    QueryResult rslt1 = new QueryResult("c1", "q1");
    rslt1.setSpentTimeMillis(222L);
    rsltLst.addResult(rslt1);
    FALSE(rsltLst.isSuccess());
    EQUAL(rsltLst.getSpentTimeMillis(), 100L);
    EQUAL(rsltLst.countResults(), 2);
    EQUAL(rsltLst.getAllResults().size(), 2);
    EQUAL(rsltLst.getAllResults().get(0), rslt0);
    EQUAL(rsltLst.getAllResults().get(1), rslt1);
    EQUAL(rsltLst.getFirstResult(), rslt0);
    EQUAL(rsltLst.getLastResult(), rslt1);
    EQUAL(rsltLst.getResultsByConnectionId("c0").size(), 1);
    EQUAL(rsltLst.getResultsByConnectionId("c1").size(), 1);
    EQUAL(rsltLst.getResultsByConnectionId("c2").size(), 0);
    EQUAL(rsltLst.getFirstResultByConnectionId("c0"), rslt0);
    EQUAL(rsltLst.getFirstResultByConnectionId("c1"), rslt1);
    NULL(rsltLst.getFirstResultByConnectionId("c2"));
    EQUAL(rsltLst.getLastResultByConnectionId("c0"), rslt0);
    EQUAL(rsltLst.getLastResultByConnectionId("c1"), rslt1);
    NULL(rsltLst.getLastResultByConnectionId("c2"));
    EQUAL(rsltLst.getResultsByQueryId("q0").size(), 1);
    EQUAL(rsltLst.getResultsByQueryId("q1").size(), 1);
    EQUAL(rsltLst.getResultsByQueryId("q2").size(), 0);
    EQUAL(rsltLst.getFirstResultByQueryId("q0"), rslt0);
    EQUAL(rsltLst.getFirstResultByQueryId("q1"), rslt1);
    NULL(rsltLst.getFirstResultByQueryId("q2"));
    EQUAL(rsltLst.getLastResultByQueryId("q0"), rslt0);
    EQUAL(rsltLst.getLastResultByQueryId("q1"), rslt1);
    NULL(rsltLst.getLastResultByQueryId("q2"));

    rsltLst.resetSpentTimeMillis();
    FALSE(rsltLst.isSuccess());
    EQUAL(rsltLst.getSpentTimeMillis(), 333L);
    EQUAL(rsltLst.countResults(), 2);
    EQUAL(rsltLst.getAllResults().size(), 2);
    EQUAL(rsltLst.getAllResults().get(0), rslt0);
    EQUAL(rsltLst.getAllResults().get(1), rslt1);
    EQUAL(rsltLst.getFirstResult(), rslt0);
    EQUAL(rsltLst.getLastResult(), rslt1);
    EQUAL(rsltLst.getResultsByConnectionId("c0").size(), 1);
    EQUAL(rsltLst.getResultsByConnectionId("c1").size(), 1);
    EQUAL(rsltLst.getResultsByConnectionId("c2").size(), 0);
    EQUAL(rsltLst.getFirstResultByConnectionId("c0"), rslt0);
    EQUAL(rsltLst.getFirstResultByConnectionId("c1"), rslt1);
    NULL(rsltLst.getFirstResultByConnectionId("c2"));
    EQUAL(rsltLst.getLastResultByConnectionId("c0"), rslt0);
    EQUAL(rsltLst.getLastResultByConnectionId("c1"), rslt1);
    NULL(rsltLst.getLastResultByConnectionId("c2"));
    EQUAL(rsltLst.getResultsByQueryId("q0").size(), 1);
    EQUAL(rsltLst.getResultsByQueryId("q1").size(), 1);
    EQUAL(rsltLst.getResultsByQueryId("q2").size(), 0);
    EQUAL(rsltLst.getFirstResultByQueryId("q0"), rslt0);
    EQUAL(rsltLst.getFirstResultByQueryId("q1"), rslt1);
    NULL(rsltLst.getFirstResultByQueryId("q2"));
    EQUAL(rsltLst.getLastResultByQueryId("q0"), rslt0);
    EQUAL(rsltLst.getLastResultByQueryId("q1"), rslt1);
    NULL(rsltLst.getLastResultByQueryId("q2"));

    QueryResult rslt2 = new QueryResult("c2", "q2");
    rslt2.setSpentTimeMillis(333L);
    rsltLst.addResult(rslt2);
    FALSE(rsltLst.isSuccess());
    EQUAL(rsltLst.getSpentTimeMillis(), 666L);
    EQUAL(rsltLst.countResults(), 3);
    EQUAL(rsltLst.getAllResults().size(), 3);
    EQUAL(rsltLst.getAllResults().get(0), rslt0);
    EQUAL(rsltLst.getAllResults().get(1), rslt1);
    EQUAL(rsltLst.getAllResults().get(2), rslt2);
    EQUAL(rsltLst.getFirstResult(), rslt0);
    EQUAL(rsltLst.getLastResult(), rslt2);
    EQUAL(rsltLst.getResultsByConnectionId("c0").size(), 1);
    EQUAL(rsltLst.getResultsByConnectionId("c1").size(), 1);
    EQUAL(rsltLst.getResultsByConnectionId("c2").size(), 1);
    EQUAL(rsltLst.getFirstResultByConnectionId("c0"), rslt0);
    EQUAL(rsltLst.getFirstResultByConnectionId("c1"), rslt1);
    EQUAL(rsltLst.getFirstResultByConnectionId("c2"), rslt2);
    EQUAL(rsltLst.getLastResultByConnectionId("c0"), rslt0);
    EQUAL(rsltLst.getLastResultByConnectionId("c1"), rslt1);
    EQUAL(rsltLst.getLastResultByConnectionId("c2"), rslt2);
    EQUAL(rsltLst.getResultsByQueryId("q0").size(), 1);
    EQUAL(rsltLst.getResultsByQueryId("q1").size(), 1);
    EQUAL(rsltLst.getResultsByQueryId("q2").size(), 1);
    EQUAL(rsltLst.getFirstResultByQueryId("q0"), rslt0);
    EQUAL(rsltLst.getFirstResultByQueryId("q1"), rslt1);
    EQUAL(rsltLst.getFirstResultByQueryId("q2"), rslt2);
    EQUAL(rsltLst.getLastResultByQueryId("q0"), rslt0);
    EQUAL(rsltLst.getLastResultByQueryId("q1"), rslt1);
    EQUAL(rsltLst.getLastResultByQueryId("q2"), rslt2);

    QueryResult rslt3 = new QueryResult("c0", "q1");
    rslt3.setSpentTimeMillis(444L);
    rsltLst.addResult(rslt3);
    FALSE(rsltLst.isSuccess());
    EQUAL(rsltLst.getSpentTimeMillis(), 1110L);
    EQUAL(rsltLst.countResults(), 4);
    EQUAL(rsltLst.getAllResults().size(), 4);
    EQUAL(rsltLst.getAllResults().get(0), rslt0);
    EQUAL(rsltLst.getAllResults().get(1), rslt1);
    EQUAL(rsltLst.getAllResults().get(2), rslt2);
    EQUAL(rsltLst.getAllResults().get(3), rslt3);
    EQUAL(rsltLst.getFirstResult(), rslt0);
    EQUAL(rsltLst.getLastResult(), rslt3);
    EQUAL(rsltLst.getResultsByConnectionId("c0").size(), 2);
    EQUAL(rsltLst.getResultsByConnectionId("c1").size(), 1);
    EQUAL(rsltLst.getResultsByConnectionId("c2").size(), 1);
    EQUAL(rsltLst.getFirstResultByConnectionId("c0"), rslt0);
    EQUAL(rsltLst.getFirstResultByConnectionId("c1"), rslt1);
    EQUAL(rsltLst.getFirstResultByConnectionId("c2"), rslt2);
    EQUAL(rsltLst.getLastResultByConnectionId("c0"), rslt3);
    EQUAL(rsltLst.getLastResultByConnectionId("c1"), rslt1);
    EQUAL(rsltLst.getLastResultByConnectionId("c2"), rslt2);
    EQUAL(rsltLst.getResultsByQueryId("q0").size(), 1);
    EQUAL(rsltLst.getResultsByQueryId("q1").size(), 2);
    EQUAL(rsltLst.getResultsByQueryId("q2").size(), 1);
    EQUAL(rsltLst.getFirstResultByQueryId("q0"), rslt0);
    EQUAL(rsltLst.getFirstResultByQueryId("q1"), rslt1);
    EQUAL(rsltLst.getFirstResultByQueryId("q2"), rslt2);
    EQUAL(rsltLst.getLastResultByQueryId("q0"), rslt0);
    EQUAL(rsltLst.getLastResultByQueryId("q1"), rslt3);
    EQUAL(rsltLst.getLastResultByQueryId("q2"), rslt2);

    rsltLst.setSpentTimeMillis(0L);
    FALSE(rsltLst.isSuccess());
    EQUAL(rsltLst.getSpentTimeMillis(), 0L);
    EQUAL(rsltLst.countResults(), 4);
    EQUAL(rsltLst.getAllResults().size(), 4);
    EQUAL(rsltLst.getAllResults().get(0), rslt0);
    EQUAL(rsltLst.getAllResults().get(1), rslt1);
    EQUAL(rsltLst.getAllResults().get(2), rslt2);
    EQUAL(rsltLst.getAllResults().get(3), rslt3);
    EQUAL(rsltLst.getFirstResult(), rslt0);
    EQUAL(rsltLst.getLastResult(), rslt3);
    EQUAL(rsltLst.getResultsByConnectionId("c0").size(), 2);
    EQUAL(rsltLst.getResultsByConnectionId("c1").size(), 1);
    EQUAL(rsltLst.getResultsByConnectionId("c2").size(), 1);
    EQUAL(rsltLst.getFirstResultByConnectionId("c0"), rslt0);
    EQUAL(rsltLst.getFirstResultByConnectionId("c1"), rslt1);
    EQUAL(rsltLst.getFirstResultByConnectionId("c2"), rslt2);
    EQUAL(rsltLst.getLastResultByConnectionId("c0"), rslt3);
    EQUAL(rsltLst.getLastResultByConnectionId("c1"), rslt1);
    EQUAL(rsltLst.getLastResultByConnectionId("c2"), rslt2);
    EQUAL(rsltLst.getResultsByQueryId("q0").size(), 1);
    EQUAL(rsltLst.getResultsByQueryId("q1").size(), 2);
    EQUAL(rsltLst.getResultsByQueryId("q2").size(), 1);
    EQUAL(rsltLst.getFirstResultByQueryId("q0"), rslt0);
    EQUAL(rsltLst.getFirstResultByQueryId("q1"), rslt1);
    EQUAL(rsltLst.getFirstResultByQueryId("q2"), rslt2);
    EQUAL(rsltLst.getLastResultByQueryId("q0"), rslt0);
    EQUAL(rsltLst.getLastResultByQueryId("q1"), rslt3);
    EQUAL(rsltLst.getLastResultByQueryId("q2"), rslt2);

    rsltLst.setSpentTimeMillis(1L);
    FALSE(rsltLst.isSuccess());
    EQUAL(rsltLst.getSpentTimeMillis(), 1L);
    EQUAL(rsltLst.countResults(), 4);
    EQUAL(rsltLst.getAllResults().size(), 4);
    EQUAL(rsltLst.getAllResults().get(0), rslt0);
    EQUAL(rsltLst.getAllResults().get(1), rslt1);
    EQUAL(rsltLst.getAllResults().get(2), rslt2);
    EQUAL(rsltLst.getAllResults().get(3), rslt3);
    EQUAL(rsltLst.getFirstResult(), rslt0);
    EQUAL(rsltLst.getLastResult(), rslt3);
    EQUAL(rsltLst.getResultsByConnectionId("c0").size(), 2);
    EQUAL(rsltLst.getResultsByConnectionId("c1").size(), 1);
    EQUAL(rsltLst.getResultsByConnectionId("c2").size(), 1);
    EQUAL(rsltLst.getFirstResultByConnectionId("c0"), rslt0);
    EQUAL(rsltLst.getFirstResultByConnectionId("c1"), rslt1);
    EQUAL(rsltLst.getFirstResultByConnectionId("c2"), rslt2);
    EQUAL(rsltLst.getLastResultByConnectionId("c0"), rslt3);
    EQUAL(rsltLst.getLastResultByConnectionId("c1"), rslt1);
    EQUAL(rsltLst.getLastResultByConnectionId("c2"), rslt2);
    EQUAL(rsltLst.getResultsByQueryId("q0").size(), 1);
    EQUAL(rsltLst.getResultsByQueryId("q1").size(), 2);
    EQUAL(rsltLst.getResultsByQueryId("q2").size(), 1);
    EQUAL(rsltLst.getFirstResultByQueryId("q0"), rslt0);
    EQUAL(rsltLst.getFirstResultByQueryId("q1"), rslt1);
    EQUAL(rsltLst.getFirstResultByQueryId("q2"), rslt2);
    EQUAL(rsltLst.getLastResultByQueryId("q0"), rslt0);
    EQUAL(rsltLst.getLastResultByQueryId("q1"), rslt3);
    EQUAL(rsltLst.getLastResultByQueryId("q2"), rslt2);

    rsltLst.resetSpentTimeMillis();
    FALSE(rsltLst.isSuccess());
    EQUAL(rsltLst.getSpentTimeMillis(), 1110L);
    EQUAL(rsltLst.countResults(), 4);
    EQUAL(rsltLst.getAllResults().size(), 4);
    EQUAL(rsltLst.getAllResults().get(0), rslt0);
    EQUAL(rsltLst.getAllResults().get(1), rslt1);
    EQUAL(rsltLst.getAllResults().get(2), rslt2);
    EQUAL(rsltLst.getAllResults().get(3), rslt3);
    EQUAL(rsltLst.getFirstResult(), rslt0);
    EQUAL(rsltLst.getLastResult(), rslt3);
    EQUAL(rsltLst.getResultsByConnectionId("c0").size(), 2);
    EQUAL(rsltLst.getResultsByConnectionId("c1").size(), 1);
    EQUAL(rsltLst.getResultsByConnectionId("c2").size(), 1);
    EQUAL(rsltLst.getFirstResultByConnectionId("c0"), rslt0);
    EQUAL(rsltLst.getFirstResultByConnectionId("c1"), rslt1);
    EQUAL(rsltLst.getFirstResultByConnectionId("c2"), rslt2);
    EQUAL(rsltLst.getLastResultByConnectionId("c0"), rslt3);
    EQUAL(rsltLst.getLastResultByConnectionId("c1"), rslt1);
    EQUAL(rsltLst.getLastResultByConnectionId("c2"), rslt2);
    EQUAL(rsltLst.getResultsByQueryId("q0").size(), 1);
    EQUAL(rsltLst.getResultsByQueryId("q1").size(), 2);
    EQUAL(rsltLst.getResultsByQueryId("q2").size(), 1);
    EQUAL(rsltLst.getFirstResultByQueryId("q0"), rslt0);
    EQUAL(rsltLst.getFirstResultByQueryId("q1"), rslt1);
    EQUAL(rsltLst.getFirstResultByQueryId("q2"), rslt2);
    EQUAL(rsltLst.getLastResultByQueryId("q0"), rslt0);
    EQUAL(rsltLst.getLastResultByQueryId("q1"), rslt3);
    EQUAL(rsltLst.getLastResultByQueryId("q2"), rslt2);
  }

  public void setSpentTimeMillis_long_Negative()
  {
    MSG("引数が負の値の場合。");

    QueryResultList rsltLst = new QueryResultList();

    try {
      rsltLst.setSpentTimeMillis(-1L);
      NG();
    } catch (IllegalArgumentException e) {
      OK(e);
    }
  }

  enum Error {
    Error0, Error1, Error2,
  }

  public void addResult_result()
  {
    MSG("結果オブジェクトを追加するメソッドの確認。");

    ReasonedException exc0 = new ReasonedException(Error.Error0);
    ReasonedException exc1 = new ReasonedException(Error.Error1);
    ReasonedException exc2 = new ReasonedException(Error.Error2);
    ReasonedException exc3 = new ReasonedException(Error.Error2);

    QueryResultList rsltLst = new QueryResultList();
    TRUE (rsltLst.isSuccess());
    EQUAL(rsltLst.getSpentTimeMillis(), 0L);
    EQUAL(rsltLst.countResults(), 0);
    EQUAL(rsltLst.getAllResults().size(), 0);
    NULL (rsltLst.getFirstResult());
    NULL (rsltLst.getLastResult());
    EQUAL(rsltLst.getResultsByConnectionId("c0").size(), 0);
    EQUAL(rsltLst.getResultsByConnectionId("c1").size(), 0);
    EQUAL(rsltLst.getResultsByConnectionId("c2").size(), 0);
    NULL (rsltLst.getFirstResultByConnectionId("c0"));
    NULL (rsltLst.getFirstResultByConnectionId("c1"));
    NULL (rsltLst.getFirstResultByConnectionId("c2"));
    NULL (rsltLst.getLastResultByConnectionId("c0"));
    NULL (rsltLst.getLastResultByConnectionId("c1"));
    NULL (rsltLst.getLastResultByConnectionId("c2"));
    EQUAL(rsltLst.getResultsByQueryId("q0").size(), 0);
    EQUAL(rsltLst.getResultsByQueryId("q1").size(), 0);
    EQUAL(rsltLst.getResultsByQueryId("q2").size(), 0);
    NULL (rsltLst.getFirstResultByQueryId("q0"));
    NULL (rsltLst.getFirstResultByQueryId("q1"));
    NULL (rsltLst.getFirstResultByQueryId("q2"));
    NULL (rsltLst.getLastResultByQueryId("q0"));
    NULL (rsltLst.getLastResultByQueryId("q1"));
    NULL (rsltLst.getLastResultByQueryId("q2"));
    NULL (rsltLst.getResultByException(exc0));
    NULL (rsltLst.getResultByException(exc1));
    NULL (rsltLst.getResultByException(exc2));
    NULL (rsltLst.getResultByException(exc3));

    QueryResult rslt0 = new QueryResult("c0", "q0");
    rslt0.setException(exc0);

    rsltLst.addResult(rslt0);
    FALSE(rsltLst.isSuccess());
    EQUAL(rsltLst.getSpentTimeMillis(), 0L);
    EQUAL(rsltLst.countResults(), 1);
    EQUAL(rsltLst.getAllResults().size(), 1);
    EQUAL(rsltLst.getFirstResult(), rslt0);
    EQUAL(rsltLst.getLastResult(), rslt0);
    EQUAL(rsltLst.getResultsByConnectionId("c0").size(), 1);
    EQUAL(rsltLst.getResultsByConnectionId("c1").size(), 0);
    EQUAL(rsltLst.getResultsByConnectionId("c2").size(), 0);
    EQUAL(rsltLst.getFirstResultByConnectionId("c0"), rslt0);
    NULL (rsltLst.getFirstResultByConnectionId("c1"));
    NULL (rsltLst.getFirstResultByConnectionId("c2"));
    EQUAL(rsltLst.getLastResultByConnectionId("c0"), rslt0);
    NULL (rsltLst.getLastResultByConnectionId("c1"));
    NULL (rsltLst.getLastResultByConnectionId("c2"));
    EQUAL(rsltLst.getResultsByQueryId("q0").size(), 1);
    EQUAL(rsltLst.getResultsByQueryId("q1").size(), 0);
    EQUAL(rsltLst.getResultsByQueryId("q2").size(), 0);
    EQUAL(rsltLst.getFirstResultByQueryId("q0"), rslt0);
    NULL (rsltLst.getFirstResultByQueryId("q1"));
    NULL (rsltLst.getFirstResultByQueryId("q2"));
    EQUAL(rsltLst.getLastResultByQueryId("q0"), rslt0);
    NULL (rsltLst.getLastResultByQueryId("q1"));
    NULL (rsltLst.getLastResultByQueryId("q2"));
    EQUAL(rsltLst.getResultByException(exc0), rslt0);
    NULL (rsltLst.getResultByException(exc1));
    NULL (rsltLst.getResultByException(exc2));
    NULL (rsltLst.getResultByException(exc3));

    QueryResult rslt1 = new QueryResult("c0", "q1");
    rslt1.setException(exc1);

    rsltLst.addResult(rslt1);
    FALSE(rsltLst.isSuccess());
    EQUAL(rsltLst.getSpentTimeMillis(), 0L);
    EQUAL(rsltLst.countResults(), 2);
    EQUAL(rsltLst.getAllResults().size(), 2);
    EQUAL(rsltLst.getFirstResult(), rslt0);
    EQUAL(rsltLst.getLastResult(), rslt1);
    EQUAL(rsltLst.getResultsByConnectionId("c0").size(), 2);
    EQUAL(rsltLst.getResultsByConnectionId("c1").size(), 0);
    EQUAL(rsltLst.getResultsByConnectionId("c2").size(), 0);
    EQUAL(rsltLst.getFirstResultByConnectionId("c0"), rslt0);
    NULL (rsltLst.getFirstResultByConnectionId("c1"));
    NULL (rsltLst.getFirstResultByConnectionId("c2"));
    EQUAL(rsltLst.getLastResultByConnectionId("c0"), rslt1);
    NULL (rsltLst.getLastResultByConnectionId("c1"));
    NULL (rsltLst.getLastResultByConnectionId("c2"));
    EQUAL(rsltLst.getResultsByQueryId("q0").size(), 1);
    EQUAL(rsltLst.getResultsByQueryId("q1").size(), 1);
    EQUAL(rsltLst.getResultsByQueryId("q2").size(), 0);
    EQUAL(rsltLst.getFirstResultByQueryId("q0"), rslt0);
    EQUAL(rsltLst.getFirstResultByQueryId("q1"), rslt1);
    NULL (rsltLst.getFirstResultByQueryId("q2"));
    EQUAL(rsltLst.getLastResultByQueryId("q0"), rslt0);
    EQUAL(rsltLst.getLastResultByQueryId("q1"), rslt1);
    NULL (rsltLst.getLastResultByQueryId("q2"));
    EQUAL(rsltLst.getResultByException(exc0), rslt0);
    EQUAL(rsltLst.getResultByException(exc1), rslt1);
    NULL (rsltLst.getResultByException(exc2));
    NULL (rsltLst.getResultByException(exc3));

    QueryResult rslt2 = new QueryResult("c1", "q1");
    rslt2.setException(exc2);

    rsltLst.addResult(rslt2);
    FALSE(rsltLst.isSuccess());
    EQUAL(rsltLst.getSpentTimeMillis(), 0L);
    EQUAL(rsltLst.countResults(), 3);
    EQUAL(rsltLst.getAllResults().size(), 3);
    EQUAL(rsltLst.getFirstResult(), rslt0);
    EQUAL(rsltLst.getLastResult(), rslt2);
    EQUAL(rsltLst.getResultsByConnectionId("c0").size(), 2);
    EQUAL(rsltLst.getResultsByConnectionId("c1").size(), 1);
    EQUAL(rsltLst.getResultsByConnectionId("c2").size(), 0);
    EQUAL(rsltLst.getFirstResultByConnectionId("c0"), rslt0);
    EQUAL(rsltLst.getFirstResultByConnectionId("c1"), rslt2);
    NULL (rsltLst.getFirstResultByConnectionId("c2"));
    EQUAL(rsltLst.getLastResultByConnectionId("c0"), rslt1);
    EQUAL(rsltLst.getLastResultByConnectionId("c1"), rslt2);
    NULL (rsltLst.getLastResultByConnectionId("c2"));
    EQUAL(rsltLst.getResultsByQueryId("q0").size(), 1);
    EQUAL(rsltLst.getResultsByQueryId("q1").size(), 2);
    EQUAL(rsltLst.getResultsByQueryId("q2").size(), 0);
    EQUAL(rsltLst.getFirstResultByQueryId("q0"), rslt0);
    EQUAL(rsltLst.getFirstResultByQueryId("q1"), rslt1);
    NULL (rsltLst.getFirstResultByQueryId("q2"));
    EQUAL(rsltLst.getLastResultByQueryId("q0"), rslt0);
    EQUAL(rsltLst.getLastResultByQueryId("q1"), rslt2);
    NULL (rsltLst.getLastResultByQueryId("q2"));
    EQUAL(rsltLst.getResultByException(exc0), rslt0);
    EQUAL(rsltLst.getResultByException(exc1), rslt1);
    EQUAL(rsltLst.getResultByException(exc2), rslt2);
    NULL (rsltLst.getResultByException(exc3));

    QueryResult rslt3 = new QueryResult("c2", "q2");
    rslt3.setException(exc3);

    rsltLst.addResult(rslt3);
    FALSE(rsltLst.isSuccess());
    EQUAL(rsltLst.getSpentTimeMillis(), 0L);
    EQUAL(rsltLst.countResults(), 4);
    EQUAL(rsltLst.getAllResults().size(), 4);
    EQUAL(rsltLst.getFirstResult(), rslt0);
    EQUAL(rsltLst.getLastResult(), rslt3);
    EQUAL(rsltLst.getResultsByConnectionId("c0").size(), 2);
    EQUAL(rsltLst.getResultsByConnectionId("c1").size(), 1);
    EQUAL(rsltLst.getResultsByConnectionId("c2").size(), 1);
    EQUAL(rsltLst.getFirstResultByConnectionId("c0"), rslt0);
    EQUAL(rsltLst.getFirstResultByConnectionId("c1"), rslt2);
    EQUAL(rsltLst.getFirstResultByConnectionId("c2"), rslt3);
    EQUAL(rsltLst.getLastResultByConnectionId("c0"), rslt1);
    EQUAL(rsltLst.getLastResultByConnectionId("c1"), rslt2);
    EQUAL(rsltLst.getLastResultByConnectionId("c2"), rslt3);
    EQUAL(rsltLst.getResultsByQueryId("q0").size(), 1);
    EQUAL(rsltLst.getResultsByQueryId("q1").size(), 2);
    EQUAL(rsltLst.getResultsByQueryId("q2").size(), 1);
    EQUAL(rsltLst.getFirstResultByQueryId("q0"), rslt0);
    EQUAL(rsltLst.getFirstResultByQueryId("q1"), rslt1);
    EQUAL(rsltLst.getFirstResultByQueryId("q2"), rslt3);
    EQUAL(rsltLst.getLastResultByQueryId("q0"), rslt0);
    EQUAL(rsltLst.getLastResultByQueryId("q1"), rslt2);
    EQUAL(rsltLst.getLastResultByQueryId("q2"), rslt3);
    EQUAL(rsltLst.getResultByException(exc0), rslt0);
    EQUAL(rsltLst.getResultByException(exc1), rslt1);
    EQUAL(rsltLst.getResultByException(exc2), rslt2);
    EQUAL(rsltLst.getResultByException(exc3), rslt3);
  }

  public void addResult_result_Null()
  {
    MSG("引数がヌルの場合。");

    QueryResultList rsltLst = new QueryResultList();

    try {
      rsltLst.addResult(null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    }
  }

  public void toThreadSafe()
  {
    MSG("スレッド・セーフなQueryResultListオブジェクトの作成。");

    QueryResultList rsltLst = new QueryResultList();
    QueryResultList rsltLst1 = rsltLst.toThreadSafe();

    QueryResult rslt0 = new QueryResult("c0", "q0");
    rslt0.setSuccess(false);
    rslt0.setSpentTimeMillis(123L);
    ReasonedException exc0 = new ReasonedException();
    rslt0.setException(exc0);
    rsltLst1.addResult(rslt0);

    QueryResult rslt1 = new QueryResult("c0", "q1");
    rslt1.setSuccess(false);
    rslt1.setSpentTimeMillis(111L);
    ReasonedException exc1 = new ReasonedException();
    rslt1.setException(exc1);
    rsltLst1.addResult(rslt1);

    rsltLst1.setSpentTimeMillis(999L);

    FALSE(rsltLst.isSuccess());
    EQUAL(rsltLst.getSpentTimeMillis(), 999L);
    EQUAL(rsltLst.countResults(), 2);
    EQUAL(rsltLst.getAllResults().size(), 2);
    EQUAL(rsltLst.getFirstResult(), rslt0);
    EQUAL(rsltLst.getLastResult(), rslt1);
    EQUAL(rsltLst.getResultsByConnectionId("c0").size(), 2);
    EQUAL(rsltLst.getFirstResultByConnectionId("c0"), rslt0);
    EQUAL(rsltLst.getLastResultByConnectionId("c0"), rslt1);
    EQUAL(rsltLst.getResultsByQueryId("q0").size(), 1);
    EQUAL(rsltLst.getResultsByQueryId("q1").size(), 1);
    EQUAL(rsltLst.getFirstResultByQueryId("q0"), rslt0);
    EQUAL(rsltLst.getFirstResultByQueryId("q1"), rslt1);
    EQUAL(rsltLst.getLastResultByQueryId("q0"), rslt0);
    EQUAL(rsltLst.getLastResultByQueryId("q1"), rslt1);
    EQUAL(rsltLst.getResultByException(exc0), rslt0);
    EQUAL(rsltLst.getResultByException(exc1), rslt1);

    FALSE(rsltLst1.isSuccess());
    EQUAL(rsltLst1.getSpentTimeMillis(), 999L);
    EQUAL(rsltLst1.countResults(), 2);
    EQUAL(rsltLst1.getAllResults().size(), 2);
    EQUAL(rsltLst1.getFirstResult(), rslt0);
    EQUAL(rsltLst1.getLastResult(), rslt1);
    EQUAL(rsltLst1.getResultsByConnectionId("c0").size(), 2);
    EQUAL(rsltLst1.getFirstResultByConnectionId("c0"), rslt0);
    EQUAL(rsltLst1.getLastResultByConnectionId("c0"), rslt1);
    EQUAL(rsltLst1.getResultsByQueryId("q0").size(), 1);
    EQUAL(rsltLst1.getResultsByQueryId("q1").size(), 1);
    EQUAL(rsltLst1.getFirstResultByQueryId("q0"), rslt0);
    EQUAL(rsltLst1.getFirstResultByQueryId("q1"), rslt1);
    EQUAL(rsltLst1.getLastResultByQueryId("q0"), rslt0);
    EQUAL(rsltLst1.getLastResultByQueryId("q1"), rslt1);
    EQUAL(rsltLst1.getResultByException(exc0), rslt0);
    EQUAL(rsltLst1.getResultByException(exc1), rslt1);
    
    rsltLst1.resetSpentTimeMillis();
    EQUAL(rsltLst.getSpentTimeMillis(), 234L);
    EQUAL(rsltLst1.getSpentTimeMillis(), 234L);
    
    TRUE(rsltLst1 instanceof QueryResultList.ThreadSafeQueryResultList);
    QueryResultList.ThreadSafeQueryResultList rsltLst11 =
      QueryResultList.ThreadSafeQueryResultList.class.cast(rsltLst1);
    EQUAL(rsltLst11.getInner(), rsltLst);

    EQUAL(rsltLst1, rsltLst1.toThreadSafe());
  }
}
