/*
 * Decompiled with CFR 0.152.
 */
package ts.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ts.util.DateTime;
import ts.util.ReasonedRuntimeException;
import ts.util.TypedGetter;
import ts.util.text.StringSequence;

public abstract class AbstractTypedGetter<K, V>
implements TypedGetter<K> {
    private final Set<Object> trueSet = new HashSet<Object>();
    private DateFormat dateTimeFormat;

    public AbstractTypedGetter() {
        this.trueSet.add(Boolean.TRUE);
        this.trueSet.add(Boolean.TRUE.toString());
        this.dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    }

    protected abstract V get(K var1);

    public void addTrueObject(Object object) {
        this.trueSet.add(object);
    }

    public void removeTrueObject(Object object) {
        this.trueSet.remove(object);
    }

    public void setDateTimeFormat(String string) {
        assert (string != null) : "@param:formatString is null.";
        try {
            this.dateTimeFormat = new SimpleDateFormat(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setDateTimeFormat(DateFormat dateFormat) {
        assert (dateFormat != null) : "@param:format is null.";
        if (dateFormat == null) {
            return;
        }
        this.dateTimeFormat = dateFormat;
    }

    @Override
    public boolean getBoolean(K k) {
        return this.trueSet.contains(this.get(k));
    }

    @Override
    public int getInteger(K k) throws ReasonedRuntimeException {
        V v = this.get(k);
        if (v == null) {
            return 0;
        }
        if (v instanceof Integer) {
            return (Integer)Integer.class.cast(v);
        }
        if (v instanceof Long) {
            return (int)this.limit((Long)Long.class.cast(v), Integer.MIN_VALUE, Integer.MAX_VALUE);
        }
        if (v instanceof BigInteger) {
            return this.limit(new BigDecimal((BigInteger)BigInteger.class.cast(v)), new BigDecimal(Integer.MIN_VALUE), new BigDecimal(Integer.MAX_VALUE)).intValue();
        }
        if (v instanceof BigDecimal) {
            return this.limit((BigDecimal)BigDecimal.class.cast(v), new BigDecimal(Integer.MIN_VALUE), new BigDecimal(Integer.MAX_VALUE)).intValue();
        }
        if (v instanceof Float) {
            return (int)this.limit(((Float)Float.class.cast(v)).floatValue(), -2.1474836E9f, 2.1474836E9f);
        }
        if (v instanceof Double) {
            return (int)this.limit((Double)Double.class.cast(v), -2.147483648E9, 2.147483647E9);
        }
        if (v instanceof Number) {
            return ((Number)Number.class.cast(v)).intValue();
        }
        return this.limit(this.toBigDecimal(v.toString()), new BigDecimal(Integer.MIN_VALUE), new BigDecimal(Integer.MAX_VALUE)).intValue();
    }

    @Override
    public long getLong(K k) {
        V v = this.get(k);
        if (v == null) {
            return 0L;
        }
        if (v instanceof Integer) {
            return ((Integer)Integer.class.cast(v)).intValue();
        }
        if (v instanceof Long) {
            return (Long)Long.class.cast(v);
        }
        if (v instanceof BigInteger) {
            return this.limit(new BigDecimal((BigInteger)BigInteger.class.cast(v)), new BigDecimal(Long.MIN_VALUE), new BigDecimal(Long.MAX_VALUE)).longValue();
        }
        if (v instanceof BigDecimal) {
            return this.limit((BigDecimal)BigDecimal.class.cast(v), new BigDecimal(Long.MIN_VALUE), new BigDecimal(Long.MAX_VALUE)).longValue();
        }
        if (v instanceof Float) {
            return (long)this.limit(((Float)Float.class.cast(v)).floatValue(), -9.223372E18f, 9.223372E18f);
        }
        if (v instanceof Double) {
            return (long)this.limit((Double)Double.class.cast(v), -9.223372036854776E18, 9.223372036854776E18);
        }
        if (v instanceof Number) {
            return ((Number)Number.class.cast(v)).longValue();
        }
        return this.limit(this.toBigDecimal(v.toString()), new BigDecimal(Long.MIN_VALUE), new BigDecimal(Long.MAX_VALUE)).longValue();
    }

    @Override
    public float getFloat(K k) {
        V v = this.get(k);
        if (v == null) {
            return 0.0f;
        }
        if (v instanceof Float) {
            return ((Float)Float.class.cast(v)).floatValue();
        }
        if (v instanceof Double) {
            return new BigDecimal((Double)Double.class.cast(v)).floatValue();
        }
        if (v instanceof BigInteger) {
            return new BigDecimal((BigInteger)BigInteger.class.cast(v)).floatValue();
        }
        if (v instanceof BigDecimal) {
            return ((BigDecimal)BigDecimal.class.cast(v)).floatValue();
        }
        if (v instanceof Number) {
            return ((Number)Number.class.cast(v)).longValue();
        }
        return this.limit(this.toBigDecimal(v.toString()), new BigDecimal(-3.4028234663852886E38), new BigDecimal(3.4028234663852886E38)).floatValue();
    }

    @Override
    public double getDouble(K k) {
        V v = this.get(k);
        if (v == null) {
            return 0.0;
        }
        if (v instanceof Float) {
            return ((Float)Float.class.cast(v)).floatValue();
        }
        if (v instanceof Double) {
            return (Double)Double.class.cast(v);
        }
        if (v instanceof BigInteger) {
            return new BigDecimal((BigInteger)BigInteger.class.cast(v)).doubleValue();
        }
        if (v instanceof BigDecimal) {
            return ((BigDecimal)BigDecimal.class.cast(v)).doubleValue();
        }
        if (v instanceof Number) {
            return ((Number)Number.class.cast(v)).longValue();
        }
        return this.limit(this.toBigDecimal(v.toString()), new BigDecimal(-1.7976931348623157E308), new BigDecimal(Double.MAX_VALUE)).doubleValue();
    }

    @Override
    public BigDecimal getBigDecimal(K k) {
        V v = this.get(k);
        if (v == null) {
            return new BigDecimal(0L);
        }
        if (v instanceof Float) {
            return new BigDecimal(((Float)Float.class.cast(v)).floatValue());
        }
        if (v instanceof Double) {
            return new BigDecimal((Double)Double.class.cast(v));
        }
        if (v instanceof BigInteger) {
            return new BigDecimal((BigInteger)BigInteger.class.cast(v));
        }
        if (v instanceof BigDecimal) {
            return (BigDecimal)BigDecimal.class.cast(v);
        }
        if (v instanceof Number) {
            return new BigDecimal(((Number)Number.class.cast(v)).longValue());
        }
        return this.toBigDecimal(v.toString());
    }

    @Override
    public String getString(K k) {
        V v = this.get(k);
        if (v == null) {
            return "";
        }
        if (v instanceof DateTime) {
            return this.dateTimeFormat.format(((DateTime)DateTime.class.cast(v)).getDate());
        }
        if (v instanceof Date) {
            return this.dateTimeFormat.format((Date)Date.class.cast(v));
        }
        return v.toString();
    }

    @Override
    public String getNumberString(K k, String string) {
        assert (string != null) : "@param:format is null.";
        V v = this.get(k);
        try {
            if (v == null) {
                return "";
            }
            if (v instanceof Float) {
                double d = ((Float)Float.class.cast(v)).doubleValue();
                return new DecimalFormat(string).format(d);
            }
            if (v instanceof Double) {
                double d = (Double)Double.class.cast(v);
                return new DecimalFormat(string).format(d);
            }
            if (v instanceof Number) {
                return new DecimalFormat(string).format(Number.class.cast(v));
            }
            return new DecimalFormat(string).format(new BigDecimal(v.toString()));
        }
        catch (Exception exception) {
            throw new ReasonedRuntimeException(Error.FailToCastNumber, "[number string] <- [" + v + "]", exception);
        }
    }

    @Override
    public String getDateTimeString(K k, String string) {
        assert (string != null) : "@param:format is null.";
        V v = this.get(k);
        try {
            if (v == null) {
                return "";
            }
            if (v instanceof DateTime) {
                Date date = ((DateTime)DateTime.class.cast(v)).getDate();
                return new SimpleDateFormat(string).format(date);
            }
            if (v instanceof Date) {
                Date date = (Date)Date.class.cast(v);
                return new SimpleDateFormat(string).format(date);
            }
            Date date = this.dateTimeFormat.parse(v.toString());
            return new SimpleDateFormat(string).format(date);
        }
        catch (Exception exception) {
            throw new ReasonedRuntimeException(Error.FailToCastDateTime, "[date string] <- [" + v + "]", exception);
        }
    }

    @Override
    public DateTime getDateTime(K k) {
        V v = this.get(k);
        if (v == null) {
            return new DateTime(0L);
        }
        if (v instanceof DateTime) {
            return (DateTime)DateTime.class.cast(v);
        }
        if (v instanceof Date) {
            return new DateTime((Date)Date.class.cast(v));
        }
        try {
            return new DateTime(this.dateTimeFormat.parse(v.toString()));
        }
        catch (Exception exception) {
            throw new ReasonedRuntimeException(Error.FailToCastDateTime, "[DateTime] <- [" + v + "]", exception);
        }
    }

    @Override
    public List<? extends Object> getList(K k) {
        V v = this.get(k);
        if (v == null) {
            return new ArrayList(0);
        }
        if (v instanceof List) {
            return (List)v;
        }
        if (v instanceof Collection) {
            return new ArrayList((Collection)Collection.class.cast(v));
        }
        if (v instanceof Object[]) {
            Object[] objectArray = (Object[])Object[].class.cast(v);
            ArrayList<Object> arrayList = new ArrayList<Object>(objectArray.length);
            for (Object object : objectArray) {
                arrayList.add(object);
            }
            return arrayList;
        }
        if (v instanceof boolean[]) {
            boolean[] blArray = (boolean[])boolean[].class.cast(v);
            ArrayList<Boolean> arrayList = new ArrayList<Boolean>(blArray.length);
            for (boolean bl : blArray) {
                arrayList.add(bl ? Boolean.TRUE : Boolean.FALSE);
            }
            return arrayList;
        }
        if (v instanceof int[]) {
            int[] nArray = (int[])int[].class.cast(v);
            ArrayList<Integer> arrayList = new ArrayList<Integer>(nArray.length);
            for (int n : nArray) {
                arrayList.add(new Integer(n));
            }
            return arrayList;
        }
        if (v instanceof long[]) {
            long[] lArray = (long[])long[].class.cast(v);
            ArrayList<Long> arrayList = new ArrayList<Long>(lArray.length);
            for (long l : lArray) {
                arrayList.add(new Long(l));
            }
            return arrayList;
        }
        if (v instanceof float[]) {
            float[] fArray = (float[])float[].class.cast(v);
            ArrayList<Float> arrayList = new ArrayList<Float>(fArray.length);
            for (float f : fArray) {
                arrayList.add(new Float(f));
            }
            return arrayList;
        }
        if (v instanceof double[]) {
            double[] dArray = (double[])double[].class.cast(v);
            ArrayList<Double> arrayList = new ArrayList<Double>(dArray.length);
            for (double d : dArray) {
                arrayList.add(new Double(d));
            }
            return arrayList;
        }
        if (v instanceof short[]) {
            short[] sArray = (short[])short[].class.cast(v);
            ArrayList<Short> arrayList = new ArrayList<Short>(sArray.length);
            for (short s : sArray) {
                arrayList.add(new Short(s));
            }
            return arrayList;
        }
        if (v instanceof byte[]) {
            byte[] byArray = (byte[])byte[].class.cast(v);
            ArrayList<Byte> arrayList = new ArrayList<Byte>(byArray.length);
            for (byte by : byArray) {
                arrayList.add(new Byte(by));
            }
            return arrayList;
        }
        if (v instanceof char[]) {
            char[] cArray = (char[])char[].class.cast(v);
            ArrayList<Character> arrayList = new ArrayList<Character>(cArray.length);
            for (char c : cArray) {
                arrayList.add(new Character(c));
            }
            return arrayList;
        }
        ArrayList<V> arrayList = new ArrayList<V>(1);
        arrayList.add(v);
        return arrayList;
    }

    protected long limit(long l, long l2, long l3) {
        if (l < l2 || l > l3) {
            throw new ReasonedRuntimeException((Enum)Error.FailToCastNumber, "[long][val:" + l + "][min:" + l2 + "][max:" + l3 + "]");
        }
        return l;
    }

    protected float limit(float f, float f2, float f3) {
        if (f < f2 || f > f3) {
            throw new ReasonedRuntimeException((Enum)Error.FailToCastNumber, "[float][val:" + f + "][min:" + f2 + "][max:" + f3 + "]");
        }
        return f;
    }

    protected double limit(double d, double d2, double d3) {
        if (d < d2 || d > d3) {
            throw new ReasonedRuntimeException((Enum)Error.FailToCastNumber, "[double][val:" + d + "][min:" + d2 + "][max:" + d3 + "]");
        }
        return d;
    }

    protected BigDecimal limit(BigDecimal bigDecimal, BigDecimal bigDecimal2, BigDecimal bigDecimal3) {
        if (bigDecimal.compareTo(bigDecimal2) < 0 || bigDecimal.compareTo(bigDecimal3) > 0) {
            throw new ReasonedRuntimeException((Enum)Error.FailToCastNumber, "[BigDecimal][val:" + bigDecimal + "][min:" + bigDecimal2 + "][max:" + bigDecimal3 + "]");
        }
        return bigDecimal;
    }

    protected BigDecimal toBigDecimal(String string) throws ReasonedRuntimeException {
        if (string == null) {
            return new BigDecimal(0);
        }
        String string2 = string.trim();
        if (string2.isEmpty()) {
            return new BigDecimal(0);
        }
        StringSequence stringSequence = new StringSequence(string2);
        String string3 = "";
        if (stringSequence.character().equals("-")) {
            string3 = "-";
            stringSequence.next();
        } else if (stringSequence.character().equals("+")) {
            stringSequence.next();
        }
        stringSequence.skipWhitespaces();
        while (stringSequence.validIndex() && stringSequence.character().equals("0")) {
            stringSequence.next();
        }
        String string4 = stringSequence.substring();
        if (string4.isEmpty()) {
            return new BigDecimal(0);
        }
        try {
            return new BigDecimal(string3 + string4, MathContext.UNLIMITED);
        }
        catch (Exception exception) {
            throw new ReasonedRuntimeException(Error.FailToCastNumber, "[BigDecimal] <- [" + string + "]", exception);
        }
    }

    public static enum Error {
        FailToCastNumber,
        FailToCastDateTime;

    }
}

