/*
 * CountRotator class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.util;

import java.io.Serializable;

/**
 * zJE^NXB
 * <br>
 * JE^̒lێAZĂ߂̃\bh
 * pӂĂB
 * JE^̏lAlAĺAftHgł
 * 0A{@link java.lang.Long#MIN_VALUE}A{@link java.lang.Long#MAX_VALUE}
 * ɐݒ肳邪ARXgN^ŔCӂ̒lw肷邱ƂłB
 * <br>
 * JE^1Z邪AőlɎƂłɉZ
 * ŏlɐݒ肳AJE^̒l͏zB
 * <br>
 * ̃NX̒ڂ̃CX^X̓}`XbhɑΉĂȂA
 * {@link ts.util.CountRotate#synchronizedCountRotate}\bhgpāA
 * XbhZ[tȃCX^X쐬邱ƂłB
 *
 * @author  V. 
 * @version $Revision: 1.2 $, $Date: 2011-08-01 15:29:29 $
 */
public class CountRotate implements Serializable
{
  /** VAEo[WԍB */
  static final long serialVersionUID = 7115246801504112856L;

  /** JE^B */
  private long value_ ;

  /** lB */
  private long minLimit_ ;

  /** lB */
  private long maxLimit_ ;

  /**
   * ftHgRXgN^B
   * <br>
   * JE^̏l[Al{@link java.lang.Long#MIN_VALUE}A
   * l{@link java.lang.Long#MAX_VALUE}ɐݒ肷B
   */
  public CountRotate()
  {
    value_ = 0L;
    minLimit_ = Long.MIN_VALUE;
    maxLimit_ = Long.MAX_VALUE;
  }

  /**
   * JE^̏lɂƂRXgN^B
   * <br>
   * JE^̉l{@link java.lang.Long#MIN_VALUE}A
   * l{@link java.lang.Long#MAX_VALUE}ɐݒ肷B
   *
   * @param  init JE^̏lB
   */
  public CountRotate(long init)
  {
    value_ = init;
    minLimit_ = Long.MIN_VALUE;
    maxLimit_ = Long.MAX_VALUE;
  }

  /**
   * JE^̏lAlAlɂƂRXgN^B
   * <br>
   * ll菬ꍇ́Allɐݒ肷B
   * ll傫ꍇ́Allɐݒ肷B
   * lƏl̑召֌Wt̏ꍇ́A݂ɒlւB
   *
   * @param  init JE^̏lB
   * @param  min  JE^̉lB
   * @param  max  JE^̏lB
   */
  public CountRotate(long init, long min, long max)
  {
    if (min > max) {
      minLimit_ = max;
      maxLimit_ = min;
    }
    else {
      minLimit_ = min;
      maxLimit_ = max;
    }

    if (init < minLimit_) {
      value_ = minLimit_;
    }
    else if (init > maxLimit_) {
      value_ = maxLimit_;
    }
    else {
      value_ = init;
    }
  }

  /**
   * ݂̃JE^l擾B
   *
   * @return ݂̃JE^lB
   */
  public long currentValue()
  {
    return value_ ;
  }

  /**
   * JE^ZB
   * <br>
   * ZÕJE^lől{@link java.lang.Long#MAX_VALUE}̏ꍇ́A
   * Z{@link java.lang.Long#MIN_VALUE}ɂȂB
   *
   * @return Z̃JE^̒lB
   */
  public long increment()
  {
    if (value_ >= maxLimit_) {
      value_ = minLimit_ ;
    }
    else {
      value_ ++;
    }

    return value_ ;
  }

  /**
   * XbhZ[tȏzJE^IuWFNg𐶐B
   * <br>
   * JE^̏l̓[ƂB
   *
   * @return XbhZ[tȏzJE^IuWFNgB
   */
  public static CountRotate synchronizedCountRotate()
  {
    return synchronizedCountRotate(0L);
  }

  /**
   * JE^̏lw肵ăXbhZ[tȏzJE^IuWFNg
   * B
   *
   * @param  init JE^̏lB
   * @return XbhZ[tȏzJE^IuWFNgB
   */
  public static CountRotate synchronizedCountRotate(long init)
  {
    return new CountRotate(init) {
      static final long serialVersionUID = 7115246801504112857L;

      @Override
      public synchronized long currentValue() {
        return super.currentValue();
      }
      @Override
      public synchronized long increment() {
        return super.increment();
      }
    };
  }

  /**
   * JE^̏lAlAlw肵ăXbhZ[t
   * zJE^IuWFNg𐶐B
   *
   * @param  init JE^̏lB
   * @param  min  JE^̉lB
   * @param  max  JE^̏lB
   * @return XbhZ[tȏzJE^IuWFNgB
   */
  public static CountRotate synchronizedCountRotate(
    long init, long min, long max)
  {
    return new CountRotate(init, min, max) {
      static final long serialVersionUID = 7115246801504112858L;

      @Override
      public synchronized long currentValue() {
        return super.currentValue();
      }
      @Override
      public synchronized long increment() {
        return super.increment();
      }
    };
  }

  /**
   * w肳ꂽzJE^IuWFNǧ݂̒lgpāAXbhZ[t
   * zJE^IuWFNgVɐB
   *
   * @param  c ɂȂzJE^IuWFNgB
   * @return XbhZ[tȏzJE^IuWFNgB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  public static CountRotate synchronizedCountRotate(CountRotate c)
  {
    assert (c != null) : "@param:c is null.";

    return synchronizedCountRotate(c.value_, c.minLimit_, c.maxLimit_);
  }
}
