/*
 * Decompiled with CFR 0.152.
 */
package ts.query;

import java.util.Map;
import ts.query.IQuery;
import ts.query.IQueryHistory;
import ts.query.IQueryResult;
import ts.query.IQueryTransaction;
import ts.query.QueryConfig;
import ts.query.QueryExecutionConfig;
import ts.query.QueryResult;
import ts.query.QueryTransaction;
import ts.util.ReasonedException;
import ts.util.ReasonedRuntimeException;

public class Query
implements IQuery {
    private final QueryConfig config;
    private IQueryTransaction transaction;
    private final boolean isNeededToControlTransaction;

    protected Query(QueryConfig queryConfig) {
        assert (queryConfig != null) : "@param:config is null.";
        this.config = queryConfig;
        this.transaction = this.createDefaultTransaction();
        this.isNeededToControlTransaction = true;
    }

    protected Query(QueryConfig queryConfig, IQueryTransaction iQueryTransaction) {
        assert (queryConfig != null && iQueryTransaction != null) : queryConfig == null ? "@param:config is null." : (iQueryTransaction == null ? "@param:tran is null." : "");
        this.config = queryConfig;
        this.transaction = iQueryTransaction;
        this.isNeededToControlTransaction = false;
    }

    protected IQueryTransaction createDefaultTransaction() {
        return new QueryTransaction();
    }

    protected QueryConfig getConfig() {
        return this.config;
    }

    protected IQueryTransaction getTransaction() {
        return this.transaction;
    }

    @Override
    public IQueryHistory getQueryHistory() {
        return this.getTransaction().getQueryHistory();
    }

    protected boolean isNeededToControlTransaction() {
        return this.isNeededToControlTransaction;
    }

    @Override
    public IQueryResult execute(Map<String, Object> map) throws ReasonedException, ReasonedRuntimeException {
        QueryResult queryResult = new QueryResult(this.getConfig().getQueryId());
        queryResult.setBeginTimeMillis(System.currentTimeMillis());
        if (this.isNeededToControlTransaction()) {
            this.controlTransaction(map, queryResult);
        } else {
            this.executeQuery(map, queryResult);
        }
        queryResult.setEndTimeMillis(System.currentTimeMillis());
        return queryResult;
    }

    protected void controlTransaction(Map<String, Object> map, QueryResult queryResult) throws ReasonedException, ReasonedRuntimeException {
        if (this.isNeededToControlTransaction && this.transaction.getState() == IQueryTransaction.State.Ended) {
            this.transaction = this.createDefaultTransaction();
        }
        IQueryTransaction iQueryTransaction = this.getTransaction();
        try {
            iQueryTransaction.begin();
            this.executeQuery(map, queryResult);
            iQueryTransaction.commit();
        }
        catch (ReasonedException reasonedException) {
            iQueryTransaction.rollback();
            throw reasonedException;
        }
        catch (ReasonedRuntimeException reasonedRuntimeException) {
            iQueryTransaction.rollback();
            throw reasonedRuntimeException;
        }
        catch (RuntimeException runtimeException) {
            iQueryTransaction.rollback();
            throw runtimeException;
        }
        finally {
            iQueryTransaction.end();
        }
    }

    protected void executeQuery(Map<String, Object> map, QueryResult queryResult) throws ReasonedException, ReasonedRuntimeException {
        IQueryTransaction iQueryTransaction = this.getTransaction();
        for (String string : this.getConfig().getExecutionIds()) {
            QueryExecutionConfig queryExecutionConfig = new QueryExecutionConfig(string);
            Object t = queryExecutionConfig.create(iQueryTransaction);
            t.execute(map, queryResult);
        }
    }
}

