/*
 * Decompiled with CFR 0.152.
 */
package ts.query;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import ts.query.IQueryHistory;
import ts.util.ReasonedException;
import ts.util.table.ArrayListTable;
import ts.util.table.DefaultMapComparator;
import ts.util.table.Header;
import ts.util.table.Index;
import ts.util.table.MapComparator;
import ts.util.table.MapIterator;
import ts.util.table.Table;

public class QueryHistory
implements IQueryHistory {
    static final long serialVersionUID = 1063227293342192945L;
    protected final Table<IQueryHistory.Item, Serializable> historyTable = this.newHistoryTable();
    protected final Index<IQueryHistory.Item, Serializable> historyIndexForQidCidEid = this.historyTable.getIndex((Object[])new IQueryHistory.Item[]{IQueryHistory.Item.QueryId, IQueryHistory.Item.ConnectionId, IQueryHistory.Item.ExecutionId});
    protected final Index<IQueryHistory.Item, Serializable> historyIndexForCidEid = this.historyTable.getIndex((Object[])new IQueryHistory.Item[]{IQueryHistory.Item.ConnectionId, IQueryHistory.Item.ExecutionId});
    protected final Index<IQueryHistory.Item, Serializable> historyIndexForEid = this.historyTable.getIndex((Object[])new IQueryHistory.Item[]{IQueryHistory.Item.ExecutionId});
    protected final Index<IQueryHistory.Item, Serializable> historyIndexForExc = this.historyTable.getIndex((Object[])new IQueryHistory.Item[]{IQueryHistory.Item.Exception});
    protected final MapComparator<IQueryHistory.Item, Serializable> sorter = new DefaultMapComparator((Object[])new IQueryHistory.Item[]{IQueryHistory.Item.EntryDateTime});

    protected Table<IQueryHistory.Item, Serializable> newHistoryTable() {
        ArrayListTable.Header header = new ArrayListTable.Header(12);
        header.addColumn((Object)IQueryHistory.Item.QueryId);
        header.addColumn((Object)IQueryHistory.Item.ConnectionId);
        header.addColumn((Object)IQueryHistory.Item.ExecutionId);
        header.addColumn((Object)IQueryHistory.Item.IsSuccess);
        header.addColumn((Object)IQueryHistory.Item.Exception);
        header.addColumn((Object)IQueryHistory.Item.BeginTime);
        header.addColumn((Object)IQueryHistory.Item.EndTime);
        header.addColumn((Object)IQueryHistory.Item.SpentTime);
        header.addColumn((Object)IQueryHistory.Item.FetchCount);
        header.addColumn((Object)IQueryHistory.Item.UpdateCount);
        header.addColumn((Object)IQueryHistory.Item.Content);
        header.addColumn((Object)IQueryHistory.Item.EntryDateTime);
        return new ArrayListTable((Header)header);
    }

    @Override
    public Map<IQueryHistory.Item, Serializable> appendNew() {
        return this.historyTable.appendNew();
    }

    @Override
    public List<Map<IQueryHistory.Item, Serializable>> getAll() {
        Map map = Collections.emptyMap();
        List list = this.historyTable.select(map);
        Collections.sort(list, this.sorter);
        return list;
    }

    @Override
    public List<Map<IQueryHistory.Item, Serializable>> getByQueryId(String string) {
        List list = this.historyIndexForQidCidEid.select((Object)IQueryHistory.Item.QueryId, (Object)string);
        Collections.sort(list, this.sorter);
        return list;
    }

    @Override
    public List<Map<IQueryHistory.Item, Serializable>> getByConnectionId(String string) {
        List list = this.historyIndexForCidEid.select((Object)IQueryHistory.Item.ConnectionId, (Object)string);
        Collections.sort(list, this.sorter);
        return list;
    }

    @Override
    public List<Map<IQueryHistory.Item, Serializable>> getByConnectionId(String string, String string2) {
        HashMap<IQueryHistory.Item, String> hashMap = new HashMap<IQueryHistory.Item, String>();
        hashMap.put(IQueryHistory.Item.QueryId, string);
        hashMap.put(IQueryHistory.Item.ConnectionId, string2);
        List list = this.historyIndexForQidCidEid.select(hashMap);
        Collections.sort(list, this.sorter);
        return list;
    }

    @Override
    public List<Map<IQueryHistory.Item, Serializable>> getByExecutionId(String string) {
        List list = this.historyIndexForEid.select((Object)IQueryHistory.Item.ExecutionId, (Object)string);
        Collections.sort(list, this.sorter);
        return list;
    }

    @Override
    public List<Map<IQueryHistory.Item, Serializable>> getByExecutionId(String string, String string2) {
        HashMap<IQueryHistory.Item, String> hashMap = new HashMap<IQueryHistory.Item, String>();
        hashMap.put(IQueryHistory.Item.ConnectionId, string);
        hashMap.put(IQueryHistory.Item.ExecutionId, string2);
        List list = this.historyIndexForCidEid.select(hashMap);
        Collections.sort(list, this.sorter);
        return list;
    }

    @Override
    public List<Map<IQueryHistory.Item, Serializable>> getByExecutionId(String string, String string2, String string3) {
        HashMap<IQueryHistory.Item, String> hashMap = new HashMap<IQueryHistory.Item, String>();
        hashMap.put(IQueryHistory.Item.QueryId, string);
        hashMap.put(IQueryHistory.Item.ConnectionId, string2);
        hashMap.put(IQueryHistory.Item.ExecutionId, string3);
        List list = this.historyIndexForQidCidEid.select(hashMap);
        Collections.sort(list, this.sorter);
        return list;
    }

    @Override
    public List<Map<IQueryHistory.Item, Serializable>> getByIsSuccess(boolean bl) {
        LinkedList<Map<IQueryHistory.Item, Serializable>> linkedList = new LinkedList<Map<IQueryHistory.Item, Serializable>>();
        if (bl) {
            MapIterator mapIterator = this.historyTable.records();
            while (mapIterator.hasNext()) {
                Map map = (Map)mapIterator.next();
                if (!Boolean.TRUE.equals(map.get((Object)IQueryHistory.Item.IsSuccess))) continue;
                linkedList.add(map);
            }
        } else {
            MapIterator mapIterator = this.historyTable.records();
            while (mapIterator.hasNext()) {
                Map map = (Map)mapIterator.next();
                if (!Boolean.FALSE.equals(map.get((Object)IQueryHistory.Item.IsSuccess))) continue;
                linkedList.add(map);
            }
        }
        Collections.sort(linkedList, this.sorter);
        return linkedList;
    }

    @Override
    public Map<IQueryHistory.Item, Serializable> getByException(ReasonedException reasonedException) {
        List list = this.historyIndexForCidEid.select((Object)IQueryHistory.Item.Exception, (Object)reasonedException);
        if (list.isEmpty()) {
            return null;
        }
        return (Map)list.get(0);
    }
}

