/*
 * Decompiled with CFR 0.152.
 */
package ts.query;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import ts.query.IQuery;
import ts.query.IQueryConnection;
import ts.query.IQueryExecution;
import ts.query.IQueryHistory;
import ts.query.IQueryTransaction;
import ts.query.QueryConfig;
import ts.query.QueryConnectionConfig;
import ts.query.QueryExecutionConfig;
import ts.query.QueryHistory;
import ts.util.ReasonedException;
import ts.util.ReasonedRuntimeException;

public class QueryTransaction
implements IQueryTransaction {
    private IQueryTransaction.State state = IQueryTransaction.State.Created;
    private long beginTimeMillis = 0L;
    private long limitTimeMillis = 0L;
    private long timeoutMillis = 0L;
    private final Map<String, IQueryConnection> connectionMap = this.newConnectionMap();
    private final QueryHistory history = this.newQueryHistory();

    protected QueryTransaction() {
        this.state = IQueryTransaction.State.Created;
    }

    protected Map<String, IQueryConnection> newConnectionMap() {
        return new LinkedHashMap<String, IQueryConnection>();
    }

    protected QueryHistory newQueryHistory() {
        return new QueryHistory();
    }

    @Override
    public long getBeginTimeMillis() {
        return this.beginTimeMillis;
    }

    @Override
    public long getLimitTimeMillis() {
        if (this.beginTimeMillis <= 0L || this.timeoutMillis <= 0L) {
            return 0L;
        }
        return this.beginTimeMillis + this.timeoutMillis;
    }

    @Override
    public long getTimeoutMillis() {
        return this.timeoutMillis;
    }

    @Override
    public void setTimeoutMillis(long l) {
        this.checkState(new IQueryTransaction.State[]{IQueryTransaction.State.Created});
        this.timeoutMillis = l;
    }

    @Override
    public IQueryHistory getQueryHistory() {
        return this.history;
    }

    @Override
    public IQueryTransaction.State getState() {
        return this.state;
    }

    protected final void changeState(IQueryTransaction.State[] stateArray, IQueryTransaction.State state) throws ReasonedRuntimeException {
        this.checkState(stateArray);
        this.state = state;
    }

    protected final void checkState(IQueryTransaction.State[] stateArray) throws ReasonedRuntimeException {
        assert (stateArray != null) : "@param:allows is null.";
        for (IQueryTransaction.State state : stateArray) {
            if (state != this.getState()) continue;
            return;
        }
        throw new ReasonedRuntimeException((Enum)IQueryTransaction.Error.IllegalState, "[state=" + this.getState().name() + "]");
    }

    @Override
    public void begin() throws ReasonedException, ReasonedRuntimeException {
        this.changeState(new IQueryTransaction.State[]{IQueryTransaction.State.Created}, IQueryTransaction.State.Begining);
        this.beginTimeMillis = System.currentTimeMillis();
        this.limitTimeMillis = this.getTimeoutMillis() > 0L ? this.beginTimeMillis + this.getTimeoutMillis() : 0L;
        this.state = IQueryTransaction.State.Begined;
    }

    @Override
    public void commit() throws ReasonedException, ReasonedRuntimeException {
        this.changeState(new IQueryTransaction.State[]{IQueryTransaction.State.Begined, IQueryTransaction.State.Committed, IQueryTransaction.State.Rollbacked}, IQueryTransaction.State.Committing);
        for (IQueryConnection iQueryConnection : this.connectionMap.values()) {
            iQueryConnection.commit();
        }
        this.state = IQueryTransaction.State.Committed;
    }

    @Override
    public void rollback() throws ReasonedRuntimeException {
        this.changeState(new IQueryTransaction.State[]{IQueryTransaction.State.Begined, IQueryTransaction.State.Committed, IQueryTransaction.State.Rollbacked, IQueryTransaction.State.Rollbacking, IQueryTransaction.State.Rollbacked}, IQueryTransaction.State.Rollbacking);
        ReasonedRuntimeException reasonedRuntimeException = null;
        for (IQueryConnection iQueryConnection : this.connectionMap.values()) {
            try {
                iQueryConnection.rollback();
            }
            catch (ReasonedRuntimeException reasonedRuntimeException2) {
                if (reasonedRuntimeException != null) continue;
                reasonedRuntimeException = reasonedRuntimeException2;
            }
            catch (ReasonedException reasonedException) {
                if (reasonedRuntimeException != null) continue;
                reasonedRuntimeException = new ReasonedRuntimeException(reasonedException.getReason(), "[connection Id=" + iQueryConnection.getConnectionId() + "]", (Throwable)reasonedException);
            }
            catch (Exception exception) {
                if (reasonedRuntimeException != null) continue;
                reasonedRuntimeException = new ReasonedRuntimeException((Enum)IQueryTransaction.Error.FailToRollback, "[connection Id=" + iQueryConnection.getConnectionId() + "]", (Throwable)exception);
            }
        }
        if (reasonedRuntimeException != null) {
            throw reasonedRuntimeException;
        }
        this.state = IQueryTransaction.State.Rollbacked;
    }

    @Override
    public void end() throws ReasonedRuntimeException {
        IQueryTransaction.State state = this.state;
        this.state = IQueryTransaction.State.Ending;
        ArrayList<IQueryConnection> arrayList = new ArrayList<IQueryConnection>(this.connectionMap.values());
        this.connectionMap.clear();
        ReasonedRuntimeException reasonedRuntimeException = null;
        if (state != IQueryTransaction.State.Created && state != IQueryTransaction.State.Ended) {
            for (IQueryConnection iQueryConnection : arrayList) {
                if (iQueryConnection.isClosed()) continue;
                try {
                    iQueryConnection.rollback();
                }
                catch (ReasonedRuntimeException reasonedRuntimeException2) {
                    if (reasonedRuntimeException != null) continue;
                    reasonedRuntimeException = reasonedRuntimeException2;
                }
                catch (ReasonedException reasonedException) {
                    if (reasonedRuntimeException != null) continue;
                    reasonedRuntimeException = new ReasonedRuntimeException(reasonedException.getReason(), "[connection Id=" + iQueryConnection.getConnectionId() + "]", (Throwable)reasonedException);
                }
                catch (Exception exception) {
                    if (reasonedRuntimeException != null) continue;
                    reasonedRuntimeException = new ReasonedRuntimeException((Enum)IQueryTransaction.Error.FailToRollback, "[connection Id=" + iQueryConnection.getConnectionId() + "]", (Throwable)exception);
                }
            }
        }
        for (IQueryConnection iQueryConnection : arrayList) {
            if (iQueryConnection.isClosed()) continue;
            try {
                iQueryConnection.close();
            }
            catch (ReasonedRuntimeException reasonedRuntimeException3) {
                if (reasonedRuntimeException != null) continue;
                reasonedRuntimeException = reasonedRuntimeException3;
            }
            catch (ReasonedException reasonedException) {
                if (reasonedRuntimeException != null) continue;
                reasonedRuntimeException = new ReasonedRuntimeException(reasonedException.getReason(), "[connection Id=" + iQueryConnection.getConnectionId() + "]", (Throwable)reasonedException);
            }
            catch (Exception exception) {
                if (reasonedRuntimeException != null) continue;
                reasonedRuntimeException = new ReasonedRuntimeException((Enum)IQueryTransaction.Error.FailToEnd, "[connection Id=" + iQueryConnection.getConnectionId() + "]", (Throwable)exception);
            }
        }
        if (reasonedRuntimeException != null) {
            throw reasonedRuntimeException;
        }
        this.state = IQueryTransaction.State.Ended;
    }

    protected IQueryConnection findConnection(String string) throws ReasonedException, ReasonedRuntimeException {
        IQueryConnection iQueryConnection = this.connectionMap.get(string);
        if (iQueryConnection == null) {
            QueryConnectionConfig queryConnectionConfig = new QueryConnectionConfig(string);
            iQueryConnection = queryConnectionConfig.create();
            iQueryConnection.open();
            this.connectionMap.put(queryConnectionConfig.getConnectionId(), iQueryConnection);
        }
        return iQueryConnection;
    }

    @Override
    public IQueryConnection getQueryConnection(String string) throws ReasonedException, ReasonedRuntimeException {
        this.checkState(new IQueryTransaction.State[]{IQueryTransaction.State.Begined, IQueryTransaction.State.Committed, IQueryTransaction.State.Rollbacked});
        return this.findConnection(string);
    }

    @Override
    public IQueryExecution getQueryExecution(String string) throws ReasonedException, ReasonedRuntimeException {
        this.checkState(new IQueryTransaction.State[]{IQueryTransaction.State.Begined, IQueryTransaction.State.Committed, IQueryTransaction.State.Rollbacked});
        QueryExecutionConfig queryExecutionConfig = new QueryExecutionConfig(string);
        return queryExecutionConfig.create(this);
    }

    @Override
    public IQuery getQuery(String string) throws ReasonedException, ReasonedRuntimeException {
        this.checkState(new IQueryTransaction.State[]{IQueryTransaction.State.Begined, IQueryTransaction.State.Committed, IQueryTransaction.State.Rollbacked});
        QueryConfig queryConfig = new QueryConfig(string);
        return queryConfig.create(this);
    }
}

