/*
 * 作成日 : 2008/04/09
 *
 * Copyright 2008 Project Tsukuyomi. All rights reserved. 
 */
package jp.sourceforge.tsukuyomi.japanese;

/**
 * 仮名に関するユーティリティクラスです。
 * 
 * @author itoasuka
 */
public class KanaUtil {
	/**
	 * ユーティリティクラスであるため何もしません。
	 */
	private KanaUtil() {
		// 何もしない
	}

	/**
	 * ひらがなをカタカナに変換します。
	 * 
	 * @param src
	 *            変換対象の文字列
	 * @return 変換後の文字列
	 */
	public static String toKatakana(String src) {
		StringBuffer sb = new StringBuffer();

		for (int i = 0; i < src.length(); i++) {
			char c = src.charAt(i);

			if ('\u3041' <= c && c <= '\u3094') {
				sb.append((char) (c - '\u3041' + '\u30A1'));
			} else {
				sb.append(c);
			}
		}

		return sb.toString();
	}

	/**
	 * カタカナをひらがなに変換します。
	 * 
	 * @param src
	 *            変換対象の文字列
	 * @return 変換後の文字列
	 */
	public static String toHiragana(String src) {
		StringBuffer sb = new StringBuffer();

		for (int i = 0; i < src.length(); i++) {
			char c = src.charAt(i);

			if ('\u30A1' <= c && c <= '\u30f3') {
				sb.append((char) (c - '\u30A1' + '\u3041'));
			} else {
				sb.append(c);
			}
		}

		return sb.toString();
	}
}
