/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.jcache;

import edu.emory.mathcs.backport.java.util.concurrent.BlockingQueue;
import edu.emory.mathcs.backport.java.util.concurrent.ExecutionException;
import edu.emory.mathcs.backport.java.util.concurrent.Future;
import edu.emory.mathcs.backport.java.util.concurrent.LinkedBlockingQueue;
import edu.emory.mathcs.backport.java.util.concurrent.ThreadPoolExecutor;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.jcache.JCacheEntry;
import net.sf.ehcache.jcache.JCacheListenerAdaptor;
import net.sf.ehcache.jcache.JCacheStatistics;
import net.sf.jsr107cache.Cache;
import net.sf.jsr107cache.CacheEntry;
import net.sf.jsr107cache.CacheException;
import net.sf.jsr107cache.CacheListener;
import net.sf.jsr107cache.CacheLoader;
import net.sf.jsr107cache.CacheStatistics;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JCache
implements Cache {
    private static final Log LOG = LogFactory.getLog((String)JCache.class.getName());
    private static final int EXECUTOR_KEEP_ALIVE_TIME = 60000;
    private static final int EXECUTOR_MAXIMUM_POOL_SIZE = 10;
    private static final int EXECUTOR_CORE_POOL_SIZE = 0;
    private Ehcache cache;
    private CacheLoader cacheLoader;
    private ThreadPoolExecutor executorService;

    public JCache(Ehcache cache, CacheLoader cacheLoader) {
        this.cache = cache;
        this.executorService = new ThreadPoolExecutor(0, 10, 60000L, TimeUnit.MILLISECONDS, (BlockingQueue)new LinkedBlockingQueue());
        this.cacheLoader = cacheLoader;
    }

    public void setCacheLoader(CacheLoader cacheLoader) {
        this.cacheLoader = cacheLoader;
    }

    public void addListener(CacheListener cacheListener) {
        JCacheListenerAdaptor cacheListenerAdaptor = new JCacheListenerAdaptor(cacheListener);
        this.cache.getCacheEventNotificationService().registerListener(cacheListenerAdaptor);
    }

    public void evict() {
        this.cache.evictExpiredElements();
    }

    public Map getAll(Collection keys) throws CacheException {
        if (keys == null) {
            return new HashMap(0);
        }
        HashMap<Object, Object> map = new HashMap<Object, Object>(keys.size());
        if (this.cacheLoader != null) {
            try {
                map = new HashMap(keys.size());
                ArrayList<KeyedFuture> futures = new ArrayList<KeyedFuture>(keys.size());
                Iterator iterator = keys.iterator();
                while (iterator.hasNext()) {
                    Object key = iterator.next();
                    if (this.cache.isKeyInCache(key)) {
                        map.put(key, this.get(key));
                        continue;
                    }
                    futures.add(new KeyedFuture(key, this.asynchronousLoad(key)));
                }
                for (int i = 0; i < futures.size(); ++i) {
                    KeyedFuture keyedFuture = (KeyedFuture)futures.get(i);
                    keyedFuture.future.get();
                    Object key = keyedFuture.key;
                    map.put(key, this.get(key));
                }
            }
            catch (ExecutionException e) {
                throw new CacheException(e.getMessage(), (Throwable)e);
            }
            catch (InterruptedException e) {
                throw new CacheException(e.getMessage(), (Throwable)e);
            }
        } else {
            Iterator iterator = keys.iterator();
            while (iterator.hasNext()) {
                Object key = iterator.next();
                map.put(key, this.get(key));
            }
        }
        return map;
    }

    public CacheLoader getCacheLoader() {
        return this.cacheLoader;
    }

    public CacheEntry getCacheEntry(Object key) {
        Element element = this.cache.get(key);
        if (element != null) {
            return new JCacheEntry(element);
        }
        return null;
    }

    public CacheStatistics getCacheStatistics() throws IllegalStateException {
        return new JCacheStatistics(this.cache.getStatistics());
    }

    public void load(Object key) throws CacheException {
        if (this.cacheLoader == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"The CacheLoader is null. Returning.");
            }
            return;
        }
        boolean existsOnCall = this.cache.isKeyInCache(key);
        if (existsOnCall) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("The key " + key + " exists in the cache. Returning."));
            }
            return;
        }
        this.asynchronousLoad(key);
    }

    Future asynchronousLoad(final Object key) {
        Future future = this.executorService.submit(new Runnable(){

            public void run() {
                try {
                    boolean existsOnRun = JCache.this.cache.isKeyInCache(key);
                    if (!existsOnRun) {
                        Object value = JCache.this.cacheLoader.load(key);
                        JCache.this.put(key, value);
                    }
                }
                catch (CacheException e) {
                    LOG.debug((Object)("CacheException during load. Load will not be completed. Cause was " + e.getCause()), (Throwable)e);
                }
            }
        });
        return future;
    }

    public void loadAll(Collection keys) throws CacheException {
        if (this.cacheLoader == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"The CacheLoader is null. Returning.");
            }
            return;
        }
        if (keys == null) {
            return;
        }
        this.asynchronousLoadAll(keys);
    }

    Future asynchronousLoadAll(final Collection keys) {
        Future future = this.executorService.submit(new Runnable(){

            public void run() {
                try {
                    ArrayList nonLoadedKeys = new ArrayList(keys.size());
                    Iterator iterator = keys.iterator();
                    while (iterator.hasNext()) {
                        Object key = iterator.next();
                        if (JCache.this.cache.isKeyInCache(key)) continue;
                        nonLoadedKeys.add(key);
                    }
                    Map map = JCache.this.cacheLoader.loadAll(nonLoadedKeys);
                    JCache.this.putAll(map);
                }
                catch (CacheException e) {
                    LOG.debug((Object)("CacheException during load. Load will not be completed. Cause was " + e.getCause()), (Throwable)e);
                }
            }
        });
        return future;
    }

    public Object peek(Object key) {
        Element element = this.cache.get(key);
        if (element != null) {
            return element.getObjectValue();
        }
        return null;
    }

    public void removeListener(CacheListener cacheListener) {
        JCacheListenerAdaptor cacheListenerAdaptor = new JCacheListenerAdaptor(cacheListener);
        this.cache.getCacheEventNotificationService().unregisterListener(cacheListenerAdaptor);
    }

    public int size() {
        return this.cache.getSize();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean containsKey(Object key) {
        return this.cache.isKeyInCache(key);
    }

    public boolean containsValue(Object value) {
        long start = System.currentTimeMillis();
        boolean inCache = this.cache.isValueInCache(value);
        long end = System.currentTimeMillis();
        if (LOG.isWarnEnabled()) {
            LOG.warn((Object)("Performance Warning: containsValue is not recommended. This call took " + (end - start) + " ms"));
        }
        return inCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(Object key) throws RuntimeException {
        Element element = this.cache.get(key);
        if (element != null) {
            return element.getObjectValue();
        }
        if (this.cacheLoader == null) {
            return null;
        }
        try {
            Object object = key;
            synchronized (object) {
                Future future = this.asynchronousLoad(key);
                future.get();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Exception on load", e);
        }
        element = this.cache.getQuiet(key);
        if (element == null) {
            return null;
        }
        return element.getObjectValue();
    }

    public Object put(Object key, Object value) {
        Element element = null;
        if (this.cache.isKeyInCache(key)) {
            element = this.cache.getQuiet(key);
        }
        this.cache.put(new Element(key, value));
        if (element != null) {
            return element.getObjectValue();
        }
        return null;
    }

    public Object remove(Object key) {
        Element element = this.cache.get(key);
        this.cache.remove(key);
        if (element != null) {
            return element.getObjectValue();
        }
        return null;
    }

    public void putAll(Map sourceMap) {
        if (sourceMap == null) {
            return;
        }
        Iterator iterator = sourceMap.keySet().iterator();
        while (iterator.hasNext()) {
            Object key = iterator.next();
            this.cache.put(new Element(key, sourceMap.get(key)));
        }
    }

    public void clear() {
        this.cache.removeAll();
    }

    public Set keySet() {
        List list = this.cache.getKeys();
        HashSet set = new HashSet();
        set.addAll(list);
        return set;
    }

    public Collection values() {
        List list = this.cache.getKeysNoDuplicateCheck();
        HashSet<Object> set = new HashSet<Object>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            Object key = list.get(i);
            Element element = this.cache.get(key);
            if (element == null) continue;
            set.add(element.getObjectValue());
        }
        return set;
    }

    public Set entrySet() {
        List list = this.cache.getKeysNoDuplicateCheck();
        HashSet<JCacheEntry> set = new HashSet<JCacheEntry>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            Object key = list.get(i);
            Element element = this.cache.get(key);
            if (element == null) continue;
            set.add(new JCacheEntry(element));
        }
        return set;
    }

    public void setStatisticsAccuracy(int statisticsAccuracy) {
        this.cache.setStatisticsAccuracy(statisticsAccuracy);
    }

    public Ehcache getBackingCache() {
        return this.cache;
    }

    public String toString() {
        return ((Object)this.cache).toString();
    }

    ThreadPoolExecutor getExecutorService() {
        return this.executorService;
    }

    class KeyedFuture {
        private Object key;
        private Future future;

        public KeyedFuture(Object key, Future future) {
            this.key = key;
            this.future = future;
        }
    }
}

