/*
 * Decompiled with CFR 0.152.
 */
package org.openid4java.consumer;

import java.text.ParseException;
import java.util.Date;
import org.apache.log4j.Logger;
import org.openid4java.consumer.NonceVerifier;
import org.openid4java.util.InternetDateFormat;

public abstract class AbstractNonceVerifier
implements NonceVerifier {
    private static Logger _log = Logger.getLogger(AbstractNonceVerifier.class);
    private static final boolean DEBUG = _log.isDebugEnabled();
    protected static InternetDateFormat _dateFormat = new InternetDateFormat();
    protected int _maxAge;

    protected AbstractNonceVerifier(int maxAge) {
        this._maxAge = maxAge;
    }

    public int getMaxAge() {
        return this._maxAge / 1000;
    }

    public int seen(String idpUrl, String nonce) {
        if (DEBUG) {
            _log.debug((Object)("Verifying nonce: " + nonce));
        }
        Date now = new Date();
        try {
            Date nonceDate = _dateFormat.parse(nonce);
            if (this.isTooOld(now, nonceDate)) {
                _log.warn((Object)("Nonce is too old: " + nonce));
                return 3;
            }
            return this.seen(now, idpUrl, nonce);
        }
        catch (ParseException e) {
            _log.error((Object)("Error verifying the nonce: " + nonce), (Throwable)e);
            return 2;
        }
    }

    protected abstract int seen(Date var1, String var2, String var3);

    protected boolean isTooOld(Date now, Date nonce) {
        long age = now.getTime() - nonce.getTime();
        return age > (long)(this._maxAge * 1000);
    }
}

