/*
 * Decompiled with CFR 0.152.
 */
package org.openid4java.message.ax;

import org.apache.log4j.Logger;
import org.openid4java.message.MessageException;
import org.openid4java.message.Parameter;
import org.openid4java.message.ParameterList;
import org.openid4java.message.ax.AxMessage;

public class StoreResponse
extends AxMessage {
    private static Logger _log = Logger.getLogger(StoreResponse.class);
    private static final boolean DEBUG = _log.isDebugEnabled();

    protected StoreResponse() {
        this._parameters.set(new Parameter("mode", "store_response"));
        if (DEBUG) {
            _log.debug((Object)"Created empty store request.");
        }
    }

    public static StoreResponse createStoreResponse() {
        return new StoreResponse();
    }

    protected StoreResponse(ParameterList params) {
        super(params);
    }

    public static StoreResponse createStoreResponse(ParameterList params) throws MessageException {
        StoreResponse resp = new StoreResponse(params);
        if (!resp.isValid()) {
            throw new MessageException("Invalid parameters for a store response");
        }
        if (DEBUG) {
            _log.debug((Object)("Created store response from parameter list:\n" + params));
        }
        return resp;
    }

    protected void setFailure(String description) {
        this._parameters.set(new Parameter("status", "failure"));
        if (description != null) {
            this._parameters.set(new Parameter("status.description", description));
        }
    }

    public boolean hasFailed() {
        return this._parameters.hasParameter("status") && "failure".equals(this._parameters.getParameterValue("status"));
    }

    public String getStatus() {
        return this._parameters.hasParameter("status") ? this._parameters.getParameterValue("status") : null;
    }

    public String getStatusDescription() {
        return this._parameters.hasParameter("status.description") ? this._parameters.getParameterValue("status.description") : null;
    }

    private boolean isValid() {
        if (this.getStatusDescription() != null && this.getStatus() == null) {
            return false;
        }
        for (Parameter param : this._parameters.getParameters()) {
            String paramName = param.getKey();
            if (!(paramName.equals("mode") || paramName.equals("status") || paramName.equals("status.description"))) {
                _log.warn((Object)("Invalid parameter name in store response: " + paramName));
                return false;
            }
            if (!paramName.equals("status") || "failure".equals(param.getValue())) continue;
            _log.warn((Object)("Invalid status value: " + param.getValue()));
            return false;
        }
        return true;
    }
}

