/*
 * Decompiled with CFR 0.152.
 */
package org.openid4java.message.pape;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.openid4java.message.MessageException;
import org.openid4java.message.Parameter;
import org.openid4java.message.ParameterList;
import org.openid4java.message.pape.PapeMessage;

public class PapeResponse
extends PapeMessage {
    private static Logger _log = Logger.getLogger(PapeResponse.class);
    private static final boolean DEBUG = _log.isDebugEnabled();
    public static final String AUTH_AGE_UNKNOWN = "unknown";
    protected static final List PAPE_FIELDS = Arrays.asList("auth_policies", "auth_age", "nist_auth_level");

    protected PapeResponse() {
        this.set("auth_policies", "");
        if (DEBUG) {
            _log.debug((Object)"Created empty PAPE response.");
        }
    }

    public static PapeResponse createPapeResponse() {
        return new PapeResponse();
    }

    protected PapeResponse(ParameterList params) {
        this._parameters = params;
    }

    public static PapeResponse createPapeResponse(ParameterList params) throws MessageException {
        PapeResponse resp = new PapeResponse(params);
        if (!resp.isValid()) {
            throw new MessageException("Invalid parameters for a PAPE response");
        }
        if (DEBUG) {
            _log.debug((Object)("Created PAPE response from parameter list:\n" + params));
        }
        return resp;
    }

    public String getAuthPolicies() {
        return this.getParameterValue("auth_policies");
    }

    public void setAuthPolicies(String policyUris) {
        this.set("auth_policies", policyUris);
    }

    public void addAuthPolicy(String policyUri) {
        String policies = this.getAuthPolicies();
        if (policies == null || policies.length() == 0) {
            this.setAuthPolicies(policyUri);
        } else {
            this.setAuthPolicies(policies + " " + policyUri);
        }
    }

    public List getAuthPoliciesList() {
        String policies = this.getParameterValue("auth_policies");
        if (policies != null) {
            return Arrays.asList(policies.split(" "));
        }
        return new ArrayList();
    }

    public void setAuthAge(int seconds) {
        if (-1 == seconds) {
            this.set("auth_age", AUTH_AGE_UNKNOWN);
        } else {
            this.set("auth_age", Integer.toString(seconds));
        }
    }

    public int getAuthAge() {
        String authAge = this.getParameterValue("auth_age");
        if (authAge == null) {
            return -1;
        }
        if (AUTH_AGE_UNKNOWN.equals(authAge)) {
            return 0;
        }
        return Integer.parseInt(authAge);
    }

    public int getNistAuthLevel() {
        String level = this.getParameterValue("nist_auth_level");
        if (level != null && level.length() > 0) {
            return Integer.parseInt(level);
        }
        return -1;
    }

    public void setNistAuthLevel(int level) throws MessageException {
        if (level < 0 || level > 4) {
            throw new MessageException("Invalid NIST level: " + level);
        }
        this.set("nist_auth_level", Integer.toString(level));
    }

    private boolean isValid() {
        if (!this._parameters.hasParameter("auth_policies")) {
            _log.warn((Object)"auth_policies is required in a PAPE response.");
            return false;
        }
        Iterator it = this._parameters.getParameters().iterator();
        while (it.hasNext()) {
            String paramName = ((Parameter)it.next()).getKey();
            if (PAPE_FIELDS.contains(paramName)) continue;
            _log.warn((Object)("Invalid parameter name in PAPE response: " + paramName));
            return false;
        }
        return true;
    }
}

