/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.assembler;

import java.util.HashMap;
import java.util.Map;
import org.seasar.framework.container.AutoBindingDef;
import org.seasar.framework.container.IllegalAutoBindingDefRuntimeException;
import org.seasar.framework.container.assembler.AutoBindingAutoDef;
import org.seasar.framework.container.assembler.AutoBindingConstructorDef;
import org.seasar.framework.container.assembler.AutoBindingNoneDef;
import org.seasar.framework.container.assembler.AutoBindingPropertyDef;
import org.seasar.framework.container.assembler.AutoBindingSemiAutoDef;

public final class AutoBindingDefFactory {
    public static final AutoBindingDef AUTO = new AutoBindingAutoDef("auto");
    public static final AutoBindingDef CONSTRUCTOR = new AutoBindingConstructorDef("constructor");
    public static final AutoBindingDef PROPERTY = new AutoBindingPropertyDef("property");
    public static final AutoBindingDef NONE = new AutoBindingNoneDef("none");
    public static final AutoBindingDef SEMIAUTO = new AutoBindingSemiAutoDef("semiauto");
    private static Map autoBindingDefs = new HashMap();

    private AutoBindingDefFactory() {
    }

    public static void addAutoBindingDef(AutoBindingDef autoBindingDef) {
        autoBindingDefs.put(autoBindingDef.getName(), autoBindingDef);
    }

    public static boolean existAutoBindingDef(String name) {
        return autoBindingDefs.containsKey(name);
    }

    public static AutoBindingDef getAutoBindingDef(String name) {
        if (!autoBindingDefs.containsKey(name)) {
            throw new IllegalAutoBindingDefRuntimeException(name);
        }
        return (AutoBindingDef)autoBindingDefs.get(name);
    }

    static {
        AutoBindingDefFactory.addAutoBindingDef(AUTO);
        AutoBindingDefFactory.addAutoBindingDef(CONSTRUCTOR);
        AutoBindingDefFactory.addAutoBindingDef(PROPERTY);
        AutoBindingDefFactory.addAutoBindingDef(NONE);
        AutoBindingDefFactory.addAutoBindingDef(SEMIAUTO);
    }
}

