/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.query;

import java.sql.PreparedStatement;
import java.sql.Statement;
import java.util.List;
import org.seasar.extension.jdbc.BatchUpdate;
import org.seasar.extension.jdbc.EntityMeta;
import org.seasar.extension.jdbc.JdbcContext;
import org.seasar.extension.jdbc.exception.SEntityExistsException;
import org.seasar.extension.jdbc.exception.SOptimisticLockException;
import org.seasar.extension.jdbc.manager.JdbcManagerImplementor;
import org.seasar.extension.jdbc.query.AbstractQuery;
import org.seasar.framework.exception.EmptyRuntimeException;
import org.seasar.framework.util.PreparedStatementUtil;
import org.seasar.framework.util.StatementUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAutoBatchUpdate<T, S extends BatchUpdate<S>>
extends AbstractQuery<S>
implements BatchUpdate<S> {
    protected final List<T> entities;
    protected final EntityMeta entityMeta;
    protected int batchSize;
    protected boolean suppresOptimisticLockException;

    public AbstractAutoBatchUpdate(JdbcManagerImplementor jdbcManager, List<T> entities) {
        super(jdbcManager);
        if (entities == null) {
            throw new NullPointerException("entities");
        }
        if (entities.isEmpty()) {
            throw new EmptyRuntimeException("entities");
        }
        this.entities = entities;
        this.entityMeta = jdbcManager.getEntityMetaFactory().getEntityMeta(entities.get(0).getClass());
    }

    @Override
    public S batchSize(int batchSize) {
        this.batchSize = batchSize;
        return (S)this;
    }

    @Override
    public int[] execute() {
        this.prepare("executeBatch");
        try {
            return this.executeInternal();
        }
        catch (RuntimeException e) {
            if (this.getJdbcManager().getDialect().isUniqueConstraintViolation(e)) {
                throw new SEntityExistsException(this.executedSql, e);
            }
            throw e;
        }
    }

    public List<T> getEntities() {
        return this.entities;
    }

    protected void prepareSql() {
        this.executedSql = this.toSql();
    }

    protected abstract String toSql();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int[] executeInternal() {
        JdbcContext jdbcContext = this.jdbcManager.getJdbcContext();
        try {
            PreparedStatement ps = this.getPreparedStatement(jdbcContext);
            int[] rows = this.executeBatch(ps);
            if (this.isOptimisticLock()) {
                this.validateRows(rows);
            }
            if (this.entityMeta.hasVersionPropertyMeta()) {
                this.incrementVersions();
            }
            int[] nArray = rows;
            return nArray;
        }
        finally {
            if (!jdbcContext.isTransactional()) {
                jdbcContext.destroy();
            }
        }
    }

    protected int[] executeBatch(PreparedStatement ps) {
        int batchSize = this.batchSize > 0 ? this.batchSize : this.jdbcManager.getDialect().getDefaultBatchSize();
        int size = this.entities.size();
        int[] updateRows = new int[size];
        int pos = 0;
        for (int i = 0; i < size; ++i) {
            T entity = this.entities.get(i);
            this.prepareParams(entity);
            this.logSql();
            this.prepareInParams(ps);
            PreparedStatementUtil.addBatch((PreparedStatement)ps);
            this.resetParams();
            if (i != size - 1 && (batchSize <= 0 || (i + 1) % batchSize != 0)) continue;
            int[] rows = PreparedStatementUtil.executeBatch((PreparedStatement)ps);
            System.arraycopy(rows, 0, updateRows, pos, rows.length);
            pos = i + 1;
        }
        return updateRows;
    }

    protected PreparedStatement getPreparedStatement(JdbcContext jdbcContext) {
        PreparedStatement ps = this.createPreparedStatement(jdbcContext);
        if (this.queryTimeout > 0) {
            StatementUtil.setQueryTimeout((Statement)ps, (int)this.queryTimeout);
        }
        this.prepareInParams(ps);
        return ps;
    }

    protected PreparedStatement createPreparedStatement(JdbcContext jdbcContext) {
        return jdbcContext.getPreparedStatement(this.executedSql);
    }

    protected abstract void prepareParams(T var1);

    protected abstract boolean isOptimisticLock();

    protected void validateRows(int[] rows) {
        if (this.suppresOptimisticLockException) {
            return;
        }
        for (int i = 0; i < rows.length; ++i) {
            if (rows[i] != 0) continue;
            throw new SOptimisticLockException(this.entities.get(i));
        }
    }

    protected void incrementVersions() {
    }
}

