/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.where;

import java.util.ArrayList;
import java.util.List;
import org.seasar.extension.jdbc.ConditionType;
import org.seasar.extension.jdbc.Where;
import org.seasar.framework.util.StringUtil;
import org.seasar.framework.util.tiger.CollectionsUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractWhere<T extends AbstractWhere<T>>
implements Where {
    protected StringBuilder criteriaSb = new StringBuilder(100);
    protected List<Object> paramList = new ArrayList<Object>();
    protected List<String> propertyNameList = new ArrayList<String>();
    protected boolean excludesWhitespace;

    protected void addCondition(ConditionType conditionType, String propertyName, Object value) {
        if (this.criteriaSb.length() > 0) {
            this.criteriaSb.append(" and ");
        }
        this.criteriaSb.append(conditionType.getCondition(propertyName, value));
        int size = conditionType.addValue(this.paramList, value);
        for (int i = 0; i < size; ++i) {
            this.propertyNameList.add(propertyName);
        }
    }

    protected Object normalize(Object value) {
        if (this.excludesWhitespace && value instanceof String && StringUtil.isEmpty((String)((String)String.class.cast(value)).trim())) {
            return null;
        }
        return value;
    }

    protected Object[] normalize(Object ... values) {
        if (!this.excludesWhitespace || values == null) {
            return values;
        }
        ArrayList<Object> list = CollectionsUtil.newArrayList(values.length);
        for (int i = 0; i < values.length; ++i) {
            Object normalizedValue = this.normalize(values[i]);
            if (normalizedValue == null) continue;
            list.add(normalizedValue);
        }
        return list.toArray(new Object[list.size()]);
    }

    public T excludesWhitespace() {
        this.excludesWhitespace = true;
        return (T)this;
    }

    @Deprecated
    public T ignoreWhitespace() {
        return this.excludesWhitespace();
    }

    public T eq(String propertyName, Object value) {
        if (ConditionType.EQ.isTarget(value = this.normalize(value))) {
            this.addCondition(ConditionType.EQ, propertyName, value);
        }
        return (T)this;
    }

    public T ne(String propertyName, Object value) {
        if (ConditionType.NE.isTarget(value = this.normalize(value))) {
            this.addCondition(ConditionType.NE, propertyName, value);
        }
        return (T)this;
    }

    public T lt(String propertyName, Object value) {
        if (ConditionType.LT.isTarget(value = this.normalize(value))) {
            this.addCondition(ConditionType.LT, propertyName, value);
        }
        return (T)this;
    }

    public T le(String propertyName, Object value) {
        if (ConditionType.LE.isTarget(value = this.normalize(value))) {
            this.addCondition(ConditionType.LE, propertyName, value);
        }
        return (T)this;
    }

    public T gt(String propertyName, Object value) {
        if (ConditionType.GT.isTarget(value = this.normalize(value))) {
            this.addCondition(ConditionType.GT, propertyName, value);
        }
        return (T)this;
    }

    public T ge(String propertyName, Object value) {
        if (ConditionType.GE.isTarget(value = this.normalize(value))) {
            this.addCondition(ConditionType.GE, propertyName, value);
        }
        return (T)this;
    }

    public T in(String propertyName, Object ... values) {
        if (ConditionType.IN.isTarget(values = this.normalize(values))) {
            this.addCondition(ConditionType.IN, propertyName, values);
        }
        return (T)this;
    }

    public T notIn(String propertyName, Object ... values) {
        if (ConditionType.NOT_IN.isTarget(values = this.normalize(values))) {
            this.addCondition(ConditionType.NOT_IN, propertyName, values);
        }
        return (T)this;
    }

    public T like(String propertyName, String value) {
        Object normalizedValue = this.normalize((Object)value);
        if (ConditionType.LIKE.isTarget(normalizedValue)) {
            this.addCondition(ConditionType.LIKE, propertyName, normalizedValue);
        }
        return (T)this;
    }

    public T starts(String propertyName, String value) {
        Object normalizedValue = this.normalize((Object)value);
        if (ConditionType.STARTS.isTarget(normalizedValue)) {
            this.addCondition(ConditionType.STARTS, propertyName, normalizedValue);
        }
        return (T)this;
    }

    public T ends(String propertyName, String value) {
        Object normalizedValue = this.normalize((Object)value);
        if (ConditionType.ENDS.isTarget(normalizedValue)) {
            this.addCondition(ConditionType.ENDS, propertyName, normalizedValue);
        }
        return (T)this;
    }

    public T contains(String propertyName, String value) {
        Object normalizedValue = this.normalize((Object)value);
        if (ConditionType.CONTAINS.isTarget(normalizedValue)) {
            this.addCondition(ConditionType.CONTAINS, propertyName, normalizedValue);
        }
        return (T)this;
    }

    public T isNull(String propertyName, Boolean value) {
        if (ConditionType.IS_NULL.isTarget(value)) {
            this.addCondition(ConditionType.IS_NULL, propertyName, value);
        }
        return (T)this;
    }

    public T isNotNull(String propertyName, Boolean value) {
        if (ConditionType.IS_NOT_NULL.isTarget(value)) {
            this.addCondition(ConditionType.IS_NOT_NULL, propertyName, value);
        }
        return (T)this;
    }

    @Override
    public String getCriteria() {
        return new String(this.criteriaSb);
    }

    @Override
    public Object[] getParams() {
        return this.paramList.toArray();
    }

    @Override
    public String[] getPropertyNames() {
        return this.propertyNameList.toArray(new String[this.propertyNameList.size()]);
    }
}

