/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.httpsession;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public final class SessionIdUtil {
    public static final String SESSION_ID_KEY = "S2SESSIONID";
    private static final String PART_OF_URI = ";S2SESSIONID=";

    public static String getSessionIdFromCookie(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            return null;
        }
        for (int i = 0; i < cookies.length; ++i) {
            Cookie cookie = cookies[i];
            if (!cookie.getName().equals(SESSION_ID_KEY)) continue;
            return cookie.getValue();
        }
        return null;
    }

    public static String getSessionIdFromURL(HttpServletRequest request) {
        String uri = request.getRequestURI();
        int index = uri.lastIndexOf(PART_OF_URI);
        if (index < 0) {
            return null;
        }
        int index2 = (uri = uri.substring(index + PART_OF_URI.length())).indexOf(63);
        if (index2 < 0) {
            return uri;
        }
        return uri.substring(0, index2);
    }

    public static String rewriteURL(String url, HttpServletRequest request) {
        if (request.isRequestedSessionIdFromCookie()) {
            return url;
        }
        HttpSession session = request.getSession(false);
        if (session == null) {
            return url;
        }
        int index = url.indexOf(63);
        if (index < 0) {
            return url + PART_OF_URI + session.getId();
        }
        return url.substring(0, index) + PART_OF_URI + session.getId() + url.substring(index);
    }

    public static void writeCookie(HttpServletRequest request, HttpServletResponse response, String sessionId) {
        if (request.isRequestedSessionIdFromCookie()) {
            return;
        }
        Cookie cookie = new Cookie(SESSION_ID_KEY, sessionId);
        cookie.setPath(request.getContextPath());
        response.addCookie(cookie);
    }
}

