/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tsukuyomi.openid.impl;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import jp.sourceforge.tsukuyomi.openid.AuthenticationRequest;
import jp.sourceforge.tsukuyomi.openid.OpenID;
import jp.sourceforge.tsukuyomi.openid.OpenIDRuntimeException;
import jp.sourceforge.tsukuyomi.openid.message.AuthRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthenticationRequestImpl
implements AuthenticationRequest {
    private static final Log LOG = LogFactory.getLog(AuthenticationRequestImpl.class);
    private static final String LS = System.getProperty("line.separator");
    private AuthRequest authRequest;
    private HttpServletResponse response;
    private String version;

    public AuthenticationRequestImpl(HttpServletResponse response, AuthRequest authRequest, String version) {
        this.response = response;
        this.authRequest = authRequest;
        this.version = version;
    }

    @Override
    public Map<String, String> getParameterMap() {
        Map<String, String> m = this.authRequest.getParameterMap();
        HashMap<String, String> parameter = new HashMap<String, String>();
        for (Map.Entry<String, String> e : m.entrySet()) {
            parameter.put(e.getKey().toString(), e.getValue().toString());
        }
        return parameter;
    }

    @Override
    public String getPostURL() {
        return this.authRequest.getDestinationUrl(false);
    }

    @Override
    public String getRedirectURL() {
        return this.authRequest.getDestinationUrl(true);
    }

    @Override
    public void sendRedirect() {
        String url = this.getRedirectURL();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Redirect to " + url));
        }
        try {
            this.response.sendRedirect(url);
        }
        catch (IOException e) {
            throw new OpenIDRuntimeException(e);
        }
    }

    @Override
    public void writeForm() {
        PrintWriter pw;
        StringBuilder sb = new StringBuilder();
        sb.append("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">");
        sb.append(LS);
        sb.append("<html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"ja\" lang=\"ja\">");
        sb.append(LS);
        sb.append("<head>");
        sb.append(LS);
        sb.append("  <meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\" />");
        sb.append(LS);
        sb.append("  <meta http-equiv=\"Content-Script-Type\" content=\"text/javascript\" />");
        sb.append(LS);
        sb.append("  <title>OpenID HTML FORM Redirection</title>");
        sb.append(LS);
        sb.append("</head>");
        sb.append(LS);
        sb.append("<body onload=\"document.forms['openid-form-redirection'].submit();\">");
        sb.append(LS);
        sb.append("  <form id=\"openid-form-redirection\" name=\"openid-form-redirection\" action=\"");
        sb.append(this.authRequest.getDestinationUrl(false));
        sb.append("\" method=\"post\" accept-charset=\"utf-8\">");
        sb.append(LS);
        for (Map.Entry<String, String> e : this.getParameterMap().entrySet()) {
            sb.append("    <input type=\"hidden\" name=\"");
            sb.append(e.getKey());
            sb.append("\" value=\"");
            sb.append(e.getValue());
            sb.append("\" />");
            sb.append(LS);
        }
        sb.append("    <button type=\"submit\">Continue...</button>");
        sb.append(LS);
        sb.append(" </form>");
        sb.append(LS);
        sb.append("</body>");
        sb.append(LS);
        sb.append("</html>");
        sb.append(LS);
        String form = sb.toString();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Write to respose" + LS + form));
        }
        this.response.setContentType("text/html; charset=UTF-8");
        try {
            pw = this.response.getWriter();
        }
        catch (IOException e) {
            throw new OpenIDRuntimeException(e);
        }
        pw.print(form);
    }

    @Override
    public void goNext() {
        if (OpenID.isVersion2(this.version)) {
            this.writeForm();
        } else {
            this.sendRedirect();
        }
    }
}

