/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tsukuyomi.openid.message;

import java.util.Arrays;
import java.util.List;
import jp.sourceforge.tsukuyomi.openid.association.AssociationSessionType;
import jp.sourceforge.tsukuyomi.openid.message.DirectError;
import jp.sourceforge.tsukuyomi.openid.message.ParameterList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssociationError
extends DirectError {
    private static final Log LOG = LogFactory.getLog(AssociationError.class);
    public static final String ASSOC_ERR = "unsupported-type";
    protected static final List<String> requiredFields = Arrays.asList("ns", "error_code", "error", "session_type");
    protected static final List<String> optionalFields = Arrays.asList("assoc_type");

    protected AssociationError(String msg, AssociationSessionType type) {
        super(msg);
        this.set("ns", "http://specs.openid.net/auth/2.0");
        this.set("error_code", ASSOC_ERR);
        this.set("session_type", type.getSessionType());
        this.set("assoc_type", type.getAssociationType());
    }

    protected AssociationError(ParameterList params) {
        super(params);
    }

    public static AssociationError createAssociationError(String msg, AssociationSessionType type) {
        AssociationError err = new AssociationError(msg, type);
        if (!err.isValid()) {
            LOG.error((Object)("Invalid association error message created, type: " + type + " message: " + msg));
        }
        return err;
    }

    public static AssociationError createAssociationError(ParameterList params) {
        AssociationError err = new AssociationError(params);
        if (!err.isValid()) {
            LOG.error((Object)("Invalid association error message created: " + err.keyValueFormEncoding()));
        }
        return err;
    }

    @Override
    public List<String> getRequiredFields() {
        return requiredFields;
    }

    public void setAssociationSessionType(AssociationSessionType type) {
        this.set("session_type", type.getSessionType());
        this.set("assoc_type", type.getAssociationType());
    }

    public String getSessionType() {
        return this.getParameterValue("session_type");
    }

    public String getAssocType() {
        return this.getParameterValue("assoc_type");
    }

    private String getErrorCode() {
        return this.getParameterValue("error_code");
    }

    @Override
    public boolean isValid() {
        if (!super.isValid()) {
            return false;
        }
        return ASSOC_ERR.equals(this.getErrorCode()) && "http://specs.openid.net/auth/2.0".equals(this.getParameterValue("ns"));
    }
}

