/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tsukuyomi.openid.message;

import java.util.Arrays;
import java.util.List;
import jp.sourceforge.tsukuyomi.openid.message.Message;
import jp.sourceforge.tsukuyomi.openid.message.MessageException;
import jp.sourceforge.tsukuyomi.openid.message.ParameterList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VerifyResponse
extends Message {
    private static final Log LOG = LogFactory.getLog(VerifyResponse.class);
    private static final boolean DEBUG = LOG.isDebugEnabled();
    protected static final List<String> REQUIRED_FIELDS = Arrays.asList("is_valid");
    protected static final List<String> OPTIONAL_FIELDS = Arrays.asList("ns", "invalidate_handle");

    protected VerifyResponse(boolean compatibility) {
        this.setSignatureVerified(false);
        if (!compatibility) {
            this.set("ns", "http://specs.openid.net/auth/2.0");
        }
    }

    protected VerifyResponse(ParameterList params) {
        super(params);
    }

    public static VerifyResponse createVerifyResponse(boolean compatibility) throws MessageException {
        VerifyResponse resp = new VerifyResponse(compatibility);
        if (!resp.isValid()) {
            throw new MessageException("Invalid set of parameters for the requested message type");
        }
        if (DEBUG) {
            LOG.debug((Object)("Created verification response:\n" + resp.keyValueFormEncoding()));
        }
        return resp;
    }

    public static VerifyResponse createVerifyResponse(ParameterList params) throws MessageException {
        VerifyResponse resp = new VerifyResponse(params);
        if (!resp.isValid()) {
            throw new MessageException("Invalid set of parameters for the requested message type");
        }
        if (DEBUG) {
            LOG.debug((Object)("Created verification response:\n" + resp.keyValueFormEncoding()));
        }
        return resp;
    }

    @Override
    public List<String> getRequiredFields() {
        return REQUIRED_FIELDS;
    }

    public boolean isVersion2() {
        return this.hasParameter("ns") && "http://specs.openid.net/auth/2.0".equals(this.getParameterValue("ns"));
    }

    public void setSignatureVerified(boolean verified) {
        this.set("is_valid", verified ? "true" : "false");
    }

    public boolean isSignatureVerified() {
        return "true".equals(this.getParameterValue("is_valid"));
    }

    public void setInvalidateHandle(String handle) {
        this.set("invalidate_handle", handle);
    }

    public String getInvalidateHandle() {
        return this.getParameterValue("invalidate_handle");
    }

    @Override
    public boolean isValid() {
        if (!super.isValid()) {
            return false;
        }
        if (!"true".equals(this.getParameterValue("is_valid")) && !"false".equals(this.getParameterValue("is_valid"))) {
            LOG.warn((Object)("Invalid is_valid value in verification response: " + this.getParameterValue("is_valid")));
            return false;
        }
        return true;
    }
}

