/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tsukuyomi.openid.message.ax;

import jp.sourceforge.tsukuyomi.openid.message.MessageException;
import jp.sourceforge.tsukuyomi.openid.message.Parameter;
import jp.sourceforge.tsukuyomi.openid.message.ParameterList;
import jp.sourceforge.tsukuyomi.openid.message.ax.AxMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StoreResponse
extends AxMessage {
    private static final Log LOG = LogFactory.getLog(StoreResponse.class);
    private static final boolean DEBUG = LOG.isDebugEnabled();

    protected StoreResponse() {
        this.parameters.set(new Parameter("mode", "store_response"));
        if (DEBUG) {
            LOG.debug((Object)"Created empty store request.");
        }
    }

    public static StoreResponse createStoreResponse() {
        return new StoreResponse();
    }

    protected StoreResponse(ParameterList params) {
        super(params);
    }

    public static StoreResponse createStoreResponse(ParameterList params) throws MessageException {
        StoreResponse resp = new StoreResponse(params);
        if (!resp.isValid()) {
            throw new MessageException("Invalid parameters for a store response");
        }
        if (DEBUG) {
            LOG.debug((Object)("Created store response from parameter list:\n" + params));
        }
        return resp;
    }

    protected void setFailure(String description) {
        this.parameters.set(new Parameter("status", "failure"));
        if (description != null) {
            this.parameters.set(new Parameter("status.description", description));
        }
    }

    public boolean hasFailed() {
        return this.parameters.hasParameter("status") && "failure".equals(this.parameters.getParameterValue("status"));
    }

    public String getStatus() {
        return this.parameters.hasParameter("status") ? this.parameters.getParameterValue("status") : null;
    }

    public String getStatusDescription() {
        return this.parameters.hasParameter("status.description") ? this.parameters.getParameterValue("status.description") : null;
    }

    private boolean isValid() {
        if (this.getStatusDescription() != null && this.getStatus() == null) {
            return false;
        }
        for (Parameter param : this.parameters.getParameters()) {
            String paramName = param.getKey();
            if (!(paramName.equals("mode") || paramName.equals("status") || paramName.equals("status.description"))) {
                LOG.warn((Object)("Invalid parameter name in store response: " + paramName));
                return false;
            }
            if (!paramName.equals("status") || "failure".equals(param.getValue())) continue;
            LOG.warn((Object)("Invalid status value: " + param.getValue()));
            return false;
        }
        return true;
    }
}

