/*
 * Copyright 2006-2007 Sxip Identity Corporation
 */

package jp.sourceforge.tsukuyomi.openid.discovery;

import java.net.MalformedURLException;
import java.net.URL;

/**
 * Holds information obtained by performing HTML discovery on an URL.
 */
public class HtmlResult {
	private UrlIdentifier claimedId;
	private URL idp1Endpoint;
	private String delegate1;
	private URL idp2Endpoint;
	private String delegate2;

	/**
	 * Constructs an empty HtmlResult object.
	 */
	public HtmlResult() {

	}

	/**
	 * Sets the claimed identifier.
	 */
	public void setClaimed(UrlIdentifier claimed) {
		this.claimedId = claimed;
	}

	/**
	 * Gets the claimed identifier.
	 */
	public UrlIdentifier getClaimedId() {
		return this.claimedId;
	}

	public void setEndpoint1(String idp1Endpoint) throws DiscoveryException {
		URL url;
		try {
			url = new URL(idp1Endpoint);

			this.idp1Endpoint = url;
		} catch (MalformedURLException e) {
			throw new DiscoveryException("Invalid openid.server URL: "
				+ idp1Endpoint);
		}

	}

	public URL getIdp1Endpoint() {
		return this.idp1Endpoint;
	}

	public void setDelegate1(String delegate1) {
		this.delegate1 = delegate1;
	}

	public String getDelegate1() {
		return this.delegate1;
	}

	public void setEndpoint2(String idp2Endpoint) throws DiscoveryException {
		URL url;
		try {
			url = new URL(idp2Endpoint);

			this.idp2Endpoint = url;

		} catch (MalformedURLException e) {
			throw new DiscoveryException("Invalid openid2.provider URL: "
				+ idp2Endpoint);
		}

	}

	public URL getIdp2Endpoint() {
		return this.idp2Endpoint;
	}

	public void setDelegate2(String delegate2) {
		this.delegate2 = delegate2;
	}

	public String getDelegate2() {
		return this.delegate2;
	}

	@Override
	public String toString() {
		return "ClaimedID:"
			+ this.claimedId
			+ (this.idp2Endpoint != null ? "\nOpenID2-endpoint:"
				+ this.idp2Endpoint.toString() : "")
			+ (this.delegate2 != null
				? "\nOpenID2-localID:" + this.delegate2
				: "")
			+ (this.idp1Endpoint != null ? "\nOpenID1-endpoint:"
				+ this.idp1Endpoint.toString() : "")
			+ (this.delegate1 != null
				? "\nOpenID1-delegate:" + this.delegate1
				: "");
	}
}
