package jp.sourceforge.tsukuyomi.openid.discovery;

import java.util.regex.Pattern;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IdentifierParser {
	private static final Log LOG = LogFactory.getLog(IdentifierParser.class);
	private static final boolean DEBUG = LOG.isDebugEnabled();

	private static final String XRI_PREFIX = "xri://";
	private static final Pattern URL_PATTERN =
		Pattern.compile("^https?://", Pattern.CASE_INSENSITIVE);
	private static final Pattern XRI_PATTERN =
		Pattern.compile("^[!=@\\$\\+\\(]", Pattern.CASE_INSENSITIVE);

	public static Identifier parse(String identifier)
			throws IdentifierException {
		try {
			// strip the xri:// prefix if it exists
			if (identifier.toLowerCase().startsWith(XRI_PREFIX)) {
				if (DEBUG) {
					LOG.debug("Dropping xri:// prefix from identifier: "
						+ identifier);
				}
				identifier = identifier.substring(6);
			}

			if (URL_PATTERN.matcher(identifier).find()) {
				if (DEBUG) {
					LOG.debug("Creating URL identifier for: " + identifier);
				}
				return new UrlIdentifier(identifier);
			} else if (XRI_PATTERN.matcher(identifier).find()) {
				if (DEBUG) {
					LOG.debug("Creating XRI identifier for: " + identifier);
				}
				return new XriIdentifier(identifier);
			} else {
				if (DEBUG) {
					LOG
						.debug("Creating URL identifier (http:// prepended) for: "
							+ identifier);
				}
				return new UrlIdentifier("http://" + identifier);
			}
		} catch (Exception e) {
			throw new IdentifierException("Cannot parse identifier: "
				+ identifier, e);
		}
	}
}
