/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.cubby.tags;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.jsp.JspTagException;
import org.seasar.cubby.routing.PathResolver;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LinkSupport {
    private String actionClassName;
    private String actionMethodName;
    private final Map<String, List<String>> parameters = new HashMap<String, List<String>>();

    LinkSupport() {
    }

    public void setActionClassName(String actionClassName) {
        this.actionClassName = actionClassName;
    }

    public void setActionMethodName(String actionMethodName) {
        this.actionMethodName = actionMethodName;
    }

    public void addParameter(String name, String value) {
        if (!this.parameters.containsKey(name)) {
            this.parameters.put(name, new ArrayList());
        }
        List<String> values = this.parameters.get(name);
        values.add(value);
    }

    public Map<String, String[]> getParameters() {
        HashMap<String, String[]> parameters = new HashMap<String, String[]>();
        for (Map.Entry<String, List<String>> entry : this.parameters.entrySet()) {
            parameters.put(entry.getKey(), entry.getValue().toArray(new String[0]));
        }
        return parameters;
    }

    public String getPath(String characterEncoding) throws JspTagException {
        Class actionClass;
        try {
            actionClass = LinkSupport.forName(this.actionClassName);
        }
        catch (ClassNotFoundException e) {
            throw new JspTagException((Throwable)e);
        }
        S2Container container = SingletonS2ContainerFactory.getContainer();
        PathResolver pathResolver = (PathResolver)PathResolver.class.cast(container.getComponent(PathResolver.class));
        String path = pathResolver.reverseLookup(actionClass, this.actionMethodName, this.getParameters(), characterEncoding);
        return path;
    }

    public boolean isLinkable() {
        return this.actionClassName != null && this.actionMethodName != null;
    }

    private static <T> Class<T> forName(String className) throws ClassNotFoundException {
        return Class.forName(className);
    }

    public void clear() {
        this.actionClassName = null;
        this.actionMethodName = null;
        this.parameters.clear();
    }
}

