/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.cubby.util;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import org.seasar.cubby.action.Accept;
import org.seasar.cubby.action.Action;
import org.seasar.cubby.action.ActionResult;
import org.seasar.cubby.action.Form;
import org.seasar.cubby.action.OnSubmit;
import org.seasar.cubby.action.Path;
import org.seasar.cubby.action.RequestMethod;
import org.seasar.cubby.action.RequestParameterBindingType;
import org.seasar.cubby.exception.ActionRuntimeException;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CubbyUtils {
    private static final String INDEX_METHOD_NAME = "index";
    public static Accept DEFAULT_ACCEPT_ANNOTATION;

    public static String getActionDirectory(Class<? extends Action> actionClass) {
        String actionName;
        Path path = actionClass.getAnnotation(Path.class);
        if (path != null && !StringUtil.isEmpty((String)path.value())) {
            actionName = path.value();
        } else {
            String name = CubbyUtils.left(actionClass.getSimpleName(), "$");
            actionName = CubbyUtils.toFirstLower(name.replaceAll("(.*[.])*([^.]+)(Action$)", "$2"));
        }
        return actionName;
    }

    private static String left(String text, String sep) {
        int pos = text.indexOf(sep);
        if (pos != -1) {
            return text.substring(0, pos);
        }
        return text;
    }

    private static String toFirstLower(String text) {
        if (StringUtil.isEmpty((String)text)) {
            throw new IllegalArgumentException("text is empty.");
        }
        StringBuilder sb = new StringBuilder();
        sb.append(text.substring(0, 1).toLowerCase());
        if (text.length() > 1) {
            sb.append(text.substring(1));
        }
        return sb.toString();
    }

    public static String getActionPath(Class<? extends Action> actionClass, Method method) {
        String actionMethodName = CubbyUtils.getActionMethodName(method);
        if (actionMethodName.startsWith("/")) {
            String path = actionMethodName;
            return path;
        }
        String actionDirectory = CubbyUtils.getActionDirectory(actionClass);
        String path = "/".equals(actionDirectory) ? "/" + actionMethodName : "/" + actionDirectory + "/" + actionMethodName;
        return path;
    }

    private static String getActionMethodName(Method method) {
        String methodName;
        Path path = method.getAnnotation(Path.class);
        String actionName = path != null && !StringUtil.isEmpty((String)path.value()) ? path.value() : (INDEX_METHOD_NAME.equals(methodName = method.getName()) ? "" : methodName);
        return actionName;
    }

    public static RequestMethod[] getAcceptableRequestMethods(Class<?> actionClass, Method method) {
        Accept accept = method.isAnnotationPresent(Accept.class) ? method.getAnnotation(Accept.class) : (actionClass.isAnnotationPresent(Accept.class) ? actionClass.getAnnotation(Accept.class) : DEFAULT_ACCEPT_ANNOTATION);
        return accept.value();
    }

    public static int getObjectSize(Object value) {
        int size;
        if (value == null) {
            size = 0;
        } else if (value.getClass().isArray()) {
            Object[] array = (Object[])value;
            size = array.length;
        } else if (value instanceof Collection) {
            Collection collection = (Collection)value;
            size = collection.size();
        } else {
            size = 1;
        }
        return size;
    }

    public static String getPath(HttpServletRequest request) {
        StringBuilder builder = new StringBuilder();
        builder.append(request.getServletPath());
        String pathInfo = request.getPathInfo();
        if (pathInfo != null) {
            builder.append(pathInfo);
        }
        return builder.toString();
    }

    public static boolean isActionClass(Class<?> clazz) {
        return Action.class.isAssignableFrom(clazz) && !Modifier.isAbstract(clazz.getModifiers());
    }

    public static boolean isActionMethod(Method method) {
        return ActionResult.class.isAssignableFrom(method.getReturnType()) && method.getParameterTypes().length == 0;
    }

    public static String replaceFirst(String text, String replace, String with) {
        if (text == null || replace == null || with == null) {
            return text;
        }
        int index = text.indexOf(replace);
        if (index == -1) {
            return text;
        }
        StringBuilder builder = new StringBuilder(100);
        builder.append(text.substring(0, index));
        builder.append(with);
        builder.append(text.substring(index + replace.length()));
        return builder.toString();
    }

    public static String[] split2(String text, char delim) {
        if (text == null) {
            return null;
        }
        int index = text.indexOf(delim);
        if (index == -1) {
            return new String[]{text};
        }
        String[] tokens = new String[]{text.substring(0, index), text.substring(index + 1)};
        return tokens;
    }

    public static String escapeHtml(Object str) {
        if (str == null) {
            return "";
        }
        String text = str instanceof String ? (String)str : str.toString();
        text = StringUtil.replace((String)text, (String)"&", (String)"&amp;");
        text = StringUtil.replace((String)text, (String)"<", (String)"&lt;");
        text = StringUtil.replace((String)text, (String)">", (String)"&gt;");
        text = StringUtil.replace((String)text, (String)"\"", (String)"&quot;");
        text = StringUtil.replace((String)text, (String)"'", (String)"&#39;");
        return text;
    }

    public static int getPriority(Method method) {
        Path path = method.getAnnotation(Path.class);
        return path != null ? path.priority() : Integer.MAX_VALUE;
    }

    public static Object getFormBean(Action action, Class<?> actionClass, Method method) {
        Form form = CubbyUtils.getForm(actionClass, method);
        if (form == null) {
            return action;
        }
        if (!form.binding()) {
            return null;
        }
        if (form.bindingType() == RequestParameterBindingType.NONE) {
            return null;
        }
        if ("this".equals(form.value())) {
            return action;
        }
        String propertyName = form.value();
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc(action.getClass());
        PropertyDesc propertyDesc = beanDesc.getPropertyDesc(propertyName);
        Object formBean = propertyDesc.getValue((Object)action);
        if (formBean == null) {
            throw new ActionRuntimeException("ECUB0102", new Object[]{propertyName});
        }
        return formBean;
    }

    public static Form getForm(Class<?> actionClass, Method method) {
        Form form = method.isAnnotationPresent(Form.class) ? method.getAnnotation(Form.class) : actionClass.getAnnotation(Form.class);
        return form;
    }

    public static String getOnSubmit(Method method) {
        OnSubmit onSubmit = method.getAnnotation(OnSubmit.class);
        String parameterName = onSubmit == null ? null : onSubmit.value();
        return parameterName;
    }

    public static <T> T getAttribute(HttpServletRequest request, String name) {
        return (T)request.getAttribute(name);
    }

    static {
        @Accept
        class AcceptDummy {
            AcceptDummy() {
            }
        }
        DEFAULT_ACCEPT_ANNOTATION = AcceptDummy.class.getAnnotation(Accept.class);
    }
}

