/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.unit;

import java.lang.reflect.Method;
import junit.framework.TestCase;
import org.seasar.framework.exception.NoSuchMethodRuntimeException;
import org.seasar.framework.unit.EasyMockSupport;
import org.seasar.framework.util.ClassUtil;
import org.seasar.framework.util.MethodUtil;
import org.seasar.framework.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EasyMockTestCase
extends TestCase {
    protected EasyMockSupport easyMockSupport = new EasyMockSupport();

    public EasyMockTestCase() {
    }

    public EasyMockTestCase(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runBare() throws Throwable {
        this.easyMockSupport.clear();
        this.setUp();
        try {
            this.bindFields();
            try {
                this.doRunTest();
            }
            finally {
                this.unbindFields();
            }
        }
        finally {
            this.tearDown();
        }
    }

    protected void bindFields() throws Throwable {
        this.easyMockSupport.bindMockFields((Object)this, null);
    }

    protected void doRunTest() throws Throwable {
        boolean recorded = this.doRecord();
        if (recorded) {
            this.easyMockSupport.replay();
        }
        this.runTest();
        if (recorded) {
            this.easyMockSupport.verify();
            this.easyMockSupport.reset();
        }
    }

    protected boolean doRecord() throws Throwable {
        String targetName = this.getTargetName();
        if (!StringUtil.isEmpty((String)targetName)) {
            try {
                Method method = ClassUtil.getMethod(((Object)((Object)this)).getClass(), (String)("record" + targetName), null);
                MethodUtil.invoke((Method)method, (Object)((Object)this), null);
                return true;
            }
            catch (NoSuchMethodRuntimeException noSuchMethodRuntimeException) {
                // empty catch block
            }
        }
        return false;
    }

    protected String getTargetName() {
        return this.getName().substring(4);
    }

    protected void unbindFields() {
        this.easyMockSupport.unbindMockFields((Object)this);
    }

    protected <T> T createMock(Class<T> clazz) {
        return this.easyMockSupport.createMock(clazz);
    }

    protected <T> T createNiceMock(Class<T> clazz) {
        return this.easyMockSupport.createNiceMock(clazz);
    }

    protected <T> T createStrictMock(Class<T> clazz) {
        return this.easyMockSupport.createStrictMock(clazz);
    }

    protected abstract class Subsequence {
        protected Subsequence() {
        }

        public void doTest() throws Exception {
            this.record();
            EasyMockTestCase.this.easyMockSupport.replay();
            this.replay();
            EasyMockTestCase.this.easyMockSupport.verify();
            EasyMockTestCase.this.easyMockSupport.reset();
        }

        protected void record() throws Exception {
        }

        protected abstract void replay() throws Exception;
    }
}

