/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.dxo.command.impl;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.seasar.extension.dxo.IllegalSignatureRuntimeException;
import org.seasar.extension.dxo.annotation.AnnotationReader;
import org.seasar.extension.dxo.command.DxoCommand;
import org.seasar.extension.dxo.converter.ConversionContext;
import org.seasar.extension.dxo.converter.ConverterFactory;
import org.seasar.extension.dxo.converter.impl.ConversionContextImpl;
import org.seasar.framework.exception.SIllegalArgumentException;

public abstract class AbstractDxoCommand
implements DxoCommand {
    protected Class dxoClass;
    protected Method method;
    protected ConverterFactory converterFactory;
    protected AnnotationReader annotationReader;
    protected ConversionHelper conversionHelper;

    public AbstractDxoCommand(Class dxoClass, Method method, ConverterFactory converterFactory, AnnotationReader annotationReader) {
        this.dxoClass = dxoClass;
        this.method = method;
        this.converterFactory = converterFactory;
        this.annotationReader = annotationReader;
        this.conversionHelper = this.getConversionHelper(method);
    }

    public Object execute(Object[] args) {
        return this.conversionHelper.convert(args);
    }

    protected abstract Object convertScalar(Object var1);

    protected abstract void convertScalar(Object var1, Object var2);

    protected abstract Class getDestElementType();

    protected Object[] createArray(int length) {
        return (Object[])Array.newInstance(this.getDestElementType(), length);
    }

    protected ConversionContext createContext(Object source) {
        return new ConversionContextImpl(this.dxoClass, this.method, this.converterFactory, this.annotationReader, source);
    }

    protected ConversionHelper getConversionHelper(Method method) {
        Class<?> destType;
        Class<?>[] parameterTypes = method.getParameterTypes();
        int parameterSize = parameterTypes.length;
        if (parameterSize != 1 && parameterSize != 2) {
            throw new IllegalSignatureRuntimeException(method.getDeclaringClass(), method);
        }
        Class<?> sourceType = parameterTypes[0];
        Class<?> clazz = destType = parameterSize == 1 ? method.getReturnType() : parameterTypes[1];
        if (sourceType.isArray()) {
            if (destType.isArray()) {
                return new ArrayToArrayConversionHelper();
            }
            if (List.class.isAssignableFrom(destType)) {
                return new ArrayToListConversionHelper();
            }
        } else if (List.class.isAssignableFrom(sourceType)) {
            if (destType.isArray()) {
                return new ListToArrayConversionHelper();
            }
            if (List.class.isAssignableFrom(destType)) {
                return new ListToListConvertsionHelper();
            }
        } else {
            return new ScalarConversionHelper();
        }
        throw new IllegalSignatureRuntimeException(method.getDeclaringClass(), method);
    }

    protected void assertSource(Object source) throws SIllegalArgumentException {
        if (source == null) {
            throw new SIllegalArgumentException("ESSR0601", new Object[]{this.dxoClass, this.method});
        }
    }

    protected void assertDest(Object dest) throws SIllegalArgumentException {
        if (dest == null) {
            throw new SIllegalArgumentException("ESSR0602", new Object[]{this.dxoClass, this.method});
        }
    }

    public class ListToListConvertsionHelper
    implements ConversionHelper {
        public Object convert(Object[] args) {
            List source = (List)args[0];
            List<Object> dest = args.length == 1 ? new ArrayList() : (List)args[1];
            dest.clear();
            Iterator it = source.iterator();
            while (it.hasNext()) {
                dest.add(AbstractDxoCommand.this.convertScalar(it.next()));
            }
            return dest;
        }
    }

    public class ListToArrayConversionHelper
    implements ConversionHelper {
        public Object convert(Object[] args) {
            List src = (List)args[0];
            Object[] dest = args.length == 1 ? AbstractDxoCommand.this.createArray(src.size()) : (Object[])args[1];
            Iterator it = src.iterator();
            for (int i = 0; it.hasNext() && i < dest.length; ++i) {
                dest[i] = AbstractDxoCommand.this.convertScalar(it.next());
            }
            return dest;
        }
    }

    public class ArrayToListConversionHelper
    implements ConversionHelper {
        public Object convert(Object[] args) {
            Object[] src = (Object[])args[0];
            List<Object> dest = args.length == 1 ? new ArrayList() : (List)args[1];
            dest.clear();
            for (int i = 0; i < src.length; ++i) {
                dest.add(AbstractDxoCommand.this.convertScalar(src[i]));
            }
            return dest;
        }
    }

    public class ArrayToArrayConversionHelper
    implements ConversionHelper {
        public Object convert(Object[] args) {
            Object[] src = (Object[])args[0];
            Object[] dest = args.length == 1 ? AbstractDxoCommand.this.createArray(src.length) : (Object[])args[1];
            for (int i = 0; i < src.length && i < dest.length; ++i) {
                dest[i] = AbstractDxoCommand.this.convertScalar(src[i]);
            }
            return dest;
        }
    }

    public class ScalarConversionHelper
    implements ConversionHelper {
        public Object convert(Object[] args) {
            if (args.length == 1) {
                return AbstractDxoCommand.this.convertScalar(args[0]);
            }
            Object dest = args[1];
            AbstractDxoCommand.this.convertScalar(args[0], dest);
            return dest;
        }
    }

    public static interface ConversionHelper {
        public Object convert(Object[] var1);
    }
}

