/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.util;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.NoSuchElementException;

public class SLinkedList
implements Cloneable,
Externalizable {
    static final long serialVersionUID = 1L;
    private transient Entry header = new Entry(null, null, null);
    private transient int size = 0;

    public SLinkedList() {
        this.header._next = (this.header._previous = this.header);
    }

    public Entry getFirstEntry() {
        if (this.isEmpty()) {
            return null;
        }
        return this.header._next;
    }

    public Object getFirst() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.getFirstEntry()._element;
    }

    public Entry getLastEntry() {
        if (this.isEmpty()) {
            return null;
        }
        return this.header._previous;
    }

    public Object getLast() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.getLastEntry()._element;
    }

    public Object removeFirst() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        Object first = this.header._next._element;
        this.header._next.remove();
        return first;
    }

    public Object removeLast() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        Object last = this.header._previous._element;
        this.header._previous.remove();
        return last;
    }

    public void addFirst(Object o) {
        this.header._next.addBefore(o);
    }

    public void addLast(Object o) {
        this.header.addBefore(o);
    }

    public void add(int index, Object element) {
        this.getEntry(index).addBefore(element);
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean contains(Object o) {
        return this.indexOf(o) != -1;
    }

    public boolean remove(Object o) {
        if (o == null) {
            Entry e = this.header._next;
            while (e != this.header) {
                if (e._element == null) {
                    e.remove();
                    return true;
                }
                e = e._next;
            }
        } else {
            Entry e = this.header._next;
            while (e != this.header) {
                if (o.equals(e._element)) {
                    e.remove();
                    return true;
                }
                e = e._next;
            }
        }
        return false;
    }

    public Object remove(int index) {
        Entry e = this.getEntry(index);
        e.remove();
        return e._element;
    }

    public void clear() {
        this.header._next = (this.header._previous = this.header);
        this.size = 0;
    }

    public Entry getEntry(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        Entry e = this.header;
        if (index < this.size / 2) {
            for (int i = 0; i <= index; ++i) {
                e = e._next;
            }
        } else {
            for (int i = this.size; i > index; --i) {
                e = e._previous;
            }
        }
        return e;
    }

    public Object get(int index) {
        return this.getEntry(index)._element;
    }

    public Object set(int index, Object element) {
        Entry e = this.getEntry(index);
        Object oldVal = e._element;
        e._element = element;
        return oldVal;
    }

    public int indexOf(Object o) {
        int index = 0;
        if (o == null) {
            Entry e = this.header._next;
            while (e != this.header) {
                if (e._element == null) {
                    return index;
                }
                ++index;
                e = e._next;
            }
        } else {
            Entry e = this.header._next;
            while (e != this.header) {
                if (o.equals(e._element)) {
                    return index;
                }
                ++index;
                e = e._next;
            }
        }
        return -1;
    }

    public void writeExternal(ObjectOutput s) throws IOException {
        s.writeInt(this.size);
        Entry e = this.header._next;
        while (e != this.header) {
            s.writeObject(e._element);
            e = e._next;
        }
    }

    public void readExternal(ObjectInput s) throws IOException, ClassNotFoundException {
        int size = s.readInt();
        this.header = new Entry(null, null, null);
        this.header._next = (this.header._previous = this.header);
        for (int i = 0; i < size; ++i) {
            this.addLast(s.readObject());
        }
    }

    public Object clone() {
        SLinkedList copy = new SLinkedList();
        Entry e = this.header._next;
        while (e != this.header) {
            copy.addLast(e._element);
            e = e._next;
        }
        return copy;
    }

    public Object[] toArray() {
        Object[] result = new Object[this.size];
        int i = 0;
        Entry e = this.header._next;
        while (e != this.header) {
            result[i++] = e._element;
            e = e._next;
        }
        return result;
    }

    public class Entry {
        private Object _element;
        private Entry _next;
        private Entry _previous;

        Entry(Object element, Entry next, Entry previous) {
            this._element = element;
            this._next = next;
            this._previous = previous;
        }

        public Object getElement() {
            return this._element;
        }

        public Entry getNext() {
            if (this._next != SLinkedList.this.header) {
                return this._next;
            }
            return null;
        }

        public Entry getPrevious() {
            if (this._previous != SLinkedList.this.header) {
                return this._previous;
            }
            return null;
        }

        public void remove() {
            this._previous._next = this._next;
            this._next._previous = this._previous;
            SLinkedList.this.size--;
        }

        public Entry addBefore(Object o) {
            Entry newEntry;
            this._previous._next = newEntry = new Entry(o, this, this._previous);
            this._previous = newEntry;
            SLinkedList.this.size++;
            return newEntry;
        }
    }
}

