/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tsukuyomi.openid.discovery;

import java.util.regex.Pattern;
import jp.sourceforge.tsukuyomi.openid.discovery.Identifier;
import jp.sourceforge.tsukuyomi.openid.discovery.IdentifierException;
import jp.sourceforge.tsukuyomi.openid.discovery.UrlIdentifier;
import jp.sourceforge.tsukuyomi.openid.discovery.XriIdentifier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IdentifierParser {
    private static final Log LOG = LogFactory.getLog(IdentifierParser.class);
    private static final boolean DEBUG = LOG.isDebugEnabled();
    private static final String XRI_PREFIX = "xri://";
    private static final Pattern URL_PATTERN = Pattern.compile("^https?://", 2);
    private static final Pattern XRI_PATTERN = Pattern.compile("^[!=@\\$\\+\\(]", 2);

    public static Identifier parse(String identifier) throws IdentifierException {
        try {
            if (identifier.toLowerCase().startsWith(XRI_PREFIX)) {
                if (DEBUG) {
                    LOG.debug((Object)("Dropping xri:// prefix from identifier: " + identifier));
                }
                identifier = identifier.substring(6);
            }
            if (URL_PATTERN.matcher(identifier).find()) {
                if (DEBUG) {
                    LOG.debug((Object)("Creating URL identifier for: " + identifier));
                }
                return new UrlIdentifier(identifier);
            }
            if (XRI_PATTERN.matcher(identifier).find()) {
                if (DEBUG) {
                    LOG.debug((Object)("Creating XRI identifier for: " + identifier));
                }
                return new XriIdentifier(identifier);
            }
            if (DEBUG) {
                LOG.debug((Object)("Creating URL identifier (http:// prepended) for: " + identifier));
            }
            return new UrlIdentifier("http://" + identifier);
        }
        catch (Exception e) {
            throw new IdentifierException("Cannot parse identifier: " + identifier, e);
        }
    }
}

