/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tsukuyomi.openid.message.pape;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import jp.sourceforge.tsukuyomi.openid.message.MessageException;
import jp.sourceforge.tsukuyomi.openid.message.Parameter;
import jp.sourceforge.tsukuyomi.openid.message.ParameterList;
import jp.sourceforge.tsukuyomi.openid.message.pape.PapeMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PapeRequest
extends PapeMessage {
    private static final Log LOG = LogFactory.getLog(PapeRequest.class);
    private static final boolean DEBUG = LOG.isDebugEnabled();
    protected static final List<String> PAPE_FIELDS = Arrays.asList("preferred_auth_policies", "max_auth_age");

    protected PapeRequest() {
        this.set("preferred_auth_policies", "");
        if (DEBUG) {
            LOG.debug((Object)"Created empty Pape request.");
        }
    }

    public static PapeRequest createPapeRequest() {
        return new PapeRequest();
    }

    protected PapeRequest(ParameterList params) {
        this.parameters = params;
    }

    public static PapeRequest createPapeRequest(ParameterList params) throws MessageException {
        PapeRequest req = new PapeRequest(params);
        if (!req.isValid()) {
            throw new MessageException("Invalid parameters for a PAPE request");
        }
        if (DEBUG) {
            LOG.debug((Object)("Created PAPE request from parameter list:\n" + params));
        }
        return req;
    }

    public String getPreferredAuthPolicies() {
        return this.getParameterValue("preferred_auth_policies");
    }

    public void setPreferredAuthPolicies(String policyUris) {
        this.set("preferred_auth_policies", policyUris);
    }

    public void addPreferredAuthPolicy(String policyUri) {
        String policies = this.getPreferredAuthPolicies();
        if (policies == null || policies.length() == 0) {
            this.setPreferredAuthPolicies(policyUri);
        } else {
            this.setPreferredAuthPolicies(policies + " " + policyUri);
        }
    }

    public List<String> getPreferredAuthPoliciesList() {
        String policies = this.getParameterValue("preferred_auth_policies");
        if (policies != null) {
            return Arrays.asList(policies.split(" "));
        }
        return new ArrayList<String>();
    }

    public void setMaxAuthAge(int seconds) {
        this.set("max_auth_age", Integer.toString(seconds));
    }

    public int getMaxAuthAge() {
        String maxAuthAge = this.getParameterValue("max_auth_age");
        if (maxAuthAge != null) {
            return Integer.parseInt(maxAuthAge);
        }
        return -1;
    }

    public boolean isValid() {
        if (!this.parameters.hasParameter("preferred_auth_policies")) {
            LOG.warn((Object)"preferred_auth_policies is required in a PAPE request.");
            return false;
        }
        for (Parameter param : this.parameters.getParameters()) {
            String paramName = param.getKey();
            if (PAPE_FIELDS.contains(paramName)) continue;
            LOG.warn((Object)("Invalid parameter name in PAPE request: " + paramName));
            return false;
        }
        return true;
    }
}

