/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tsukuyomi.openid.rp;

import java.text.ParseException;
import java.util.Date;
import jp.sourceforge.tsukuyomi.openid.rp.NonceVerifier;
import jp.sourceforge.tsukuyomi.openid.util.InternetDateFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractNonceVerifier
implements NonceVerifier {
    private static final Log LOG = LogFactory.getLog(AbstractNonceVerifier.class);
    private static final boolean DEBUG = LOG.isDebugEnabled();
    protected int maxAge;

    protected AbstractNonceVerifier(int maxAge) {
        this.maxAge = maxAge;
    }

    public int getMaxAge() {
        return this.maxAge / 1000;
    }

    public int seen(String idpUrl, String nonce) {
        if (DEBUG) {
            LOG.debug((Object)("Verifying nonce: " + nonce));
        }
        Date now = new Date();
        try {
            InternetDateFormat dateFormat = new InternetDateFormat();
            Date nonceDate = dateFormat.parse(nonce);
            if (this.isTooOld(now, nonceDate)) {
                LOG.warn((Object)("Nonce is too old: " + nonce));
                return 3;
            }
            return this.seen(now, idpUrl, nonce);
        }
        catch (ParseException e) {
            LOG.error((Object)("Error verifying the nonce: " + nonce), (Throwable)e);
            return 2;
        }
    }

    protected abstract int seen(Date var1, String var2, String var3);

    protected boolean isTooOld(Date now, Date nonce) {
        long age = now.getTime() - nonce.getTime();
        return age > (long)(this.maxAge * 1000);
    }
}

