/* Copyright (C) 2017 Momi-g

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 3 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program. If not, see <http://www.gnu.org/licenses/>.
*/
/*SH_doc*
title=msgp section=3 repnl=\040
@name	msgp
@_brief	printf() wrapper functions
@_syno
 void pf1-3(const char* fmt, ...);
 void npf1-3(const char* fmt, ...);
 void epf(const char* fmt, ...);
 void nepf(condt char* fmt, ...);
 void dpf(condt char* fmt, ...);
 void dbg(...);
 void idbg(...);
 void sbg(s0, s1, ...[,strsz], [, cmt] );
 
 MSGP_t pfset(FILE* p1, FILE* p2, FILE* p3, FILE* dg);
 MSGP_t pfget();
 MSGP_t pfpush(MSGP_t obj);

@tl_dr
	@(code)@
 #include "msgp.h"
 int main() {
 	pf1("aa");	// automatically add '\n'
 	npf2("bb");		// header 'n' no newline
 	pf3("cc");
 	dbg("dd");	// >> disp: aa, bb, cc, dd
 	
 	pfset(NULL,stderr,NULL,PF_NOCHANGE);	//>> pf1-3,dbg setting
 	npf1("aa");
 	pf2("bb");
 	pf3("cc");
 	dbg("dbg is", 123, "var");	// >>arg support int,dbl,ptr,char,str
 	idbg(1, 10)	//same as dbg() but avoid str, SEGV longjmp()
 	const char* s = "hello, world";
 	sbg(s,s,s)	//near to dbg(), but check for str, avoid SEGV longjmp()
 	
 	MSGP_t old = pfset(stdout, stdout, stdout, stderr);	//>> dfl setting
 	pf1("info: %s", old.tostr);
 	epf("epf/nepf is always disp to stderr.");
 	dpf("dpf() follows dbg() i/o setting, uses for -D_DBG etc");
 }
 // ~$ gcc src.c msgp.c
	@()@
@param
	@(list)
	fmt: printf fmt
	p1-dg: NULL(noout)/PF_NOCHANGE/FILE*
	obj: output setting rtns before setting obj. use it to restore.
	@()

@return 	pfset()/pfpush() rtns before setting. pfget() rtns current setting.
	dbg() rtns some int val.
@details
	dbg() is printf debug helper. not need args type(int, char* etc).
		@(code)--@
	eg)	dbg(12,num,s,"cmt",1.11);
 >>>
	DBG: src.c 7: main(): cnt:1 pid:17477 arg:(12,num,s,"comment",1.11)
	12 = i:12 / d:-1.72631 / p:0xc / c:\014 '\f' / s:(mem_err)
	num = i:678 / d:-1.72631 / p:0x2a6 / c:\246 '?' / s:(mem_err)
	s = i:4636870 / d:-1.72631 / p:0x46c0c6 / c:\306 '?' / s:abc
	"cmt" = i:4636911 / d:-1.72631 / p:0x46c0ef / c:\357 '?' / s:cmt
	1.11 = i:1546188227 / d:1.11 / p:0x5c28f5c3 / c:\303 '?' / s:(mem_err)
		@()--@
	the type of argument is not specified. guess type and convert. --
	i/d/p/c/s == int/dbl/ptr/char/str--
	dbg() are stricted output size. max 1024 byte(1024 char) at once.--
	dbg() supports variable args. allows at least 1-9 args. --
	dbg() uses SIGSEGV/longjmp. it may cause some troubles if your pg uses signals. --
 
@notes -
@conforming_to POSIX.1-2001+ (-D_XOPEN_SOURCE=600/_POSIX_C_SOURCE=200112L)
@copyright Copyright 2017 Momi-g, GPLv3+
@_ver 2022-07-08 v1.3.8 (2017-XX-XX v1.0.0)
@_see -
//SH_docE*/

#ifndef b7b7ab95edd0
#define b7b7ab95edd0

//https://www.jpcert.or.jp/sc-rules/c-pre13-c.html
//-D_POSIX_C_SOURCE=200112L
//-D_XOPEN_SOURCE=600
//199901L > __STDC_VERSION__+0

//2001L: sigaction()
#include <features.h> 	//SH_co* -D_XOPEN_SOURCE=600 -std=c99 */
#if ( _POSIX_C_SOURCE +0 < 200112L )
	#include	"needs compiler posix-2001 or upper(c99+)"
#endif

#include <stdint.h>	//uint
#include <stdio.h>	//FILE* type

//---api_start
struct MSGP_cmndata_tag {
	char  tostr[128];	// for tostring, "stderr, stdout ..."
	void* arrfp[6];	// epf + pf1,pf2,pf3,dbg + NULL
	void* brrfp[6];
	FILE* (*getfp)(int idx);
} typedef MSGP_t;

enum {
	MSGP_FP_EPF = 0
	, MSGP_FP_PF1
	, MSGP_FP_PF2
	, MSGP_FP_PF3
	, MSGP_FP_DBG
	, MSGP_FP_SUM
};
#define PF_NOCHANGE	(&MSGP_cmndata)
#define MSGP_ck	MSGP_cmndata.getfp
extern MSGP_t MSGP_cmndata;

/*replace printf()*/
#define epf(...)	(MSGP_ck(MSGP_FP_EPF)?MSGP_cmnpf_b7b7(MSGP_FP_EPF, 1, __VA_ARGS__):0)
#define pf1(...)	(MSGP_ck(MSGP_FP_PF1)?MSGP_cmnpf_b7b7(MSGP_FP_PF1, 1, __VA_ARGS__):0)
#define pf2(...)	(MSGP_ck(MSGP_FP_PF2)?MSGP_cmnpf_b7b7(MSGP_FP_PF2, 1, __VA_ARGS__):0)
#define pf3(...)	(MSGP_ck(MSGP_FP_PF3)?MSGP_cmnpf_b7b7(MSGP_FP_PF3, 1, __VA_ARGS__):0)
#define dpf(...)	(MSGP_ck(MSGP_FP_DBG)?MSGP_cmnpf_b7b7(MSGP_FP_DBG, 1, __VA_ARGS__):0)

#define npf1(...)	(MSGP_ck(MSGP_FP_PF1)?MSGP_cmnpf_b7b7(MSGP_FP_PF1, 0, __VA_ARGS__):0)
#define npf2(...)	(MSGP_ck(MSGP_FP_PF2)?MSGP_cmnpf_b7b7(MSGP_FP_PF2, 0, __VA_ARGS__):0)
#define npf3(...)	(MSGP_ck(MSGP_FP_PF3)?MSGP_cmnpf_b7b7(MSGP_FP_PF3, 0, __VA_ARGS__):0)
#define ndpf(...)	(MSGP_ck(MSGP_FP_DBG)?MSGP_cmnpf_b7b7(MSGP_FP_DBG, 0, __VA_ARGS__):0)

/*setting*/
#define pfset(...)  pfset_b7b7_impl(__VA_ARGS__, #__VA_ARGS__) 
#define pfget(none)	pfget_b7f7(none)
#define pfpush(MSGP_t)	pfpush_b7f7(MSGP_t)

/*dbg*/
#define	dbg(...)	(MSGP_ck(MSGP_FP_DBG)?MSGP_dbg (__VA_ARGS__):0)
#define	idbg(...)	(MSGP_ck(MSGP_FP_DBG)?MSGP_idbg(__VA_ARGS__):0)
#define sbg(...)	(MSGP_ck(MSGP_FP_DBG)?MSGP_sbg (__VA_ARGS__):0)
//---api_end

/* wrap, conv */
int MSGP_cmnpf_b7b7(int tgt, int nflg, const char* fmt, ...);
MSGP_t pfset_b7b7_impl(void* pf1, void* pf2, void* pf3, void* dbg, const char* s);
MSGP_t pfget_b7f7(void);
MSGP_t pfpush_b7f7(MSGP_t predata);

#define MSGP_sbg(...)	( \
	dbg_b7b7_top(MSGP_FP_DBG, __FILE__, __LINE__, __func__, #__VA_ARGS__ "+s")	\
	, dbg_b7b7_end(MSGP_FP_DBG, ""), sck_b7b7_x(__VA_ARGS__,~0)	\
	)

/*
#ifndef MSGP_sck_pf
	#define MSGP_sck_pf	printf
#endif
*/
#define sck_b7b7_x(...)	sck_b7b7_impl(NULL, #__VA_ARGS__, __VA_ARGS__)
int sck_b7b7_impl(int(*cb)(const char*, ...), const char* ags_, ...);

// for dbg()
// from license: cc-by-sa 2.5/3.0 (code is changed from the orig)
// https://stackoverflow.com/questions/2632300	Q: Ed Marty  ->  A: Matthew Slattery
#define ARGCNT(...) ARGCNT_2(__VA_ARGS__,16,15,14,13,12,11,10,9,8,7,6,5,4,3,2,1,0)
#define ARGCNT_2(args,n16,n15,n14,n13,n12,n11,n10,n9,n8,n7,n6,n5,n4,n3,n2,num,...)	ARGCNT_3(num)
#define ARGCNT_3(a) ITERMCR_ ## a

// https://stackoverflow.com/questions/44479282 Q: user1150609 -> A: H Walters
#define ITERMCR_1(...) 		dbg_b7b7_middle( 1, #__VA_ARGS__, __VA_ARGS__)
#define ITERMCR_2(a,...)	dbg_b7b7_middle( 2, #a,a,(dbg_b7b7_arg_t){0} ), ITERMCR_1(__VA_ARGS__)
#define ITERMCR_3(a,...)	dbg_b7b7_middle( 3, #a,a,(dbg_b7b7_arg_t){0} ), ITERMCR_2(__VA_ARGS__)
#define ITERMCR_4(a,...) 	dbg_b7b7_middle( 4, #a,a,(dbg_b7b7_arg_t){0} ), ITERMCR_3(__VA_ARGS__)
#define ITERMCR_5(a,...) 	dbg_b7b7_middle( 5, #a,a,(dbg_b7b7_arg_t){0} ), ITERMCR_4(__VA_ARGS__)
#define ITERMCR_6(a,...) 	dbg_b7b7_middle( 6, #a,a,(dbg_b7b7_arg_t){0} ), ITERMCR_5(__VA_ARGS__)
#define ITERMCR_7(a,...) 	dbg_b7b7_middle( 7, #a,a,(dbg_b7b7_arg_t){0} ), ITERMCR_6(__VA_ARGS__)
#define ITERMCR_8(a,...) 	dbg_b7b7_middle( 8, #a,a,(dbg_b7b7_arg_t){0} ), ITERMCR_7(__VA_ARGS__)
#define ITERMCR_9(a,...) 	dbg_b7b7_middle( 9, #a,a,(dbg_b7b7_arg_t){0} ), ITERMCR_8(__VA_ARGS__)
#define ITERMCR_10(a,...) 	dbg_b7b7_middle(10, #a,a,(dbg_b7b7_arg_t){0} ), ITERMCR_9(__VA_ARGS__)
#define ITERMCR_11(a,...) 	dbg_b7b7_middle(11, #a,a,(dbg_b7b7_arg_t){0} ), ITERMCR_10(__VA_ARGS__)
#define ITERMCR_12(a,...) 	dbg_b7b7_middle(12, #a,a,(dbg_b7b7_arg_t){0} ), ITERMCR_11(__VA_ARGS__)
#define ITERMCR_13(a,...) 	dbg_b7b7_middle(13, #a,a,(dbg_b7b7_arg_t){0} ), ITERMCR_12(__VA_ARGS__)
#define ITERMCR_14(a,...) 	dbg_b7b7_middle(14, #a,a,(dbg_b7b7_arg_t){0} ), ITERMCR_13(__VA_ARGS__)
#define ITERMCR_15(a,...) 	dbg_b7b7_middle(15, #a,a,(dbg_b7b7_arg_t){0} ), ITERMCR_14(__VA_ARGS__)
#define ITERMCR_16(a,...) 	dbg_b7b7_middle(16, #a,a,(dbg_b7b7_arg_t){0} ), ITERMCR_15(__VA_ARGS__)
// end license:	cc-by-sa 2.5/3.0

//ref: http://idlysphere.blog66.fc2.com/blog-entry-181.html 可愛い。
//ref: http://www.open-std.org/jtc1/sc22/wg14/www/docs/n1570.pdf >>A1.7 Punctuators（区切り子）
//ref: https://bytes.com/topic/c/answers/218725-does-not-give-valid-preprocessing-token-why
//ref: https://ja.stackoverflow.com/questions/34093
//ref: http://www.c-lang.org/detail/macro_detail.html	#__line__ TYPE

// dbg() dmydata for allign arg sz
typedef union dbg_b7b7_argtag{
	int i;
	char* p;
	double d;
} dbg_b7b7_arg_t;

#define	MSGP_dbg(...)	dbg_sub(__VA_ARGS__+0)
#define	dbg_sub(...)	(	\
	dbg_b7b7_top(MSGP_FP_DBG, __FILE__, __LINE__, __func__, #__VA_ARGS__)	\
	, ARGCNT(__VA_ARGS__)(__VA_ARGS__), dbg_b7b7_end(MSGP_FP_DBG, "\n") )

int dbg_b7b7_top(int plv, const char* fname, int nline, \
            const char* fcname, const char* rawstr);
int dbg_b7b7_middle(int agnum, char* rawlit, ...);
int dbg_b7b7_end(int plv, const char* es);
// dbg() ... err

//add
#define	MSGP_idbg(...)	idbg_sub(__VA_ARGS__+0)
#define	idbg_sub(...)	(idbg_b7b7_top()	\
	,dbg_b7b7_top(MSGP_FP_DBG, __FILE__, __LINE__, __func__, #__VA_ARGS__)	\
	, ARGCNT(__VA_ARGS__)(__VA_ARGS__) ,dbg_b7b7_end(MSGP_FP_DBG, "\n"), idbg_b7b7_end())

int idbg_b7b7_top(void);
int idbg_b7b7_end(void);

//hpp
#ifdef _IMPL_msgp		/*SH_c o* -D_IMPL_msgp	*/
/*--copyfrom msgp.c*/
/* Copyright (C) 2017 Momi-g

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 3 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program. If not, see <http://www.gnu.org/licenses/>.
*/

# include "msgp.h"
#include <stdarg.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>		//exit()
#include <errno.h>
#include <unistd.h>	//getpid()	fd, STDERR_FILENO.  FILE* ... stdout stream.
#include <stdint.h>	//intptr_t type
#include <signal.h> //siginfo_t

#define DBG_B7B7_MLEN	100
#define DBG_B7B7_BUFFSIZE	1024
#define PF_MAXINFOLEN (128-1)

static int	GLdbgcounter = 0;
char GLdbgbuffer[DBG_B7B7_BUFFSIZE+1]={0};
static int	GLdbgmode = 0;	//add. idbg

//static char tostr_sub[PF_MAXINFOLEN+1] = "stdout, stdout, stdout, stderr";

static FILE* getfp(int idx);
MSGP_t MSGP_cmndata = {
	.tostr = "pf1-3,dbg: stdout, stdout, stdout, stderr"
	, .arrfp = {NULL,	NULL,	NULL,	NULL,	NULL,  (void*)1}
	, .brrfp = {&stderr, &stdout, &stdout, &stdout, &stderr, NULL}
	, .getfp = getfp
	// epf, pf1,2,3 dbg, NULL
};



//--code
static FILE* getfp(int idx){
	void** arr = MSGP_cmndata.arrfp;
	void** brr = MSGP_cmndata.brrfp;
	if(	arr[MSGP_FP_SUM]){
		for(int i=0; i<MSGP_FP_SUM; i++){ arr[i] = *(void**)brr[i];	}
		arr[MSGP_FP_SUM]=NULL;
	}
	return arr[idx];
}

//pf_cmn()
int MSGP_cmnpf_b7b7(int plv, int nlflg, const char* fmt, ...) {
	int rc=0;
	FILE* fp = getfp(plv);
	if(fp == NULL) { return rc; }

	va_list vl;
	va_start(vl, fmt);
	rc = vfprintf(fp, fmt, vl);
	if(nlflg==1) {
		fprintf(fp, "\n");
		rc++;
	}
	fflush(fp);
	va_end(vl);
	return rc;
}

 	
// i/o funcs: ret pre_settings.   pf1-3,dbg
MSGP_t pfset_b7b7_impl(void* p1, void* p2, void* p3, void* dg, const char* s) {
	getfp(0);	//initck
	MSGP_t rbuf = MSGP_cmndata;
	void** arr = MSGP_cmndata.arrfp;
	void** brr = MSGP_cmndata.brrfp;
	int iarr[] = { MSGP_FP_PF1, MSGP_FP_PF2, MSGP_FP_PF3, MSGP_FP_DBG };
	void** parr[] = { &p1, &p2, &p3, &dg, NULL };
	//
	for(int i=0;parr[i];i++){
		int n = iarr[i];
		brr[n]=arr[n];
		void* fp = *parr[i];
		fp==PF_NOCHANGE ? fp=brr[n] :0;
		arr[n] = fp;
	}
	snprintf(MSGP_cmndata.tostr, PF_MAXINFOLEN, "pf1-3,dbg: %s", s);
	return rbuf;
}

MSGP_t pfget_b7f7() {
	getfp(0);	//initck
	return MSGP_cmndata;
}

MSGP_t pfpush_b7f7(MSGP_t obj) {
	getfp(0);
	MSGP_t rbuf = MSGP_cmndata;
	MSGP_cmndata = obj;
	return rbuf;
}

static int sck_pfcb(const char* fmt, ...){
	FILE* fp = getfp(MSGP_FP_DBG);
	if(fp==NULL){return 0;}
	int rc=0;
	va_list ap;
	va_start(ap, fmt);
	rc = vfprintf(fp, fmt, ap);
	return rc;
}

//dbg funcs,	add numonly
int sck_b7b7_impl(int(*cb)(const char*, ...), const char* ags_, ...) {
	cb=sck_pfcb;
	char* ags = (char*)ags_;
	int msz=0;
	const char* msg = NULL;
	char* sarr[128]= {0};
	//
	va_list ap;
	va_start(ap, ags_);
	int flg=1;	//head+" ~0 etc
	int idx=0;
	for(char* p = ags;; p++) {
		//printf("%d, %d, %c\n", flg, msz, *p);
		if(flg==1){
			char* pp=NULL;
			if( strtol(p, &pp, 10) ) { flg=0; p=pp-1; continue; }
			else { flg = -1; }
		}
		if(*p==',') {
			if(flg== -1) { sarr[idx] = va_arg(ap, char*); }
			//printf("%d, %s\n", idx, sarr[idx]);
			if(flg== 0) { msz = va_arg(ap, int); }
			idx++;
			flg=1;
			continue;
		}
		if(flg!= -1){ continue; }
		if(*p=='"') { msg = va_arg(ap, char*); break; }
		if(*p=='~') { break; }
	}
	va_end(ap);
	int rc=0;
	//print
	if(msg&& *msg!=':') { rc+=cb("--cmt: %s\n", msg); }
	for(int i=0; sarr[i]; i++) {
		char* p = sarr[i];
		int sz = strlen(p);
		if(msz>0 && sz>msz) {
			rc+=cb("sz=%d: ^%.*s..\n", sz, msz, p);
		} else if(msz<-1&& sz> -msz*2) {
			rc+=cb("sz=%d: ^%.*s..%.*s$\n", sz, -msz, p, -msz, p+sz+msz);
		} else {
			rc+=cb("sz=%d: ^%s$\n", sz, p);
		}
	}
	//end
	rc+=cb("\n");
	return rc;
}

int idbg_b7b7_top(void){ GLdbgmode= -1; return 0;}
int idbg_b7b7_end(void){ GLdbgmode= 0 ; return 0;}

#include <setjmp.h>
static sigjmp_buf marktry;	// try-catch sigsegv. sigjmp ... posix2001 upper
static void dbg_siggrep(int flg, int signum);

int dbg_b7b7_top(int plv, const char* fname, int nline
 , const char* fcname, const char* rawstr) {
	FILE* fp = getfp(MSGP_FP_DBG);
	GLdbgcounter++;		//global counter for debag info
	if(fp == NULL|| GLdbgbuffer[0]!='\0') { return 0; }
	int orest=  DBG_B7B7_BUFFSIZE - 1;
	GLdbgbuffer[0]='\0';
	const char* pfix = "DBG";
	if( *(rawstr+strlen(rawstr)-1) == 's'){ pfix = "SBG"; }
	snprintf( GLdbgbuffer, orest,
         "%s: %s %d: %s(): cnt:%d pid:%d arg:(%.*s)\n", pfix,
         fname, nline, fcname, GLdbgcounter, getpid(), (int)(strlen(rawstr)-2), rawstr);
	return 0;
}

int dbg_b7b7_middle(int agnum, char* rawlit, ...) {
	if( GLdbgbuffer[0]=='\0') { return 0; }
	if(agnum==1 && strlen(rawlit)==2){return 0;} //dbg()系。要素があれば+0で3以上になる。
	int cutsz=0;
	if(agnum==1){cutsz=2;}	//尻尾に+0がついてるのでキリトリセン
	
	char sbuf[DBG_B7B7_MLEN+1]={0};
	int orest = DBG_B7B7_MLEN;
	snprintf( sbuf, orest, "\t%.*s = ", (int)(strlen(rawlit)-cutsz), rawlit);
	orest=DBG_B7B7_MLEN - strlen(sbuf);

	va_list vl, vls;
	va_start(vl, rawlit);
	va_copy(vls, vl);

	int ri;
	double rd;
	char* rp;
	//int系. double系が先だとそっちに行くから。アクセス違反はsegvで逃げる。
	ri = va_arg(vl, int);	//local変数 int未満は全部intに格上げされる。
	snprintf( &(sbuf[strlen(sbuf)]), orest, "i:%d / ", ri);
	orest=DBG_B7B7_MLEN - strlen(sbuf);

	//double系.
	va_copy(vl, vls);
	rd = va_arg(vl, double);
	snprintf( &(sbuf[strlen(sbuf)]), orest, "d:%f / ", rd);
	orest=DBG_B7B7_MLEN - strlen(sbuf);
	
	//ptr
	va_copy(vl, vls);
	rp = va_arg(vl, char*);	// vl_add -> argpos_add -> argraw(int/char*)
	snprintf( &(sbuf[strlen(sbuf)]), orest, "p:%p / ", rp);
	orest=DBG_B7B7_MLEN - 1 - strlen(sbuf);
	
	//char
	// %hh + c ... int args. not char args. (promote args problem. see man printf)
	// edit escape chars \n>>\\n etc
//	va_start(vl, rawlit);
//	ri = va_arg(vl, int);	
	char cbuf[2]= {(char)ri, 0};
	char* msg;
	if(cbuf[0] == '\0') { msg = (char*)"\\0";}
	else if(cbuf[0] == '\a') { msg = (char*)"\\a";}
	else if(cbuf[0] == '\b') { msg = (char*)"\\b";}
	else if(cbuf[0] == '\t') { msg = (char*)"\\t"; }
	else if(cbuf[0] == '\n') { msg = (char*)"\\n";}
	else if(cbuf[0] == '\v') { msg = (char*)"\\v";}
	else if(cbuf[0] == '\f') { msg = (char*)"\\f";}
	else if(cbuf[0] == '\r') { msg = (char*)"\\r";}
	else if(1){ msg = cbuf; }
	
	// hh ... size select char
	snprintf( &(sbuf[strlen(sbuf)]), orest, "c:\134%03hho '%s' / s:", ri, msg );
	orest=DBG_B7B7_MLEN - strlen(sbuf);

	//string
	if(GLdbgmode != -1 ){
		//add str skip mode(idbg). avoid SEGV trap err
		// http://www.nurs.or.jp/~sug/soft/super/longjmp.htm
		// try - catch signal stop
		if(sigsetjmp(marktry, SIGSEGV) == 0) {
			dbg_siggrep(1, SIGSEGV);	//set trap
			strncpy( &(sbuf[strlen(sbuf)] ), rp, orest);
		} else {
			strncpy( &(sbuf[strlen(sbuf)]), "(mem_err)", orest );
		}
		dbg_siggrep(0, SIGSEGV);	//reset trap
	}else{
		strncpy( &(sbuf[strlen(sbuf)]), "(skip)", orest );
	}

	va_end(vl);
	va_end(vls);

	//add + \n
	if(strlen(sbuf) >= DBG_B7B7_MLEN-1 ){ sbuf[DBG_B7B7_MLEN-1]='*'; }
	int len = strlen(GLdbgbuffer);
	strncpy( &(GLdbgbuffer[len]), sbuf, DBG_B7B7_BUFFSIZE-len-1);
	len = strlen(GLdbgbuffer);
	if( len+1 == DBG_B7B7_BUFFSIZE ){GLdbgbuffer[len-1]='\n';}
	else{GLdbgbuffer[len]='\n';}
	return 0;
}

int dbg_b7b7_end(int plv, const char* es) {
	getfp(0);
	FILE* fp = getfp(MSGP_FP_DBG);
	if(fp==NULL) {goto lbl_RTN;}
	if(es==NULL){es = "";}
	fprintf(fp, "%s%s", GLdbgbuffer, es);
	fflush(fp);		//	buff is an evil
lbl_RTN:;	
	GLdbgbuffer[0]='\0';
	return 0;
}

static void dbg_sigfunc(int signum, siginfo_t* info, void* ctx) {
	//sighandle, sigcatch?, siginterrrupt?,sig"exception code(java)"?
	//in code, very,very, verrrry stricted.
	//1. use only "signal safe function"
	//2. use global(outer function) var, "volatile sig_atomic_t"
	//3. you can use auto var (stack, local memory?)
	//http://d.hatena.ne.jp/yupo5656/20040712/p2
	siglongjmp(marktry, 1);
	//	char msg[] = "sig_catch. err?\n";
	//	write(STDERR_FILENO, msg, strlen(msg) );	// #include <unistd.h>
}

// (1/0, SIGSEGV) on, off. if get sig, rtn 1(dbg_sigfunc), else rtn 0.
static void dbg_siggrep(int flg, int signum) {
	static struct sigaction sct_ss;	//snapshot for save state.
	struct sigaction sct = {0};
	sigemptyset(&(sct.sa_mask));	//clear. 0xFFFF -> block recall SIG when this method running.
	sigaddset(&sct.sa_mask, signum);	// target signal
	if(flg==0) {		// reset trap
		sigaction(signum, &sct_ss, NULL);
		//sct.sa_handler = SIG_DFL;	//SIG_DFL or SIG_IGN
	} else {	//set trap
		//signal select action 1.def 2.ign 3.func
		//3.func ...SA_SIGINFO+sa_sigaction or sct.sa_handler = *func.
		//sct.sa_handler = SIG_IGN;	//set proc sig work enable(def) or disable(catch) .
		sct.sa_flags = SA_SIGINFO;	//send sig state to myfunc();
		sct.sa_flags |= SA_RESETHAND;	//add one shot setting.
		//		zzz.sa_flags = zzz.sa_flags | SA_RESTART;	//default sigtrap drop blocking method.
		//sct.sa_flags |= SA_NOCLDWAIT;	//if SIG_DEF.  SIG_IGN ignore sa_flags.
		sct.sa_sigaction = dbg_sigfunc;	// restricted type, (int, siginfo_t *, void *)
		sigaction(signum, &sct, &sct_ss);		//run(set) trap  NULL...oldsetting buf.
	}
}


/*SH_SMP*
# include "msgp.h"

int main() {
	int a = 123 ;
	int b = 223;
	double c = 12.3;
	char* d = NULL;
	dbg(a,c,b,d);
//	return 0;
	
	epf("epf");
	pf1("pf1");
	npf1("npf1\n");
	pf2("pf2");
	pf3("pf3");
	dbg("dbg", printf("abc%d\n",1) );
	puts("--");
//
	FILE* fp = stdout;
	MSGP_t old = pfset(NULL,PF_NOCHANGE,fp,NULL);	// pf1,pf2,pf3,dbg. NULL=noout
//	MSGP_t old = pfset(NULL,NULL,NULL,NULL);	// pf1,pf2,pf3,dbg. NULL=noout
	MSGP_t now=pfget();
	puts(old.tostr);	// >> stdout,sout,sout,serr
	puts(now.tostr);	// >> NULL,stdout(...PF_NOCHANGE),fp,NULL
	epf("epf");
	pf1("pf1");
	pf2("pf2");
	pf3("pf3");
	dbg("dbg");
	puts("--");
//
	old = pfset(stdout,NULL,NULL, stdout);
	now = pfget();
	puts(old.tostr);	// >> NULL,stdout,fp,NULL
	puts(now.tostr);	// >> stdout,NULL,NULL, stdout
	epf("epf");
	pf1("pf1");
	pf2("pf2");
	pf3("pf3");
	dbg("dbg");
	puts("--");
	//
	old = pfpush(old);
	now = pfget();
	puts(old.tostr);	// >> stdout,NULL,NULL, stdout	... save&load.
	puts(now.tostr);	// >> NULL,stdout,fp,NULL
	epf("epf");
	pf1("pf1");
	pf2("pf2");
	pf3("pf3");
	dbg("dbg");
	puts("--");
}
//~$ gcc src.c msgp.c -Wall -pedantic -D_XOPEN_SOURCE=600 -std=c99
//SH_SMPE*/



/*
 change log
 --
2022-07-07  Momi-g	<dmy@dmy.dmy>

	* msgp.h(sbg, sck): add new api, disp s1/s1,s2 info
	* (dbg_end): add end '\n' on/off arg
	* (dbg): add parlen blk ( dbg(), dbg_mdl(), dbg_end() )
	* (all): rewrite all code, macro

2022-07-05  Momi-g	<dmy@dmy.dmy>

	* msgp.h(all): change fn() ret void >> int, stmt to expr, ternary op
	
2022-06-28  Momi-g	<dmy@dmy.dmy>

	* msgp.h(dbg): fix api __VA_ARGS__ for c99 warning
	
	* msgp.h(doc): update doc, brp others

2021-11-16  Momi-g	<dmy@dmy.dmy>

	* msgp.h(dbg_b7b7_top, middle): fix for 64bit print(%.*s) >> (int)cast

2021-07-10  Momi-g	<dmy@dmy.dmy>

	* msgp.h(dbg_middle): add (dbg_b7b7_arg_t){0}, fix b/o read.
 
2021-05-21  Momi-g	<dmy@dmy.dmy>

	* msgp.h(PF_NOCHANGE): funcptr>>glvar ptr. func <> void* is gray code.

	* msgp.h(-pedantic): debug code for -Wpedantic.

2021-05-06  Momi-g	<dmy@dmy.dmy>

	* msgp.h(doc): fix cmtdoc, allow dbg(void)

2021-02-22  Momi-g	<dmy@dmy.dmy>

	* msgp.h(idbg): unofficial api, add+improve. dispname cutoff bug

2021-01-18  Momi-g	<dmy@dmy.dmy>

	* msgp.sh.c ( dbg() macro ): improve __VA_ARGS__+0, allow dbg(void) api
	* (dbg_b7b7_top): fix msg to skip "+0"
	* (dbg_b7b7_middle): fix msg, add dbg(void) ck code 
	* (t_dbg test): add test 
	
2021-01-09  Momi-g	<dmy@dmy.dmy>

	* msgp.sh.c (pfset): fix pfset strcpy src/dst overlap bug
	
	* msgp.sh.c (hcut.hpp): adapt new unittest macro
	
	* msgp.sh.c (sh code): adapt new build script

2020-05-15  Momi-g	<dmy@dmy.dmy>

	* msgp.sh.c (dbg): rewrite code, fix va_arg double bug

*/

/*--copyend msgp.c*/
#endif

#endif
