/* Copyright (C) 2022 Momi-g

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 3 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program. If not, see <http://www.gnu.org/licenses/>.
*/

// this code is rewrite of flat_hash_map(cpp boost license) for c-lang.
// https://github.com/skarupke/flat_hash_map/blob/master/flat_hash_map.hpp

/*SH_doc
title=hfl section=3 repnl=\040

@name hfl
@_brief hashtb api for C-lang
@_syno
 typedef struct hfl_node_tag {
 	int tp;		// 'i'nt, 'd'bl, 'p'tr, 's'tr(or 's'truct)
 	char* key;
 	int i;
 	double d;
 	void* p;
 	char* s;
 	int ssz;
 	//..opaque data
 } hfl_nt;
 
 typedef struct hfl_tag{
 	uint32_t cnt;
 	//..opaque data
 } hfl_t;
 
 hfl_t*	hfl_new([uint32_t sz]);
 void*	hfl_free(hfl_t* obj);
 hfl_nt*	hfl_unset(hfl_t* obj, char* key);
 hfl_nt*	hfl_find(hfl_t* obj, char* key);
 hfl_t*	hfl_clear(hfl_t* obj);
 
 #define	hfl_set_i(obj,k,v)	
 #define	hfl_set_d(obj,k,v)
 #define	hfl_set_p(obj,k,v)
 #define	hfl_set_s(obj,k,ptr,[sz])
 #define	hfl_foreach(node, obj)
	
@tl_dr
		@(code)
 #include "hfl.h"
 
 int main(int argc, char** argv){
 	hfl_t* obj = hfl_new();
 	hfl_nt* np = hfl_set_i(obj, "k1", 12);
 	puts(rp->key);	// "k1"
 	int tp = rp->tp;	// int == 'i'
 	hfl_unset(obj, "k1");	//del
 
 	np = hfl_set_s(obj, "k2", "hw");
 	puts(np->s);	// "hw"
 	np = hfl_find(obj, "k2");
 	puts(np->s);	// "hw", np->ssz == 0 (nochange, ag4 isnt)

 	hfl_set_s(obj, "k3", "hi\0gw", 5);	//ag4 isnt/is == strdup/malloc
 	np = hfl_find(obj, "k3");
 	strncmp(np->s, "hi\0gw", np->ssz);	// == 0, np->ssz==5
 	
 	hfl_foreach(p, obj){
 		puts(p->key);
 		hfl_set_i(obj, p->key, 2);	//ok, replace/update
 		hfl_unset(obj, p->key);	//ok
 		// hfl_set_i(obj, "new", 2);	//NG, add newkey
 		p->i = 10;	// allow direct set, not recommend
 	}
 	
 	np = hfl_unset(obj, "k2");
 	np = hfl_find(obj, "k2");	//np == NULL;
 	int cnt = obj->cnt;	//holding keys
 	
 	obj = hfl_clear(obj);	//del allkeys, obj->cnt == 0
 	
 	hfl_free(obj);
 	return 0;
 }
 //~$ cc src.c libhfl.a
		@()
@_desc
	c99 hsearch() allows only 1 hashtb in 1 pg. 
	hfl allows to hold many hashtb.
		@(code)
	--- bench mark: c_arr, c99hash, hfl, gtkhash
	  FAST: c_arr(1) < c99hash == hfl == ghash (20) :SLOW
		@()
	consume time of get/set is almost the same. --
	--
	hfl_set_s(obj, key, vptr, [memsz]) saves mem using strdup()/malloc().
	use malloc() if ag4 exist and not 0. buffmem is freed when hfl_free().

@_eg
	-
@return_value
	suc/fail == ptr, int 0 / NULL, int not0
@errors
	output emsg and exit(1) if fatal err
@notes -
@conforming_to POSIX.1-2001+ (-D_XOPEN_SOURCE=600/_POSIX_C_SOURCE=200112L)
@COPYRIGHT Copyright 2022 momi-g, GPLv3+
@_ver 2022-07-11 v1.0.6 (2022-05-29 v1.0.0)

@_see
https://probablydance.com/2017/02/26/i-wrote-the-fastest-hashtable/ --
https://github.com/skarupke/flat_hash_map --
//SH_docE*/
#ifndef hfl_61a25e678cdd
#define hfl_61a25e678cdd

#include <features.h> 	//SH_co* -D_XOPEN_SOURCE=600 -std=c99 */
#if ( _POSIX_C_SOURCE +0 < 200112L )
	#include "stop cc: needs compiler posix-2001 or upper(c99+)"
#endif

#ifdef hfl_p_
# include <emsg: detect conflict varname hfl.h/'_hfl_p' >
#endif

#include <stdio.h>
#include <string.h>
#include <stdint.h>
typedef struct hfl_node_tag {
	int tp;
	char* key;
	int i;
	double d;
	void* p;
	char* s;
	int ssz;
	//
	uint32_t slot;
	struct hfl_node_tag* pre;
	struct hfl_node_tag* next;
} hfl_nt;

typedef uint32_t (s2u_ft)(const char* key);

typedef struct hfl_tag{
	uint32_t cnt;
	//
	uint32_t mcnt;
	uint32_t lcnt;
	s2u_ft* hashcb;
	hfl_nt** arr;
	hfl_nt* enode;
} hfl_t;

#define hfl_foreach(node, obj)	for(hfl_nt* (node)=obj->enode->pre, *hfl_p_; \
	 hfl_p_=(node)->pre, (node) != obj->enode; (node)=hfl_p_ )

#define hfl_set_i(obj,k,v)	hfl_set_cmn(obj,k,'i',(int)(v), 0)
#define hfl_set_d(obj,k,v)	hfl_set_cmn(obj,k,'d',(double)(v), 0)
#define hfl_set_p(obj,k,v)	hfl_set_cmn(obj,k,'p',(void*)(v), 0)

#define hfl_set_s(obj,k,...)	hfl_set_s_(obj,k, __VA_ARGS__, -1, -1)
#define hfl_set_s_(obj,k,v,sz,...)	hfl_set_s__(obj,k,v,sz)
#define hfl_set_s__(obj,k,v,sz)	hfl_set_cmn(obj,k,'s',(char*)(v), (int)(sz))

#define hfl_new(...)	hfl_new_impl(__VA_ARGS__ +0)
hfl_t* hfl_new_impl(uint32_t sz);
void*	hfl_free(hfl_t* obj);
hfl_nt* hfl_set_cmn(hfl_t* obj, char* k, int tp, ...);
hfl_nt* hfl_unset(hfl_t* obj, char* k);
hfl_nt* hfl_find(hfl_t* obj, char* k);
hfl_t* hfl_clear(hfl_t* obj);

//hpp
#ifdef _IMPL_hfl		/*SH_c o* -D_IMPL_hfl	*/
/*--copyfrom hfl.c*/
/* Copyright (C) 2022 Momi-g

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 3 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program. If not, see <http://www.gnu.org/licenses/>.
*/

// this code is rewrite of flat_hash_map(cpp boost license) for c-lang.
// https://github.com/skarupke/flat_hash_map/blob/master/flat_hash_map.hpp

/*SH_doc
title=hfl section=3 repnl=\040

@name hfl
@_brief hashtb api for C-lang
@_syno
 typedef struct hfl_node_tag {
 	int tp;		// 'i'nt, 'd'bl, 'p'tr, 's'tr(or 's'truct)
 	char* key;
 	int i;
 	double d;
 	void* p;
 	char* s;
 	int ssz;
 	//..opaque data
 } hfl_nt;
 
 typedef struct hfl_tag{
 	uint32_t cnt;
 	//..opaque data
 } hfl_t;
 
 hfl_t*	hfl_new([uint32_t sz]);
 void*	hfl_free(hfl_t* obj);
 hfl_nt*	hfl_unset(hfl_t* obj, char* key);
 hfl_nt*	hfl_find(hfl_t* obj, char* key);
 hfl_t*	hfl_clear(hfl_t* obj);
 
 #define	hfl_set_i(obj,k,v)	
 #define	hfl_set_d(obj,k,v)
 #define	hfl_set_p(obj,k,v)
 #define	hfl_set_s(obj,k,ptr,[sz])
 #define	hfl_foreach(node, obj)
	
@tl_dr
		@(code)
 #include "hfl.h"
 
 int main(int argc, char** argv){
 	hfl_t* obj = hfl_new();
 	hfl_nt* np = hfl_set_i(obj, "k1", 12);
 	puts(rp->key);	// "k1"
 	int tp = rp->tp;	// int == 'i'
 	hfl_unset(obj, "k1");	//del
 
 	np = hfl_set_s(obj, "k2", "hw");
 	puts(np->s);	// "hw"
 	np = hfl_find(obj, "k2");
 	puts(np->s);	// "hw", np->ssz == 0 (nochange, ag4 isnt)

 	hfl_set_s(obj, "k3", "hi\0gw", 5);	//ag4 isnt/is == strdup/malloc
 	np = hfl_find(obj, "k3");
 	strncmp(np->s, "hi\0gw", np->ssz);	// == 0, np->ssz==5
 	
 	hfl_foreach(p, obj){
 		puts(p->key);
 		hfl_set_i(obj, p->key, 2);	//ok, replace/update
 		hfl_unset(obj, p->key);	//ok
 		// hfl_set_i(obj, "new", 2);	//NG, add newkey
 		p->i = 10;	// allow direct set, not recommend
 	}
 	
 	np = hfl_unset(obj, "k2");
 	np = hfl_find(obj, "k2");	//np == NULL;
 	int cnt = obj->cnt;	//holding keys
 	
 	obj = hfl_clear(obj);	//del allkeys, obj->cnt == 0
 	
 	hfl_free(obj);
 	return 0;
 }
 //~$ cc src.c libhfl.a
		@()
@_desc
	c99 hsearch() allows only 1 hashtb in 1 pg. 
	hfl allows to hold many hashtb.
		@(code)
	--- bench mark: c_arr, c99hash, hfl, gtkhash
	  FAST: c_arr(1) < c99hash == hfl == ghash (20) :SLOW
		@()
	consume time of get/set is almost the same. --
	--
	hfl_set_s(obj, key, vptr, [memsz]) saves mem using strdup()/malloc().
	use malloc() if ag4 exist and not 0. buffmem is freed when hfl_free().

@_eg
	-
@return_value
	suc/fail == ptr, int 0 / NULL, int not0
@errors
	output emsg and exit(1) if fatal err
@notes -
@conforming_to POSIX.1-2001+ (-D_XOPEN_SOURCE=600/_POSIX_C_SOURCE=200112L)
@COPYRIGHT Copyright 2022 momi-g, GPLv3+
@_ver 2022-07-11 v1.0.6 (2022-05-29 v1.0.0)

@_see
https://probablydance.com/2017/02/26/i-wrote-the-fastest-hashtable/ --
https://github.com/skarupke/flat_hash_map --
//SH_docE*/
/* tool macros */
#ifndef ERRact
#include <stdio.h>	//SH_co* -D_XOPEN_SOURCE=600 -std=c99 */
 #if (199901L <= __STDC_VERSION__ +0)	/* nealy 200112L, _POSIX_C_SOURCE	c99*/
	#include <sys/types.h>
	#include <unistd.h>
	#define ERRactag	__func__, getpid()
 #else
	#define ERRactag	"func:c99+", 0
 #endif
 #include <string.h>
 #include <errno.h>
 #define ERRact(xpr, msg, act)	if(xpr){ int en_=errno; fprintf(stderr, \
	"ERR: %s %d %s() pid:%d %s msg:%s sys:%s\n",__FILE__,__LINE__, ERRactag \
	, "hit(" #xpr ")", msg, strerror(en_) ); act; }
 #define STOP(xpr, msg)	ERRact(xpr, msg, fputs("STOP\n",stderr);exit(1) )
#endif
#define loop(a)		for(int lpcnt=1;lpcnt<=a;lpcnt++)
/*tool end*/

#include <stdlib.h>
#include <string.h>
#include "hfl.h"

#ifndef HAVE_CONFIG_H
# include "msgp.h"		/*SH_co* -D_IMPL_msgp	*/
#endif



//https://softwareengineering.stackexchange.com/questions/49550
#ifndef HFL_HASHCB
# define HFL_HASHCB			hash_fnv1a
#endif

typedef uint32_t uint;
// <sys/types.h> << omitted uint,  from c99 >> c11
// https://pubs.opengroup.org/onlinepubs/9699919799/

static uint hash_djb2(const char *str);
static uint hash_fnv1a(const char *str);

static uint hfl_nextsz(uint n);
static int hfl_delnode(hfl_t* obj, hfl_nt* p);
static hfl_t* hfl_renew(hfl_t* obj);
static hfl_nt* hfl_insnode(hfl_t* obj, char* key, hfl_nt* p);
static uint getslot(s2u_ft hashcb, uint hashsz, char* key);

//djb2: http://www.cse.yorku.ca/~oz/hash.html
static uint32_t hash_djb2(const char *str){
	unsigned char* s = (unsigned char*)str;
	uint32_t hash = 5381;	//init vec
	//hash * 33 + c
	for(; *s; s++){	hash = ((hash << 5) + hash) + *s; }
	return hash;
}



//fnv-1a: http://www.isthe.com/chongo/tech/comp/fnv/index.html#FNV-param
#define FNV32_INIT ((uint32_t)0x811c9dc5)
#define FNV32_PRIME	((uint32_t)0x01000193)
static uint32_t hash_fnv1a(const char *str){
	unsigned char* s = (unsigned char*)str;
	uint32_t h = FNV32_INIT;	//init vec
	for(; *s; s++) { h ^= *s; h *= FNV32_PRIME; }
    return h;
}


//https://stackoverflow.com/questions/14069737/
//only 6:  const int, enum, charint 'c', sizeof(), _Alignof(), (int)float/dbl
enum prime_etag {
 P0 =1			,P1 =2			,P2 =3			,P3 =7			,P4 =13
,P5 =31			,P6 =61			,P7 =127		,P8 =251		,P9 =509
,P10=1021		,P11=2039		,P12=4093		,P13=8191		,P14=16381
,P15=32749		,P16=65521		,P17=131071		,P18=262139		,P19=524287
,P20=1048573	,P21=2097143	,P22=4194301	,P23=8388593	,P24=16777213
,P25=33554393	,P26=67108859	,P27=134217689	,P28=268435399	,P29=536870909
,P30=1073741789	,P31=2147483647
};

static uint prime_arr[32+1] = {
 P0  ,P1  ,P2  ,P3	,P4		,P5  ,P6  ,P7  ,P8  ,P9  
,P10 ,P11 ,P12 ,P13 ,P14	,P15 ,P16 ,P17 ,P18 ,P19
,P20 ,P21 ,P22 ,P23 ,P24	,P25 ,P26 ,P27 ,P28 ,P29
,P30 ,P31 ,0
};
#ifndef HFL_SLOTDFL
# define HFL_SLOTDFL	31
#endif

#ifndef HFL_SLOTMAX
# define HFL_SLOTMAX 31
#endif
static uint hfl_nextsz(uint n){
	uint* arr = prime_arr;
	uint lim = prime_arr[HFL_SLOTMAX];
	lim < HFL_SLOTDFL ? lim=HFL_SLOTDFL: lim;
	for(int i=0;; i++){
		uint nn = arr[i];
		if( nn!=0 && nn<=lim && nn<=n ){ continue; }
		n = nn;
		break;
	}
	return n;
}

#ifndef HFL_RATIO
# define HFL_RATIO	0.8
#endif

hfl_t* hfl_new_impl(uint sz){
	//if(sz==HFL_SLOTDFL){sz=HFL_SLOTDFL; }
	if(sz==0){sz=HFL_SLOTDFL; }
	hfl_t* obj = calloc(1, sizeof(hfl_t) );
	obj->hashcb = HFL_HASHCB;
	obj->cnt = 0;
	obj->mcnt = sz;
	obj->lcnt = sz * HFL_RATIO;
	obj->arr  = calloc(sz, sizeof(hfl_nt*) );
	obj->enode= calloc(1, sizeof(hfl_nt) );
	obj->enode->pre = obj->enode;
	obj->enode->next = obj->enode;
	
//idx系の管理になるのでf_rqからとってくる。arr[0]で固定位置
	return obj;

//deadcode
	hash_djb2("");
}
void* hfl_free(hfl_t* obj){
	hfl_nt* p = obj->enode;
	if(p){
		void* sv = p->pre;
		for(;;){
			p = sv;
			if(p == obj->enode){break;}
			free(p->key);
			free(p->s);
			sv=p->pre;
			free(p);
		}
	}
	free(obj->arr);
	free(obj->enode);
	free(obj);
	hfl_t buf ={0};
	*obj = buf;
	return obj;
}

// ISO99
// #define strdup(a)	(memcpy(malloc(strlen(a)+1),a ,strlen(a)+1))
static
hfl_nt* hfl_insnode(hfl_t* obj, char* key, hfl_nt* p){
	if(obj==NULL|| key==NULL){ return NULL; }
	//編集するのはpのみ。xp,ppはobjのデータなのでp->系ではない
	if(obj->cnt > obj->lcnt){ hfl_renew(obj); }
	if(p==NULL){
		p = calloc(1, sizeof(hfl_nt) );
		p->key = strdup(key);
	}
	uint pos = getslot(obj->hashcb, obj->mcnt, key);
	hfl_nt* pp = obj->arr[pos];
	hfl_nt* xp;
	if(pp==NULL){
		pp = obj->enode->pre;
		xp = obj->enode;
	}
	else { xp = pp->next; }
	
	//insnode
	p->slot = pos;
	p->pre = pp;	//arr先頭に挿入。initはtailにセットされてる
	p->next = xp;
	
	pp->next = p;
	xp->pre = p;
	
	obj->arr[pos] = p;
	obj->cnt++;
	return p;
}

static
hfl_t* hfl_renew(hfl_t* obj){
	if(obj==NULL){ return hfl_new(); }
	uint nsz = hfl_nextsz(obj->mcnt);
	if(nsz==0){
		obj->lcnt = obj->mcnt;
		return NULL;
	}
	
	hfl_t* nobj = hfl_new(nsz);
	uint ck=0;
//トリッキーだけどforは降順なのでxdiは見ない。逆方向にメモって修正すればいけそう
	hfl_foreach(p, obj){
		hfl_insnode(nobj, p->key, p);
		ck++;
	}
	STOP(ck != obj->cnt, "cnt unmatch");

	//rep
	free(obj->arr);
	free(obj->enode);
	*obj = *nobj;
	
	nobj->arr = NULL;
	nobj->enode =NULL;
	hfl_free(nobj);
	return obj;
}


static int hfl_delnode(hfl_t* obj, hfl_nt* p){
	STOP(p==obj->enode, "try to del enode");

	hfl_nt*	pp = p->pre;
	hfl_nt* xp = p->next;

	xp->pre = pp;
	pp->next = xp;
	
	//slot
	uint pos = p->slot;
	if(obj->arr[pos] == p){
		if(pp->slot==pos){ obj->arr[pos] = pp; }
		else{ obj->arr[pos] = NULL; }
	}
	free(p->key);
	free(p->s);
	hfl_nt buf = {0};
	*p = buf;
	free(p);
	obj->cnt--;
	return 0;
}

static uint getslot(s2u_ft hashcb, uint hsz, char* key){
	uint idx = hashcb(key);
	// cc optimize: mod Strength reduction, case flow control
	// https://stackoverflow.com/questions/14069737/
	switch(hsz){
		case P0 : idx %= P0 ; break;
		case P1 : idx %= P1 ; break;
		case P2 : idx %= P2 ; break;
		case P3 : idx %= P3 ; break;
		case P4 : idx %= P4 ; break;
		case P5 : idx %= P5 ; break;
		case P6 : idx %= P6 ; break;
		case P7 : idx %= P7 ; break;
		case P8 : idx %= P8 ; break;
		case P9 : idx %= P9 ; break;
		case P10: idx %= P10; break;
		case P11: idx %= P11; break;
		case P12: idx %= P12; break;
		case P13: idx %= P13; break;
		case P14: idx %= P14; break;
		case P15: idx %= P15; break;
		case P16: idx %= P16; break;
		case P17: idx %= P17; break;
		case P18: idx %= P18; break;
		case P19: idx %= P19; break;
		case P20: idx %= P20; break;
		case P21: idx %= P21; break;
		case P22: idx %= P22; break;
		case P23: idx %= P23; break;
		case P24: idx %= P24; break;
		case P25: idx %= P25; break;
		case P26: idx %= P26; break;
		case P27: idx %= P27; break;
		case P28: idx %= P28; break;
		case P29: idx %= P29; break;
		case P30: idx %= P30; break;
		case P31: idx %= P31; break;
		default : idx %= hsz; break;
	}
	return idx;
}

#include <stdarg.h>
hfl_nt* hfl_set_cmn(hfl_t* obj, char* k, int tp, ...){
	hfl_nt* p = hfl_find(obj, k);
	int rewflg=0;
	p?rewflg=1 :0;
	if(p==NULL){ p = hfl_insnode(obj, k, NULL); }
	if(p==NULL){ return NULL; }
	
	char* yp;
	int yu;
	
	p->tp = tp;
	va_list va;
	va_start(va, tp);
	switch(tp){
		case 'i': p->i = va_arg(va,int); break;
		case 'd': p->d = va_arg(va,double); break;
		case 'p': p->p = va_arg(va,void*); break;
		case 's':
			rewflg? free(p->s),1  :0;
			yp = va_arg(va,char*);
			yu = va_arg(va,int);
			if(yu<0){ p->s = strdup(yp); break; }
			p->s = malloc(yu);
			STOP(p->s == NULL, "mem err");
			memcpy(p->s, yp, yu);
			p->ssz = yu;
			break;
		default: STOP(1, "invalid typechar");
	}
	va_end(va);
	return p;
}

hfl_nt* hfl_unset(hfl_t* obj, char* k){
	hfl_nt*  p = hfl_find(obj, k);
	if(p==NULL){ return NULL; }
	hfl_delnode(obj, p);
	return p;
}


//strcmp()はmemcmp()にくらべて遅い。memはword単位で比較可能
hfl_nt* hfl_find(hfl_t* obj, char* k){
	if(obj==NULL || k==NULL){ return NULL; }
	uint pos = getslot(obj->hashcb, obj->mcnt, k);
	hfl_nt* p = obj->arr[pos];
	if(p==NULL){ return NULL; }
	for(;p;){
		if(p->slot != pos || p==obj->enode){ p=NULL; break; }
		if(strcmp(p->key, k)==0){ break;}
		//if(memcmp(k, np->key, sz)==0){ break;}
		p = p->pre;
	}
	return p;
}


hfl_t* hfl_clear(hfl_t* hdb){
	hfl_foreach(node, hdb){
		hfl_unset(hdb, node->key);
	}
	return hdb;
}










/*SH_SMP
#include <stdio.h>
#include "hfl.h"

int main(int argc, char** argv){
	hfl_t* obj = hfl_new();
	hfl_nt* rp = hfl_set_i(obj, "k1", 12);
	puts(rp->key);	// "k1"
	int tp = rp->tp;	// int == 'i'
	hfl_unset(obj, "k1");	//del

	rp = hfl_set_s(obj, "k2", "hw");
	puts(rp->s);	// "hw"
	rp = hfl_find(obj, "k2");
	puts(rp->s);	// "hw"
	
	float n = 12.3;
	rp = hfl_set_s(obj, "k3", &n, sizeof(float) );
	// ag4 isnt >> strdup()
	// ag4 exist >> malloc()
	n = *(float*)(rp->s);
	
	hfl_foreach(p, obj){
		puts(p->key);
		hfl_set_i(obj, p->key, 2);	//ok, replace/update
		hfl_unset(obj, p->key);	//ok
		// hfl_set_i(obj, "new", 2);	//NG, add newkey
		p->i = 10;	//ok
	}
	
	rp = hfl_unset(obj, "k2");
	rp = hfl_find(obj, "k2");	//rp == NULL;
	int cnt = obj->cnt;	//holding keys
	
	hfl_free(obj);
	return 0;
}
//~$ gcc src.c libhfl.a
//SH_SMPE*/


/*
 change log
 --
2022-07-11 Momi-g	<dmy@dmy.dmy>

	* hfl.sh.c(set_cmn() ): fix memleak, add rewflg for del premem

2022-07-10 Momi-g	<dmy@dmy.dmy>

	* hfl.sh.c(hfl.h): add hpp impl code

2022-07-02	Momi-g	<dmy@dmy.dmy>

	* hfl.sh.c(hfl.h): change type: node->s (void*) >> (char*)

2022-06-28	Momi-g	<dmy@dmy.dmy>

	* hfl.sh.c: fix hfl_set_s() ag3 macro, brp macro

2022-06-17	Momi-g	<dmy@dmy.dmy>

	* hfl.sh.c: add hfl_clear(), fix doc. v1.0.2

2022-06-08	Momi-g	<dmy@dmy.dmy>

	* hfl.sh.c: update, fix doc

2022-05-29	Momi-g	<dmy@dmy.dmy>

	* hfl.sh.c: init.

*/

/*--copyend hfl.c*/
#endif

#endif /* inc_guard */
