#include <emsg: see ... '~$ sh aaa.sh.c -h'   (other opt:no/-m/-w/)>	/*
C='^[/][/*]SH_'		;O=${0##*[/]};R=`dirname $0`/;R0=$R$O;Re=eval\ ;R=$R${O%%.*}
O=${0##*.};Rs=$R.$O;Rm=$R.tmp.$O;Rh=$R.h;R=$Rs$Rh$Rm;Rp='printf %s\n ';Rc=:;O="
";[ "${R##*$R0*}" = '' ]&&$Rp"$0:NGext"&&exit 1;R='sed -ne ';Cm=$R'"/[E]ND/!d;:l
n;p;b l"<$R0>$Rm;$Rp"$Rm"';Rw=$R'"/$C$R/!d;:l;n;/${C}ED/q;p;b l"<$R0';Cw="(R=LS
$Rw;$Rw>&3;R=HD;$Rw;R=SC;$Rw>&3)"'>$Rh 3>$Rs;$Rp"$Rh $Rs"';RB=$($R"s/${C}OP//p"\
<$R0|(F=mw;while read -r a b;do B=${a%:};F=`$Rp"$F"|$R"s#$B:*##;p"`${a%_};$Rp"
C$B=\$(cat<<'E'$O$b${O}E$O)";done;$Rp"R1=$F"));$Re"$RB";while getopts $R1 R;do
case $R in \?)exit 1;;* )$Re"O$R=\$OPTARG";Rc=$Rc$O`$Re'$Rp"$C'$R\"`;;esac;done
[ "$Rc" = : ]&&Rc=$Cm;shift $((OPTIND-1));$Re"$C_$O$Rc";exit #END  GPLv3+ */

/*SH_LS*/
/* Copyright (C) 2022 Momi-g

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 3 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program. If not, see <http://www.gnu.org/licenses/>.
*/

/*SH_doc
title=*SH_bn* section=3 repnl=\040
@name *SH_bn*
@_brief conv c99 esc string '\n\100' >> '(\n)@' etc
@_syno
 #include "clit.h"
 char* clit(const char* s [,int ssz]);
 char* clitv(const char* s ,int* szptr);
	
@tl_dr
		@(code)@
 #include <stdlib.h>
 #include <stdio.h>
 #include "clit.h"
 
 int main(int argc, char** argv){
 	int sz;
 	char* s = "abc\\n\\100\\u0070\\U00000071";	// \n @ p q
 	char* rp = clit(s);	//use strlen(s) if ag2 isnt/-1
 	puts(rp);	//abc(\n)@pq
 	free(rp);	//always needs free(rtn);
 	
 	//--err
 	s = "\\u70 \\x61";
 	rp = clit(s, 7);	// \u70 \x
 	puts(rp);	//>> emsg. errno != 0
 	free(rp);
 	
 	//--bin
 	s = "a\0b\\100";
 	sz = 7;	//a(\0)b(\)100
 	rp = clitv(s, &sz);
 	puts(rp);	// a
 	free(rp);
 	if(sz!=4){ return 1; }
 	return 0;
 }
 // ~$ cc src.c clit.c	#..or libclit.a etc
 // ~$ ./a.out; echo $?
 	@()@
@params
	@(list)
	s: str/bin holding esc '\' chars
	ssz: conv size if set. use strlen(s) if noset/-1
	szptr: pass s size and write rtnptr sz (verbose)
	@()
@return
	return malloc()ed bin/str. return emsg + errno!=0 if err.
	you always need free() rtnptr.	
@_desc conv c99 escaped literal to utf-8 binary. --
	  char: \ + \"'?abfntv --
	  oct : \ooo (1-3digits) --
	  u4  : \u+ hhhh (4digits) --
	  U8  : \U+ hhhhhhhh (8digits) --
	hex \xhhhh... isnt support. oct is restricted in 3digits==1byte
	but hex isnt. hex value depends on env, endian etc. --
	unicode changes to utf-8 byte sequences.
@errors set errno != 0 if err.
@notes -
@conforming_to POSIX.1-2001+ (-D_XOPEN_SOURCE=600 etc)
@COPYRIGHT Copyright 2022 momi-g, GPLv3+
@_ver 2022-07-10 v1.0.2 (2022-06-27 v1.0.0)
@_see
	https://kikakurui.com/x3/X3010-2003-01.html --
	https://www.dii.uchile.cl/~daespino/files/Iso_C_1999_definition.pdf --
//SH_docE*/
/*SH_ED*/

/*SH_HD*/
#ifndef *SH_bn*_26e14b3219c5
#define *SH_bn*_26e14b3219c5

#include <features.h> 	//SH_co* -D_XOPEN_SOURCE=600 -std=c99 */
#if ( _POSIX_C_SOURCE +0 < 200112L )
	#include "stop cc: needs compiler posix-2001 or upper(c99+)"
#endif

#define clit(...)	clit_sub(__VA_ARGS__, -1, -1)
#define clit_sub(a, b, ...)	clit_impl(a, b)
#define clitv(...)	clitv_impl(__VA_ARGS__)

char* clit_impl(const char* s, int ssz);
char* clitv_impl(const char* s, int* ssz);

//hpp
#ifdef _IMPL_*SH_bn*
	#include "*SH_bn*.c"	/*SH_rf* *SH_bn*.c */
#endif

#endif /* inc_guard: *SH_bn* */
/*SH_ED*/


/*SH_SC*/
#ifndef ERRact
#include <stdio.h>
 #if (199901L <= __STDC_VERSION__ +0)	/* nealy 200112L, _POSIX_C_SOURCE	c99*/
	#include <sys/types.h>
	#include <unistd.h>
	#define ERRactag	__func__, getpid()
 #else
	#define ERRactag	"func:c99+", 0
 #endif
 #include <string.h>
 #include <errno.h>
 #define ERRact(xpr, msg, act)	if(xpr){ int en_=errno; fprintf(stderr, \
	"ERR: %s %d %s() pid:%d %s msg:%s sys:%s\n",__FILE__,__LINE__, ERRactag \
	, "hit(" #xpr ")", msg, strerror(en_) ); act; }
 #define STOP(xpr, msg)	ERRact(xpr, msg, fputs("STOP\n",stderr);exit(1) )
#endif
#define loop(a)		for(int lpcnt=1;lpcnt<=a;lpcnt++)

#include <stdio.h>
#include <stdlib.h>
#include "*SH_bn*.h"

#ifdef TEST
	#include <assert.h>
	#include "*SH_bn*.h"	/*SH_co*	 */
	#include "hcut.h"		/*SH_co * -D_IMPL_hcut */
	# include "msgp.h"		/*SH_co* -D_IMPL_msgp */
	# include "laptime.h"	/*SH_co* -D_IMPL_laptime */
	#define qu(...)		Qsub(__VA_ARGS__)
	#define Qsub(...)	#__VA_ARGS__

	#ifndef loop
	# define loop(a)		for(int lpcnt=1;lpcnt<=a;lpcnt++)
	#endif
#endif


#ifdef TEST
HCUT_ADD(t_0) {
	eq_i(1, 1);
}
#endif

#ifdef TEST
HCUT_ADD(t_clit) {
	const char* s = "abc";
	char* rp = clit(s);
	eq_s(s, rp);
	free(rp);
	//
	s = "\\100\\n\\u30420";
	rp = clit(s);
	eq_s("\100\n\u30420", rp);
	free(rp);
//err
	s = "\\u304";
	rp = clit(s);
puts(rp);
	eq(errno!=0, "uHHH");
	free(rp);
//err
	s = "a\\x60b";
	rp = clit(s);
puts(rp);
	eq(errno!=0, "kick hex");
	free(rp);
//allow end '\'
	s = "a\\";
	rp = clit(s);
puts(rp);
	eq_s("a\\", rp);
	free(rp);

//clitv()
	s = "a\\100b";
	int sz = strlen(s);
	rp = clitv(s, &sz);
	eq_s(rp, "a@b");
	eq_i(sz, 3);
	free(rp);
}
#endif

static int add_u8(char* p, int n);
static char* clit_err(char* p, const char* msg);

char* clit_impl(const char* s, int ssz){
	return clitv_impl(s, &ssz);
}

// \ooo\a系以外のescは放置 >> 修正 [[ \123\x00 ]] 系で完全対応させる
char* clitv_impl(const char* s, int* rsz){
	int ssz = *rsz;
	if(s==NULL){ return strdup("");}
	if(ssz<0){ ssz = strlen(s); }
	char* rp = calloc(1, ssz+1);
	int sdx = 0;
	int rdx = 0;
	char* p=NULL;
	int n=0;
//
	while(sdx<ssz){
		if(s[sdx]!='\\'|| sdx+1 == ssz){
			//\EOF=='\'
			rp[rdx]=s[sdx];
			sdx++;
			rdx++;
			continue;
		}
		sdx++;
		switch(s[sdx]){
			case '\\': rp[rdx]='\\'; sdx++;	rdx++; continue;
			case '\"': rp[rdx]='\"'; sdx++;	rdx++; continue;
			case '\?': rp[rdx]='\?'; sdx++;	rdx++; continue;
			case '\'': rp[rdx]='\''; sdx++;	rdx++; continue;
			case 'a':  rp[rdx]='\a'; sdx++;	rdx++; continue;
			case 'b':  rp[rdx]='\b'; sdx++;	rdx++; continue;
			case 'f':  rp[rdx]='\f'; sdx++;	rdx++; continue;
			case 'n':  rp[rdx]='\n'; sdx++;	rdx++; continue;
			case 't':  rp[rdx]='\t'; sdx++;	rdx++; continue;
			case 'v':  rp[rdx]='\v'; sdx++;	rdx++; continue;
			default: ;
		}
		char ss[9+1]={0};	//U..8..\0 == 10
		//oct
		sprintf(ss, "%.*s%c", 3, s+sdx, 0);	// \ooo max3
		n = strtol(ss, &p, 8);
		if(p!=ss){
			//hit oct
			rp[rdx] = n;
			sdx += p-ss;
			rdx ++;
			continue;
		}
		//hex
		if(s[sdx]=='x'||s[sdx]=='X'){
			return clit_err(rp, "hex esc is unportble so unsupported");
		}
		//u4
		if(s[sdx]=='u'){
			sdx++;
			sprintf(ss, "%.*s%c", 4, s+sdx, 0);	// \uhhhh max4
			char* p=NULL;
			n = strtol(ss, &p, 16);
			if(p!=ss){
			//hit u4
				int rc = add_u8(rp+rdx, n);
				if(p-ss!=4 || rc<0){
					char sbuf[100];
					sprintf(sbuf, "bad uc: \\u%.*s", 4, s+sdx);
					return clit_err(rp, sbuf);
				}
				sdx += 4;	//top '0'
				rdx += rc;
				continue;
			}
			sdx--;
		}
		if(s[sdx]=='U'){
			sdx++;
			sprintf(ss, "%.*s%c", 8, s+sdx, 0);	// \uhhhh max4
			char* p=NULL;
			n = strtol(ss, &p, 16);
			if(p!=ss){
			//hit u4
				int rc = add_u8(rp+rdx, n);
				if(p-ss!=8 || rc<0){
					char sbuf[100];
					sprintf(sbuf, "bad uc: \\U%.*s", 8, s+sdx);
					return clit_err(rp, sbuf);
				}
				sdx += 8;	//top '0'
				rdx += rc;
				continue;
			}
			sdx--;
		}
		char buf[100]={0};
		sprintf(buf, "bad char %d + %d", (int)s[sdx], (int)s[sdx+1] );
		return clit_err(rp, buf);
	}
	*rsz = rdx;
	return rp;
}

static
char* clit_err(char* rp, const char* msg){
	free(rp);
	errno = EINVAL;
	return strdup(msg);
}

static
int add_u8(char* p, int n){
	if(n<0x80){
		// 0-u0080
		*p = ( char)n;
		return 1;
	}
	if(n<0x800){
		//u0080-07FF
		 char c2 = (n % (1<<6) ) + (1<<7);	//10 123456
		n = n>>6;
		 char c1 = n % (1<<5) + (1<<7)+(1<<6);	//110 12345
		*p = c1;
		*(p+1) = c2;
		return 2;
	}
	if(n<0x10000){
		//u0800-FFFF
		 char c3 = (n % (1<<6) ) + (1<<7);	//10 123456
		n = n>>6;
		 char c2 = (n % (1<<6) ) + (1<<7);	//10 123456
		n = n>>6;
		 char c1 = n % (1<<4) + (1<<7)+(1<<6)+(1<<5);	//111 12345
		*p = c1;
		*(p+1) = c2;
		*(p+2) = c3;
		return 3;
	}
	if(n<0x10FFFF){
		//u0800-FFFF
		 char c4 = (n % (1<<6) ) + (1<<7);	//10 123456
		n = n>>6;
		 char c3 = (n % (1<<6) ) + (1<<7);	//10 123456
		n = n>>6;
		 char c2 = (n % (1<<6) ) + (1<<7);	//10 123456
		n = n>>6;
		 char c1 = n % (1<<3) + (1<<7)+(1<<6)+(1<<5)+(1<<4);	//1111 234
		*p = c1;
		*(p+1) = c2;
		*(p+2) = c3;
		*(p+3) = c4;
		return 4;
	}
	return -1;
}

/*SH_SMP
 #include <stdlib.h>
 #include <stdio.h>
 #include "clit.h"
 
 int main(int argc, char** argv){
	int sz;
 	char* s = "abc\\n\\100\\u0070\\U00000071";	// \n @ p q
 	char* rp = clit(s);	//use strlen(s) if ag2 isnt/-1
 	puts(rp);	//abc(\n)@pq
 	free(rp);	//always needs free(rtn);
 	
 	//--err
 	s = "\\u70 \\x61";
 	rp = clit(s, 7);	// \u70 \x
 	puts(rp);	//>> emsg. errno != 0
 	free(rp);
 	
 	//--bin
 	s = "a\0b\\100";
 	sz = 7;	//a(\0)b(\)100
 	rp = clitv(s, &sz);
 	puts(rp);	// a
 	free(rp);
 	if(sz!=4){ return 1; }
 	return 0;
 }
 // ~$ cc src.c clit.c	#..or libclit.a etc
 // ~$ ./a.out; echo $?
//SH_SMPE*/

#ifdef TEST

#ifndef VLV
# define VLV	1
#endif /**/
HCUT_RUN("stderr", VLV,
		 t_0)
#endif

/*
 change log
 --
2022-07-10	Momi-g	<momi-g@dmy.dmy>

	* *SH_bn*.sh.c: add hpp impl header code

2022-06-27	Momi-g	<momi-g@dmy.dmy>

	* *SH_bn*.sh.c: init. v1.0.0

*/

/*SH_ED*/

/*SH_OP _ set -e;a=`sed -ne "/${C}DF/!d;:l;n;/${C}DE/q;p;bl"<$R0`;eval "$a";set +e	#*/
/*SH_OP	h $p"-tsbS:test/eg/.o/.so -LMP:leak,mem,prof -f:funcs -o:bldout		GPLv3+"	 #*/
/*SH_OP	f sed -ne "/${C}DF/q;/;/d;/^[a-zA-Z].*)/p"<$R0 #*/
/*SH_OP t $e"$CW";ftt "$@";$p'cc -O0 $dm -Wall -pedantic -Wfatal-errors -g -pg -ggdb3 $Rm `fOI $Rs $tf` `fg $Rh $Rs $tf` `fL`'|fv	#*/
/*SH_OP T $e"$CW";ftt "$@";$p'cc -O3 $dm $Rm `fOI $Rs $tf ` `fg $Rs $tf ` `fL`'|fv	#*/
/*SH_OP s fgr0 "${C}SMP" "${C}SMPE"<$R0|fbn>eg.c;$p'cc eg.c `fg eg.c` `fOI eg.c`'|fv #*/

/*SH_OP L $p"fml $@"|fv #*/
/*SH_OP M $p"fM ./a.out"|fv	 #*/
/*SH_OP P $p'valgrind --tool=callgrind --callgrind-out-file=log.out ./a.out;kcachegrind log.out'|fv	 #*/

/*SH_OP b $e"$CW";$p'cc -c $Rs -pedantic -O2 -Wall -g `fg $Rs` `fI $Rs`'|fv;$p"$bn.o" #*/
/*SH_OP B $e"$Cb";$p"ar -r lib$bn.a $bn.o `fO $Rs`"|fv;$p"lib$bn.a"	#*/
/*SH_OP A $e"$CB";$p'fA lib$bn.a `fg $Rh $Rs|fu|grep '[.]a$'|fU`'|fv;$p"lib$bn.a" #*/
/*SH_OP S $e"$CW";$p"cc -shared -fPIC -o lib$bn.so $bn.c `fOI $Rs` `fg $Rs`"|fv;$p"lib$bn.so" #*/
/*SH_OP W $e"$Cm$O$Cw">/dev/null;fborn;$p"$Rs $Rh $tf"	#*/
/*SH_OP o $e"$CW";$p'fman $Rh 3'|fv		#*/

/*SH_OP y cp $Rs $bn.cbrt;$p"cbrt $bn.cbrt --c $Rs --h cbft.h"|fv	#*/
/*SH_OP Y $e"$Cm$O$Cw">/dev/null;$e"$Cy";fborn;$p"$Rs $Rh $tf"		#*/

/*SH_DF
#-- noob
fman()( $p"cat $1|sed -e '/${C}docE/q'|fgr0 '${C}doc' '${C}docE'|amn >$bn.$2
 mandoc -Thtml <$bn.$2 >$bn.$2.html
 man -Tutf8 /dev/stdin<$bn.$2|sed -e 's/.`printf \"\\b\"`//g'>$bn.$2.txt
 "|fv
)

#-- local

#-- vars
bn=`basename ${Rs%.*}`; tf=${Rs%/*}/${bn}.ts.${Rs##*.}; e="eval "; p="$Rp"
#-- mod
fv()(while read -r a;do $e"cat<<E$O# $a${O}E"|sed -e 's@-L.*-L[^ ]*@-L(omit)@g'>/dev/stderr;$e"$a";done)

fbn()(sed -e "s@\*${C##*]}bn\*@$bn@g"|frf|frv|flit)
fsn()(tr -s ' \t' '\n')
fsl()(tr -s '\n' ' ')
fu()(fsn|sort -u)
fU()(fu|fsl;$p)

fgr()(sed -e "/$1/!d;:l;/$2/{p;d};n;bl")	#切出
fgr0()(sed -ne "/$1/!d;:l;n;/$2/d;p;bl")	#抜き切出
fgR()(sed -ne "/$1/bl;p;d;:l;n;/$2/d;bl")	#切すて
fg()($e\$p`sed -ne "s/.*${C##*]}co\*\([^*]*\).*$/\1/p" "$@"`|fsn|awk '!a[$0]{a[$0]=1;print}'|fsl)

# fO src.o from inc"src.abc" etc. kick self
fO()(set -- `fdp "$@"|awk '$0~/[.](h|hpp)$/{print}'|sed -e 's/[.][^.]*$/.c/'|fU`
	buf="";for i;do test -f $i&&buf="$buf $i";done;$p"$buf"
)
fI()(fdp "$@"|sed -e 's/[^/]*$//g'|fu|sed -e '/./s/^/ -I/g'|fu|grep -v '^\-I$'|fU)
fL()(find -L `dirname $R0` -type d|sed -e 's/^/-L/g'|fU)
# inc""系.h,hpp,oをパス付きで羅列 OIはfdpが重複するので高速化でまとめる 複数file_ok
fOI()(
set -- `fdp "$@"`
s="-I./ "`$p"$@"|sed -e 's/[^/]*$//g'|fu|sed -e 's/^/ -I/g'|fu|grep -v '^\-I$'|fU`
set -- `$p"$@"|awk '$0~/[.](h|hpp)$/{print}'|sed -e 's/[.][^.]*$/.c/'|fU`
buf="";for i;do test -f $i&&buf="$buf $i";done;
$p"$buf $s"
)

# 依存inc""を再帰的に取得./以下全て self系はkick
fdp()( l="$*"; paths="$@"; all=""; used=""
 while :;do
	all=`$p$all $paths|fU`	#差分を追加 repの始末 差分たちからaaa.hを取得 partial path
	buf=`(cat $paths|sed -ne 's@^[ \t]*#inc[^"]*.\([a-zA-Z0-9._]*\)".*@\1@p')|sort -u`
	ch=`$p$used $buf|tr -s ' ' '\n'|sort|uniq -u`	#使用済は外す
	used="$used $ch"	#リスト更新
	paths=`fsvy $ch|sort -u`	#ls検索 name系のみのはず
	buf=`$p"$all" "$paths"|fU`	#増えたらloop
	[ ${#all} = ${#buf} ]&&break
 done
# initを除く
 set -- $all
 for i;do a=${i##*[/]}; a=${a%%.*};[ "${l##*$a*}" = "$l" ]&&set -- "$@" $i;shift;done
 $p"$@"
)

# corecode:search + depthck + uniq
fsvy()(c="find -L ./ -false"
	for i; do c="$c -o -path '*'$i";done; l=`$e"$c"`
	for i; do $p"$l"|grep -F "$i"|awk '{sv=$0;print gsub("[/]","") " " sv}'|
	sort -k 1.1,1n -k 2.2,2|awk '{print $2;exit}'; done
)

# libをまとめる
fA()(n=0;dir=`dirname $0`/tmpdir;mkdir $dir;cd $dir;
 for i;do
 	n=$((n+1))
 	cp ../$i $i
 	ar -x $i
 	for ii in *.o;do mv "$ii" "p${n}_$ii";done
 	ar -r lib$bn.aa *.o
 	rm *.o
 done
 $p'mv lib$bn.aa ../lib$bn.a'|fv
 cd ..;rm -r $dir
)

#-- yacc
fy(){
set -e
cat<<'EEE'|fv
fgr0 "${C}YACC" "${C}YACCE"<$Rs|fbn>myyacc.y
fgr0 "${C}LEX" "${C}LEXE"<$Rs|fbn>mylex.l
fgR "${C}YACC" "${C}YACCE"<$Rs>$Rm
fgR "${C}LEX" "${C}LEXE"<$Rm>$Rs

lex mylex.l
#bison -Wnone -Wall -Wno-empty-rule -p zz -dv myyacc.y 
# bisonはy.tab.c固定名ではなくsrc.tab.c/hを吐く 標準に戻す
bison -Wnone -Wall -Wno-empty-rule -dv myyacc.y --defines=y.tab.h -o y.tab.c

cat $Rh y.tab.c lex.yy.c > $Rs
$p"$Rs"
EEE
}

#-- longcmd
frf()(
 # *sh_rf* 0 a.txt b.txt ...でcat纏めて出力 top0でsrcinfoは無し出力
 awk -v tg="${C##*]}rf" 'index($0,tg){
 s=substr($0, index($0,tg)+length(tg)+1);split(s, a)
 m="[ -f \"%s\" ]&&(echo \"/*--copyfrom %s*\"/;cat \"%s\";echo \"/*--copyend %s*\"/)"
 mm="[ -f \"%s\" ]&&(_=\"%s\"/;cat \"%s\";_=\"%s\")"
 for(i=1;i in a;i++){v=a[i];if(v==0){m=mm;continue};system(sprintf(m,v,v,v,v)) }
 next
 }
 {print}'
)
frv()(buf=`awk '$1=="@_ver" {print $3;exit}'<$R0`;sed -e "s@\*${C##*]}ver\*@$buf@g")
flit()(sed -ne "/${C##*]}lit/b l;p;d;:l;n;/${C##*]}litE/d;"'s/[\]/&&/g;s/"/\\"/g;s@.*@"&\\n"@g;p;b l')

fml()(
 # --show-leak-kinds=definite,indirect(inner ref),possible,reachable(doesnt p=NULL)
 #cmd="valgrind --leak-check=full --show-leak-kinds=all --track-origins=yes --verbose ./a.out 2>&1|sed -e '/SUMMA/!d;n;n;n;n'"
 cmd="valgrind --leak-check=full --show-leak-kinds=definite,possible --track-origins=no --verbose ./a.out 2>&1|sed -e '/SUMMA/!d;n;n;n;n'"
 test $# = 0 && $p"$cmd"|fv && return
 set -- " " "$@"
 $e"$Ct"
 test $? = 0 && $p"$cmd"|fv
)

ftm(){
 awk -v w="$1" '
 /^HCUT_ADD/ && index($0,"("w")")==0 {
	while(match($0,"^#endif$") ==0 ){getline}
	print $0; next
 }
 {print $0}'
}

fte()(
 cat > $Rm-
 cmd="cat"
 [ $# != 0 ] && cmd='ftm $b'
 a="`sed -ne 's@^HCUT_ADD(\([^)]*\).*@\1, @p' $Rm-|tr -d '\n'`NULL"
 if [ $# != 0 ];then	a=""; for i;do a="$a $i,";done; a="$a NULL"; fi
 b=`$p"$a"|tr ',' ' '`
 sed -ne "p;/_RUN/b l;d;:l;/[)]/{c \\$O $a)$O p;d};n;b l" $Rm-|$e"$cmd"|
 fgr0 "^#ifdef TEST" '^#endif$'
 rm $Rm-
)

ftt(){
 [ $# != 0 ] && [ "${1#[0123]}" = "" ]&&dm="-DVLV=$1"&&shift
 (cat $Rs;fte "$@"<$tf)>$Rm
}
fborn(){
 fgr "^#ifdef TEST" "^#endif$"<$R0|fbn>$tf
 fgR "^#ifdef TEST_" "^#endif$"<$tf |fte>tests.code
 fgR "^#ifdef TEST" "^#endif$"<$Rs|fbn>$Rm;mv $Rm $Rs;fbn<$Rh>$Rm;mv $Rm $Rh
}
fM()(
 valgrind -q --tool=massif --massif-out-file=./vmem.buf --stacks=yes --trace-children=yes $1>/dev/null
 ms_print ./vmem.buf|sed -ne '/[KMG]B/bl;d;:l;/snap/q;p;n;bl';rm ./vmem.buf)

/*SH_DE*/
