#include <emsg: see ... '~$ sh aaa.sh.c -h'   (other opt:no/-m/-w/)>	/*
C='^[/][/*]SH_'		;O=${0##*[/]};R=`dirname $0`/;R0=$R$O;Re=eval\ ;R=$R${O%%.*}
O=${0##*.};Rs=$R.$O;Rm=$R.tmp.$O;Rh=$R.h;R=$Rs$Rh$Rm;Rp='printf %s\n ';Rc=:;O="
";[ "${R##*$R0*}" = '' ]&&$Rp"$0:NGext"&&exit 1;R='sed -ne ';Cm=$R'"/[E]ND/!d;:l
n;p;b l"<$R0>$Rm;$Rp"$Rm"';Rw=$R'"/$C$R/!d;:l;n;/${C}ED/q;p;b l"<$R0';Cw="(R=LS
$Rw;$Rw>&3;R=HD;$Rw;R=SC;$Rw>&3)"'>$Rh 3>$Rs;$Rp"$Rh $Rs"';RB=$($R"s/${C}OP//p"\
<$R0|(F=mw;while read -r a b;do B=${a%:};F=`$Rp"$F"|$R"s#$B:*##;p"`${a%_};$Rp"
C$B=\$(cat<<'E'$O$b${O}E$O)";done;$Rp"R1=$F"));$Re"$RB";while getopts $R1 R;do
case $R in \?)exit 1;;* )$Re"O$R=\$OPTARG";Rc=$Rc$O`$Re'$Rp"$C'$R\"`;;esac;done
[ "$Rc" = : ]&&Rc=$Cm;shift $((OPTIND-1));$Re"$C_$O$Rc";exit #END  GPLv3+ */

//SH_LS
/* Copyright (C) 2022 Momi-g

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 3 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program. If not, see <http://www.gnu.org/licenses/>.
*/

/*SH_doc*
title=*SH_bn* section=3 repnl=\040
@name	stredit
@_brief	auto growing str/bin buffer. fast.
@_syno
 typedef struct stredit_tag {
 	char* p;
 	int ofst;
 	int sz;
 	int msz;
 	// ..and inner_data
 } se_t;
 
 se_t*	se_new(void);
 se_t*	se_free(se_t* obj);	//macro: >> (se_freeXX(obj), obj=NULL)
 int		se_ins(se_t* obj, int cur, const char* bin [,int binsz] );
 int		se_insf(se_t* obj, int cur, const char* fmt, ...);
 int		se_del(se_t* obj, int cur, int dcnt);
 
 char*	se_ptr(obj);		// get str/data head ptr. obj->p.
 int		se_sz(obj);		// data sz. obj->sz.
 int		se_clear(se_t* obj);	//rtn some int val

@params
		@(list)
	obj:	mainstruct. holds malloc()ed ptr, memsz etc
	cur:	edit cursor pos
	bin:	str/bin you want to add
	binsz:	addsize >= -2. -1@:strlen(bin), -2@:strlen(bin)+1.
	fmt:	printf() fmt
	dcnt:	del byte size. dcnt<0 / 0<dcnt == bs-key/del-key
		@()

@tl_dr
		@(code)@
	#include <stdio.h>
	#include "stredit.h"

	int main() {
	  se_t* obj = se_new();		// ""
	  int rc= se_ins(obj, -1, "foo"); // "foo", rc=3(strsz), -1 == end
	  char* p = se_ptr(obj);		// get headptr
	  puts(p);				// >> 'foo'
	  int sz = se_sz(obj);		// >> 3
	  
	  se_ins(obj, 1,  "ZZZ");	// f|oo + ZZZ, "fZZZoo", 1 == inspos
	  rc = se_ins(obj, 0, "baz");	// "bazfZZZoo", rc=3
	  se_ins(obj, -1, "\0abc");	// "bazfZZZoo", read as str if ag4 isnt
	  se_ins(obj, 0, "\0abc", 2);	// "(\0)abazfZZZoo", rc==2
	  sz = se_sz(obj);			// 11, sz is holding bin size
	  se_clear(obj);				// "", rc = 0
	  
	  se_insf(obj, 0, "%#x",17);	// "0x11", printf() fmt
	  se_insf(obj, -1, "\0");	// "0x11", rc=0
	  se_insf(obj, -1, "%c", 0);	// "0x11(\0)", rc=1
	  se_del(obj, 1, 2);		// "01(\0)" , cur==1, del 2byte. rc=2
	  se_del(obj, -1, -2);		// "0" , rc=2. -1==tail, -2 == bs 2byte. rc=2
	  puts(obj->p);			// "01"
	  
	  se_ins(obj, 0, obj->p);		// >> "0101", allow to use inner ptr
	  se_insf(obj, 1, "%s", obj->p);	// >> "0_01011,
	  
	  se_free(obj);	// (free_XX(obj), obj=NULL);
	  return 0;
	}
	// ~$ gcc src.c stredit.c
		@()@
@return	
		@(code)@
	se_ins/se_insf/se_del: edit byte int size
	se_clear:  some int val
	se_new/se_free: new/freed se_t* ptr
		@()@
@_desc *SH_bn* is string buffer for general purpose, add/del/ins/clear chars.
	buffsz is automatically realloc()ed. see samples for detail usage. --
	input data/str is always terminated with '\0'.
	this last byte is out of se_sz() cnt. --
	--
	- puts(se_ptr(obj)) never causes SEGV err.
		@(code)--@
	se_ins(obj, 0, "foo");		// sz=3	puts(se_ptr(obj) ) >> "foo" 
	se_ins(obj, 0, "\0ab",4);	// sz=7	puts(se_ptr(obj) ) >> "foo" 
	se_clear(obj);				// sz=0	puts(se_ptr(obj) ) >> ""
	se_ins(obj, 0, "bar");		// sz=3	puts(se_ptr(obj) ) >> "bar" 
		@()--@
	- str editting funcs rtns added sz as printf()
		@(code)--@
	se_t* obj = se_new();
	char* s = "hw";
	int p1 = se_ins(obj, s, strlen(s)+1 );	//+1=='\0', p1==3
	s = "gw";
	int p2 = se_ins(obj, s, -2 );	//-2==slen(s)+1, p2==3, "hw(\0)gw(\0)"
	puts( se_ptr(strpool)+p1 );	//>>gw
	puts( strpool->p );		//>>hw
		@()--@
	- se_clear() doesnt shrink heap --
	- sloppy benchmark:
		@(code)--@
	FAST: strdup/se_ins(1) > se_insf(5) >>> asprintf(300) >>> libapr(1000) :SLOW

	code: while(i-- >0){ se_ins(obj, "123"); }, loop(1*1000*1000) etc
	
	100.466 ms: msg:se_ins(abc) lp: 1*1000*1000
	517.152 ms: msg:se_insf(abc) lp: 1*1000*1000
	118.990 ms: msg:strdup(abc) loop1*1000*1000
 
 (too slow + causes memclash)
	244.710 ms	: msg:gnu asprintf(), x10 == 2.4s (lp: 10*1000)
	978.828 ms	: msg:apr_psprintf(), x10 == 9.7s (lp: 10*1000)
 		@()--@
@notes -
@conforming posix-2001+
@_ver 2022-07-10 v1.0.2 (2021-06-25 v1.0.0)
//SH_docE*/
/*SH_ED*/

/*SH_HD*/
#ifndef stredit_fc94efbf1b06
#define stredit_fc94efbf1b06

//2001L: sigaction()
#include <features.h> 	//SH_co* -D_XOPEN_SOURCE=600 -std=c99 */
#if ( _POSIX_C_SOURCE +0 < 200112L )
	#include	"stop cc: needs compiler posix-2001 or upper(c99+)"
#endif

typedef struct stredit_tag {
	char* p;	//仮想的なtop
	int ofst;	// 中央付近に陣取る
	int sz;
	int msz;
	char* sbuf;
	int sbufsz;
} se_t;

// init heap sz
#ifndef SE_BUFSZ
 #define SE_BUFSZ	32
#endif
	
se_t* se_new(void);
#define se_free(obj)	(se_free_impl(obj), obj=NULL)
se_t* se_free_impl(se_t* obj);

#define se_ins(...)	se_ins_impl(__VA_ARGS__, -1)
int se_ins_impl(se_t* obj, int pos, const char* bin, ...);
#define se_insf(...)	se_insf_impl(__VA_ARGS__)
int se_insf_impl(se_t* obj, int pos, const char* fmt, ...);

int se_del(se_t* obj, int pos, int dcnt);
se_t* se_clear(se_t* str);

#define se_ptr(obj) (obj->p)
#define se_eptr(obj) (obj->p + obj->sz -1 )
#define se_sz(obj)	(obj->sz)

//hpp
#ifdef _IMPL_*SH_bn*		/*SH_c o* -D_IMPL_*SH_bn*	*/
	#include "*SH_bn*.c"	/*SH_rf*	*SH_bn*.c	*/
#endif

#endif /* stredit_fc94efbf1b06 */
/*SH_ED*/

/*SH_SC*/
/* tool macros */
#ifndef ERRact
#include <stdio.h>
 #if (199901L <= __STDC_VERSION__ +0)	/* nealy 200112L, _POSIX_C_SOURCE	c99*/
	#include <sys/types.h>
	#include <unistd.h>
	#define ERRactag	__func__, getpid()
 #else
	#define ERRactag	"func:c99+", 0
 #endif
 #include <string.h>
 #include <errno.h>
 #define ERRact(xpr, msg, act)	if(xpr){ int en_=errno; fprintf(stderr, \
	"ERR: %s %d %s() pid:%d %s msg:%s sys:%s\n",__FILE__,__LINE__, ERRactag \
	, "hit(" #xpr ")", msg, strerror(en_) ); act; }
 #define STOP(xpr, msg)	ERRact(xpr, msg, fputs("STOP\n",stderr);exit(1) )
#endif
#define loop(a)		for(int lpcnt=1;lpcnt<=a;lpcnt++)
/*tool end*/

#include <stdlib.h>
#include <string.h>

#include "*SH_bn*.h"

#ifdef TEST
	#include <assert.h>
	#include "*SH_bn*.h"	//SH_co*	*
	#include "hcut.h"
	# include "msgp.h"		//SH_co* -D_IMPL_msgp	*
	#include "laptime.h"
	#define qu(...)		Qsub(__VA_ARGS__)
	#define Qsub(...)	#__VA_ARGS__

	#ifndef loop
	# define loop(a)		for(int lpcnt=1;lpcnt<=a;lpcnt++)
	#endif
#endif

#ifdef TEST
HCUT_ADD(t_0) {
	int rc=0;
	se_t* obj = se_new();
	se_ins(obj, 0, "hello");
	se_del(obj, 0, 2);
puts(obj->p);
	se_free(obj);

	eq_i(rc, 0, "msg");
}
#endif

/*src*/
se_t* se_new(void) {
	; STOP( SE_BUFSZ<1, "init bufsz is negative num");
	se_t* obj=(se_t*)calloc(1, sizeof(se_t));
	; if(!obj){return NULL;}	//STOP(!obj, "calloc() failed");

	obj->ofst = SE_BUFSZ/2;
	char* p = (char*)calloc(SE_BUFSZ, sizeof(char));
	; if(!p){return NULL;}	//STOP(!obj, "calloc() failed");

	obj->p = p + obj->ofst;
	obj->sz=0;
	obj->msz= SE_BUFSZ;
	
	obj->sbuf = calloc(SE_BUFSZ, sizeof(char) );
	obj->sbufsz = SE_BUFSZ;
	return obj;
}

se_t* se_free_impl(se_t* obj) {
	if(!obj){return NULL;}
	free(obj->p - obj->ofst);
	free(obj->sbuf);
	obj->p=NULL;	
	obj->ofst=0;
	obj->sz=0;
	obj->msz=0;
	obj->sbuf=NULL;
	obj->sbufsz=0;
	free(obj);
	return obj;
}
#ifdef TEST
HCUT_ADD(t_new) {
	int rc=0;
	se_t* obj = se_new();	// ""
	se_free(obj);
	eq_p(obj, NULL);
	eq_i(rc, 0, "msg");
}
#endif

#include <stdarg.h>
//curは0なら||abcde, 2なら|ab|cde でpreに残すbyte数に一致する
static int se_realloc(se_t* obj, int binsz, int pflg);

int se_ins_impl(se_t* obj, int cur, const char* bin, ...) {
	; STOP(!obj, "NULL obj.");	//削れば10%早くなるけどセグフォで見えないのは嫌
	va_list ap;
	va_start(ap, bin);
	int binsz = va_arg(ap, int);
	va_end(ap);
	
	//ag cmpl
	; STOP(binsz < -2, "binsz>=0 or -1:strlen(), -2:strlen()+1, -3...err")
	binsz == -1 ? binsz = strlen(bin)
	: binsz == -2 ? binsz = strlen(bin) + 1
	: 0;
	if(cur == -1){ cur = obj->sz; }
// add bad range >> disp err for note
	else if(cur > obj->sz){
		errno = EINVAL;
		ERRact(cur, "bad curpos, over the max", return -1);
	}

	//inner ptr
	if(obj->p <= bin && bin< obj->p + obj->sz){
		if(obj->sbufsz < binsz){
			obj->sbuf = realloc(obj->sbuf, binsz);
			obj->sbufsz = binsz;
		}
		memcpy(obj->sbuf, bin, binsz);
		bin = obj->sbuf;		
//dbg(1, sleep(1) );
	}
	//ck memspace
	int pflg = 0;
	while(1){
		int presz = obj->ofst;
		int pstsz = obj->msz - obj->sz - obj->ofst;
		cur < obj->sz/2 ? pflg = -1: (pflg = -2);

		/**/ if(presz>binsz && pflg==-1) { pflg = 1; }
		else if(pstsz>binsz && pflg==-2) { pflg = 2; }
		if(pflg>0){break;}
		se_realloc(obj, binsz, pflg);
	}
	//write
	//head
	if(pflg==1){
		int mvsz = cur;
		if(mvsz){ memmove(obj->p -binsz, obj->p, mvsz); }
		memcpy(obj->p-binsz+cur, bin, binsz);
		; obj->ofst -= binsz;
		; obj->p -= binsz;
		goto lb_RTN;
	}
	//tail
	if(pflg==2){
		int mvsz = obj->sz - cur;
		memmove(obj->p + cur + binsz, obj->p + cur, mvsz);
		memcpy(obj->p + cur, bin, binsz);
		goto lb_RTN;
	}
	
lb_RTN:;
	obj->sz += binsz;
	obj->p[obj->sz]=0;
	return binsz;
}

#ifdef TEST
HCUT_ADD(t_ins) {
	int rc=0;
	char* p=NULL, *pp=NULL;
	se_t* obj = se_new();
	rc = se_ins(obj, 2, "unko");
	eq_i(rc, -1);
	se_clear(obj);
	//
	rc = se_ins(obj, 0, "unko");
	eq_i(rc, 4);
	eq_i(obj->sz, 4);
	p = se_ptr(obj);
	eq_s(p, "unko");
dbg(obj->msz, obj->ofst);
	//
	rc = se_ins(obj, 0, "anko");
	eq_i(rc, 4);
	eq_i(obj->sz, 8);
	p = se_ptr(obj);
	eq_s(p, "ankounko");
//dbg(obj->msz, obj->ofst);
	//
	rc = se_ins(obj, -1, "inko");
	eq_i(rc, 4);
	eq_i(obj->sz, 12);
	p = se_ptr(obj);
	eq_s(p, "ankounkoinko");
//dbg(obj->msz, obj->ofst);
	//
	se_clear(obj);
	eq_i(obj->sz, 0);
	eq_s(obj->p, "");
	//
	pp = "012345678901234567890123456789__a";
	rc = se_ins(obj, -1, pp);
	eq_i(rc, 33);
	eq_i(obj->sz, 33);
	eq_i(obj->msz, 32*2);
	p = se_ptr(obj);
	eq_s(p, pp);
dbg(obj->msz, obj->sz, obj->ofst, obj->p);
	//
	rc = se_ins(obj, 0, pp);
	eq_i(rc, 33);
	eq_i(obj->sz, 66);
	eq_i(obj->msz, 32*4);
	p = se_ptr(obj);
//	eq_s(p, pp);
dbg(obj->msz, obj->sz, obj->ofst, obj->p);
	se_clear(obj);
	eq_i(obj->sz, 0);
dbg(obj->msz, obj->sz, obj->ofst, obj->p);

	se_free(obj);
	eq(obj==NULL);
}
#endif

// corecode
static
int se_realloc(se_t* obj, int binsz, int pflg){
	//	init: |....@....|
	//	add : |....@@...|
	//	ins : |.===@@...|			realloc					centering
	//	ext	: |.===@@@@@|  >>  |.==@@@@@(XX)|....| >> |....==@@@@@(XX).....|
	int newsz = 0;
	char* p = obj->p - obj->ofst;
	//centering if uneven layout	|.|xxxxx|..............|
	int evsz = (obj->msz - obj->sz)/2;
	if(obj->sz + binsz +1 < evsz){ newsz = obj->msz; }	// +1 == 1/2
	else{
		newsz = obj->msz*2;
		if(newsz - obj->sz - 1 < binsz){ newsz += binsz+1; }
		p = realloc(p, newsz);
		; if(p==NULL){ return -1; }
	}
	pflg == -1 ? pflg = 1: (pflg= 0);
	
	//centering head == +, tail== -
	int nofst = (newsz - (obj->sz +binsz) )/2 + pflg * binsz;
	memmove(p +nofst, p +obj->ofst, obj->sz);
	obj->ofst = nofst;
	obj->p = p + nofst;
	obj->msz = newsz;
	obj->p[obj->sz]=0;
	return 0;
}

#include <stdarg.h>
//curは0なら||abcde, 2なら|ab|cde でpreに残すbyte数に一致する

int se_insf(se_t* obj, int cur, const char* fmt, ...) {
	; STOP(!obj, "NULL obj.");
	char sbuf[1]={0};
	va_list ap;
	va_start(ap, fmt);
	size_t binsz = vsnprintf(sbuf, sizeof(sbuf), fmt, ap);	//sn系は\0を除く。クソが。
	va_end(ap);
	//pf系は全て外 %sが怪しいが判別不能
	//inner sv
	if(obj->sbufsz < binsz){
		obj->sbuf = realloc(obj->sbuf, binsz);
		obj->sbufsz = binsz;
	}
	char* bin = obj->sbuf;
	va_start(ap, fmt);
	vsnprintf(bin, binsz+1, fmt, ap);	// +1 == \0
	va_end(ap);
	//
	se_ins_impl(obj, cur, bin, binsz);
	return binsz;
}

int se_del(se_t* obj, int cur, int dcnt) {
	; STOP(!obj, "NULL obj.");	//削れば10%早くなるけどセグフォで見えないのは嫌
//	; STOP(dcnt<0, "badval, dcnt<0");
	//comp args
	// -+ direction
	if(cur<0){ cur = obj->sz +  cur+1;}
	if(dcnt<0){ cur += dcnt; dcnt= -dcnt; }
	if(cur<0){
		dcnt += cur;
		cur=0;
	}
	if(dcnt<0){dcnt=0; }
	dcnt > obj->sz - cur ? dcnt = obj->sz - cur :0;
	
	//shortcut, head/tail 0
	if(cur+dcnt == obj->sz){ goto lb_RTN; }
	if(cur==0) { obj->ofst += dcnt; obj->p += dcnt;	goto lb_RTN; }

	//centering
	int pflg = 0;
	cur < (obj->sz)/2 ? pflg = 1: (pflg= -1);
	//write
	//head
	if(pflg>0){
		int mvsz = cur;
		memmove(obj->p + mvsz, obj->p, mvsz);
		; obj->ofst += mvsz;
		; obj->p += mvsz;
		goto lb_RTN;
	}
	//tail
	if(pflg<0){
		int mvsz = obj->sz - cur;
		memmove(obj->p + cur, obj->p + cur + dcnt, mvsz);
		goto lb_RTN;
	}
	
lb_RTN:;
	obj->sz -= dcnt;
	obj->p[obj->sz]=0;
	return dcnt;
}

se_t* se_clear(se_t* obj) {
	if(!obj){return obj;}
	; STOP(!obj, "NULL obj.");
	obj->p = obj->p - obj->ofst + obj->msz/2;
	obj->ofst = obj->msz /2;
	obj->sz=0;
	obj->p[0]=0;
	return obj;
}

#ifdef TEST_
HCUT_ADD(t_cmn) {
	int rc=0;
	eq_i(rc, 0);
	se_t* obj = se_new();	// ""
	se_ins(obj, 0, "aaa");		// "foo"
	eq_s("aaa", obj->p);
	eq_i(3, obj->sz);
	//
	se_ins(obj, 1, "bbb");		// "foobar"
	eq_s("abbbaa", obj->p);
	eq_i(6, obj->sz);
	//
	se_ins(obj, 1, "X");
	eq_s("aXbbbaa", obj->p);
	//
	se_ins(obj, 2, "YY");		// "bazfoobar"
	eq_s("aXYYbbbaa", obj->p);
	eq_i(9, obj->sz);
//*
	se_clear(obj);
//
	se_ins(obj, 0, "\0abc", 2);	// "(\0)zbazfoobar"	,use only 2byte
	eq_s("", obj->p);
	eq_i(2, obj->sz);
//
	se_clear(obj);				// ""
	eq_s("", obj->p);
	eq_i(0, obj->sz);

	se_insf(obj, 0, "%#x",17);		// "0x11"	,fmt same as printf()
	eq_s("0x11", obj->p);
	eq_i(4, obj->sz);

	se_del(obj, -1, -1);			// "0x1"	,del tail 1byte
	eq_s("0x1", obj->p);
	eq_i(3, obj->sz);

	se_del(obj, 0, 2);			// "1"		,del head 2byte
	eq_s("1", obj->p);
	eq_i(1, obj->sz);
	se_clear(obj);			
//
	rc = se_ins(obj, 0, "0123456789");
	eq_i(rc, 10, "rtnsz ck");
	rc = se_ins(obj, -1, "0123456789");
	eq_i(rc, 10, "rtnsz ck");
	se_ins(obj, -1, "0123456789");
	se_ins(obj, -1, "0123456789");
	char* ss = "0123456789012345678901234567890123456789";
	eq_s(ss, obj->p);
	
dbg(obj->p, obj->sz, obj->msz, obj->ofst);
	for(int i=0;i<obj->msz;i++){
		printf("%d ", (obj->p - obj->ofst)[i]);
	}
	puts(obj->p);
	puts("");
//	exit(1);

	eq_i(40, obj->sz, "realloc() test");

	se_clear(obj);			
	se_ins(obj, 0, "01234567890123456789");
	se_ins(obj, 0, se_ptr(obj) );
	ss = "0123456789012345678901234567890123456789";
	eq_s(ss, se_ptr(obj), "inner ptr test");
	se_clear(obj);
	//
	eq_i(obj->sz, 0);
	eq_s(obj->p, "", "empty");
	
	se_ins(obj, -1, "01234567890123456789");
	se_insf(obj, 0, "%s", se_ptr(obj) );
	eq_s("0123456789012345678901234567890123456789", se_ptr(obj), "inner ptr test@f");
//--update
	se_clear(obj);
	rc = se_ins(obj, 0, "hello");
	eq_i(rc, 5);
	//
	se_del(obj, -1, -2);
	eq_s(obj->p, "hel");
	//
	se_del(obj, 0, -2);
	eq_s(obj->p, "hel");
	//
	se_del(obj, -2, 3);
	eq_s(obj->p, "he");

	se_free(obj);
	eq_p(obj, NULL);
//*/
}
#endif


#ifdef TEST_
# undef LPN
# define LPN 1*100*1000
//# define LPN 10
HCUT_ADD(t_pp) {
	eq_i(0,0);
	//
	se_t* obj = se_new();
	int i=LPN;
laptime(0);
	while(i-- >0){ se_ins(obj, 0, "abc"); }
laptime("se_ins(abc) lp: " qu(LPN) );
	se_free(obj);
}
#endif


#ifdef TEST_

# undef LPN
# define LPN 1*1000*1000
//# define LPN 10
HCUT_ADD(t_bm1) {
	eq_i(0,0);
	//
	se_t* obj = se_new();
	int i=LPN;
laptime(0);
	while(i-- >0){ se_ins(obj, 0, "abc"); }
laptime("se_ins(abc) lp: " qu(LPN) );
	se_free(obj);
//real	0m0.009s
//user	0m0.006s
//sys	0m0.004s

//real	96.281 ms	: ./stredit.ts.c 23: t_bm1sub(): msg:se_ins(abc) lp: 1*1000*1000
}
#endif

#ifdef TEST_
HCUT_ADD(t_bm2) {
	se_t* obj = se_new();
	int i = LPN;
laptime(0);
	while(i-- >0){ se_insf(obj, 0, "%s", "abc"); }
laptime("se_insf(abc) lp: " qu(LPN) );
	dbg(obj->sz);
	se_free(obj);
//real	0m0.042s
//user	0m0.036s
//sys	0m0.005s

//real	517.152 ms	: ./stredit.ts.c 21: t_bm2sub(): msg:se_insf(abc) lp: 1*1000*1000
}
#endif

#ifdef TEST_
HCUT_ADD(t_bm3) {
	se_t* obj = se_new();
	int i = LPN;
laptime(0);
	while(i-- >0){ se_ins(obj, 0, obj->p, 3); }
laptime("se_ins(abc), malloc() lp: " qu(LPN) );
	se_free(obj);
//real	0m3.541s
//user	0m3.539s
//sys	0m0.000s

//real	107.130 ms	: ./stredit.ts.c 21: t_bm3sub(): msg:se_ins(abc), malloc() lp: 1*1000*1000
}
#endif

#ifdef TEST_
HCUT_ADD(t_bm5) {
/*
	apr_initialize();
	apr_pool_t* mp;
	apr_pool_create(&mp, NULL);

//	se_t* obj = se_new();
	int i=10 * 1000;
	char* p = "";
laptime(0);
	while(i-- >0){ p=apr_psprintf(mp, "%s123",p); }
laptime("apr_psprintf, 1/10");
	dbg(strlen(p) );
	apr_pool_clear(mp);	//再利用する場合
	apr_pool_destroy(mp);	//もういらない場合
	apr_terminate();
//	se_free(obj);

//real	0m1.078s
//user	0m0.840s
//sys	0m0.237s
*/
}
#endif

#ifdef TEST_
HCUT_ADD(t_bm6) {
//	se_t* obj = se_new();
	int i=10 * 1000;
	char* p = "";
laptime(0);
	while(i-- >0){ asprintf(&p, "%s123",p); }
laptime("gnu asprintf(): 10*1000");
	dbg(strlen(p) );
//	se_free(obj);

//real	0m0.373s
//user	0m0.251s
//sys	0m0.122s
}
#endif

#ifdef TEST_
HCUT_ADD(t_bm7) {
//	se_t* obj = se_new();
	char* p = "abc";
laptime(0);
	loop(LPN){ p=strdup(p); }
laptime("strdup(abc) loop" qu(LPN) );
//	se_free(obj);

//real	0m0.018s
//user	0m0.009s
//sys	0m0.009s

//real	118.990 ms	: ./stredit.ts.c 21: t_bm7sub(): msg:strdup(abc) loop1*1000*1000
}
#endif

/*SH_SMP
#include "*SH_bn*.h"
#include <stdio.h>

int main() {
	se_t* obj = se_new();		// ""
	se_ins(obj, "foo");		// "foo"
	char* p = se_ptr(obj);		// get headptr
	puts(p);					// >> 'foo'
	int sz = se_sz(obj);		// >> 3
printf("%d\n", sz);

	se_ins(obj, "bar");		// "foobar"
	se_ins(obj, "baz");		// "bazfoobar"
	se_ins(obj, "\0abc", 2);	// "(\0)zbazfoobar"	,use only 2byte
	sz = se_sz(obj);			//	11,	sz is holding binary size
	se_clear(obj);				// ""
puts(obj->p);
	se_insf(obj,"%#x",17);		// "0x11"	,fmt same as printf()
puts(obj->p);
	se_bs(obj, 1);			// "0x1"	,del tail 1byte
printf("%d\n", obj->sz);	// >> len=3

	se_del(obj,2);			// "1"		,del head 2byte
	puts(obj->p);			// >> "1"
	
	se_free(obj);
	return 0;
}

//SH_SMPE*/

#ifdef TEST

#ifndef VLV
# define VLV	1
#endif /**/
HCUT_RUN("stderr", VLV,  //0,1,2,3: keep nl for brp testcode
	t_0 );
#endif


/*
 change log
 --
2022-07-10 Momi-g	<dmy@dmy.dmy>

	* *SH_bn*.sh.c(stredit.h) : add hpp impl code

2022-06-26  Momi-g	<dmy@dmy.dmy>

	* *SH_bn*.sh.c(se_del) : change minus val, add bs-key, add se_eptr()

2022-06-25  Momi-g	<dmy@dmy.dmy>

	* *SH_bn*.sh.c(init) : fork from stringrow. v1.0.0

*/


/*SH_ED*/

/*SH_OP _ set -e;a=`sed -ne "/${C}DF/!d;:l;n;/${C}DE/q;p;bl"<$R0`;eval "$a";set +e	#*/
/*SH_OP	h $p"-tsbS:test/eg/.o/.so -LMP:leak,mem,prof -f:funcs -o:bldout		GPLv3+"	 #*/
/*SH_OP	f sed -ne "/${C}DF/q;/;/d;/^[a-zA-Z].*)/p"<$R0 #*/
/*SH_OP t $e"$CW";ftt "$@";$p'cc -O0 $dm -Wall -pedantic -Wfatal-errors -g -pg -ggdb3 $Rm `fOI $Rs $tf` `fg $Rh $Rs $tf` `fL`'|fv	#*/
/*SH_OP T $e"$CW";ftt "$@";$p'cc -O3 $dm $Rm `fOI $Rs $tf ` `fg $Rs $tf ` `fL`'|fv	#*/
/*SH_OP s $e"$CW";fgr0 "${C}SMP" "${C}SMPE"<$R0|fbn>eg.c;$p'cc eg.c $bn.c `fg eg.c` `fOI eg.c`'|fv #*/

/*SH_OP L $p"fml $@"|fv #*/
/*SH_OP M $p"fM ./a.out"|fv	 #*/
/*SH_OP P $p'valgrind --tool=callgrind --callgrind-out-file=log.out ./a.out;kcachegrind log.out'|fv	 #*/

/*SH_OP b $e"$CW";$p'cc -c $Rs -pedantic -O2 -Wall -g `fg $Rs` `fI $Rs`'|fv;$p"$bn.o" #*/
/*SH_OP B $e"$Cb";$p"ar -r lib$bn.a $bn.o `fO $Rs`"|fv;$p"lib$bn.a"	#*/
/*SH_OP A $e"$CB";$p'fA lib$bn.a `fg $Rh $Rs|fu|grep '[.]a$'|fU`'|fv;$p"lib$bn.a" #*/
/*SH_OP S $e"$CW";$p"cc -shared -fPIC -o lib$bn.so $bn.c `fOI $Rs` `fg $Rs`"|fv;$p"lib$bn.so" #*/
/*SH_OP W $e"$Cm$O$Cw">/dev/null;fborn;$p"$Rs $Rh $tf"	#*/
/*SH_OP o $e"$CW";$p'fman $Rh 3'|fv		#*/

/*SH_OP y cp $Rs $bn.cbrt;$p"cbrt $bn.cbrt --c $Rs --h cbft.h"|fv	#*/
/*SH_OP Y $e"$Cm$O$Cw">/dev/null;$e"$Cy";fborn;$p"$Rs $Rh $tf"		#*/

/*SH_DF
#-- noob
fman()( $p"cat $1|sed -e '/${C}docE/q'|fgr0 '${C}doc' '${C}docE'|amn >$bn.$2
 mandoc -Thtml <$bn.$2 >$bn.$2.html
 man -Tutf8 /dev/stdin<$bn.$2|sed -e 's/.`printf \"\\b\"`//g'>$bn.$2.txt
 "|fv
)

#-- local

#-- vars
bn=`basename ${Rs%.*}`; tf=${Rs%/*}/${bn}.ts.${Rs##*.}; e="eval "; p="$Rp"
#-- mod
fv()(while read -r a;do $e"cat<<E$O# $a${O}E"|sed -e 's@-L.*-L[^ ]*@-L(omit)@g'>/dev/stderr;$e"$a";done)

fbn()(sed -e "s@\*${C##*]}bn\*@$bn@g"|frf|frv|flit)
fsn()(tr -s ' \t' '\n')
fsl()(tr -s '\n' ' ')
fu()(fsn|sort -u)
fU()(fu|fsl;$p)

fgr()(sed -e "/$1/!d;:l;/$2/{p;d};n;bl")	#切出
fgr0()(sed -ne "/$1/!d;:l;n;/$2/d;p;bl")	#抜き切出
fgR()(sed -ne "/$1/bl;p;d;:l;n;/$2/d;bl")	#切すて
fg()($e\$p`sed -ne "s/.*${C##*]}co\*\([^*]*\).*$/\1/p" "$@"`|fsn|awk '!a[$0]{a[$0]=1;print}'|fsl)

# fO src.o from inc"src.abc" etc. kick self
fO()(set -- `fdp "$@"|awk '$0~/[.](h|hpp)$/{print}'|sed -e 's/[.][^.]*$/.c/'|fU`
 buf="";for i;do test -f $i&&buf="$buf $i";done;$p"$buf"
)
fI()(fdp "$@"|sed -e 's/[^/]*$//g'|fu|sed -e '/./s/^/ -I/g'|fu|grep -v '^\-I$'|fU)
fL()(find -L `dirname $R0` -type d|sed -e 's/^/-L/g'|fU)
 # inc""系.h,hpp,oをパス付きで羅列 OIはfdpが重複するので高速化でまとめる 複数file_ok
fOI()(
 set -- `fdp "$@"`
 s="-I./ "`$p"$@"|sed -e 's/[^/]*$//g'|fu|sed -e 's/^/ -I/g'|fu|grep -v '^\-I$'|fU`
 set -- `$p"$@"|awk '$0~/[.](h|hpp)$/{print}'|sed -e 's/[.][^.]*$/.c/'|fU`
 buf="";for i;do test -f $i&&buf="$buf $i";done;
 $p"$buf $s"
)

# 依存inc""を再帰的に取得./以下全て self系はkick
fdp()( l="$*"; paths="$@"; all=""; used=""
 while :;do
  all=`$p$all $paths|fU`	#差分を追加 repの始末 差分たちからaaa.hを取得 partial path
  buf=`(cat $paths|sed -ne 's@^[ \t]*#inc[^"]*.\([a-zA-Z0-9._]*\)".*@\1@p')|sort -u`
  ch=`$p$used $buf|tr -s ' ' '\n'|sort|uniq -u`	#使用済は外す
  used="$used $ch"	#リスト更新
  paths=`fsvy $ch|sort -u`	#ls検索 name系のみのはず
  buf=`$p"$all" "$paths"|fU`	#増えたらloop
  [ ${#all} = ${#buf} ]&&break
 done
# initを除く
 set -- $all
 for i;do a=${i##*[/]}; a=${a%%.*};[ "${l##*$a*}" = "$l" ]&&set -- "$@" $i;shift;done
 $p"$@"
)

# corecode:search + depthck + uniq
fsvy()(c="find -L ./ -false"
 for i; do c="$c -o -path '*'$i";done; l=`$e"$c"`
 for i; do $p"$l"|grep -F "$i"|awk '{sv=$0;print gsub("[/]","") " " sv}'|
 sort -k 1.1,1n -k 2.2,2|awk '{print $2;exit}'; done
)

# libをまとめる
fA()(n=0;dir=`dirname $0`/tmpdir;mkdir $dir;cd $dir;
 for i;do
 	n=$((n+1))
 	cp ../$i $i
 	ar -x $i
 	for ii in *.o;do mv "$ii" "p${n}_$ii";done
 	ar -r lib$bn.aa *.o
 	rm *.o
 done
 $p'mv lib$bn.aa ../lib$bn.a'|fv
 cd ..;rm -r $dir
)

#-- yacc
fy(){
 set -e
 cat<<'EEE'|fv
 fgr0 "${C}YACC" "${C}YACCE"<$Rs|fbn>myyacc.y
 fgr0 "${C}LEX" "${C}LEXE"<$Rs|fbn>mylex.l
 fgR "${C}YACC" "${C}YACCE"<$Rs>$Rm
 fgR "${C}LEX" "${C}LEXE"<$Rm>$Rs

 lex mylex.l
 #bison -Wnone -Wall -Wno-empty-rule -p zz -dv myyacc.y
 # bisonはy.tab.c固定名ではなくsrc.tab.c/hを吐く 標準に戻す
 bison -Wnone -Wall -Wno-empty-rule -dv myyacc.y --defines=y.tab.h -o y.tab.c

 cat $Rh y.tab.c lex.yy.c > $Rs
 $p"$Rs"
EEE
}

#-- longcmd
frf()(
 # *sh_rf* 0 a.txt b.txt ...でcat纏めて出力 top0でsrcinfoは無し出力
 awk -v tg="${C##*]}rf" 'index($0,tg){
 s=substr($0, index($0,tg)+length(tg)+1);split(s, a)
 m="[ -f \"%s\" ]&&(echo \"/*--copyfrom %s*\"/;cat \"%s\";echo \"/*--copyend %s*\"/)"
 mm="[ -f \"%s\" ]&&(_=\"%s\"/;cat \"%s\";_=\"%s\")"
 for(i=1;i in a;i++){v=a[i];if(v==0){m=mm;continue};system(sprintf(m,v,v,v,v)) }
 next
 }
 {print}'
)
frv()(buf=`awk '$1=="@_ver" {print $3;exit}'<$R0`;sed -e "s@\*${C##*]}ver\*@$buf@g")
flit()(sed -ne "/${C##*]}lit/b l;p;d;:l;n;/${C##*]}litE/d;"'s/[\]/&&/g;s/"/\\"/g;s@.*@"&\\n"@g;p;b l')

fml()(
 # --show-leak-kinds=definite,indirect(inner ref),possible,reachable(doesnt p=NULL)
 #cmd="valgrind --leak-check=full --show-leak-kinds=all --track-origins=yes --verbose ./a.out 2>&1|sed -e '/SUMMA/!d;n;n;n;n'"
 cmd="valgrind --leak-check=full --show-leak-kinds=definite,possible --track-origins=no --verbose ./a.out 2>&1|sed -e '/SUMMA/!d;n;n;n;n'"
 test $# = 0 && $p"$cmd"|fv && return
 set -- " " "$@"
 $e"$Ct"
 test $? = 0 && $p"$cmd"|fv
)

ftm(){
 awk -v w="$1" '
 /^HCUT_ADD/ && index($0,"("w")")==0 {
	while(match($0,"^#endif$") ==0 ){getline}
	print $0; next
 }
 {print $0}'
}

fte()(
 cat > $Rm-
 cmd="cat"
 [ $# != 0 ] && cmd='ftm $b'
 a="`sed -ne 's@^HCUT_ADD(\([^)]*\).*@\1, @p' $Rm-|tr -d '\n'`NULL"
 if [ $# != 0 ];then	a=""; for i;do a="$a $i,";done; a="$a NULL"; fi
 b=`$p"$a"|tr ',' ' '`
 sed -ne "p;/_RUN/b l;d;:l;/[)]/{c \\$O $a)$O p;d};n;b l" $Rm-|$e"$cmd"|
 fgr0 "^#ifdef TEST" '^#endif$'
 rm $Rm-
)

ftt(){
 [ $# != 0 ] && [ "${1#[0123]}" = "" ]&&dm="-DVLV=$1"&&shift
 (cat $Rs;fte "$@"<$tf)>$Rm
}
fborn(){
 fgr "^#ifdef TEST" "^#endif$"<$R0|fbn>$tf
 fgR "^#ifdef TEST_" "^#endif$"<$tf |fte>tests.code
 fgR "^#ifdef TEST" "^#endif$"<$Rs|fbn>$Rm;mv $Rm $Rs;fbn<$Rh>$Rm;mv $Rm $Rh
}
fM()(
 valgrind -q --tool=massif --massif-out-file=./vmem.buf --stacks=yes --trace-children=yes $1>/dev/null
 ms_print ./vmem.buf|sed -ne '/[KMG]B/bl;d;:l;/snap/q;p;n;bl';rm ./vmem.buf
)

/*SH_DE*/
