#include <emsg: see ... '~$ sh aaa.sh.c -h'   (other opt:no/-m/-w/)>	/*
C='^[/][/*]SH_'		;O=${0##*[/]};R=`dirname $0`/;R0=$R$O;Re=eval\ ;R=$R${O%%.*}
O=${0##*.};Rs=$R.$O;Rm=$R.tmp.$O;Rh=$R.h;R=$Rs$Rh$Rm;Rp='printf %s\n ';Rc=:;O="
";[ "${R##*$R0*}" = '' ]&&$Rp"$0:NGext"&&exit 1;R='sed -ne ';Cm=$R'"/[E]ND/!d;:l
n;p;b l"<$R0>$Rm;$Rp"$Rm"';Rw=$R'"/$C$R/!d;:l;n;/${C}ED/q;p;b l"<$R0';Cw="(R=LS
$Rw;$Rw>&3;R=HD;$Rw;R=SC;$Rw>&3)"'>$Rh 3>$Rs;$Rp"$Rh $Rs"';RB=$($R"s/${C}OP//p"\
<$R0|(F=mw;while read -r a b;do B=${a%:};F=`$Rp"$F"|$R"s#$B:*##;p"`${a%_};$Rp"
C$B=\$(cat<<'E'$O$b${O}E$O)";done;$Rp"R1=$F"));$Re"$RB";while getopts $R1 R;do
case $R in \?)exit 1;;* )$Re"O$R=\$OPTARG";Rc=$Rc$O`$Re'$Rp"$C'$R\"`;;esac;done
[ "$Rc" = : ]&&Rc=$Cm;shift $((OPTIND-1));$Re"$C_$O$Rc";exit #END  GPLv3+ */

/*SH_LS*/
/* Copyright (C) 2022 Momi-g

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 3 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program. If not, see <http://www.gnu.org/licenses/>.
*/

/*SH_doc
title=*SH_bn* section=3 repnl=\040
@name *SH_bn*
@_brief toml-like data format and parser
@_syno
 typedef struct twl_tag {
 	int rc;
 	char* emsg;
 	double cnt;
 	//..opaque data
 } twl_t;
 
 typedef struct twlval_tag {
 	const char* k;	//key
 	const char* t;	//3 types, "n"um/"s"tr/"d"ate
 	double n;		//num val
 	const char* s;	//str val
 	const char* date;	//date tostr: rfc3339 format
 	double y,m,d,hh,mm,ss,z,zh,zm; //date: z==zone 0/1
 } twl_vt;
 
 //--read twl format file/str
 twl_t* twl_new();
 int twl_pushfile(twl_t* obj, const char* flname);
 int twl_pushstr(twl_t* obj, const char* s [, int ssz] );
 twl_t* twl_clear(twl_t* obj);
 void* twl_free(twl_t* obj);
 int twl_dbgout(twl_t* obj, FILE* dbgfp);

 //--getter
 twl_vt twl_get(twl_t* obj, const char* id);
 twl_foreach(const char* key, twl_vt val, twl_t* obj){..}	//macro
@tl_dr
		@(code)--@
 #include "twl.h"

 int main(int argc, char** argv){
     twl_t* obj = twl_new();
     twl_pushstr(obj, "[hw] \n twl = 10.1");
     twl_pushstr(obj, NULL);	//EOF
     
     twl_vt val = twl_get(obj, "hw.twl");
     printf("%s, %f\n", val.k, val.n);
     twl_free(obj);
     return 0;
 }
 //~$ cc hw.c lib*SH_bn*.a -Wall -pedantic -std=c99 -D_POSIX_C_SOURCE=200112
 //see EXSAMPLE for more detail code
	@()--
 
@params
	@(list)
	flname: (char*) read file if set. "stdin" reads FILE* stdin
	obj: (twl_t*) core obj. holds parser, hash map etc
	s: (char*) send str/bin to twl push-parser. send EOF if set NULL
	ssz: (int) send str/bin size if set. use strlen(s) if noset/-1
	id: (char*) keyname for search
	key:(char*) twl_foreach() ID for liner search
	val:(twl_vt) twl_foreach() ID holding data
	dbgfp: (FILE*) fp for output dbginfo. noout if set NULL(==dfl)
	@()
@return
	@(list)
	obj: twl_new() rtns core. rtn NULL if failed. obj->cnt holds keycnt.
	rc : twl_pushfile() rtns int 0/rc<0 --
		twl_pushstr() rtns int 0/1/rc<0 == complete/morestr/err --
		err == ERR_TKN / ERR_STX / ERR_INN and emsg is 'obj->emsg'.
		'obj->rc' holds the same int.
	val: all data is double/char*. all data is init with 0/"". --
		never fails *val.t =='n', puts(val.date) etc  --
		--
		val.k @: char*, ID/keyname, "aa.bb.c" etc --
		val.t @: char*, valtype. "n/s/d" or "", num/str/date --
		--
		val.n @: dbl, val.t=="n"  data.  0.11,  12.00 etc --
		val.s @: char*, val.t=="s" data. "hw" etc --
		val.date @: char*, val.t=="d" tostr data. follows rfc3339 --
		--
		val.ssz@: dbl, val.s size. val.s can holds binary, \0 etc. --
		val.y/m/d/hh/mm/ss/z/zh/zm@: dbl, 'z'one is 0/1 == noset/set --
	@()

@error
	twl_pushfile/str() may rtns rc<0.
	@(code)--@
	ERR_TKN: lex err
	ERR_STX: yacc err
	ERR_INN: other inner err
	@()--@
	'obj->emsg' may holding detail msgstr. --
	exit() if fatal err.

@_desc
	twl is alt-toml data format. omit unnecessary syntax from toml.
	the differences is the below. see NOTES for details:
		@(code)--@
	- no nest with rval: deep nest causes troubles.
	- lowercase ID only: ok: ab.xy=100  NG: Ab.xy=100
	- no quote lval    : ID is no quoting alnum+[._] as c-lang
	- no table array   : silver bullet for javascript specific
	- add mulitline cmt: #*..*# etc
	- add parallel set : a,b = 10,20 >> a=10; b=10
		@()--@
	twl format target is:
		@(code)--@
	- non-programmer can use with low learning cost
	- a few syntax rule
	- pay cost if you need to send complex data (or fix data structure)
	- respect to: ini, shell, c-lang, utf8
	- avoid to  : XML, XSLT, python, c++, lisp, markdown
		@()--@
	
	see samples for twl data read api fundtions. input data is saved to hashtb.
	all value is 'const char* / double' except rc, obj->rc (int).
	char* data is init with blank str "", so never fails to put(val.s) etc.
@_eg
	@(code)--@
 //--data.twl
 # cmtline
 [ab]
 a=10	#ab.a=10
 [aa.bb]
 b="hw"	#aa.bb.b="hw"

 //--src.c
 #include "twl.h"
 
 int main(int argc, char** argv){
 	int rc=0;
 	twl_t* obj;
 	twl_vt val;

 	// read from file
 	if(0){
 	obj = twl_new();
 	; rc = twl_dbgout(obj, stderr);  //dispinfo. rc<0 >> badfp+nochange
 	rc = twl_pushfile(obj, "data.twl");	//suc/fail == 0/rc<0
 	; rc = twl_dbgout(obj, NULL);	// noout(==dfl)
 	val = twl_get(obj, "aa.bb.b");
 	; if( *val.t == 0 ){ puts("bad key"); return 1; }
 	printf("%s, %s, %f\n", val.k, val.s, obj->cnt); //key,val,cntkey
 	twl_free(obj);
 	}

 	//read using push-style parsing
 	obj = twl_new();
 	const char* s = "[ab]\n a = 10 ; d = 2000-01-01";
 	rc = twl_pushstr(obj, s);	//rc=1/0 (more/complete) err<0
 	// (obj,s, -1) >> use -1 == strlen(s) if ag3 isnt
 	; if(rc<0){ puts(obj->emsg); return rc; }
 	rc = twl_pushstr(obj, NULL);	//NULL >> send EOF
 
 	val = twl_get(obj, "ab.a");
 	printf("%s, %f\n", val.t, val.n);	// "n", 10.0
 	
 	twl_foreach(k, v, obj){
 		puts(k);	//== v.k, char* key/id, "ab.a" etc
 		if( strcmp(v.t, "n")==0 ){ printf("num: %f\n", v.n); }
 		if( *v.t == 's' ){ printf("str : %s\n", v.s); }
 		if( *v.t == 'd' ){ printf("date: %s\n", v.date); }
 	}
 	obj = twl_clear(obj); //read other file/str if needs
 	printf("%f\n", obj->cnt);	//==0, obj->cnt == holding keycnt
 	
 	twl_free(obj);
 	return 0;
 }
 //$ cc src.c lib*SH_bn*.a -Wall -pedantic -std=c99 -D_POSIX_C_SOURCE=200112
		@()--

@notes
		@(code)--@
	---bench mark: 
	code: a[n]=num / twl_pushstr(obj, "key=10 ") etc
	
	set : 8.3ms <<<< 8842ms
	FAST: a[n] (1) <<<< twl_set (1000) :SLOW
	
	get : 14.4ms << 216.8ms 
	FAST: a[n] (1)  <<  twl_get (15)   :SLOW

	-O0
	real	332.267 ms  : ./twl.tmp.c 4674: msg:sprintf() ovh 1000*1000
	real	341.507 ms  : ./twl.tmp.c 4686: msg:a[n] set 1000*1000
	real	14.469 ms   : ./twl.tmp.c 4693: msg:a[n] get 1000*1000
	real	14608.907 ms: ./twl.tmp.c 4702: msg:twl_set 1000*1000
	real	449.135 ms  : ./twl.tmp.c 4712: msg:twl_get 1000*1000
	-O3
	real	356.416 ms  : ./twl.tmp.c 4674: msg:sprintf() ovh 1000*1000
	real	341.656 ms  : ./twl.tmp.c 4686: msg:a[n] set 1000*1000
	real	0.001 ms    : ./twl.tmp.c 4693: msg:a[n] get 1000*1000
	real	8842.322 ms : ./twl.tmp.c 4702: msg:twl_set 1000*1000
	real	216.870 ms  : ./twl.tmp.c 4712: msg:twl_get 1000*1000
	--- 
		@()--@
	@(code)--@
	--- twl syntax info
	//SH_rf* 0 syntax.twl *
	@()--@
@conforming_to POSIX.1-2001+ (-D_POSIX_C_SOURCE=200112L etc)
@COPYRIGHT Copyright 2022 momi-g, GPLv3+
@_ver 2022-07-12 v1.0.2 (2022-06-13 v1.0.0)
@_see https://en.wikipedia.org/wiki/Configuration_file
//SH_docE*/

/*SH_ED*/

/*SH_HD*/
#ifndef *SH_bn*_61a25e678cdd
#define *SH_bn*_61a25e678cdd

#include <features.h> 	//SH_co* -D_XOPEN_SOURCE=600 -std=c99 */
#if ( _POSIX_C_SOURCE +0 < 200112L )
	#include "stop cc: needs compiler posix-2001 or upper(c99+)"
#endif

#include <stdio.h>
#include <string.h>
#include "hfl.h"	//SH_rf*	hfl.h	 */

#define TWL_VER "v1.0.0"
#define TWL_MGCMT "#_twl:"
enum {
	  ERR_TKN = -1
	, ERR_STX = -2
	, ERR_INN = -3
};

typedef struct twl_tag{
	int rc;
	char* emsg;
	double cnt;
	hfl_t* hdb;
	void* pvm;

//sv_state
	FILE* svpf;
	int igtab;
	int line;	//hdoc memo
	int clm;
	int tdx;
	int tdxsz;
//
	char* lb;
	int svcnt;
	int ldcnt;
//lexbuff
	void* sepp;
	char* lex0;
	char* lex1;
//yaccbuff
	void* sehd;
	void* setmp;
	void* seyc;
} twl_t;

#define twl_new(...)	twl_new_impl(__VA_ARGS__ +0)
twl_t* twl_new_impl(const char* flname);

#define twl_pushfile(obj, name) twl_pushfile_impl(obj, name)
int twl_pushfile_impl(twl_t* obj, const char* s);

#define twl_pushstr(obj, ...)	twl_pushstr_impl(obj,  __VA_ARGS__, -1)
int twl_pushstr_impl(twl_t* obj, const char* s, int ssz, ...);

twl_t* twl_clear(twl_t* obj);
void* twl_free(twl_t* obj);
int twl_dbgout(twl_t* obj, FILE* fp);

//getter
typedef struct twlval_tag {
	const char* k;
	const char* t;
	double n;
	const char* s;
	double ssz;
	const char* date;	//date rfc3339 format str
	double y,m,d,hh,mm,ss,z,zh,zm; //date: z==zone 0/1
} twl_vt;

twl_vt twl_get(twl_t* obj, const char* key);

#undef twl_foreach
#define twl_foreach(k, v, obj)	for(hfl_nt* twl_nd=obj->hdb->enode->pre, *hfl_p_; \
	 hfl_p_=twl_nd->pre, twl_nd != obj->hdb->enode; twl_nd=hfl_p_ ) \
	for(twl_vt v={0}; strncmp(twl_nd->key, "t=",2)==0 && v.t==NULL && (v=twl_get(obj, twl_nd->key+2), 1);) \
	for(const char* k = twl_nd->key+2; k; k=NULL)
/*
#define hfl_foreach(node, obj)	for(hfl_nt* (node)=obj->enode->pre, *hfl_p_; \
	hfl_p_=(node)->pre, (node) != obj->enode; (node)=hfl_p_ )
*/

#define twl_set_i(obj,k,v)		hfl_set_i(obj->hdb, k, v)
#define twl_set_d(obj,k,v)		hfl_set_d(obj->hdb, k, v)
#define twl_set_p(obj,k,v)		hfl_set_p(obj->hdb, k, v)
#define twl_set_s(obj,k,v)		hfl_set_s(obj->hdb, k, v)
#define twl_unset(obj, k)		hfl_unset(obj->hdb, k)

#endif /* inc_guard: *SH_bn* */
/*SH_ED*/


/*SH_SC*/
/*SH_CBRT*/
#ifndef ERRact
#include <stdio.h>
 #if (199901L <= __STDC_VERSION__ +0)	/* nealy 200112L, _POSIX_C_SOURCE	c99*/
	#include <sys/types.h>
	#include <unistd.h>
	#define ERRactag	__func__, getpid()
 #else
	#define ERRactag	"func:c99+", 0
 #endif
 #include <string.h>
 #include <errno.h>
 #define ERRact(xpr, msg, act)	if(xpr){ int en_=errno; fprintf(stderr, \
	"ERR: %s %d %s() pid:%d %s msg:%s sys:%s\n",__FILE__,__LINE__, ERRactag \
	, "hit(" #xpr ")", msg, strerror(en_) ); act; }
 #define STOP(xpr, msg)	ERRact(xpr, msg, fputs("STOP\n",stderr);exit(1) )
#endif
#define loop(a)		for(int lpcnt=1;lpcnt<=a;lpcnt++)

#include <stdio.h>
#include <stdlib.h>
#include "*SH_bn*.h"
# include "stredit.h"	/*SH_co*	-D_IMPL_stredit	 */
# include "clit.h"		/*SH_co*	-D_IMPL_clit	 */
# include "hfl.h"		/*SH_co*	-D_IMPL_hfl		 */
# include "msgp.h"		/*SH_co*	-D_IMPL_msgp	 */

#ifdef TEST
	#include <assert.h>
	#include "*SH_bn*.h"
	#include "hcut.h"
	# include "msgp.h"
	# include "laptime.h"	/*SH_co* -D_IMPL_laptime	*/
	#define qu(...)		Qsub(__VA_ARGS__)
	#define Qsub(...)	#__VA_ARGS__

	#ifndef loop
	# define loop(a)		for(int lpcnt=1;lpcnt<=a;lpcnt++)
	#endif
#endif

#ifdef TEST
HCUT_ADD(t_0) {
	eq_i(1, 1);
}
#endif

/*pre-code---*/
//typedef struct pos_tag { int l, c; } pos_t;

typedef double dbl;
typedef struct td_tag {
	int l;
	int c;
	//
	se_t* se;
	int idx;
	int ssz;
	int tp;
	//
	dbl y;
	dbl m;
	dbl d;
	dbl hh;
	dbl mm;
	dbl ss;
	dbl z;
	dbl zh;
	dbl zm;
} td_t;
//token data

// major, minor, revision
typedef struct ver_tag{
	int rc;
	int m;
	int n;
	int r;
} ver_t;

static int ck_magic(twl_t* obj, const char* cmt);
int twl_dbgout(twl_t* obj, FILE* fp){
	int rc=0;
	MSGP_t yo = pfset(PF_NOCHANGE, PF_NOCHANGE, PF_NOCHANGE, fp);
	yo.rc ? rc = -1: 0;
	return rc;
}

// sync to %prefix YY_: YP(a) >> YY_a,  YP(_,a) >> _YY_a
#define PFIX YY_
#define YP(...) YP1(PFIX, __VA_ARGS__, __VA_ARGS__, , )
#define YP1(z,a,b,c, ...) YP2(c,z,b)
#define YP2(a,m,b) a ## m ## b

/*lex---*/
%scanner%

//general
%prefix YY_
%common_type td_t
%constructor $ = (td_t){0};

//
%mode HDOC_S HDOC_P HDOC_E
//..and 'default'

//--start rule
//skip
: #\*([^\*]|[\r\n]|(\*+([^\*#]|[\r\n])))*\*# {
	sbg($text, "mcmt#");
}

: /\*([^\*]|[\r\n]|(\*+([^\*/]|[\r\n])))*\*/ {
	sbg($text, "mcmt/");
}

: [/][/][^\n]*[\n] {
	sbg($text, "lcmt/");
}


: #[^\n]*[\n] {
	sbg($text, "lcmt#");
	int rc = ck_magic(obj, $text);
	if(rc){return rc;}	//err
};

: ([\ \t\n\;]|[\r\n])+	;

//HDOC, litより先に始末しないとダメ
<HDOC_E> HDOC: \n|\r\n {
	//cbrtはmodeがigだと$chmを使っても無視されるロジックなので
	//専用tokenからタグ付きで送らないとダメ
sbg("HDOC_E");
	//hdocからyaccに詰め直し
	se_t* se = obj->sehd;
	$.l = obj->line;
	$.c = obj->clm;
	char* p = se_ptr(se);
	int sz = se_sz(se);
sbg(p, "hdptr");
	se = obj->seyc;
	$.se = se;
	$.idx = se_sz(se);
	se_ins(obj->seyc, -1, p, -2);
	$.ssz = sz;
sbg($.se->p + $.idx, ":repack sehd >> seyc");
	$set_mode(DEFAULT);
sbg("rtn2DFL");
}


: (""\042+|''\047+)[\-]?[a-z_][a-z0-9_]*(\.[a-z_][a-z0-9_]*)* {
sbg($text, "hdoc_head");
	se_t* se = obj->sehd;
	se_clear(se);
	char* p = $text;
	while(*p=='"'||*p=='\''){p++;}
	p--;
	se_ins(se, 0, p, -2);
	$set_mode(HDOC_S);
	obj->igtab=0;
	if( *(p+1) == '-'){obj->igtab = 1;}
	obj->line = $line;
	obj->clm = $column;
}
//skip until \n
<HDOC_S>: .*(\n|\r\n) { $set_mode(HDOC_P); }
<HDOC_P>: \n|\r\n { se_ins(obj->sehd, -1, $text); }
<HDOC_P>: .* {
	se_t* se = obj->sehd;
	int eflg =0;
	char* bp = se->p;
	char* p = se->p+1;
	*p == '-' ? p++ :0;
	char* np = bp+strlen(bp);
	
	//hdoc end id
	if(strncmp(p, $text, np-p) == 0){ eflg=1;}
	if(eflg){
sbg($text, "hdoc_ehit?");
		// ""''skip
		while(*np=='"'||*np=='\''){np++;}
idbg(*np, "hdocend_ck non-blank(nl)== token end == 0");
		if(*np!=0){ break; }	//. isnt nl
		//hit end
		eflg=2;
		char cs[] = "'";
		cs[0]=se->p[0];
idbg(cs[0], "ck slit/dlit");
		int sz = strlen(se->p);	//headerに\0を追加してる endのstrcmp()のため
idbg(se->p, sz, "ck head");
sbg(se->p);
		se_del(se, 0, sz+1);		//\0も併せて削除
		se_del(se, -1, -1);			//del end \n, \r\n, 
		if( se_eptr(se)[0] == '\r'){ se_del(se, -1, -1); }
sbg(se->p, "trim");
		//add "" ''
		se_ins(se, 0, cs);
		se_ins(se, -1, cs);
sbg(se->p, "add qu");
		//
		$set_mode(HDOC_E);
idbg(obj->line, obj->clm, p,sz,"hdoc lexend");
sbg(p);
		// return; //dont use return
	}
	if(eflg!=2){
		//not end. skip leading tab
		char* p = $text;
		if(obj->igtab){	while(*p=='\t'){ p++; }	}
		se_ins(se, -1, p);
	}
}

AS: [=]	{;}
CM: [\,] {;}

<DEFAULT> $: {
	//pre-act 
	$ = (td_t){0};
	$.l = $line;
	$.c = $column;
	se_t* se = obj->seyc;
	$.se = se;
	$.idx = se_sz(se);
	se_ins(se, -1, $text, -2);
	$.ssz = (int)$len;
idbg("lex token", $text, $line, $column, (int)$len );
sbg($text);

}

//--misc
// esc: {}[](),.^$*|?+:;-\'"

LB: \[[\ \t]*([a-z_][a-z0-9_]*)(\.[a-z_][a-z0-9_]*)*[\ \t]*\]	{;}
LB: \[[\ \t]*\]		{;}


//---lval
ID: ([a-z_][a-z0-9_]*)(\.[a-z_][a-z0-9_]*)*	{;}
 
//rval----
//timeが
//date
DATET: [\-+]?[0-9][0-9][0-9][0-9]+\-[0-1][0-9]\-[0-3][0-9][T\ ][0-2][0-9]\:[0-6][0-9]\:[0-6][0-9](\.[0-9]+)?	{;}
DATEZ: [Z] | [\-\+][0-2][0-9]\:[0-6][0-9] {;}
DATE: [\-+]?[0-9][0-9][0-9][0-9]+\-[0-1][0-9]\-[0-3][0-9]	{;}
TIME: [0-2][0-9]\:[0-6][0-9]\:[0-6][0-9](\.[0-9]+)?	{;}
/*
odt1 = 1979-05-27T07:32:00Z
odt2 = 1979-05-27T00:32:00-07:00
odt3 = 1979-05-27T00:32:00.999999-07:00
odt4 = 1979-05-27 07:32:00.1234+09:00
*/

//num
NUM: [\-+\.0-9][_xXoO0-9a-fA-F\.lL]* {;}	//strtod(s,&p,10)で変換。_は無視

//str
DLIT: "([^\"]|\n|\r\n|\\.)*" {;}	// \"は有効
SLIT: '([^\047]|\n|\r\n)*' {;}	// \'は無効

<DEFAULT> $: {;}

//rest
//BAD_TOKEN: . {;}

//set terminal type
//%token ID OP_AS NUM_I SEP	//%type ID OP_AS NUM_I SET: char*
%token AS CM  LB  ID  NUM DLIT SLIT HDOC DATE DATET DATEZ TIME BAD_TOKEN
%token_type char*	//apply 'term' token not decled types
//%constructor target: near %type, %token_type, %common_type
%constructor	$$ = 0;


/*yacc*/
%grammar%

%nt stmt expr ass ass_ lv rv dval date_ datet_ datez_ time_
//term,non-term define all token hold types 

//%type stmt expr mas sep rv dval date_ datet_ datez_ time_ mlv mid: td_t
// use %commontype for datapass

	//last type ins 'int'... all int $$ is set to 0
%params		twl_t* obj
	//external dataptr

%%

static int err_l2g(int ec);
static ver_t parse_ver(const char* cmt);
static int try_ver(const char* cmt);
static int seterr(twl_t* obj, const char* emsg, int errcode);

#include <strings.h>
static 
ver_t parse_ver(const char* cmt){
sbg(cmt);
	const char* s = cmt;
	ver_t res = {0};
	; if(0){ lb_RTN:;
idbg(res.rc, "verck end, suc:res==1");
		return res;
	}
	//
	int sz = 0;
	strncasecmp(s, "v", 1)==0 ? sz=1 :0;
	strncasecmp(s, "ver", 3)==0 ? sz=3 :0;
	if(sz==0){	goto lb_RTN; }
	s+=sz;
sbg(s, "num pos");
	for(int i=0;i<3;i++){
		char* rp = NULL;
		int n = strtol(s, &rp, 10);
idbg(i, n, s, rp, "idx, convnum, src, ep");
		if(s==rp){ goto lb_RTN; }
		i==0 ? res.m = n :0;
		i==1 ? res.n = n :0;
		i==2 ? res.r = n :0;
		//
		if(i==0){res.rc = -1;}	//set syx err
//		if(i==2 && *rp!=0){ goto lb_RTN;}
		if(i<2  && *rp!='.'){ goto lb_RTN; }
		s=rp;
		s++;
	}
	res.rc = 1;
	goto lb_RTN;
	//unreachable code
	return res;
}

static
int try_ver(const char* cmt){
sbg(cmt, TWL_VER, ":ver ck, req / TWL_VER");
	//rc 0/1 <0 == not ver/suc/err
	ver_t cver = parse_ver(TWL_VER);
	ver_t fver = parse_ver(cmt);
idbg(fver.rc, fver.m, fver.n, fver.r, cver.m, cver.n, cver.r, "cmp");
	if(fver.rc==0){ return 0; }
	if(fver.rc<0){ return ERR_TKN; }
	// cmp ver
	if(cver.m > fver.m){ return 1; }
	if(cver.m < fver.m){ return ERR_STX; }
	//
	if(cver.n > fver.n){ return 1; }
	if(cver.n < fver.n){ return ERR_STX; }
	//
	if(cver.r >=fver.r){ return 1; }
	if(cver.r < fver.r){ return ERR_STX; }
	//unreachable
	; STOP(1, "fatal err");
	return 0;
}

static
int ck_magic(twl_t* obj, const char* cmt){
	const char* s = cmt;
	int rc =0;
	const char* emsg = NULL;
	; if(0){ lb_RTN:;
idbg(rc, "magic rtn, rc==0 == suc");
		if(rc==0){return rc;}
		seterr(obj, emsg, rc);
		return err_l2g(rc);
	}
	//
	rc = strncmp(s, TWL_MGCMT, strlen(TWL_MGCMT) );
idbg(rc, TWL_MGCMT);
sbg(TWL_MGCMT);
	if(rc){ rc=0; goto lb_RTN; }	//normal cmt
sbg("hit magic");
	//hit #_twl:...
	int cnt=0;
	s += strlen(TWL_MGCMT);
	
	//--test magic list: rc==0 >> delective nohit
	rc = try_ver(s);
	if(rc>0){ cnt++; }
idbg(rc, "magic rc, err == rc<0");
	if(rc==ERR_TKN){
		emsg = "magic cmt token is invalid, 'v1.0.0' etc";
		goto lb_RTN;
	}
	if(rc==ERR_STX){
		emsg = "twl reader " TWL_VER " is oloder than req ver";
		goto lb_RTN;
	}

/*	//
	rc = try_pragma(s);
	if(rc>0){ cnt++; }
	if(rc<0){ goto lb_RTN; }
	//
	rc = try_option(s);
	if(rc>0){ cnt++; }
	if(rc<0){ goto lb_RTN; }
*/	
	//if any magic isnt work
idbg(cnt, "cnt==0 magic but not support");
	if(cnt==0){ rc = ERR_TKN; }
	rc=0;
	goto lb_RTN;
	//unreachable
	; STOP(1, "fatal err");
	return 0;	
}

static
char* twl_makekey(twl_t* obj, const char* k, const char* fix){
	se_t* se = obj->setmp;
	se_clear(se);
//dbg(obj->lb, k, fix, se->sz);
	if(obj->lb[0]){ se_insf(se, -1, "%s=%s.%s%c", fix, obj->lb, k, 0); }
	else{ se_insf(se, -1, "%s=%s%c", fix, k, 0); }
	char* rp = se_ptr(se);
//dbg(rp, se->sz);
	return rp;
}


static 
int twl_as(twl_t* obj, const char* bkey, td_t rval_){
	td_t* rval = &rval_;
	char* hkey = NULL;
idbg( ((se_t*)(obj->seyc))->sz, rval->se, rval->idx, bkey);
sbg( bkey);
//conv style
	char* vp = se_ptr(rval->se) + rval->idx;
	int vpsz = rval->ssz;
	int tp = rval->tp;
	hkey = twl_makekey(obj, bkey, "t");
idbg("asin_vals:", bkey, hkey, vp, vpsz, tp);
sbg(bkey, hkey, vp);
	int cc = obj->hdb->cnt;	//current cnt
	while(tp == 'n'){
		hfl_nt* nd = hfl_set_s(obj->hdb, hkey, "n");	//hfl_nt* nd = hfl_set_s(obj->hdb, key, "n");
		; STOP(nd==NULL, "fatal memerr");
		int nc = obj->hdb->cnt;	//next cnt
		cc!=nc ? obj->cnt++ :0;
	
		//k,v == t=a.b.d , "n"		
		//--val: skip 1_0 >> 10
//pf1("%s, %s, %d", bkey, nd->s, nd->ssz);sleep(1);
		
		double d;
		char* p = calloc(vpsz+1, 1);
		int n = 0;
		for(int i=0;vp[i];i++){
			if(vp[i]=='_'){continue;}
			p[n] = vp[i];
			n++;
		}
		char* rp=NULL;
		errno=0;
		d = strtod(p, &rp);	//endptr
		int flg = errno||*rp;
		free(p);
		if(flg){
			char sbuf[128] = {0};
			snprintf(sbuf, 127, "strtod() failed: %s = %s", bkey, vp);
			free(obj->emsg);
			seterr(obj, sbuf, ERR_TKN);
			return -1;
		}
		//--ckend
		
//dbg(1, vp);
		hkey = twl_makekey(obj, bkey, "n");
//dbg(2, vp);
idbg( d, "valkey");
sbg(hkey, vp, "k,v");
//		double d = strtod(vp, &rp);	//endptr
		hfl_set_d(obj->hdb, hkey, d);
		break;
	}
	while(tp == 's'){
		hfl_set_s(obj->hdb, hkey, "s");
		int nc = obj->hdb->cnt;	//next cnt
		cc!=nc ? obj->cnt++ :0;

		hkey = twl_makekey(obj, bkey, "s");
		//make val from arg s, sz
		int dlit = 0;
		if(vp[0] == '"'){ dlit=1; }
		*(vp+vpsz-1)=0;
		vp++;
		vpsz-=2;	// "abc" >> abc|\0  5>>4 -1 -1
idbg(hkey, vp, vpsz, "valkey");
sbg(hkey, vp, ":del qu");
		//esc
		if(dlit){ vp = clitv(vp, &vpsz); }
		//set string to hfl
		hfl_set_s(obj->hdb, hkey, vp, vpsz+1);	//binもありえるので安全敵に\0追加
		if(dlit){ free(vp); }
		// maybe needs strsz
		hkey = twl_makekey(obj, bkey, "z");	//sz
		hfl_set_d(obj->hdb, hkey, (double)vpsz);
idbg(vpsz, "val strsz");
sbg(hkey);
		break;
	}
	while(tp == 'd'){
		hfl_set_s(obj->hdb, hkey, "d");
		int nc = obj->hdb->cnt;	//next cnt
		cc!=nc ? obj->cnt++ :0;

		double dd;
		double y  = dd=rval->y;  hkey=twl_makekey(obj,bkey,"dy");	hfl_set_d(obj->hdb,hkey,dd);
		double m  = dd=rval->m;  hkey=twl_makekey(obj,bkey,"dm");	hfl_set_d(obj->hdb,hkey,dd);
		double d  = dd=rval->d;  hkey=twl_makekey(obj,bkey,"dd");	hfl_set_d(obj->hdb,hkey,dd);
		double hh = dd=rval->hh; hkey=twl_makekey(obj,bkey,"dhh"); 	hfl_set_d(obj->hdb,hkey,dd);
		double mm = dd=rval->mm; hkey=twl_makekey(obj,bkey,"dmm"); 	hfl_set_d(obj->hdb,hkey,dd);
		double ss = dd=rval->ss; hkey=twl_makekey(obj,bkey,"dss"); 	hfl_set_d(obj->hdb,hkey,dd);
		double z  = dd=rval->z;  hkey=twl_makekey(obj,bkey,"dz");	hfl_set_d(obj->hdb,hkey,dd);
		double zh= dd=rval->zh;  hkey=twl_makekey(obj,bkey,"dzh");	hfl_set_d(obj->hdb,hkey,dd);
		double zm= dd=rval->zm;  hkey=twl_makekey(obj,bkey,"dzm");	hfl_set_d(obj->hdb,hkey,dd);
		//tostr
		hkey = twl_makekey(obj,bkey,"d");
		//
		z = zh<0 ? '-' : '+';
		char* sn = "";
		y<0 ? sn="-", y*=-1 :0;
		char sbuf[128] = {0};
		sprintf(sbuf,
			"%s%04.f-%02.f-%02.fT%02.f:%02.f:%02d.%03d%c%02.f:%02.f%c"
			 ,sn, y ,m ,d ,hh, mm ,(int)ss, (int)(ss*1000)%1000, (int)z, zh,zm, 0
		);
		hfl_set_s(obj->hdb, hkey, sbuf);
sbg(hkey, sbuf, "date tostr");
//dbg(se_ptr(yo) + idx);
		break;
	}
	return 0;
}

int twl_ycc(twl_t* obj, td_t einfo){
idbg(obj->svcnt, obj->ldcnt, "hit ycc");
// del used token
	se_t* se = einfo.se;
// 	se_t* se = obj->seyc;
	int tdx = einfo.idx;
//	int tdx = obj->tdx;
idbg(tdx, se->p, se->p + tdx, "del until nexthead");
sbg(se->p, se->p + tdx);
//	int tdxsz = einfo.ssz;
//	int tdxsz = obj->tdxsz;

	se_del(se, 0, tdx);	//add \0 to all str
idbg(se->p, se->sz, "after del preycc, nexthead");
sbg(se->p);
//*/
//remove hfl mlv data
	char sbuf[128]={0};
	if(obj->ldcnt!=0){
		for(int i=0; i<obj->svcnt; i++){
			sprintf(sbuf, "%d", i);
			hfl_unset(obj->hdb, sbuf);
		}
		obj->ldcnt = 0;
		obj->svcnt = 0;
	}
	obj->tdx = 0;
	obj->tdxsz = 0;
	return 0;
}

static int twl_mlvsv(twl_t* obj, td_t td){
	//clear saved data
	char sbuf[128]={0};
	sprintf(sbuf, "%d", obj->svcnt);
	char* k = se_ptr(td.se) + td.idx;
idbg(k, obj->svcnt, obj->ldcnt, "hit lval ID");
sbg(k);
	hfl_set_s(obj->hdb, sbuf, k);

	obj->svcnt++;
	return 0;
}

static char* twl_mlvld(twl_t* obj){
	char sbuf[128] = {0};
	sprintf(sbuf, "%d", obj->ldcnt);
	hfl_nt* nd = hfl_find(obj->hdb, sbuf);
idbg((nd?nd->s: 0), obj->svcnt, obj->ldcnt, "hit multi VAL ass");
	if(nd==NULL){ return NULL; }
	obj->ldcnt++;
	return nd->s;
}

%%

/*
stmt: expr SEMICOLON;
stmt: if PAR_OPEN expr PAR_CLOSE stmt;
stmt: if PAR_OPEN expr PAR_CLOSE stmt ELSE stmt;
%prefer stmt: IF PAR_OPEN expr PAR_CLOSE stmt * ELSE stmt
%over   stmt: IF PAR_OPEN expr PAR_CLOSE stmt *

shift-reduce conflict resolve
*/

//actblkは必須?
//1st rule
//*
$: { $ = ${0};
idbg("yacc_allactck", $.idx);
	sbg($.se->p + $.idx);
	}

//stmt: {;}
stmt: expr	{;}
stmt: stmt expr {;}

expr: ass { sbg(":expr==ass cmpl");  }

//single assign

ass: LB {
	$ = ${0};
	free(obj->lb);
	const char* p = se_ptr(${0}.se)+${0}.idx ;
	obj->lb = strdup(p+1);	//[]
	char* np = obj->lb;
	np[strlen(np)-1] = 0;		//kill ']'
//
//forerr, rawpos
	obj->tdx = ${0}.idx;
	obj->tdxsz = ${0}.ssz;
}

ass: ass CM rv {
	$ = ${2};

	char* k = twl_mlvld(obj);
idbg("hit 2nd or more rv ass", k);
sbg(k);
	if(k){
		int rc = twl_as(obj, k, ${2});
		if(rc<0){ return YP(_, SYNTAX_ERROR); }
	}
	obj->tdx =   ${2}.idx;
	obj->tdxsz = ${2}.ssz;
}

ass: ass_ rv {
	obj->ldcnt=0;
sbg("hit 1st rv ass");
	char* k = twl_mlvld(obj);
idbg("ass after rval", obj->svcnt, obj->ldcnt, k);
sbg(k);
	if(k){
		int rc = twl_as(obj, k, ${1} );
		if(rc<0){ return YP(_, SYNTAX_ERROR); }
	}
	$ = ${1};
	obj->tdx =   ${1}.idx;
	obj->tdxsz = ${1}.ssz;
}
ass: ass_ {
	$ = ${0};
sbg($.se->p + $.idx, "hit void ass");
	obj->tdx =   ${0}.idx;
	obj->tdxsz = ${0}.ssz;
}

ass_: lv AS {
sbg("hit lv_as yc");
	$ = ${0};
	//tdxはlastのtailになる可能性がある場合のみ更新する
	//asはセパレータなのでinfo不要
	obj->tdx =   ${0}.idx;
	obj->tdxsz = ${0}.ssz;
}

lv: lv CM ID {
	$ = ${2};
	twl_mlvsv( obj, ${2});
}
lv: ID {
//dbg(${0}.se->p, ${0}.idx, se_ptr(${0}.se) );
	$ = ${0};
sbg(${0}.se->p, ${0}.se->p + ${0}.idx, "yscc, hit 1st ID");
sbg("del prebuff, reset");
	twl_ycc(obj, ${0});
	${0}.idx = 0;	//removeの影響修正. 1stは常に0
	twl_mlvsv( obj, ${0});
}


// n,s,d
rv: NUM	 { $ = ${0}; $.tp='n'; }
rv: DLIT { $ = ${0}; $.tp='s'; sbg( $.se->p, $.se->p +$.idx, "yacc DLIT"); }
rv: SLIT { $ = ${0}; $.tp='s'; sbg( $.se->p +$.idx, "yacc SLIT"); }
rv: HDOC { $ = ${0}; $.tp='s'; sbg( $.se->p +$.idx, "yacc HDOC"); }
rv: dval { $ = ${0}; $.tp='d'; }

//odt3 = 1979-05-27T00:32:00.999999-07:00
dval: datet_ { $ = ${0}; }
dval: datez_ { $ = ${0}; }
dval: date_  { $ = ${0}; }
dval: time_ { $ = ${0}; }

datet_: DATET {
	$ = ${0};
	char* p = se_ptr(${0}.se) + ${0}.idx ;
	$.y = strtod(p, &p);
	$.m = strtod(p+1, &p);
	$.d = strtod(p+1, &p);
	$.hh = strtod(p+1, &p);
	$.mm = strtod(p+1, &p);
	$.ss = strtod(p+1, &p);
idbg("DATET yctk", $.y, $.m, $.d, $.hh, $.mm, $.ss);
}

datez_: datet_ DATEZ {
	$ = ${0};
	$.z = 1;
	$.idx = ${1}.idx;
	char* p = se_ptr(${1}.se) + ${1}.idx ;
	if(*p=='Z'){;}
	else{
		$.zh = strtod(p, &p);
		$.zm = strtod(p+1, &p);
	}
}
date_: DATE	{
	$ = ${0};
	$.tp='d';
	char* p = se_ptr(${0}.se) + ${0}.idx ;
	$.y = strtod(p, &p);
	$.m = strtod(p+1, &p);
	$.d = strtod(p+1, &p);
}
time_: TIME {
	$ = ${0};
	$.tp='d';
	char* p = se_ptr(${0}.se) + ${0}.idx ;
	$.hh = strtod(p, &p);
	$.mm = strtod(p+1, &p);
	$.ss = strtod(p+1, &p);
}

//multi assign
%%
//post c-code %%-

typedef struct YP(stack) pvm_t;

twl_t* twl_new_impl(const char* flname){
	twl_t* obj = calloc(1, sizeof(twl_t) );
	hfl_t* hdb = hfl_new();
	obj->hdb = hdb;
	void* pvm = calloc(1, sizeof(pvm_t) );
	YP(stack_init)(pvm);
//	YY_stack_init(pvm);
	obj->pvm = pvm;
	// hfl_find(hobj, ".");
	// eq_p(hobj->p, pvm);
	// printf("%p == %p\n", hobj->p, pvm);
//	obj->hdb = hdb;
//	obj->pvm = pvm;
	obj->sehd = se_new();
	obj->sepp = se_new();
	obj->setmp = se_new();
	obj->seyc  = se_new();
	obj->lb = strdup("");
	obj->lex0 = NULL;
	obj->lex1 = NULL;
//
	obj->svpf = pfgetfp(MSGP_FP_DBG);
	pfsetfp(MSGP_FP_DBG, NULL);
	return obj;
}

void* twl_free(twl_t* obj){
//	restore
	pfsetfp(MSGP_FP_DBG, obj->svpf);
//
	hfl_free(obj->hdb);
	YP(stack_cleanup)(obj->pvm);
//	YY_stack_cleanup(obj->pvm);
	free(obj->pvm);
	free(obj->emsg);
	se_free(obj->sehd);
	se_free(obj->sepp);
	se_free(obj->setmp);
	se_free(obj->seyc);
	free(obj->lb);
//return NULL;
	free(obj->lex0);
	free(obj->lex1);
	//
	free(obj);
	*obj = (twl_t){0};
	return NULL;
}

twl_t* twl_clear(twl_t* obj){
//	twl_t* obj = calloc(1, sizeof(twl_t));
//	hfl_t* hdb = hfl_new();
//	obj->hdb = hdb;
	hfl_clear(obj->hdb);
	YP(stack_reset)(obj->pvm);
	obj->rc=0;
	obj->cnt=0;

	se_clear(obj->sehd); 
	se_clear(obj->sepp); 
	se_clear(obj->setmp);
	se_clear(obj->seyc); 
	
	free(obj->lb);
	free(obj->emsg);
	obj->emsg=NULL;

	obj->lb = strdup("");
	free(obj->lex0);
	free(obj->lex1);
	obj->lex0 = NULL;
	obj->lex1 = NULL;
	return obj;
}

#ifdef TEST_
HCUT_ADD(t_pp) {
	eq_i(1, 1);
	se_t* obj = se_new();
	const char* s1 = "hello";
	const char* s2 = "world";
	
	se_ins(obj, 0, s1);
	se_del(obj, 1, 1);
	se_ins(obj, -1, s2);
puts(obj->p);
	se_free(obj);
	eq_p(obj, NULL);
}
#endif

#ifdef TEST_
HCUT_ADD(t_new) {
	twl_t* obj = twl_new();
	twl_free(obj);
	eq_p(obj->pvm, NULL);
}
#endif

int twl_pushfile_impl(twl_t* obj, const char* flname){
	int rc = 0;
	int sverr=0;
	FILE* fp = stdin;
idbg(fp);
sbg(flname);

	if(strcmp(flname, "stdin") ){
		errno=0;
		fp = fopen(flname, "r");
sbg("fopen suc/fail");
idbg(fp, errno);
		sverr=errno;
		if(fp==NULL){  goto lb_ERR; }
	}
sbg("fp suc, start readloop");
idbg(fp, stdin);
	while(1){
		char buf[128]={0};
		rc = fread(buf, 1, 127, fp);	//1x128 = 128byte  
sbg("fread suc?");
idbg(rc);
		if(rc ==0 && ferror(fp) ) { sverr = EIO; goto lb_ERR; }
		buf[rc]=0;
		char* p = buf;
		if(rc==0){ p=NULL; }
sbg(p, "fread, push2pp");
		rc = twl_pushstr(obj, p, rc);
sbg(obj->emsg, "pushck, err,nx,cpl == rc<0,1,0");
idbg(rc);
		if(rc<0){ goto lb_ERR;}
		if(rc==0){ break; }
	}
sbg("fileEOF, close");
	if(fp!=stdin){ fclose(fp);}
	YP(stack_reset)(obj->pvm);

lb_RTN:;
	return rc;

lb_ERR:;
	if(obj->emsg){ goto lb_RTN; }
	int sz = snprintf(NULL, 0, "%s: %s",  strerror(sverr), flname );
	char* ep = malloc(sz+1);
	sprintf(ep, "%s: %s", strerror(errno), flname );
	rc = 1;
	obj->emsg = ep;
	obj->rc = rc;
	return rc;
}

static
int seterr(twl_t* obj, const char* emsg, int errcode){
	int sz=0;
	void* mp = NULL;
	if(obj->emsg){ return 0;}
	// cbrt errline start with 0? >> add +1 to fix
	// err clm maybe next(yacc) or just(lex) so reverse pos -1? 0?
	int l = YP(line)(obj->pvm);
	int c = YP(column)(obj->pvm);
	const char* p = YP(text)(obj->pvm);
//	l==0 ? l=1 :0;
	while(1){
		sz = snprintf(mp, sz, "%d:%d: (l/c around) %s: %.10s"
		, l, c, emsg, p );
		if(mp){break; }
		sz++;
		mp = malloc(sz);
	}
	free(obj->emsg);
	obj->emsg = mp;
	obj->rc = errcode;	//lex err;
sbg(obj->emsg, "hit err");
	return 0;
}

static
int err_l2g(int ec){
	if(ec==ERR_TKN){ ec = YP(_,LEXICAL_ERROR); }
	else if(ec==ERR_STX){ ec = YP(_,SYNTAX_ERROR); }
	return ec;
}

static 
char* twl_pp(twl_t* obj, const char* s, size_t ssz, se_t* se, int stopflg){
	//update buff, until \0
	if(se->sz){
		//not init >> del with \0 , utf8 == no \0 char
		int idx = strlen(se->p);
		se_del(se, 0, idx+1);
	}
	//
	if(stopflg){ s=""; ssz=0; }
	se_ins(se, -1, s);
sbg(s, se->p, -10, ":sv2se");

	//pp concat
	for(int i=0;i<se->sz;){
		char* p1 = strstr(se->p + i, "\\\r\n");
		char* p2 = strstr(se->p + i, "\\\n");
		if(p1==NULL && p2==NULL){break; }
		p1==NULL ? p1 = p2+1 :0;
		p2==NULL ? p2 = p1+1 :0;
sbg(p1, p2, se->p, -10, ":hit \\+nl");
		if(p1<p2){
			i = p1 - se->p;
			se_del(se, i, 3);
			i+=3;
		}
		else{
			i = p2 - se->p;
			se_del(se, i, 2);
			i += 2;
		}
sbg(p1, p2, se->p, -10, ":hit_cat");
	}
sbg(":msg: ckend pp_cat >> cktail \\(eos), \\\\r(eos)\n");
	int edx = se->sz -1;
	char* ep = se->p + edx;
	if( *ep == '\\' && !stopflg){ se_ins(se, edx, "\0", 1); }
	if( strcmp(ep-1, "\\\\r") == 0 && !stopflg){ se_ins(se, edx-1, "\0", 1); }
sbg(ep, se->p + edx, ":ck_eos, ep==\\ etc");

	ssz = strlen(se->p);
	if(stopflg){ ssz = se->sz; }
	obj->rc = ssz;
sbg(s, se->p, -10, ":pp exit");
	return se->p;
}

int twl_pushstr_impl(twl_t* obj, const char* s, int ssz, ...){
sbg(s, ":pushstr head");
idbg(obj->rc);
	if(obj->rc<0){return obj->rc;}
	//; STOP(obj->rc<0, "parse is already failed. renew parser");

	int rc = 0;
	int stopflg = 0;
	if(s==NULL){
		stopflg = 1;
		s="";
		ssz=0;
	}
	ssz < 0 ? ssz=strlen(s): ssz;	
	//ppstr 第一バッファ。\n系と\eofを始末する

sbg(s, "pp_bf");
idbg(ssz);
	s = twl_pp(obj, s, ssz, obj->sepp, stopflg);
	ssz = obj->rc;	//tmp intbuff
sbg(s, "pp_af");
idbg(ssz);
	
	//keep mem. 第二バッファinput()のapiがクソなのでこっちで保持しないといけない。
	if(obj->lex0==NULL){
		s = obj->lex0 = strdup(s);
		free(obj->lex1);
		obj->lex1=NULL;
	}else{
		s = obj->lex1 = strdup(s);
		free(obj->lex0);
		obj->lex0=NULL;
	}
	YP(set_input)(obj->pvm, s, ssz, stopflg);
	rc = YP(scan)(obj->pvm, obj);		//ag2 == %params int* final_result
idbg(s,rc,_YY_LEXICAL_ERROR,_YY_SYNTAX_ERROR,_YY_INTERNAL_ERROR,_YY_FEED_ME,_YY_FINISH,
"lex, stx, inn, feed, fin");
	switch(rc){
		case YP(_,LEXICAL_ERROR	): rc= ERR_TKN; seterr(obj, "bad token", rc); break;
		case YP(_,SYNTAX_ERROR	): rc= ERR_STX; seterr(obj, "bad syntax", rc); break;
		case YP(_,INTERNAL_ERROR): rc= ERR_INN; seterr(obj, "fatal inner err", rc); break;
		case YP(_,OVERFLOW		): rc= ERR_INN; seterr(obj, "fatal nest err", rc); break;
		case YP(_,NO_MEMORY		): rc= ERR_INN; seterr(obj, "fatal mem err", rc); break;

		case YP(_,FEED_ME		): rc = 1; break;
		case YP(_,FINISH		): rc = 0; break;
		default : STOP(1, "dead code"); break;
	}
	obj->rc = rc;
	return rc;
	//rc==1 feed, 0:end -1:err
}

#ifdef TEST_
HCUT_ADD(t_str) {
	twl_t* obj;
	int rc;
	obj = twl_new();
	
	char* s[] = {"[he", "llo]", ";" };
	HCUT_each(i, s){
		rc = twl_pushstr(obj, s[i] );
		eq_i(rc, 1);
	}
	rc = twl_pushstr(obj, NULL);
idbg();
	eq_i(rc,0);
idbg(rc, obj->emsg);
puts("break");
	//err
	rc = twl_pushstr(obj, "33");
	eq_i(rc, 1);
idbg(obj->emsg);

	rc = twl_pushstr(obj, NULL);
	eq_i(rc, -2);
idbg(1, rc);
sbg(obj->emsg);
//

//	twl_pushstr(obj, "33");	//force STOP
	obj = twl_clear(obj);
//return ;
//clear
puts("clear vm");
//	obj = twl_new();
//	eq_p(obj, obj, "clr");
//dbg(obj->rc, rc, obj->emsg);
	rc = twl_pushstr(obj, "h"); //1592
//dbg(obj->rc, rc, obj->emsg);

	eq_i(rc, 1);
	rc = twl_pushstr(obj, "eo"); //1592
	eq_i(rc, 1, "llo");
	rc = twl_pushstr(obj, "4z"); //1592
	eq_i(rc, 1, "4z");
	rc = twl_pushstr(obj, "=");
	eq_i(rc, 1);
	rc = twl_pushstr(obj, "123");
	eq_i(rc, 1);
	rc = twl_pushstr(obj, NULL);
//dbg(obj->rc, rc, obj->emsg);
	eq_i(rc, 0);

	hfl_foreach(node, obj->hdb){
		puts("gg");
		dbg(node->key, node->d, node->s, node->ssz);
	}
	rc = twl_pushstr(obj, "hello=323");
	eq_i(rc, 1);
idbg();	
	rc = twl_pushstr(obj, NULL);
	eq_i(rc, 0);
//all disp

idbg(obj->hdb->cnt);
	
	hfl_nt* nd = hfl_find(obj->hdb, "t=hello");
idbg(nd);
	hfl_foreach(node, obj->hdb){
		puts("z");
		dbg(node->key, node->d, node->s, node->ssz);
	}

	twl_foreach(k, v, obj){
		puts("each");
		dbg(k, v.d, v.s);
	}
	twl_free(obj);
	eq_p(obj->pvm, NULL);
}
#endif

twl_vt twl_get(twl_t* obj, const char* key){
	int sz = strlen(key)+10;	//dhh + \0
	char* p = calloc(sz, sizeof(char));
	twl_vt rj = {0};
	rj.t = "";
	rj.s = "(nostr)";
	rj.date = "(nodate)";
	if(0){
		; lb_RTN:;
		free(p);
		return rj;
	}
	hfl_nt* nd = NULL;
	//
	char* k = p+3;	//___t=abc
	*k = 't';
	*(k+1) = '=';
	strcpy(k+2, key);
	//
	nd = hfl_find(obj->hdb, k);
	if(nd==NULL){ goto lb_RTN;}
	//tp
	if( *(nd->s)=='n') {
		rj.t = "n";
		*k = 'n';
		nd = hfl_find(obj->hdb, k);
		rj.k = nd->key +2;
		rj.n = nd->d;
		goto lb_RTN;
	}
	else if( *(nd->s)=='s') {
		rj.t = "s";
		*k = 's';
		nd = hfl_find(obj->hdb, k);
		rj.k = nd->key +2;
		rj.s = nd->s;
		*k = 'z';
		nd = hfl_find(obj->hdb, k);
		rj.ssz = nd->d;
		goto lb_RTN;
	}
	else if( *(nd->s)=='d') {
		//d単体はstrなので先に始末
		rj.t = "d";
		*k = 'd';
		nd = hfl_find(obj->hdb, k);
		rj.k = nd->key +2;
		rj.date = nd->s;
		//
		const char* pfix[] =
		{ "dy"  ,"dm"  ,"dd"  ,"dhh"  ,"dmm"  ,"dss"  ,"dz"  ,"dzh"  ,"dzm", NULL };
		double* dst[] =
		{ &rj.y ,&rj.m ,&rj.d ,&rj.hh ,&rj.mm ,&rj.ss ,&rj.z ,&rj.zh ,&rj.zm, NULL};
		
		for(int i=0;pfix[i];i++){
			char* sp = (char*)pfix[i];
			int sz = strlen(sp);
			char* dp = k - sz +1;
			memcpy(dp, sp, sz);
			nd = hfl_find(obj->hdb, dp);
			*(dst[i]) = nd->d;
		}
		goto lb_RTN;
	}
	; STOP(1, "unreachable code");
	return rj;
}

#ifdef TEST_
HCUT_ADD(t_base) {
	twl_t* obj;
	twl_vt v;
	int rc=0;
	const char* s = NULL;
	//
	obj = twl_new();
	s = "a=10; b=20; c=11,22;d,e,f=\"\\100\",2;x,y=1";
puts(s);
	rc = twl_pushstr(obj, s);
	eq_i(rc, 1);
	rc = twl_pushstr(obj, NULL);
sbg(obj->emsg);
	eq_i(rc, 0);
	eq_i(obj->rc, 0);
	//
//dbg(obj->rc, obj->emsg);
	v = twl_get(obj, "a");
idbg(v.t, v.n);
	eq_s(v.t, "n");
	eq_d(v.n, 10);
	
	v = twl_get(obj, "b");
	eq_s(v.t, "n");
	eq_d(v.n, 20);
	//each

	v = twl_get(obj, "c");
	eq_s(v.t, "n");
	eq_d(v.n, 11);
	//each

	v = twl_get(obj, "d");
	eq_s(v.t, "s");
//dbg(v.sz);
	eq_s(v.s, "@");
	//each
	v = twl_get(obj, "e");
	eq_s(v.t, "n");
	eq_d(v.n, 2);
	//each

	v = twl_get(obj, "f");
	eq_s(v.t, "");
	//each

	v = twl_get(obj, "x");
	eq_s(v.t, "n");
	eq_d(v.n, 1);
	//each

	v = twl_get(obj, "y");
	eq_s(v.t, "");
	//each
	int cnt=0;
	twl_foreach(k, v, obj){
		printf("%s, %s\n", v.t, k);
		cnt++;
	}
	eq_i(cnt, 6);
	
	v = twl_get(obj, "a");
	eq_s(v.t, "n");
	eq_d(v.n, 10);

	//
	twl_clear(obj);
	eq_i(obj->rc, 0);
	//
	s = "a=10;a=20";
	rc = twl_pushstr(obj, s);
	rc = twl_pushstr(obj, NULL);
//	eq_i(rc, ERR_STX);	//change 2nd err >> accept
	eq_i(rc, 0);
	v = twl_get(obj, "a");
	eq_s(v.t, "n");
	eq_d(v.n, 20);
//	eq_i(obj->rc, ERR_STX);
	eq_i(obj->rc, 0);
//dbg(obj->emsg);
	twl_clear(obj);
	eq_i(obj->rc, 0);
	//
	twl_free(obj);
}
#endif

#ifdef TEST_
HCUT_ADD(t_val) {
	twl_t* obj;
	twl_vt v;
	int rc=0;
	const char* s = NULL;
	//
	obj = twl_new();
	s = "num=11; str='hw'; date=-0020-01-01 11:22:33.4567";
	rc = twl_pushstr(obj, s);
sbg(obj->emsg);
	eq_i(rc, 1);
	rc = twl_pushstr(obj, NULL);
	eq_i(rc, 0);
	eq_i(obj->rc, 0);
	//
idbg(obj->rc);
sbg(obj->emsg);
	v = twl_get(obj, "num");
	eq_s(v.t, "n");
	eq_d(v.n, 11);
	
	v = twl_get(obj, "str");
	eq_s(v.t, "s");
	eq_s(v.s, "hw");
	//each

	v = twl_get(obj, "date");
idbg(v.t[0]);
	eq_s(v.t, "d");
	eq_d(v.y, -20);
	eq_d(v.m, 1);
	eq_d(v.d, 1);
	eq_d(v.hh, 11);
	eq_d(v.mm, 22);
	eq_d(v.ss, 33.4567);
	eq_d(v.z, 0);
	eq_d(v.zh, 0);
	eq_d(v.zm, 0);
	puts(v.date);
	//kick err
	twl_clear(obj);
	s = "\n; @ ;";
	rc = twl_pushstr(obj, s);
	eq_i(rc<0);
sbg(obj->emsg);
	
	twl_free(obj);
}
#endif

#ifdef TEST_
HCUT_ADD(t_file) {
//	MSGP_t bk = pfset(PF_NOCHANGE, PF_NOCHANGE, PF_NOCHANGE, NULL);
//pf1(bk.tostr);
//pf1(pfget().tostr);
	twl_t* obj = twl_new();
	int rc = twl_pushfile(obj, "syntax.twl");
	eq_i(rc, 0);
//	; pfpush(bk);
sbg(obj->emsg);
	int cnt=0;
	twl_foreach(k, v, obj){
		cnt++;
		epf("cnt %d: %s, %s, %f, %s, %s, %f", cnt, k, v.t, v.n, v.s, v.date, v.z);
	}
idbg(cnt, obj->cnt);
	
	twl_vt val = twl_get(obj, "str_bin.s2");
sbg(val.s);
idbg(val.ssz);
	eq_s(val.k, "str_bin.s2");
	twl_clear(obj);
	eq_d(obj->cnt, 0);
	
//	return;
	twl_free(obj);
	eq_i(obj->cnt, 0);
}
#endif


#ifdef TEST_
HCUT_ADD(t_dbgout) {
//*
	int rc = 0;
	twl_t* obj = NULL;
puts("dbgout: dfl mode");
	obj = twl_new();
	rc = twl_pushfile(obj, "syntax.twl");
	eq_i(rc, 0);
	twl_clear(obj);

puts("dbgout: dbg mode");
	rc = twl_dbgout(obj, stderr);
	eq_i(rc, 0);
	rc = twl_pushfile(obj, "syntax.twl");
	eq_i(rc, 0);
	twl_clear(obj);

puts("dbgout: reset >> dfl mode");
	rc = twl_dbgout(obj, NULL);
	eq_i(rc, 0);
	rc = twl_pushfile(obj, "syntax.twl");
	eq_i(rc, 0);
	twl_clear(obj);
	twl_free(obj);
puts("dbgout: end");
//*/
}
#endif


#ifdef TEST_
# undef LPN
# define LPN 1000*1000
//# define LPN 1

HCUT_ADD(t_bm0) {
/*
	twl_t* obj = twl_new();
	char sbuf[100]={0};
	int a[10] = {0};
	
	// i%10, a[idx]++ off :  3.8ms >> 3.4ms, 10% improve
	laptime(0);
	for(int i=0; i<LPN; i++){
		sprintf(sbuf, "n%d = %d ", i, i);
		sbuf[0]--;
	}
	laptime("sprintf() overhead " qu(LPN) );

//-----
//a[] set
	laptime(0);
	for(int i=0; i<LPN; i++){
		sprintf(sbuf, "n%d = %d ", i, i);
		int idx = i%10;
//		a[0] = i;
		a[idx] = i;
//		a[idx]++;
	}
	laptime("a[n] set " qu(LPN) );
//a[] get
	laptime(0);
	for(int i=0; i<LPN; i++){
		int idx = i%10;
		a[idx]++;
	}
	laptime("a[n] get " qu(LPN) );
	
//-----
// twl_set()
	laptime(0);
	for(int i=0; i<LPN; i++){
		sprintf(sbuf, "n%d = %d ", i, i);
		twl_pushstr(obj, sbuf);
	}
	laptime("twl_set " qu(LPN) );

//-----
//	twl_vt yo =	twl_get(obj, "n0");
//	puts(yo.date);
// twl_get()
	laptime(0);
	for(int i=0; i<LPN; i++){
		twl_get(obj, "n0");
	}
	laptime("twl_get " qu(LPN) );
//

	twl_free(obj);
//*/
}

/*
 -O0
 real	332.267 ms	:  ./twl.tmp.c 4674: t_bm0sub(): msg:sprintf() overhead 1000*1000
 real	341.507 ms	:  ./twl.tmp.c 4686: t_bm0sub(): msg:a[n] set 1000*1000
 real	14.469 ms	:  ./twl.tmp.c 4693: t_bm0sub(): msg:a[n] get 1000*1000
 real	14608.907 ms	:  ./twl.tmp.c 4702: t_bm0sub(): msg:twl_set 1000*1000
 real	449.135 ms	:  ./twl.tmp.c 4712: t_bm0sub(): msg:twl_get 1000*1000
 
 -O3
 real	356.416 ms	:  ./twl.tmp.c 4674: t_bm0sub(): msg:sprintf() overhead 1000*1000
 real	341.656 ms	:  ./twl.tmp.c 4686: t_bm0sub(): msg:a[n] set 1000*1000
 real	0.001 ms	:  ./twl.tmp.c 4693: t_bm0sub(): msg:a[n] get 1000*1000
 real	8842.322 ms	:  ./twl.tmp.c 4702: t_bm0sub(): msg:twl_set 1000*1000
 real	216.870 ms	:  ./twl.tmp.c 4712: t_bm0sub(): msg:twl_get 1000*1000
*/
#endif

// ~$ carburetta src.cbrt --c
// ~$ carburetta src.cbrt --c src.c
// ~$ carburetta src.cbrt --c src.c --h src.h
//etc

/*SH_CBRTE*/

/*SH_SMP
 #include "twl.h"

 int main(int argc, char** argv){
     twl_t* obj = twl_new();
     twl_pushstr(obj, "[hw] \n twl = 10.1");
     twl_pushstr(obj, NULL);	//EOF
     
     twl_vt val = twl_get(obj, "hw.twl");
     printf("%s, %f\n", val.k, val.n);
     twl_free(obj);
     return 0;
 }
 //~$ cc hw.c lib*SH_bn*.a -Wall -pedantic -std=c99 -D_POSIX_C_SOURCE=200112
//SH_SMPE*/

#ifdef TEST

#ifndef VLV
# define VLV	1
#endif /**/
HCUT_RUN("stderr", VLV,
		 t_0)
#endif

/*
 change log
 --
2022-07-12	Momi-g	<dmy@dmy.dmy>

	* *SH_bn*.sh.c(all): release pkg. v1.0.2

2022-06-29	Momi-g	<dmy@dmy.dmy>

	* *SH_bn*.sh.c(funcs): add static toolfuncs, twl_svcnt() etc

2022-06-17	Momi-g	<dmy@dmy.dmy>

	* *SH_bn*.sh.c: init. v1.0.0

*/

/*SH_ED*/

/*SH_OP _ set -e;a=`sed -ne "/${C}DF/!d;:l;n;/${C}DE/q;p;bl"<$R0`;eval "$a";set +e	#*/
/*SH_OP	h $p"-tsbS:test/eg/.o/.so -LMP:leak,mem,prof -f:funcs -o:bldout		GPLv3+"	 #*/
/*SH_OP	f sed -ne "/${C}DF/q;/;/d;/^[a-zA-Z].*)/p"<$R0 #*/
/*SH_OP t $e"$CW";ftt "$@";$p'cc -O0 $dm -Wall -pedantic -Wfatal-errors -g -pg -ggdb3 $Rm `fOI $Rs $tf` `fg $Rh $Rs $tf` `fL`'|fv	#*/
/*SH_OP T $e"$CW";ftt "$@";$p'cc -O3 $dm $Rm `fOI $Rs $tf ` `fg $Rs $tf ` `fL`'|fv	#*/
/*SH_OP s fgr0 "${C}SMP" "${C}SMPE"<$R0|fbn>eg.c;$p'cc eg.c `fg eg.c` `fOI eg.c`'|fv #*/

/*SH_OP L $p"fml $@"|fv #*/
/*SH_OP M $p"fM ./a.out"|fv	 #*/
/*SH_OP P $p'valgrind --tool=callgrind --callgrind-out-file=log.out ./a.out;kcachegrind log.out'|fv	 #*/

/*SH_OP b $e"$CW";$p'cc -c $Rs -pedantic -O2 -Wall -g `fg $Rs` `fI $Rs`'|fv;$p"$bn.o" #*/
/*SH_OP B $e"$Cb";$p"ar -r lib$bn.a $bn.o `fO $Rs`"|fv;$p"lib$bn.a"	#*/
/*SH_OP A $e"$CB";$p'fA lib$bn.a `fg $Rh $Rs|fu|grep '[.]a$'|fU`'|fv;$p"lib$bn.a" #*/
/*SH_OP S $e"$CW";$p"cc -shared -fPIC -o lib$bn.so $bn.c `fOI $Rs` `fg $Rs`"|fv;$p"lib$bn.so" #*/
/*SH_OP W $e"$CY"	#$e"$Cm$O$Cw">/dev/null;fborn;$p"$Rs $Rh $tf"	#*/
/*SH_OP o $e"$CW";$p'fman $Rh 3'|fv		#*/

/*SH_OP y cp $Rs $bn.cbrt;$p"cbrt $bn.cbrt --c $Rs --h cbft.h"|fv	#*/
/*SH_OP Y $e"$Cm$O$Cw">/dev/null;$e"$Cy";fborn;$p"$Rs $Rh $tf"		#*/

/*SH_DF
#-- noob
fman()( $p"cat $1|sed -e '/${C}docE/q'|fgr0 '${C}doc' '${C}docE'|amn >$bn.$2
 mandoc -Thtml <$bn.$2 >$bn.$2.html
 man -Tutf8 /dev/stdin<$bn.$2|sed -e 's/.`printf \"\\b\"`//g'>$bn.$2.txt
 "|fv
)

#-- local

#-- vars
bn=`basename ${Rs%.*}`; tf=${Rs%/*}/${bn}.ts.${Rs##*.}; e="eval "; p="$Rp"
#-- mod
fv()(while read -r a;do $e"cat<<E$O# $a${O}E"|sed -e 's@-L.*-L[^ ]*@-L(omit)@g'>/dev/stderr;$e"$a";done)

fbn()(sed -e "s@\*${C##*]}bn\*@$bn@g"|frf|frv|flit)
fsn()(tr -s ' \t' '\n')
fsl()(tr -s '\n' ' ')
fu()(fsn|sort -u)
fU()(fu|fsl;$p)

fgr()(sed -e "/$1/!d;:l;/$2/{p;d};n;bl")	#切出
fgr0()(sed -ne "/$1/!d;:l;n;/$2/d;p;bl")	#抜き切出
fgR()(sed -ne "/$1/bl;p;d;:l;n;/$2/d;bl")	#切すて
fg()($e\$p`sed -ne "s/.*${C##*]}co\*\([^*]*\).*$/\1/p" "$@"`|fsn|awk '!a[$0]{a[$0]=1;print}'|fsl)

# fO src.o from inc"src.abc" etc. kick self
fO()(set -- `fdp "$@"|awk '$0~/[.](h|hpp)$/{print}'|sed -e 's/[.][^.]*$/.c/'|fU`
	buf="";for i;do test -f $i&&buf="$buf $i";done;$p"$buf"
)
fI()(fdp "$@"|sed -e 's/[^/]*$//g'|fu|sed -e '/./s/^/ -I/g'|fu|grep -v '^\-I$'|fU)
fL()(find -L `dirname $R0` -type d|sed -e 's/^/-L/g'|fU)
# inc""系.h,hpp,oをパス付きで羅列 OIはfdpが重複するので高速化でまとめる 複数file_ok
fOI()(
set -- `fdp "$@"`
s="-I./ "`$p"$@"|sed -e 's/[^/]*$//g'|fu|sed -e 's/^/ -I/g'|fu|grep -v '^\-I$'|fU`
set -- `$p"$@"|awk '$0~/[.](h|hpp)$/{print}'|sed -e 's/[.][^.]*$/.c/'|fU`
buf="";for i;do test -f $i&&buf="$buf $i";done;
$p"$buf $s"
)

# 依存inc""を再帰的に取得./以下全て self系はkick
fdp()( l="$*"; paths="$@"; all=""; used=""
 while :;do
	all=`$p$all $paths|fU`	#差分を追加 repの始末 差分たちからaaa.hを取得 partial path
	buf=`(cat $paths|sed -ne 's@^[ \t]*#inc[^"]*.\([a-zA-Z0-9._]*\)".*@\1@p')|sort -u`
	ch=`$p$used $buf|tr -s ' ' '\n'|sort|uniq -u`	#使用済は外す
	used="$used $ch"	#リスト更新
	paths=`fsvy $ch|sort -u`	#ls検索 name系のみのはず
	buf=`$p"$all" "$paths"|fU`	#増えたらloop
	[ ${#all} = ${#buf} ]&&break
 done
# initを除く
 set -- $all
 for i;do a=${i##*[/]}; a=${a%%.*};[ "${l##*$a*}" = "$l" ]&&set -- "$@" $i;shift;done
 $p"$@"
)

# corecode:search + depthck + uniq
fsvy()(c="find -L ./ -false"
	for i; do c="$c -o -path '*'$i";done; l=`$e"$c"`
	for i; do $p"$l"|grep -F "$i"|awk '{sv=$0;print gsub("[/]","") " " sv}'|
	sort -k 1.1,1n -k 2.2,2|awk '{print $2;exit}'; done
)

# libをまとめる
fA()(n=0;dir=`dirname $0`/tmpdir;mkdir $dir;cd $dir;
 for i;do
 	n=$((n+1))
 	cp ../$i $i
 	ar -x $i
 	for ii in *.o;do mv "$ii" "p${n}_$ii";done
 	ar -r lib$bn.aa *.o
 	rm *.o
 done
 $p'mv lib$bn.aa ../lib$bn.a'|fv
 cd ..;rm -r $dir
)

#-- yacc
fy(){
set -e
cat<<'EEE'|fv
fgr0 "${C}YACC" "${C}YACCE"<$Rs|fbn>myyacc.y
fgr0 "${C}LEX" "${C}LEXE"<$Rs|fbn>mylex.l
fgR "${C}YACC" "${C}YACCE"<$Rs>$Rm
fgR "${C}LEX" "${C}LEXE"<$Rm>$Rs

lex mylex.l
#bison -Wnone -Wall -Wno-empty-rule -p zz -dv myyacc.y 
# bisonはy.tab.c固定名ではなくsrc.tab.c/hを吐く 標準に戻す
bison -Wnone -Wall -Wno-empty-rule -dv myyacc.y --defines=y.tab.h -o y.tab.c

cat $Rh y.tab.c lex.yy.c > $Rs
$p"$Rs"
EEE
}

#-- longcmd
frf()(
 # *sh_rf* 0 a.txt b.txt ...でcat纏めて出力 top0でsrcinfoは無し出力
 awk -v tg="${C##*]}rf" 'index($0,tg){
 s=substr($0, index($0,tg)+length(tg)+1);split(s, a)
 m="[ -f \"%s\" ]&&(echo \"/*--copyfrom %s*\"/;cat \"%s\";echo \"/*--copyend %s*\"/)"
 mm="[ -f \"%s\" ]&&(_=\"%s\"/;cat \"%s\";_=\"%s\")"
 for(i=1;i in a;i++){v=a[i];if(v==0){m=mm;continue};system(sprintf(m,v,v,v,v)) }
 next
 }
 {print}'
)
frv()(buf=`awk '$1=="@_ver" {print $3;exit}'<$R0`;sed -e "s@\*${C##*]}ver\*@$buf@g")
flit()(sed -ne "/${C##*]}lit/b l;p;d;:l;n;/${C##*]}litE/d;"'s/[\]/&&/g;s/"/\\"/g;s@.*@"&\\n"@g;p;b l')

fml()(
 # --show-leak-kinds=definite,indirect(inner ref),possible,reachable(doesnt p=NULL)
 #cmd="valgrind --leak-check=full --show-leak-kinds=all --track-origins=yes --verbose ./a.out 2>&1|sed -e '/SUMMA/!d;n;n;n;n'"
 cmd="valgrind --leak-check=full --show-leak-kinds=definite,possible --track-origins=no --verbose ./a.out 2>&1|sed -e '/SUMMA/!d;n;n;n;n'"
 test $# = 0 && $p"$cmd"|fv && return
 set -- " " "$@"
 $e"$Ct"
 test $? = 0 && $p"$cmd"|fv
)

ftm(){
 awk -v w="$1" '
 /^HCUT_ADD/ && index($0,"("w")")==0 {
	while(match($0,"^#endif$") ==0 ){getline}
	print $0; next
 }
 {print $0}'
}

fte()(
 cat > $Rm-
 cmd="cat"
 [ $# != 0 ] && cmd='ftm $b'
 a="`sed -ne 's@^HCUT_ADD(\([^)]*\).*@\1, @p' $Rm-|tr -d '\n'`NULL"
 if [ $# != 0 ];then	a=""; for i;do a="$a $i,";done; a="$a NULL"; fi
 b=`$p"$a"|tr ',' ' '`
 sed -ne "p;/_RUN/b l;d;:l;/[)]/{c \\$O $a)$O p;d};n;b l" $Rm-|$e"$cmd"|
 fgr0 "^#ifdef TEST" '^#endif$'
 rm $Rm-
)

ftt(){
 [ $# != 0 ] && [ "${1#[0123]}" = "" ]&&dm="-DVLV=$1"&&shift
 (cat $Rs;fte "$@"<$tf)>$Rm
}
fborn(){
 fgr "^#ifdef TEST" "^#endif$"<$R0|fbn>$tf
 fgR "^#ifdef TEST_" "^#endif$"<$tf |fte>tests.code
 fgR "^#ifdef TEST" "^#endif$"<$Rs|fbn>$Rm;mv $Rm $Rs;fbn<$Rh>$Rm;mv $Rm $Rh
}
fM()(
 valgrind -q --tool=massif --massif-out-file=./vmem.buf --stacks=yes --trace-children=yes $1>/dev/null
 ms_print ./vmem.buf|sed -ne '/[KMG]B/bl;d;:l;/snap/q;p;n;bl';rm ./vmem.buf)

/*SH_DE*/
