/* Copyright (C) 2022 Momi-g

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 3 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program. If not, see <http://www.gnu.org/licenses/>.
*/

/*SH_doc*
title=stredit section=3 repnl=\040
@name	stredit
@_brief	auto growing str/bin buffer. fast.
@_syno
 typedef struct stredit_tag {
 	char* p;
 	int ofst;
 	int sz;
 	int msz;
 	// ..and inner_data
 } se_t;
 
 se_t*	se_new(void);
 se_t*	se_free(se_t* obj);	//macro: >> (se_freeXX(obj), obj=NULL)
 int		se_ins(se_t* obj, int cur, const char* bin [,int binsz] );
 int		se_insf(se_t* obj, int cur, const char* fmt, ...);
 int		se_del(se_t* obj, int cur, int dcnt);
 
 char*	se_ptr(obj);		// get str/data head ptr. obj->p.
 int		se_sz(obj);		// data sz. obj->sz.
 int		se_clear(se_t* obj);	//rtn some int val

@params
		@(list)
	obj:	mainstruct. holds malloc()ed ptr, memsz etc
	cur:	edit cursor pos
	bin:	str/bin you want to add
	binsz:	addsize >= -2. -1@:strlen(bin), -2@:strlen(bin)+1.
	fmt:	printf() fmt
	dcnt:	del byte size. dcnt<0 / 0<dcnt == bs-key/del-key
		@()

@tl_dr
		@(code)@
	#include <stdio.h>
	#include "stredit.h"

	int main() {
	  se_t* obj = se_new();		// ""
	  int rc= se_ins(obj, -1, "foo"); // "foo", rc=3(strsz), -1 == end
	  char* p = se_ptr(obj);		// get headptr
	  puts(p);				// >> 'foo'
	  int sz = se_sz(obj);		// >> 3
	  
	  se_ins(obj, 1,  "ZZZ");	// f|oo + ZZZ, "fZZZoo", 1 == inspos
	  rc = se_ins(obj, 0, "baz");	// "bazfZZZoo", rc=3
	  se_ins(obj, -1, "\0abc");	// "bazfZZZoo", read as str if ag4 isnt
	  se_ins(obj, 0, "\0abc", 2);	// "(\0)abazfZZZoo", rc==2
	  sz = se_sz(obj);			// 11, sz is holding bin size
	  se_clear(obj);				// "", rc = 0
	  
	  se_insf(obj, 0, "%#x",17);	// "0x11", printf() fmt
	  se_insf(obj, -1, "\0");	// "0x11", rc=0
	  se_insf(obj, -1, "%c", 0);	// "0x11(\0)", rc=1
	  se_del(obj, 1, 2);		// "01(\0)" , cur==1, del 2byte. rc=2
	  se_del(obj, -1, -2);		// "0" , rc=2. -1==tail, -2 == bs 2byte. rc=2
	  puts(obj->p);			// "01"
	  
	  se_ins(obj, 0, obj->p);		// >> "0101", allow to use inner ptr
	  se_insf(obj, 1, "%s", obj->p);	// >> "0_01011,
	  
	  se_free(obj);	// (free_XX(obj), obj=NULL);
	  return 0;
	}
	// ~$ gcc src.c stredit.c
		@()@
@return	
		@(code)@
	se_ins/se_insf/se_del: edit byte int size
	se_clear:  some int val
	se_new/se_free: new/freed se_t* ptr
		@()@
@_desc stredit is string buffer for general purpose, add/del/ins/clear chars.
	buffsz is automatically realloc()ed. see samples for detail usage. --
	input data/str is always terminated with '\0'.
	this last byte is out of se_sz() cnt. --
	--
	- puts(se_ptr(obj)) never causes SEGV err.
		@(code)--@
	se_ins(obj, 0, "foo");		// sz=3	puts(se_ptr(obj) ) >> "foo" 
	se_ins(obj, 0, "\0ab",4);	// sz=7	puts(se_ptr(obj) ) >> "foo" 
	se_clear(obj);				// sz=0	puts(se_ptr(obj) ) >> ""
	se_ins(obj, 0, "bar");		// sz=3	puts(se_ptr(obj) ) >> "bar" 
		@()--@
	- str editting funcs rtns added sz as printf()
		@(code)--@
	se_t* obj = se_new();
	char* s = "hw";
	int p1 = se_ins(obj, s, strlen(s)+1 );	//+1=='\0', p1==3
	s = "gw";
	int p2 = se_ins(obj, s, -2 );	//-2==slen(s)+1, p2==3, "hw(\0)gw(\0)"
	puts( se_ptr(strpool)+p1 );	//>>gw
	puts( strpool->p );		//>>hw
		@()--@
	- se_clear() doesnt shrink heap --
	- sloppy benchmark:
		@(code)--@
	FAST: strdup/se_ins(1) > se_insf(5) >>> asprintf(300) >>> libapr(1000) :SLOW

	code: while(i-- >0){ se_ins(obj, "123"); }, loop(1*1000*1000) etc
	
	100.466 ms: msg:se_ins(abc) lp: 1*1000*1000
	517.152 ms: msg:se_insf(abc) lp: 1*1000*1000
	118.990 ms: msg:strdup(abc) loop1*1000*1000
 
 (too slow + causes memclash)
	244.710 ms	: msg:gnu asprintf(), x10 == 2.4s (lp: 10*1000)
	978.828 ms	: msg:apr_psprintf(), x10 == 9.7s (lp: 10*1000)
 		@()--@
@notes -
@conforming posix-2001+
@_ver 2022-07-10 v1.0.2 (2021-06-25 v1.0.0)
//SH_docE*/
#ifndef stredit_fc94efbf1b06
#define stredit_fc94efbf1b06

//2001L: sigaction()
#include <features.h> 	//SH_co* -D_XOPEN_SOURCE=600 -std=c99 */
#if ( _POSIX_C_SOURCE +0 < 200112L )
	#include	"stop cc: needs compiler posix-2001 or upper(c99+)"
#endif

typedef struct stredit_tag {
	char* p;	//仮想的なtop
	int ofst;	// 中央付近に陣取る
	int sz;
	int msz;
	char* sbuf;
	int sbufsz;
} se_t;

// init heap sz
#ifndef SE_BUFSZ
 #define SE_BUFSZ	32
#endif
	
se_t* se_new(void);
#define se_free(obj)	(se_free_impl(obj), obj=NULL)
se_t* se_free_impl(se_t* obj);

#define se_ins(...)	se_ins_impl(__VA_ARGS__, -1)
int se_ins_impl(se_t* obj, int pos, const char* bin, ...);
#define se_insf(...)	se_insf_impl(__VA_ARGS__)
int se_insf_impl(se_t* obj, int pos, const char* fmt, ...);

int se_del(se_t* obj, int pos, int dcnt);
se_t* se_clear(se_t* str);

#define se_ptr(obj) (obj->p)
#define se_eptr(obj) (obj->p + obj->sz -1 )
#define se_sz(obj)	(obj->sz)

//hpp
#ifdef _IMPL_stredit		/*SH_c o* -D_IMPL_stredit	*/
/*--copyfrom stredit.c*/
/* Copyright (C) 2022 Momi-g

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 3 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program. If not, see <http://www.gnu.org/licenses/>.
*/

/*SH_doc*
title=stredit section=3 repnl=\040
@name	stredit
@_brief	auto growing str/bin buffer. fast.
@_syno
 typedef struct stredit_tag {
 	char* p;
 	int ofst;
 	int sz;
 	int msz;
 	// ..and inner_data
 } se_t;
 
 se_t*	se_new(void);
 se_t*	se_free(se_t* obj);	//macro: >> (se_freeXX(obj), obj=NULL)
 int		se_ins(se_t* obj, int cur, const char* bin [,int binsz] );
 int		se_insf(se_t* obj, int cur, const char* fmt, ...);
 int		se_del(se_t* obj, int cur, int dcnt);
 
 char*	se_ptr(obj);		// get str/data head ptr. obj->p.
 int		se_sz(obj);		// data sz. obj->sz.
 int		se_clear(se_t* obj);	//rtn some int val

@params
		@(list)
	obj:	mainstruct. holds malloc()ed ptr, memsz etc
	cur:	edit cursor pos
	bin:	str/bin you want to add
	binsz:	addsize >= -2. -1@:strlen(bin), -2@:strlen(bin)+1.
	fmt:	printf() fmt
	dcnt:	del byte size. dcnt<0 / 0<dcnt == bs-key/del-key
		@()

@tl_dr
		@(code)@
	#include <stdio.h>
	#include "stredit.h"

	int main() {
	  se_t* obj = se_new();		// ""
	  int rc= se_ins(obj, -1, "foo"); // "foo", rc=3(strsz), -1 == end
	  char* p = se_ptr(obj);		// get headptr
	  puts(p);				// >> 'foo'
	  int sz = se_sz(obj);		// >> 3
	  
	  se_ins(obj, 1,  "ZZZ");	// f|oo + ZZZ, "fZZZoo", 1 == inspos
	  rc = se_ins(obj, 0, "baz");	// "bazfZZZoo", rc=3
	  se_ins(obj, -1, "\0abc");	// "bazfZZZoo", read as str if ag4 isnt
	  se_ins(obj, 0, "\0abc", 2);	// "(\0)abazfZZZoo", rc==2
	  sz = se_sz(obj);			// 11, sz is holding bin size
	  se_clear(obj);				// "", rc = 0
	  
	  se_insf(obj, 0, "%#x",17);	// "0x11", printf() fmt
	  se_insf(obj, -1, "\0");	// "0x11", rc=0
	  se_insf(obj, -1, "%c", 0);	// "0x11(\0)", rc=1
	  se_del(obj, 1, 2);		// "01(\0)" , cur==1, del 2byte. rc=2
	  se_del(obj, -1, -2);		// "0" , rc=2. -1==tail, -2 == bs 2byte. rc=2
	  puts(obj->p);			// "01"
	  
	  se_ins(obj, 0, obj->p);		// >> "0101", allow to use inner ptr
	  se_insf(obj, 1, "%s", obj->p);	// >> "0_01011,
	  
	  se_free(obj);	// (free_XX(obj), obj=NULL);
	  return 0;
	}
	// ~$ gcc src.c stredit.c
		@()@
@return	
		@(code)@
	se_ins/se_insf/se_del: edit byte int size
	se_clear:  some int val
	se_new/se_free: new/freed se_t* ptr
		@()@
@_desc stredit is string buffer for general purpose, add/del/ins/clear chars.
	buffsz is automatically realloc()ed. see samples for detail usage. --
	input data/str is always terminated with '\0'.
	this last byte is out of se_sz() cnt. --
	--
	- puts(se_ptr(obj)) never causes SEGV err.
		@(code)--@
	se_ins(obj, 0, "foo");		// sz=3	puts(se_ptr(obj) ) >> "foo" 
	se_ins(obj, 0, "\0ab",4);	// sz=7	puts(se_ptr(obj) ) >> "foo" 
	se_clear(obj);				// sz=0	puts(se_ptr(obj) ) >> ""
	se_ins(obj, 0, "bar");		// sz=3	puts(se_ptr(obj) ) >> "bar" 
		@()--@
	- str editting funcs rtns added sz as printf()
		@(code)--@
	se_t* obj = se_new();
	char* s = "hw";
	int p1 = se_ins(obj, s, strlen(s)+1 );	//+1=='\0', p1==3
	s = "gw";
	int p2 = se_ins(obj, s, -2 );	//-2==slen(s)+1, p2==3, "hw(\0)gw(\0)"
	puts( se_ptr(strpool)+p1 );	//>>gw
	puts( strpool->p );		//>>hw
		@()--@
	- se_clear() doesnt shrink heap --
	- sloppy benchmark:
		@(code)--@
	FAST: strdup/se_ins(1) > se_insf(5) >>> asprintf(300) >>> libapr(1000) :SLOW

	code: while(i-- >0){ se_ins(obj, "123"); }, loop(1*1000*1000) etc
	
	100.466 ms: msg:se_ins(abc) lp: 1*1000*1000
	517.152 ms: msg:se_insf(abc) lp: 1*1000*1000
	118.990 ms: msg:strdup(abc) loop1*1000*1000
 
 (too slow + causes memclash)
	244.710 ms	: msg:gnu asprintf(), x10 == 2.4s (lp: 10*1000)
	978.828 ms	: msg:apr_psprintf(), x10 == 9.7s (lp: 10*1000)
 		@()--@
@notes -
@conforming posix-2001+
@_ver 2022-07-10 v1.0.2 (2021-06-25 v1.0.0)
//SH_docE*/
/* tool macros */
#ifndef ERRact
#include <stdio.h>
 #if (199901L <= __STDC_VERSION__ +0)	/* nealy 200112L, _POSIX_C_SOURCE	c99*/
	#include <sys/types.h>
	#include <unistd.h>
	#define ERRactag	__func__, getpid()
 #else
	#define ERRactag	"func:c99+", 0
 #endif
 #include <string.h>
 #include <errno.h>
 #define ERRact(xpr, msg, act)	if(xpr){ int en_=errno; fprintf(stderr, \
	"ERR: %s %d %s() pid:%d %s msg:%s sys:%s\n",__FILE__,__LINE__, ERRactag \
	, "hit(" #xpr ")", msg, strerror(en_) ); act; }
 #define STOP(xpr, msg)	ERRact(xpr, msg, fputs("STOP\n",stderr);exit(1) )
#endif
#define loop(a)		for(int lpcnt=1;lpcnt<=a;lpcnt++)
/*tool end*/

#include <stdlib.h>
#include <string.h>

#include "stredit.h"



/*src*/
se_t* se_new(void) {
	; STOP( SE_BUFSZ<1, "init bufsz is negative num");
	se_t* obj=(se_t*)calloc(1, sizeof(se_t));
	; if(!obj){return NULL;}	//STOP(!obj, "calloc() failed");

	obj->ofst = SE_BUFSZ/2;
	char* p = (char*)calloc(SE_BUFSZ, sizeof(char));
	; if(!p){return NULL;}	//STOP(!obj, "calloc() failed");

	obj->p = p + obj->ofst;
	obj->sz=0;
	obj->msz= SE_BUFSZ;
	
	obj->sbuf = calloc(SE_BUFSZ, sizeof(char) );
	obj->sbufsz = SE_BUFSZ;
	return obj;
}

se_t* se_free_impl(se_t* obj) {
	if(!obj){return NULL;}
	free(obj->p - obj->ofst);
	free(obj->sbuf);
	obj->p=NULL;	
	obj->ofst=0;
	obj->sz=0;
	obj->msz=0;
	obj->sbuf=NULL;
	obj->sbufsz=0;
	free(obj);
	return obj;
}

#include <stdarg.h>
//curは0なら||abcde, 2なら|ab|cde でpreに残すbyte数に一致する
static int se_realloc(se_t* obj, int binsz, int pflg);

int se_ins_impl(se_t* obj, int cur, const char* bin, ...) {
	; STOP(!obj, "NULL obj.");	//削れば10%早くなるけどセグフォで見えないのは嫌
	va_list ap;
	va_start(ap, bin);
	int binsz = va_arg(ap, int);
	va_end(ap);
	
	//ag cmpl
	; STOP(binsz < -2, "binsz>=0 or -1:strlen(), -2:strlen()+1, -3...err")
	binsz == -1 ? binsz = strlen(bin)
	: binsz == -2 ? binsz = strlen(bin) + 1
	: 0;
	if(cur == -1){ cur = obj->sz; }
// add bad range >> disp err for note
	else if(cur > obj->sz){
		errno = EINVAL;
		ERRact(cur, "bad curpos, over the max", return -1);
	}

	//inner ptr
	if(obj->p <= bin && bin< obj->p + obj->sz){
		if(obj->sbufsz < binsz){
			obj->sbuf = realloc(obj->sbuf, binsz);
			obj->sbufsz = binsz;
		}
		memcpy(obj->sbuf, bin, binsz);
		bin = obj->sbuf;		
//dbg(1, sleep(1) );
	}
	//ck memspace
	int pflg = 0;
	while(1){
		int presz = obj->ofst;
		int pstsz = obj->msz - obj->sz - obj->ofst;
		cur < obj->sz/2 ? pflg = -1: (pflg = -2);

		/**/ if(presz>binsz && pflg==-1) { pflg = 1; }
		else if(pstsz>binsz && pflg==-2) { pflg = 2; }
		if(pflg>0){break;}
		se_realloc(obj, binsz, pflg);
	}
	//write
	//head
	if(pflg==1){
		int mvsz = cur;
		if(mvsz){ memmove(obj->p -binsz, obj->p, mvsz); }
		memcpy(obj->p-binsz+cur, bin, binsz);
		; obj->ofst -= binsz;
		; obj->p -= binsz;
		goto lb_RTN;
	}
	//tail
	if(pflg==2){
		int mvsz = obj->sz - cur;
		memmove(obj->p + cur + binsz, obj->p + cur, mvsz);
		memcpy(obj->p + cur, bin, binsz);
		goto lb_RTN;
	}
	
lb_RTN:;
	obj->sz += binsz;
	obj->p[obj->sz]=0;
	return binsz;
}


// corecode
static
int se_realloc(se_t* obj, int binsz, int pflg){
	//	init: |....@....|
	//	add : |....@@...|
	//	ins : |.===@@...|			realloc					centering
	//	ext	: |.===@@@@@|  >>  |.==@@@@@(XX)|....| >> |....==@@@@@(XX).....|
	int newsz = 0;
	char* p = obj->p - obj->ofst;
	//centering if uneven layout	|.|xxxxx|..............|
	int evsz = (obj->msz - obj->sz)/2;
	if(obj->sz + binsz +1 < evsz){ newsz = obj->msz; }	// +1 == 1/2
	else{
		newsz = obj->msz*2;
		if(newsz - obj->sz - 1 < binsz){ newsz += binsz+1; }
		p = realloc(p, newsz);
		; if(p==NULL){ return -1; }
	}
	pflg == -1 ? pflg = 1: (pflg= 0);
	
	//centering head == +, tail== -
	int nofst = (newsz - (obj->sz +binsz) )/2 + pflg * binsz;
	memmove(p +nofst, p +obj->ofst, obj->sz);
	obj->ofst = nofst;
	obj->p = p + nofst;
	obj->msz = newsz;
	obj->p[obj->sz]=0;
	return 0;
}

#include <stdarg.h>
//curは0なら||abcde, 2なら|ab|cde でpreに残すbyte数に一致する

int se_insf(se_t* obj, int cur, const char* fmt, ...) {
	; STOP(!obj, "NULL obj.");
	char sbuf[1]={0};
	va_list ap;
	va_start(ap, fmt);
	size_t binsz = vsnprintf(sbuf, sizeof(sbuf), fmt, ap);	//sn系は\0を除く。クソが。
	va_end(ap);
	//pf系は全て外 %sが怪しいが判別不能
	//inner sv
	if(obj->sbufsz < binsz){
		obj->sbuf = realloc(obj->sbuf, binsz);
		obj->sbufsz = binsz;
	}
	char* bin = obj->sbuf;
	va_start(ap, fmt);
	vsnprintf(bin, binsz+1, fmt, ap);	// +1 == \0
	va_end(ap);
	//
	se_ins_impl(obj, cur, bin, binsz);
	return binsz;
}

int se_del(se_t* obj, int cur, int dcnt) {
	; STOP(!obj, "NULL obj.");	//削れば10%早くなるけどセグフォで見えないのは嫌
//	; STOP(dcnt<0, "badval, dcnt<0");
	//comp args
	// -+ direction
	if(cur<0){ cur = obj->sz +  cur+1;}
	if(dcnt<0){ cur += dcnt; dcnt= -dcnt; }
	if(cur<0){
		dcnt += cur;
		cur=0;
	}
	if(dcnt<0){dcnt=0; }
	dcnt > obj->sz - cur ? dcnt = obj->sz - cur :0;
	
	//shortcut, head/tail 0
	if(cur+dcnt == obj->sz){ goto lb_RTN; }
	if(cur==0) { obj->ofst += dcnt; obj->p += dcnt;	goto lb_RTN; }

	//centering
	int pflg = 0;
	cur < (obj->sz)/2 ? pflg = 1: (pflg= -1);
	//write
	//head
	if(pflg>0){
		int mvsz = cur;
		memmove(obj->p + mvsz, obj->p, mvsz);
		; obj->ofst += mvsz;
		; obj->p += mvsz;
		goto lb_RTN;
	}
	//tail
	if(pflg<0){
		int mvsz = obj->sz - cur;
		memmove(obj->p + cur, obj->p + cur + dcnt, mvsz);
		goto lb_RTN;
	}
	
lb_RTN:;
	obj->sz -= dcnt;
	obj->p[obj->sz]=0;
	return dcnt;
}

se_t* se_clear(se_t* obj) {
	if(!obj){return obj;}
	; STOP(!obj, "NULL obj.");
	obj->p = obj->p - obj->ofst + obj->msz/2;
	obj->ofst = obj->msz /2;
	obj->sz=0;
	obj->p[0]=0;
	return obj;
}











/*SH_SMP
#include "stredit.h"
#include <stdio.h>

int main() {
	se_t* obj = se_new();		// ""
	se_ins(obj, "foo");		// "foo"
	char* p = se_ptr(obj);		// get headptr
	puts(p);					// >> 'foo'
	int sz = se_sz(obj);		// >> 3
printf("%d\n", sz);

	se_ins(obj, "bar");		// "foobar"
	se_ins(obj, "baz");		// "bazfoobar"
	se_ins(obj, "\0abc", 2);	// "(\0)zbazfoobar"	,use only 2byte
	sz = se_sz(obj);			//	11,	sz is holding binary size
	se_clear(obj);				// ""
puts(obj->p);
	se_insf(obj,"%#x",17);		// "0x11"	,fmt same as printf()
puts(obj->p);
	se_bs(obj, 1);			// "0x1"	,del tail 1byte
printf("%d\n", obj->sz);	// >> len=3

	se_del(obj,2);			// "1"		,del head 2byte
	puts(obj->p);			// >> "1"
	
	se_free(obj);
	return 0;
}

//SH_SMPE*/



/*
 change log
 --
2022-07-10 Momi-g	<dmy@dmy.dmy>

	* stredit.sh.c(stredit.h) : add hpp impl code

2022-06-26  Momi-g	<dmy@dmy.dmy>

	* stredit.sh.c(se_del) : change minus val, add bs-key, add se_eptr()

2022-06-25  Momi-g	<dmy@dmy.dmy>

	* stredit.sh.c(init) : fork from stringrow. v1.0.0

*/


/*--copyend stredit.c*/
#endif

#endif /* stredit_fc94efbf1b06 */
