;; inflate_boot startup for AE-3068
	
#define BRCR   0xFEE013
#define ADRCR  0xFEE01E
#define CSCR   0xFEE01F
#define ABWCR  0xFEE020
#define ASTCR  0xFEE021
#define WCRH   0xFEE022
#define WCRL   0xFEE023
#define BCR    0xFEE024
#define DRCRA  0xFEE026
#define DRCRB  0xFEE027
#define RTMCSR 0xFEE028
#define RTCNT  0xFEE029
#define RTCOR  0xFEE02A
#define P1DDR  0xFEE000
#define P2DDR  0xFEE001
#define P3DDR  0xFEE002
#define P4DDR  0xFEE003
#define P5DDR  0xFEE004
#define P6DDR  0xFEE005
/*#define P7DDR 0xFEE006*/
#define P8DDR  0xFEE007
#define P9DDR  0xFEE008
#define PADDR  0xFEE009
#define PBDDR  0xFEE00A
#define SMR1   0xFFFFB8
#define BRR1   0xFFFFB9
#define SCR1   0xFFFFBA
#define TDR1   0xFFFFBB
#define SSR1   0xFFFFBC
#define RDR1   0xFFFFBD
#define SCMR1  0xFFFFBE

	.global	__start
	
	/* interrupt vector */
	.section .vectors,"ax"
	.long	__start
vector	=	1
	.rept	64-1
	.long	_interrupt_redirect_table+vector*4
vector	=	vector + 1
	.endr
	
	.h8300h
	.section .text

	/* CPU Reset entry */
__start:	
	mov.l	#_stack,sp
	ldc	#0x80,ccr

	/* Peripheral Setup */
	mov.l	#init_regs,er0
1:
	mov.w	@er0+,r2
	beq	3f
	mov.w	#0x00ff,e2	/* internal I/O regs (2) high address */
	cmp.w	#0xf000,r2
	bhi	2f
	dec.w	#1,e2		/* internal I/O regs (1) high address */
2:
	mov.w	@er0+,r1
	mov.b	r1l,@er2

3:	
	mov.l	#420000,er0	/* wait 50ms */
4:
	dec.l	#1,er0
	bpl	4b
		
	/* .bss clear */
	mov.l	#__sbss,er5
	mov.l	er5,er6
	inc.l	#1,er6
	mov.l	#__ebss,er4
	sub.l	er5,er4
	sub.w	r0,r0
	mov.b	r0l,@er5
1:	
	eepmov.w
	dec.w	#1,e4
	bpl	1b

	mov.l	#__begin_data,er5
	mov.l	#__sdata,er6
	mov.l	#__edata,er4
	sub.l	er6,er4	
	beq	2f	
1:	
	eepmov.w	
	dec.w	#1,e4
	bpl	1b	

2:	
	jsr	@_main
_exit:

	jmp	_exit

init_regs:
#define INIT_REGS_DATA(REGS,DATA) \
	.word	(REGS & 0xffff),DATA
init_regs:
	.word	RTCOR & 0xffff ,9
	.word	RTMCSR & 0xffff,0x30
	.word	DRCRB & 0xffff ,0x98
	.word	DRCRA & 0xffff ,0x38
	.word	ASTCR & 0xffff ,0xfb
	.word	ABWCR & 0xffff ,0xff
	.word	WCRH & 0xffff  ,0xff
	.word	WCRL & 0xffff  ,0xc8
	.word	P1DDR & 0xffff ,0xff
	.word	P2DDR & 0xffff ,0xff
	.word	P5DDR & 0xffff ,0x01
	.word	P8DDR & 0xffff ,0x0e
	;; 38400 8bit 1stop pn
	.word	SMR1 & 0xffff  ,0x00
	.word	BRR1 & 0xffff  ,15
	.word	SCR1 & 0xffff  ,0x20
	.word	0
;; Thanks Hiroyuki Senshu & Hiroki Minematsu

	.section .bss
	.space	256
_stack:	
	.end
