/* $Id: inflate_boot.ld,v 1.1.1.1 2004/11/21 10:10:09 ysato Exp $ */

ENTRY(__start)

OUTPUT_FORMAT("elf32-h8300")
OUTPUT_ARCH(h8300h)

MEMORY
{
    rom : ORIGIN = 0x000000, LENGTH = 0x80000
    ram : ORIGIN = 0x5e4000, LENGTH = 0x1c000
    iram : ORIGIN = 0xffbf20, LENGTH = 0x4000-0x100
}

SECTIONS
{
	.vectors : { KEEP (*(.vectors)) } > rom
	.text : {
		___stext = ABSOLUTE(.);
	 	*(.text*)
		*(.rodata*)
	} > rom
 	___etext = .;
	__begin_data = .;
	.data : AT(LOADADDR(.text) + SIZEOF(.text)) {
		__sdata = .;
		*(.data*)
		__edata = .;
	} > ram
	_command = LOADADDR(.data) + SIZEOF(.data);
	.bss : {
		__sbss = .;
		*(.bss*)
		__ebss = .;
		__heap_top = .;
	} > ram
}

_interrupt_redirect_table = 0xfffe20;
_kernel_entry = 0x400000;
__inflate_area_size = 0x200000 - 0x20000;
_linux_command = 0x5ffe00;
__erom = 0x80000;
_SCI_TDR = 0xffffbb;
_SCI_SSR = 0xffffbc;
