## AURについて
AlterISO 3ではAURのパッケージをビルドに含めることができます。公式パッケージのインストールが終わった後、chrootでビルド用の一般ユーザーが作成されてビルドされます。初期のAlter ISO3では`makepkg`を使用してインストールを行っていましたが、現在は`yay`を使用してインストールされます。

## yayについて
yayは最も使用されているAURヘルパーです。AlterISOはまず一時的な一般ユーザーを作成した後、yayをmakepkgでビルドしてインストールします。  
全てのAURパッケージはyayコマンドを利用してインストールされます。それにより高度な依存関係の解決を行うことができます。

## AURビルドを無効化する
チャンネルの`config.<arch>`かビルド時に`--noaur`を指定することでAURのビルドをスキップできます。  
`config.<arch>`に以下を追記して下さい。  
AURビルドを無効化すると一部のパッケージがインストールされなくなり、その後のプロセスで予期せぬエラーが発生する可能性があります。  
(例えば`gnome`チャンネルではGnome拡張機能の大半をAURからインストールします。)

```bash
# Do not install the AUR package.
noaur=true
```
AURからのインストールを無効化すると、その後の`PKGBUILD`からのパッケージのインストールのための依存関係をインストールできず、エラーが発生する場合があります。（デフォルトで設定されているCalamaresはAURのパッケージを依存関係に含んでいます。）エラーが発生する場合には`--nopkgbuild`も一緒に指定することでこのエラーを回避できます。
